/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.pagina;

import jalis.laboratorio.configurador.Constantes;
import jalis.laboratorio.configurador.InterfaceRelacionamento;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Historico;
import jalis.laboratorio.configurador.pagina.AcaoPaginasListener;
import jalis.laboratorio.configurador.pagina.Dimensao;
import jalis.laboratorio.configurador.pagina.LinhaGuia;
import jalis.laboratorio.configurador.pagina.Margem;
import jalis.laboratorio.configurador.pagina.MensagensConfigurador;
import jalis.laboratorio.configurador.pagina.PanelControlePagina;
import jalis.laboratorio.configurador.pagina.ParametrosAssinatura;
import jalis.laboratorio.configurador.pagina.Regua;
import jalis.laboratorio.configurador.propriedade.Gerenciador;
import jalis.laboratorio.configurador.selecao.PreSelecao;
import jalis.laboratorio.configurador.selecao.Selecao;
import jalis.laboratorio.digitacao.componente.HistoricoDigitacao;
import jalis.laboratorio.impressao.CampoAssinaturaLaudo;
import jalis.laboratorio.util.parsers.CamposDesmembramento;
import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.CarregaCamposImportacaoResultado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.indlab.resultado.CamposRelacionamentoIndlabUtil;
import jalis.laboratorio.util.parsers.mercolabws.resultado.CamposRelacionamentoMercolabUtil;
import jalis.laboratorio.util.parsers.pardini.resultado.CamposRelacionamentoHPardiniUtil;
import jalis.laboratorio.util.parsers.shift.CamposRelacionamentoShiftUtil;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class Pagina
extends JPanel
implements Dimensao,
Margem,
AcaoPaginasListener {
    static final ImageIcon ICON_ERROR = ImagemUtils.carregaImagemJalis("dialog_error.gif");
    static final ImageIcon ICON_INFO = ImagemUtils.carregaImagemJalis("dialog_info.gif");
    static final int TAMANHO_MENSAGEM_CONFIGURADOR = ICON_INFO != null ? ICON_INFO.getIconHeight() + 10 : 40;
    static final int DIFERENCA_MARGEM_MENSAGEM_CONFIGURADOR = 5;
    public static final int CORPO = 0;
    public static final int CABECALHO_RODAPE = 1;
    public static final int CABECALHO = 2;
    public static final int RODAPE = 3;
    public static final int SUMARIO = 4;
    public static final int RODAPE_EXAME = 5;
    public static final int PROXIMIDADE_LINHA = 4;
    public static final int DISTANCIA_MINIMA = 10;
    private static final Color COR_1 = new Color(233, 233, 233);
    private static final Color COR_2 = new Color(246, 246, 246);
    private static final Color COR_BORDA_ASSINATURA = new Color(200, 200, 200);
    private static final int MARGEM = 15;
    private static final Font FONTE = new Font("Arial", 0, 12);
    private Font fontePadrao = FONTE;
    private int margemEsquerda = 0;
    private int margemDireita = 0;
    private int margemInferior = 0;
    private int margemSuperior = 0;
    private int tipoConfiguracao = 0;
    private int alturaCabecalho = 0;
    private int alturaRodape = 0;
    private int alturaSumario = 0;
    private int alturaRodapeExame = 20;
    private int distanciaExames = 0;
    private boolean exibirSumario = true;
    private boolean exibirRodapeExame = false;
    private ParametrosAssinatura assSumario;
    private ParametrosAssinatura assRodape;
    private String parametroAreaLivre;
    private String parametrosLinhaCorpo;
    private String separadorExames = ",";
    private String separadorCOA = ",";
    private String separadorSOA = ",";
    private int alinhamentoReferenciaSumario = 2;
    private Font fonteReferenciaSumario = null;
    private int alturaReferenciaSumario = 0;
    private int posicaoReferenciaSumario = 0;
    private boolean identificadorReferencia = false;
    private int posicaoXIdentificadorReferencia = 0;
    private int posicaoYIdentificadorReferencia = 0;
    private Font fonteIdentificadorReferencia = null;
    private String[] listaVariaveis;
    private Dimension tamanho;
    private ArrayList<LinhaGuia> linhasGuias;
    private Map<Integer, List<Componente>> itens;
    private List<Componente> itensPaginaAtual;
    private Map<Componente, Integer> itensTravadosTopo;
    private Map<Componente, Integer> itensTravadosEsquerda;
    private Regua reguaHoriz;
    private Regua reguaVerti;
    private PreSelecao preSelecao;
    private Selecao selecao;
    private Gerenciador gerenciador;
    private Class novoComponente;
    private String[] camposBanco = new String[0];
    private CampoAssinaturaLaudo[] camposAssinatura = null;
    private String[] camposExternos = new String[0];
    private Map<String, Map<String, String>> historicos = new HashMap<String, Map<String, String>>();
    private boolean exibirLinhasGuias = true;
    private boolean exibirLigacoes = false;
    private InterfaceRelacionamento interRel;
    private Protocolo protocolo;
    public Map<String, CamposImportacao> mapsCampoImportacao;
    private CamposImportacao camposImportacao;
    private ArrayList<CamposImportacao> camposImportacaoDesm = new ArrayList();
    private ArrayList<String> voltaAlteracoes = new ArrayList();
    private ArrayList<MensagensConfigurador> mensagens = new ArrayList();
    private ArrayList<Componente> resultadosAnteriores = new ArrayList();
    private Color[] coresLigacao = new Color[]{Color.BLUE, Color.RED, Color.YELLOW, Color.GREEN, Color.GRAY, Color.MAGENTA, Color.ORANGE};
    private PanelControlePagina controlePaginas = new PanelControlePagina();
    private String tags = null;
    private HashMap<String, ComponenteEditor> listaTagsEmUso = new HashMap();
    private String parametros = null;
    private String conferenciaAutomaticaResultado = null;
    private String mascaraPdf = "";
    private String qualidadeImagensLaudo;
    private boolean resultadoCampo;

    public Gerenciador getGerenciador() {
        return this.gerenciador;
    }

    public Pagina() {
        this.assSumario = ParametrosAssinatura.novaInstanciaLimpa();
        this.assRodape = ParametrosAssinatura.novaInstanciaLimpa();
        this.linhasGuias = new ArrayList();
        this.itens = new HashMap<Integer, List<Componente>>();
        this.itens.put(1, new ArrayList());
        this.itensPaginaAtual = this.itens.get(1);
        this.itensTravadosTopo = new HashMap<Componente, Integer>();
        this.itensTravadosEsquerda = new HashMap<Componente, Integer>();
        this.controlePaginas.setPaginas(this.itens);
        this.tamanho = null;
        this.reguaHoriz = new Regua(0, this);
        this.reguaVerti = new Regua(1, this);
        this.novoComponente = null;
        this.adicionarSelecao();
        this.controlePaginas.addAcaoPaginasListener(this);
    }

    private void adicionarSelecao() {
        this.preSelecao = new PreSelecao();
        this.add((Component)this.preSelecao, null);
        this.selecao = new Selecao(this, this.preSelecao);
        this.add((Component)this.selecao, null);
        this.gerenciador = new Gerenciador(this.selecao);
        this.addMouseListener(this.selecao);
        this.addMouseMotionListener(this.selecao);
    }

    public String[] getListaVariaveis() {
        if (this.listaVariaveis != null && this.listaVariaveis.length > 0) {
            return this.listaVariaveis;
        }
        return null;
    }

    public void setListaVariaveis(String[] listaVariaveis) {
        this.listaVariaveis = listaVariaveis;
    }

    public boolean isResultadoCampo() {
        return this.resultadoCampo;
    }

    public void setResultadoCampo(boolean resultadoCampo) {
        this.resultadoCampo = resultadoCampo;
    }

    public Regua getReguaVertical() {
        return this.reguaVerti;
    }

    public Regua getReguaHorizontal() {
        return this.reguaHoriz;
    }

    public void setNovoComponente(Class componente) {
        this.novoComponente = componente;
    }

    public boolean criandoComponente() {
        return this.novoComponente != null;
    }

    public void addComponente(Componente comp) {
        if (comp != null) {
            this.add((Component)((Object)comp));
            this.itensPaginaAtual.add(comp);
        }
    }

    public void adicionaAlteracao(String xml) {
        if (xml != null) {
            this.voltaAlteracoes.add(xml);
        }
    }

    public String pegaUltimaAlteracaoRealizada() {
        String ultima = "";
        if (this.voltaAlteracoes.size() > 0) {
            ultima = this.voltaAlteracoes.get(this.voltaAlteracoes.size() - 1);
            this.voltaAlteracoes.remove(this.voltaAlteracoes.size() - 1);
        }
        return ultima;
    }

    public List<Componente> getComponentes() {
        ArrayList<Componente> retorno = new ArrayList<Componente>();
        this.itens.forEach((k, v) -> retorno.addAll((Collection<Componente>)v));
        return retorno;
    }

    public Componente[] getComponentesParaArray() {
        ArrayList retorno = new ArrayList();
        this.itens.forEach((k, v) -> retorno.addAll(v));
        return retorno.toArray(new Componente[retorno.size()]);
    }

    public List<Componente> getComponentesPagina(int pagina) {
        return this.itens.size() >= pagina ? this.itens.get(pagina) : null;
    }

    public void setTipoConfiguracao(String tipo) {
        if (StringUtil.validaInteiro(tipo)) {
            this.setTipoConfiguracao(Integer.parseInt(tipo));
        }
    }

    public void setTipoConfiguracao(int tipo) {
        this.tipoConfiguracao = tipo;
    }

    public boolean getExibirLinhasGuias() {
        return this.exibirLinhasGuias;
    }

    public void setExibirLinhasGuias(boolean mostrar) {
        this.exibirLinhasGuias = mostrar;
        this.reguaHoriz.setExibirLinhasGuias(mostrar);
        this.reguaVerti.setExibirLinhasGuias(mostrar);
    }

    public void setExibirLigacoes(boolean mostrar) {
        this.exibirLigacoes = mostrar;
        this.revalidate();
        this.repaint();
    }

    public int getTipoConfiguracao() {
        return this.tipoConfiguracao;
    }

    @Override
    public Rectangle getDimensoes() {
        return new Rectangle(15, 15, this.tamanho.width, this.tamanho.height);
    }

    public int getDistanciaEntreExames() {
        return this.distanciaExames;
    }

    public float getDistanciaEntreExamesCentimetros() {
        return (float)this.distanciaExames / 28.0f;
    }

    public void setDistanciaEntreExames(int distancia) {
        this.distanciaExames = distancia;
    }

    public void setDistanciaEntreExames(float distancia) {
        this.distanciaExames = (int)(28.0f * distancia);
    }

    public void setDistanciaEntreExames(String distancia) {
        if (StringUtil.validaDouble(distancia)) {
            this.setDistanciaEntreExames(Float.parseFloat(distancia));
        }
    }

    public void setTamanho(String largura, String altura) {
        if (StringUtil.validaInteiro(largura) && StringUtil.validaInteiro(altura)) {
            this.setTamanho(Integer.parseInt(largura), Integer.parseInt(altura));
        }
    }

    @Override
    public void setTamanho(int largura, int altura) {
        this.destravarItens();
        this.travarItensEsquerda();
        this.travarItensTopo(3);
        if (this.exibirSumario) {
            this.travarItensTopo(4);
        }
        if (this.exibirRodapeExame) {
            this.travarItensTopo(5);
        }
        this.tamanho = new Dimension(largura, altura);
        this.reguaHoriz.setComprimento(largura);
        this.reguaVerti.setComprimento(altura);
        this.setPreferredSize(new Dimension(largura + 30, altura + 30));
        this.atualizarItensTravados();
    }

    @Override
    public void setTamanho(double largura, double altura) {
        this.setTamanho((int)(28.0 * largura), (int)(28.0 * altura));
    }

    public void setTamanho(double[] tam) {
        if (tam != null && tam.length == 2) {
            this.setTamanho(tam[0], tam[1]);
        }
    }

    public boolean exibeSumario() {
        return this.exibirSumario;
    }

    public boolean isExibirRodapeExame() {
        return this.exibirRodapeExame;
    }

    public boolean validaAlturaSumarioReferencia() {
        Rectangle rec = this.retanguloArea(4);
        int y = rec.y + this.getPosicaoReferenciaSumario();
        return y + this.getAlturaReferenciaSumario() <= rec.y + rec.height;
    }

    public void setAlturaCabecalho(String altura) {
        if (StringUtil.validaInteiro(altura)) {
            this.setAlturaCabecalho(Integer.parseInt(altura));
        }
    }

    public void setAlturaCabecalho(int altura) {
        int tmp;
        int n = tmp = altura < 10 ? 10 : altura;
        if (this.tamanho != null) {
            int sumario = this.exibirSumario ? this.alturaSumario + 10 : 0;
            int espaco = this.tamanho.height - this.margemSuperior - this.margemInferior - sumario - this.alturaRodape - 10;
            tmp = tmp > espaco ? espaco : tmp;
            Rectangle rec = this.retanguloArea(2);
            rec.add(new Rectangle(rec.x, rec.y, rec.width, tmp));
            this.repaint(rec.x, rec.y, rec.width + 1, rec.height + 1);
        }
        this.alturaCabecalho = tmp;
    }

    public void setAlturaCabecalho(double altura) {
        this.setAlturaCabecalho((int)(28.0 * altura));
    }

    public int getAlturaCabecalho() {
        if (this.tipoConfiguracao == 1 || this.tipoConfiguracao == 2) {
            return this.alturaCabecalho;
        }
        return -1;
    }

    public void setAlturaRodape(String altura) {
        if (StringUtil.validaInteiro(altura)) {
            this.setAlturaRodape(Integer.parseInt(altura));
        }
    }

    public void setAlturaRodape(int altura) {
        int tmp;
        int n = tmp = altura < 10 ? 10 : altura;
        if (this.tamanho != null) {
            int sumario = this.exibirSumario ? this.alturaSumario + 10 : 0;
            int espaco = this.tamanho.height - this.margemSuperior - this.margemInferior - this.alturaCabecalho - sumario - 10;
            tmp = tmp > espaco ? espaco : tmp;
            Rectangle rec = this.retanguloArea(4);
            rec.add(this.retanguloArea(3));
            rec.add(new Rectangle(rec.x, rec.y - tmp - rec.height, rec.width, tmp));
            this.repaint(rec.x, rec.y, rec.width + 1, rec.height + 1);
        }
        this.destravarItens();
        this.travarItensTopo(3);
        if (this.exibirSumario) {
            this.travarItensTopo(4);
        }
        if (this.exibirRodapeExame) {
            this.travarItensTopo(5);
        }
        this.alturaRodape = tmp;
        this.selecao.fireDadosAlterados();
        this.atualizarItensTravados();
    }

    public void setAlturaRodape(double altura) {
        this.setAlturaRodape((int)(28.0 * altura));
    }

    public int getAlturaRodape() {
        if (this.tipoConfiguracao == 1) {
            return this.alturaRodape;
        }
        return -1;
    }

    public void setAlturaSumario(String altura) {
        if (StringUtil.validaInteiro(altura)) {
            this.setAlturaSumario(Integer.parseInt(altura));
        }
    }

    public void setAlturaRodapeExame(String altura) {
        if (StringUtil.validaInteiro(altura)) {
            this.setAlturaRodapeExame(Integer.parseInt(altura));
        }
    }

    public void setAlturaSumario(int altura) {
        if (this.exibirSumario) {
            int tmp;
            int n = this.assSumario.exibirReferencia() && this.getAlturaReferenciaSumario() > 10 && altura < this.getAlturaReferenciaSumario() ? this.getAlturaReferenciaSumario() : (tmp = altura < 10 ? 10 : altura);
            if (this.tamanho != null) {
                int espaco = this.tamanho.height - this.margemSuperior - this.margemInferior - this.alturaCabecalho - this.alturaRodape - 20;
                tmp = tmp > espaco ? espaco : tmp;
                Rectangle rec = this.retanguloArea(3);
                rec.add(new Rectangle(rec.x, rec.y - tmp - rec.height, rec.width, tmp));
                this.repaint(rec.x, rec.y, rec.width + 1, rec.height + 1);
            }
            this.destravarItens();
            this.travarItensTopo(4);
            this.alturaSumario = tmp;
            this.atualizarItensTravados();
        }
    }

    public void setAlturaRodapeExame(int altura) {
        if (this.exibirRodapeExame) {
            int tmp;
            int n = tmp = altura < 10 ? 10 : altura;
            if (this.tamanho != null) {
                int espaco = this.tamanho.height - this.margemSuperior - this.margemInferior - this.alturaCabecalho - this.alturaRodape - 20;
                tmp = tmp > espaco ? espaco : tmp;
                Rectangle rec = this.retanguloArea(3);
                int alturaSumarioTmp = 0;
                if (this.exibirSumario) {
                    Rectangle recSumario = this.retanguloArea(4);
                    alturaSumarioTmp = recSumario.height;
                }
                rec.add(new Rectangle(rec.x, rec.y - (tmp + alturaSumarioTmp) - rec.height, rec.width, tmp));
                this.repaint(rec.x, rec.y, rec.width + 1, rec.height + 1);
            }
            this.destravarItens();
            this.travarItensTopo(5);
            this.alturaRodapeExame = tmp;
            this.atualizarItensTravados();
        }
    }

    public void setAlturaSumario(double altura) {
        this.setAlturaSumario((int)(28.0 * altura));
    }

    public int getAlturaSumario() {
        if (this.tipoConfiguracao == 1) {
            return this.alturaSumario;
        }
        return -1;
    }

    public void setAlturaRodapeExame(double altura) {
        this.setAlturaRodapeExame((int)(28.0 * altura));
    }

    public int getAlturaRodapeExame() {
        if (this.tipoConfiguracao == 1) {
            return this.alturaRodapeExame;
        }
        return -1;
    }

    @Override
    public void setMargem(double margem, int pos) {
        this.setMargem((int)(28.0 * margem), pos);
    }

    public void setMargem(String margem, int pos) {
        if (StringUtil.validaInteiro(margem)) {
            this.setMargem(Integer.parseInt(margem), pos);
        }
    }

    @Override
    public void setMargem(int margem, int pos) {
        switch (pos) {
            case 0: {
                this.destravarItens();
                this.travarItensEsquerda();
                this.reguaHoriz.setMargem(margem, 3);
                this.repintarMargem(margem, pos);
                this.atualizarItensTravados();
                break;
            }
            case 1: {
                this.reguaHoriz.setMargem(margem, 2);
                this.repintarMargem(margem, pos);
                break;
            }
            case 2: {
                this.destravarItens();
                this.travarItensTopo(2);
                this.reguaVerti.setMargem(margem, 2);
                this.repintarMargem(margem, pos);
                this.atualizarItensTravados();
                break;
            }
            case 3: {
                this.destravarItens();
                this.travarItensTopo(3);
                if (this.exibirSumario) {
                    this.travarItensTopo(4);
                }
                this.reguaVerti.setMargem(margem, 3);
                this.repintarMargem(margem, pos);
                this.atualizarItensTravados();
            }
        }
    }

    @Override
    public int getAltura() {
        if (this.tamanho != null) {
            return this.tamanho.height;
        }
        return 0;
    }

    @Override
    public double getAlturaCentimetros() {
        if (this.tamanho != null) {
            return (double)this.tamanho.height / 28.0;
        }
        return 0.0;
    }

    @Override
    public int getAlturaOcupada() {
        if (this.tipoConfiguracao == 1 || this.tipoConfiguracao == 2) {
            return this.alturaCabecalho + this.alturaRodape + 10;
        }
        return this.getAlturaOcupada(0);
    }

    @Override
    public int getAlturaOcupada(int local) {
        Rectangle rec = this.retanguloArea(local);
        int altura = 0;
        if (rec != null) {
            Iterator itr = this.componentesNoRetangulo(rec).iterator();
            while (itr.hasNext()) {
                Rectangle tmp = ((Componente)itr.next()).getDimensoes();
                if (tmp.y + tmp.height <= altura) continue;
                altura = tmp.y + tmp.height;
            }
            altura -= rec.y;
        }
        ParametrosAssinatura ass = local == 4 ? this.assSumario : (local == 3 ? this.assRodape : null);
        altura = ass != null && ass.getTipo() == 0 && altura < ass.getAltura() ? ass.getAltura() : altura;
        return altura;
    }

    @Override
    public int getLarguraOcupada() {
        int largura = 0;
        if (!this.itensPaginaAtual.isEmpty()) {
            Iterator<Componente> itr = this.itensPaginaAtual.iterator();
            while (itr.hasNext()) {
                Rectangle rec = itr.next().getDimensoes();
                if (rec.x + rec.width <= largura) continue;
                largura = rec.x + rec.width;
            }
            largura -= 15 + this.margemEsquerda;
        }
        return largura;
    }

    @Override
    public int getLarguraOcupada(int local) {
        Rectangle rec = this.retanguloArea(local);
        int largura = 0;
        if (rec != null) {
            Iterator itr = this.componentesNoRetangulo(rec).iterator();
            while (itr.hasNext()) {
                Rectangle tmp = ((Componente)itr.next()).getDimensoes();
                if (tmp.x + tmp.width <= largura) continue;
                largura = tmp.x + tmp.width;
            }
            largura -= rec.x;
        }
        return largura;
    }

    @Override
    public int getLargura() {
        if (this.tamanho != null) {
            return this.tamanho.width;
        }
        return 0;
    }

    @Override
    public double getLarguraCentimetros() {
        if (this.tamanho != null) {
            return (double)this.tamanho.width / 28.0;
        }
        return 0.0;
    }

    public double[] getTamanho() {
        return new double[]{this.getLarguraCentimetros(), this.getAlturaCentimetros()};
    }

    @Override
    public int getMargem(int pos) {
        switch (pos) {
            case 0: {
                return this.margemEsquerda;
            }
            case 1: {
                return this.margemDireita;
            }
            case 2: {
                return this.margemSuperior;
            }
            case 3: {
                return this.margemInferior;
            }
        }
        return 0;
    }

    public double[] getMargens() {
        return new double[]{(double)this.margemEsquerda / 28.0, (double)this.margemDireita / 28.0, (double)this.margemSuperior / 28.0, (double)this.margemInferior / 28.0};
    }

    public void setMargens(double[] margens) {
        this.setMargem(margens[0], 0);
        this.setMargem(margens[1], 1);
        this.setMargem(margens[2], 2);
        this.setMargem(margens[3], 3);
    }

    @Override
    public double getMargemCentimetros(int pos) {
        switch (pos) {
            case 0: {
                return (double)this.margemEsquerda / 28.0;
            }
            case 1: {
                return (double)this.margemDireita / 28.0;
            }
            case 2: {
                return (double)this.margemSuperior / 28.0;
            }
            case 3: {
                return (double)this.margemInferior / 28.0;
            }
        }
        return 0.0;
    }

    public Rectangle retanguloPagina() {
        return new Rectangle(15, 15, this.tamanho.width, this.tamanho.height);
    }

    public Rectangle retanguloArea(int local) {
        if (this.tamanho != null) {
            if (this.tipoConfiguracao == 0) {
                return new Rectangle(15 + this.margemEsquerda, 15 + this.margemSuperior, this.tamanho.width - this.margemDireita - this.margemEsquerda, this.tamanho.height - this.margemSuperior - this.margemInferior);
            }
            if (this.tipoConfiguracao == 1) {
                switch (local) {
                    case 2: {
                        return new Rectangle(15 + this.margemEsquerda, 15 + this.margemSuperior, this.tamanho.width - this.margemDireita - this.margemEsquerda, this.alturaCabecalho);
                    }
                    case 4: {
                        if (!this.exibirSumario) break;
                        return new Rectangle(15 + this.margemEsquerda, 15 + this.tamanho.height - this.margemInferior - this.alturaRodape - this.alturaSumario - 10, this.tamanho.width - this.margemDireita - this.margemEsquerda, this.alturaSumario);
                    }
                    case 5: {
                        if (!this.exibirRodapeExame) break;
                        return new Rectangle(15 + this.margemEsquerda, 15 + this.tamanho.height - this.margemInferior - this.alturaRodape - (this.exibirSumario ? this.alturaSumario + 10 : 0) - this.alturaRodapeExame - 10, this.tamanho.width - this.margemDireita - this.margemEsquerda, this.alturaRodapeExame);
                    }
                    case 3: {
                        return new Rectangle(15 + this.margemEsquerda, 15 + this.tamanho.height - this.margemInferior - this.alturaRodape, this.tamanho.width - this.margemDireita - this.margemEsquerda, this.alturaRodape);
                    }
                }
            } else if (this.tipoConfiguracao == 2) {
                return new Rectangle(15 + this.margemEsquerda, 15 + this.margemSuperior, this.tamanho.width - this.margemDireita - this.margemEsquerda, this.alturaCabecalho);
            }
        }
        return new Rectangle();
    }

    public ParametrosAssinatura getAssinaturaSumario() {
        return this.assSumario;
    }

    public void setAssinaturaSumario(ParametrosAssinatura param) {
        this.assSumario = param;
        if (param != null && param.getTipo() == 0 && param.getAltura() > this.alturaSumario) {
            this.setAlturaSumario(param.getAltura());
        }
    }

    public ParametrosAssinatura getAssinaturaRodape() {
        return this.assRodape;
    }

    public void setAssinaturaRodape(ParametrosAssinatura param) {
        this.assRodape = param;
        if (param != null && param.getTipo() == 0 && param.getAltura() > this.alturaRodape) {
            this.setAlturaRodape(param.getAltura());
        }
    }

    public void setParametrosAreaLivre(String xml) {
        this.parametroAreaLivre = xml;
    }

    public void setParametrosLinhasCorpo(String xml) {
        this.parametrosLinhaCorpo = xml;
    }

    public void setSeparadorExames(String s) {
        this.separadorExames = s;
    }

    public void setSeparadorCOA(String s) {
        this.separadorCOA = s;
    }

    public void setSeparadorSOA(String s) {
        this.separadorSOA = s;
    }

    public void setQualidadeImagensLaudo(String qualidadeImagensLaudo) {
        this.qualidadeImagensLaudo = qualidadeImagensLaudo;
    }

    public String getParametrosAreaLivre() {
        return this.parametroAreaLivre;
    }

    public String getParametrosLinhasCorpo() {
        return this.parametrosLinhaCorpo;
    }

    public String getSeparadorExames() {
        return this.separadorExames;
    }

    public String getSeparadorCOA() {
        return this.separadorCOA;
    }

    public String getSeparadorSOA() {
        return this.separadorSOA;
    }

    public String getQualidadeImagensLaudo() {
        return this.qualidadeImagensLaudo;
    }

    public int getAlinhamentoReferenciaSumario() {
        return this.alinhamentoReferenciaSumario;
    }

    public Font getFonteReferenciaSumario() {
        return this.fonteReferenciaSumario;
    }

    public int getAlturaReferenciaSumario() {
        return this.alturaReferenciaSumario;
    }

    public int getPosicaoReferenciaSumario() {
        return this.posicaoReferenciaSumario;
    }

    public boolean getIdentificadorReferencia() {
        return this.identificadorReferencia;
    }

    public int getPosicaoXIdentificadorReferencia() {
        return this.posicaoXIdentificadorReferencia;
    }

    public int getPosicaoYIdentificadorReferencia() {
        return this.posicaoYIdentificadorReferencia;
    }

    public Font getFonteIdentificadorReferencia() {
        return this.fonteIdentificadorReferencia;
    }

    public void setIdentificadorReferencia(boolean b) {
        this.identificadorReferencia = b;
    }

    public void setPosicaoXIdentificadorReferencia(int posicao) {
        this.posicaoXIdentificadorReferencia = posicao;
    }

    public void setPosicaoYIdentificadorReferencia(int posicao) {
        this.posicaoYIdentificadorReferencia = posicao;
    }

    public void setFonteIdentificadorReferencia(Font fonte) {
        this.fonteIdentificadorReferencia = fonte;
    }

    public void setAlinhamentoReferenciaSumario(int alinha) {
        this.alinhamentoReferenciaSumario = alinha;
    }

    public void setFonteReferenciaSumario(Font f) {
        this.fonteReferenciaSumario = f;
    }

    public void setAlturaReferenciaSumario(int altura) {
        this.alturaReferenciaSumario = altura;
    }

    public void setPosicaoReferenciaSumario(int posicao) {
        this.posicaoReferenciaSumario = posicao;
    }

    public int localPonto(Point ponto) {
        if (this.tipoConfiguracao == 0 && this.retanguloArea(0).contains(ponto)) {
            return 0;
        }
        if (this.tipoConfiguracao == 1) {
            if (this.retanguloArea(2).contains(ponto)) {
                return 2;
            }
            if (this.exibirSumario && this.retanguloArea(4).contains(ponto)) {
                return 4;
            }
            if (this.retanguloArea(3).contains(ponto)) {
                return 3;
            }
            if (this.retanguloArea(5).contains(ponto)) {
                return 5;
            }
        } else if (this.tipoConfiguracao == 2 && this.retanguloArea(2).contains(ponto)) {
            return 2;
        }
        return -1;
    }

    public int localRetangulo(Rectangle retangulo) {
        if (this.tipoConfiguracao == 0 && this.contemRec(0, retangulo)) {
            return 0;
        }
        if (this.tipoConfiguracao == 1) {
            if (this.contemRec(2, retangulo)) {
                return 2;
            }
            if (this.exibirSumario && this.contemRec(4, retangulo)) {
                return 4;
            }
            if (this.exibirRodapeExame && this.contemRec(5, retangulo)) {
                return 5;
            }
            if (this.contemRec(3, retangulo)) {
                return 3;
            }
        } else if (this.tipoConfiguracao == 2 && this.contemRec(2, retangulo)) {
            return 2;
        }
        return -1;
    }

    public void adicionarLinhaGuia(LinhaGuia linha) {
        if (linha != null) {
            if (linha.horizontal() && this.reguaVerti != null) {
                this.reguaVerti.adicionarLinhaGuia(linha);
                linha.setPaginaRegua(this, this.reguaVerti);
            } else if (linha.vertical() && this.reguaHoriz != null) {
                this.reguaHoriz.adicionarLinhaGuia(linha);
                linha.setPaginaRegua(this, this.reguaHoriz);
            }
            this.linhasGuias.add(linha);
        }
    }

    public void removerLinhaGuia(LinhaGuia linha) {
        if (linha != null && linha.getRedimensionar()) {
            if (linha.horizontal() && this.reguaVerti != null) {
                this.reguaVerti.removerLinhaGuia(linha);
            } else if (linha.vertical() && this.reguaHoriz != null) {
                this.reguaHoriz.removerLinhaGuia(linha);
            }
            this.linhasGuias.remove(linha);
            if (linha.horizontal()) {
                this.repaint(0, linha.getPosicao(), this.getWidth(), 1);
            } else {
                this.repaint(linha.getPosicao(), 0, 1, this.getHeight());
            }
        }
    }

    public void iniciaPreSelecao() {
        this.preSelecao.removerSelecao();
    }

    public void preSelecionar(Rectangle area) {
        Componente prim = this.preSelecao.getPrimeiro();
        boolean ok = false;
        this.preSelecao.removerSelecao();
        if (this.novoComponente == null && this.componentesMesmoLocal(area)) {
            Iterator itr = this.componentesNoRetangulo(area).iterator();
            while (itr.hasNext()) {
                this.preSelecao.selecionar((Componente)itr.next());
                if (ok) continue;
                ok = true;
            }
        }
        if (ok) {
            this.preSelecao.setPrimeiro(prim);
        }
    }

    public void selecionar(Rectangle area) {
        this.selecao.removerSelecao();
        this.selecao.selecionar(this.preSelecao.getPrimeiro());
        this.preSelecao.removerSelecao();
        if (this.novoComponente == null && this.componentesMesmoLocal(area)) {
            this.selecao.setAvisarOuvintes(false);
            Iterator itr = this.componentesNoRetangulo(area).iterator();
            while (itr.hasNext()) {
                this.selecao.selecionar((Componente)itr.next());
            }
            this.selecao.setAvisarOuvintes(true);
        }
    }

    public Componente criarNovoComponente(Rectangle area) {
        Componente comp = null;
        if (this.novoComponente != null && this.localRetangulo(area) != -1) {
            try {
                comp = (Componente)this.novoComponente.newInstance();
                int w = area.width == 0 ? comp.getLargura() : area.width;
                int h = area.height == 0 ? comp.getAltura() : area.height;
                area.setBounds(area.x, area.y, w, h);
                area = this.ajustarParaLocal(area);
                comp.setNome(this.gerarNome(comp.getNomeBase()));
                comp.setDimensoes(area);
                comp.setLocal(this.localRetangulo(area));
                comp.setPagina(this);
                comp.setContadorPagina(this.controlePaginas.getPaginaAtual());
                this.add((Component)((Object)comp));
                this.itensPaginaAtual.add(0, comp);
                comp.atualizar();
                this.novoComponente = null;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Pagina: 1045");
            }
        }
        return comp;
    }

    public ArrayList componentesNoRetangulo(Rectangle retangulo) {
        ArrayList<Componente> retorno = new ArrayList<Componente>();
        for (Componente comp : this.itensPaginaAtual) {
            Rectangle tmp = comp.getDimensoes();
            if (!retangulo.intersects(tmp)) continue;
            retorno.add(comp);
        }
        return retorno;
    }

    public static Rectangle retanguloArrastado(Rectangle retangulo, Rectangle areaLimite) {
        int x = retangulo.x < areaLimite.x ? areaLimite.x - 2 : (retangulo.x + retangulo.width > areaLimite.x + areaLimite.width ? areaLimite.x + areaLimite.width - retangulo.width + 3 : retangulo.x);
        int y = retangulo.y < areaLimite.y ? areaLimite.y - 2 : (retangulo.y + retangulo.height > areaLimite.y + areaLimite.height ? areaLimite.y + areaLimite.height - retangulo.height + 3 : retangulo.y);
        return new Rectangle(x, y, retangulo.width, retangulo.height);
    }

    public static Rectangle retanguloRedimensionado(Rectangle velho, Rectangle novo, Rectangle areaLimite) {
        int height;
        int y;
        int width;
        int x;
        if (novo.x < areaLimite.x - 2) {
            x = areaLimite.x - 2;
            width = velho.x + velho.width - x;
        } else if (novo.x + novo.width > areaLimite.x + areaLimite.width + 3) {
            x = velho.x;
            width = areaLimite.x + areaLimite.width - x + 3;
        } else if (novo.width < 10) {
            x = novo.x > velho.x ? velho.x + velho.width - 10 : velho.x;
            width = 10;
        } else {
            x = novo.x;
            width = novo.width;
        }
        if (novo.y < areaLimite.y - 2) {
            y = areaLimite.y - 2;
            height = velho.y + velho.height - y;
        } else if (novo.y + novo.height > areaLimite.y + areaLimite.height + 3) {
            y = velho.y;
            height = areaLimite.y + areaLimite.height - y + 3;
        } else if (novo.height < 10) {
            y = novo.y > velho.y ? velho.y + velho.height - 10 : velho.y;
            height = 10;
        } else {
            y = novo.y;
            height = novo.height;
        }
        return new Rectangle(x, y, width, height);
    }

    public Rectangle grudarRetangulo(Rectangle retangulo) {
        Rectangle tmp = new Rectangle(retangulo);
        LinhaGuia[] linhas = this.linhasGuias.toArray(new LinhaGuia[this.linhasGuias.size()]);
        for (int i = 0; i < linhas.length; ++i) {
            if (linhas[i].horizontal() && Math.abs(linhas[i].getPosicao() - tmp.y) <= 4) {
                tmp.setLocation(tmp.x, linhas[i].getPosicao());
                continue;
            }
            if (!linhas[i].vertical() || Math.abs(linhas[i].getPosicao() - tmp.x) > 4) continue;
            tmp.setLocation(linhas[i].getPosicao(), tmp.y);
        }
        return tmp;
    }

    public Componente componenteContemPonto(int x, int y) {
        Componente item = null;
        Component[] itens = this.getComponents();
        for (int i = 0; i < itens.length; ++i) {
            if (!(itens[i] instanceof Componente)) continue;
            Rectangle rec = itens[i].getBounds();
            if (x <= rec.x || x >= rec.x + rec.width || y <= rec.y || y >= rec.y + rec.height || item != null && (rec.width > item.getLargura() || rec.height > item.getAltura())) continue;
            item = (Componente)((Object)itens[i]);
        }
        return item;
    }

    public boolean mouseSobreMensagemConfigurador(int x, int y) {
        Rectangle rec = new Rectangle(15, 10, this.tamanho.width, TAMANHO_MENSAGEM_CONFIGURADOR);
        return x > rec.x && x < rec.x + rec.width && y > rec.y && y < rec.y + rec.height;
    }

    public LinhaGuia getLinhaNaPosicao(int x, int y, int proximidade) {
        for (LinhaGuia linha : this.linhasGuias) {
            if ((!linha.horizontal() || y - proximidade > linha.getPosicao() || linha.getPosicao() > y + proximidade) && (!linha.vertical() || x - proximidade > linha.getPosicao() || linha.getPosicao() > x + proximidade)) continue;
            return linha;
        }
        return null;
    }

    public int getMargemNaPosicao(int x, int y, int proximidade) {
        if (this.tipoConfiguracao == 1) {
            int x1 = 15 + this.margemEsquerda;
            int x2 = 15 + this.tamanho.width - this.margemDireita;
            if (x > x1 && x < x2) {
                int tmpY = 15 + this.margemSuperior + this.alturaCabecalho;
                if (tmpY > y - proximidade && tmpY < y + proximidade) {
                    return 2;
                }
                if (this.exibeSumario() && (tmpY = 15 + this.tamanho.height - this.margemInferior - this.alturaRodape - this.alturaSumario - 10) > y - proximidade && tmpY < y + proximidade) {
                    return 4;
                }
                if (this.isExibirRodapeExame() && (tmpY = 15 + this.tamanho.height - this.margemInferior - this.alturaRodape - (this.exibeSumario() ? this.alturaSumario + 10 : 0) - this.alturaRodapeExame - 10) > y - proximidade && tmpY < y + proximidade) {
                    return 5;
                }
                tmpY = 15 + this.tamanho.height - this.margemInferior - this.alturaRodape;
                if (tmpY > y - proximidade && tmpY < y + proximidade) {
                    return 3;
                }
            }
        } else if (this.tipoConfiguracao == 2) {
            int tmpY;
            int x1 = 15 + this.margemEsquerda;
            int x2 = 15 + this.tamanho.width - this.margemDireita;
            if (x > x1 && x < x2 && (tmpY = 15 + this.margemSuperior + this.alturaCabecalho) > y - proximidade && tmpY < y + proximidade) {
                return 2;
            }
        }
        return -1;
    }

    public JTable getTablePropriedades() {
        return this.gerenciador.getTabelaPropriedades();
    }

    public void removerComponente(Componente c) {
        this.itensPaginaAtual.remove(c);
        this.remove((Component)((Object)c));
    }

    public void removerComponenteLocal(int local) {
        if (this.selecao.getLocal() == local) {
            this.selecao.removerSelecao();
        }
        Iterator itr = this.componentesNoRetangulo(this.retanguloArea(local)).iterator();
        while (itr.hasNext()) {
            this.removerComponente((Componente)itr.next());
        }
    }

    public void setExibirSumario(boolean exibir) {
        if (this.exibirSumario != exibir) {
            if (!exibir) {
                this.removerComponenteLocal(4);
            }
            this.exibirSumario = exibir;
            this.revalidate();
            this.repaint();
        }
    }

    public void setExibirRodapeExame(boolean exibir) {
        if (this.exibirRodapeExame != exibir) {
            if (!exibir) {
                this.removerComponenteLocal(5);
            }
            this.exibirRodapeExame = exibir;
            this.revalidate();
            this.repaint();
        }
    }

    public String getAtributos() {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("tipoConfiguracao", String.valueOf(this.tipoConfiguracao)));
        bui.append(StringUtil.getTag("margemEsquerda", String.valueOf(this.margemEsquerda)));
        bui.append(StringUtil.getTag("margemDireita", String.valueOf(this.margemDireita)));
        bui.append(StringUtil.getTag("margemInferior", String.valueOf(this.margemInferior)));
        bui.append(StringUtil.getTag("margemSuperior", String.valueOf(this.margemSuperior)));
        bui.append(StringUtil.getTag("alturaCabecalho", String.valueOf(this.alturaCabecalho)));
        bui.append(StringUtil.getTag("alturaSumario", String.valueOf(this.alturaSumario)));
        bui.append(StringUtil.getTag("alturaRodape", String.valueOf(this.alturaRodape)));
        bui.append(StringUtil.getTag("alturaRodapeExame", String.valueOf(this.alturaRodapeExame)));
        bui.append(StringUtil.getTag("exibirSumario", String.valueOf(this.exibirSumario)));
        bui.append(StringUtil.getTag("exibirRodapeExame", String.valueOf(this.exibirRodapeExame)));
        bui.append(StringUtil.getTag("dimensoes", StringUtil.getTag("largura", String.valueOf(this.tamanho.width)) + StringUtil.getTag("altura", String.valueOf(this.tamanho.height))));
        bui.append(StringUtil.getTag("distanciaExames", String.valueOf(this.distanciaExames)));
        bui.append(StringUtil.getTag("assinaturaSumario", this.assSumario.getAtributos()));
        bui.append(StringUtil.getTag("assinaturaRodape", this.assRodape.getAtributos()));
        bui.append(StringUtil.getTag("linhasGuia", this.getAtributosLinhaGuia()));
        bui.append(StringUtil.getTag("parametrosAreaLivre", this.getParametrosAreaLivre()));
        bui.append(StringUtil.getTag("parametrosLinhasCorpo", this.parametrosLinhaCorpo));
        bui.append(StringUtil.getTag("separadorExames", this.getSeparadorExames()));
        bui.append(StringUtil.getTag("separadorCOA", this.getSeparadorCOA()));
        bui.append(StringUtil.getTag("separadorSOA", this.getSeparadorSOA()));
        bui.append(StringUtil.getTag("qualidadeImagensLaudo", this.getQualidadeImagensLaudo()));
        if (this.tipoConfiguracao == 1 || this.tipoConfiguracao == 2) {
            bui.append("<referencias>");
            bui.append(StringUtil.getTag("alinhamentoReferenciaSumario", String.valueOf(this.getAlinhamentoReferenciaSumario())));
            bui.append(StringUtil.getTag("fonteReferenciaSumario", this.fonteReferenciaSumario != null ? StringUtil.getFonteAtributos(this.fonteReferenciaSumario) : ""));
            bui.append(StringUtil.getTag("alturaReferenciaSumario", String.valueOf(this.getAlturaReferenciaSumario())));
            bui.append(StringUtil.getTag("posicaoReferenciaSumario", String.valueOf(this.getPosicaoReferenciaSumario())));
            bui.append("<identificadorReferencias>");
            bui.append(StringUtil.getTag("imprimirIdentificadorReferencia", this.getIdentificadorReferencia() ? "true" : "false"));
            bui.append(StringUtil.getTag("fonteIdentificadorReferencia", this.fonteIdentificadorReferencia != null ? StringUtil.getFonteAtributos(this.fonteIdentificadorReferencia) : ""));
            bui.append(StringUtil.getTag("posicaoXIdentificadorReferencia", String.valueOf(this.getPosicaoXIdentificadorReferencia())));
            bui.append(StringUtil.getTag("posicaoYIdentificadorReferencia", String.valueOf(this.getPosicaoYIdentificadorReferencia())));
            bui.append("</identificadorReferencias>");
            bui.append("</referencias>");
        }
        StringBuilder cabecalho = new StringBuilder();
        StringBuilder corpo = new StringBuilder();
        StringBuilder sumario = new StringBuilder();
        StringBuilder rodape = new StringBuilder();
        StringBuilder rodapeExame = new StringBuilder();
        for (Integer contadorPagina : this.itens.keySet()) {
            List<Componente> comps = this.getComponentesPagina(contadorPagina);
            for (Componente com : comps) {
                com.setContadorPagina(contadorPagina);
                String atr = StringUtil.getTag("componente", StringUtil.getTag("tipo", com.getClass().getName()) + StringUtil.getTag("atributos", com.getAtributos()));
                if (this.tipoConfiguracao == 0) {
                    corpo.append(atr);
                    continue;
                }
                switch (com.getLocal()) {
                    case 2: {
                        cabecalho.append(atr);
                        break;
                    }
                    case 4: {
                        sumario.append(atr);
                        break;
                    }
                    case 3: {
                        rodape.append(atr);
                        break;
                    }
                    case 5: {
                        rodapeExame.append(atr);
                    }
                }
            }
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(StringUtil.getTag("cabecalho", cabecalho.toString()));
        tmp.append(StringUtil.getTag("corpo", corpo.toString()));
        tmp.append(StringUtil.getTag("sumario", sumario.toString()));
        tmp.append(StringUtil.getTag("rodape", rodape.toString()));
        tmp.append(StringUtil.getTag("rodapeExame", rodapeExame.toString()));
        return StringUtil.getTag("propriedades", bui.toString()) + StringUtil.getTag("itens", tmp.toString());
    }

    public void setLinhaGuiaCabecalho(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            this.setAtributosLinhaGuia(xml, false);
        }
    }

    public void setAtributos(String atr, String versao) {
        if (atr.trim().length() > 0) {
            String prop = StringUtil.getValor(atr, "propriedades");
            this.setTipoConfiguracao(StringUtil.getValor(prop, "tipoConfiguracao"));
            if (this.tipoConfiguracao == 1 || this.tipoConfiguracao == 2) {
                this.setMargem(StringUtil.getValor(prop, "margemEsquerda"), 0);
                this.setMargem(StringUtil.getValor(prop, "margemDireita"), 1);
                this.setMargem(StringUtil.getValor(prop, "margemInferior"), 3);
                this.setMargem(StringUtil.getValor(prop, "margemSuperior"), 2);
                this.setAlturaCabecalho(StringUtil.getValor(prop, "alturaCabecalho"));
                this.setExibirSumario(StringUtil.getBoolean(StringUtil.getValor(prop, "exibirSumario")));
                this.setExibirRodapeExame(StringUtil.getBoolean(StringUtil.getValor(prop, "exibirRodapeExame")));
                this.setAlturaSumario(StringUtil.getValor(prop, "alturaSumario"));
                this.setAlturaRodapeExame(StringUtil.getValor(prop, "alturaRodapeExame"));
                this.setAlturaRodape(StringUtil.getValor(prop, "alturaRodape"));
                String tmp = StringUtil.getValor(prop, "dimensoes");
                this.setTamanho(StringUtil.getValor(tmp, "largura"), StringUtil.getValor(tmp, "altura"));
                this.distanciaExames = StringUtil.getInt(prop, "distanciaExames");
                this.assSumario = ParametrosAssinatura.novaInstancia(StringUtil.getValor(prop, "assinaturaSumario"));
                this.assRodape = ParametrosAssinatura.novaInstancia(StringUtil.getValor(prop, "assinaturaRodape"));
                this.setParametrosAreaLivre(StringUtil.getValor(prop, "parametrosAreaLivre"));
                this.setSeparadorExames(StringUtil.getValor(prop, "separadorExames"));
                this.setSeparadorCOA(StringUtil.getValor(prop, "separadorCOA"));
                this.setSeparadorSOA(StringUtil.getValor(prop, "separadorSOA"));
                this.setQualidadeImagensLaudo(StringUtil.getValor(prop, "qualidadeImagensLaudo"));
                tmp = StringUtil.getValor(prop, "parametrosLinhasCorpo");
                if (!Funcoes.textoVazio(tmp)) {
                    this.setParametrosLinhasCorpo(tmp);
                }
                tmp = StringUtil.getValor(prop, "referencias");
                this.setAlinhamentoReferenciaSumario(StringUtil.getInt(tmp, "alinhamentoReferenciaSumario"));
                this.setFonteReferenciaSumario(StringUtil.getFonte(StringUtil.getValor(tmp, "fonteReferenciaSumario")));
                this.setAlturaReferenciaSumario(StringUtil.getInt(tmp, "alturaReferenciaSumario"));
                this.setPosicaoReferenciaSumario(StringUtil.getInt(tmp, "posicaoReferenciaSumario"));
                tmp = StringUtil.getValor(tmp, "identificadorReferencias");
                if (tmp.trim().length() > 0) {
                    this.setIdentificadorReferencia(StringUtil.getBoolean(tmp, "imprimirIdentificadorReferencia"));
                    this.setFonteIdentificadorReferencia(StringUtil.getFonte(StringUtil.getValor(tmp, "fonteIdentificadorReferencia")));
                    this.setPosicaoXIdentificadorReferencia(StringUtil.getInt(tmp, "posicaoXIdentificadorReferencia"));
                    this.setPosicaoYIdentificadorReferencia(StringUtil.getInt(tmp, "posicaoYIdentificadorReferencia"));
                }
            }
            this.setAtributosLinhaGuia(StringUtil.getValor(prop, "linhasGuia"), true);
            this.carregarComponentes(atr, versao);
        }
    }

    private void carregarComponentes(String atr, String versao) {
        try {
            String tmp = StringUtil.getValor(atr, "itens");
            String[] itens = this.carregarItens(tmp);
            for (int i = 0; i < itens.length; ++i) {
                tmp = StringUtil.getValor(itens[i], "tipo");
                Componente comp = (Componente)Class.forName(tmp).newInstance();
                comp.setPagina(this);
                comp.setAtributos(StringUtil.getValor(itens[i], "atributos"));
                if (this.componenteEstaNaPagina(comp)) {
                    this.add((Component)((Object)comp));
                }
                if (this.versaoXMLAbaixo3(comp, versao)) {
                    comp.setAlinhamentoHorizontal(2);
                }
                this.adicionarItensNaPagina(comp);
                this.organizarItensNaPagina();
            }
            this.controlePaginas.setTotalPaginas(this.itens.size());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Pagina: 1434");
        }
    }

    private boolean componenteEstaNaPagina(Componente comp) {
        return this.localRetangulo(comp.getDimensoes()) != -1 && comp.getContadorPagina().equals(this.controlePaginas.getPaginaAtual());
    }

    private String[] carregarItens(String tmp) {
        String[] itens;
        if (this.tipoConfiguracao == 0) {
            itens = StringUtil.getValores(StringUtil.getValor(tmp, "corpo"), "componente");
        } else {
            itens = StringUtil.getValores(StringUtil.getValor(tmp, "cabecalho"), "componente");
            itens = ArraysUtil.concatenar(itens, StringUtil.getValores(StringUtil.getValor(tmp, "rodapeExame"), "componente"));
            itens = ArraysUtil.concatenar(itens, StringUtil.getValores(StringUtil.getValor(tmp, "sumario"), "componente"));
            itens = ArraysUtil.concatenar(itens, StringUtil.getValores(StringUtil.getValor(tmp, "rodape"), "componente"));
        }
        return itens;
    }

    private boolean versaoXMLAbaixo3(Componente comp, String versao) {
        return !(!(comp instanceof Historico) && !(comp instanceof HistoricoDigitacao) || Funcoes.textoVazio(versao) || !versao.equalsIgnoreCase("1.0") && !versao.equalsIgnoreCase("2.0"));
    }

    private void adicionarItensNaPagina(Componente comp) {
        if (comp.getContadorPagina().equals(1)) {
            this.itensPaginaAtual.add(comp);
        } else {
            if (!this.itens.containsKey(comp.getContadorPagina())) {
                this.itens.put(comp.getContadorPagina(), new ArrayList());
            }
            this.itens.get(comp.getContadorPagina()).add(comp);
        }
    }

    private void organizarItensNaPagina() {
        Integer maior = 0;
        for (Integer pg : this.itens.keySet()) {
            if (pg <= maior) continue;
            maior = pg;
        }
        Integer pg = 1;
        while (pg < maior) {
            if (!this.itens.containsKey(pg)) {
                this.itens.put(pg, new ArrayList());
            }
            Integer n = pg;
            Integer n2 = pg = Integer.valueOf(pg + 1);
        }
    }

    public void moverTopo(Componente c) {
        int pos = ScreenUtil.indiceComponente(this, (Component)((Object)c));
        if (pos > 2) {
            this.remove((Component)((Object)c));
            this.itensPaginaAtual.remove(c);
            this.itensPaginaAtual.add(0, c);
            this.add((Component)((Object)c), 2);
            this.revalidate();
            this.repaint();
        }
    }

    public void moverAcima(Componente c) {
        int pos = ScreenUtil.indiceComponente(this, (Component)((Object)c));
        if (pos > 2) {
            this.itensPaginaAtual.remove(c);
            this.remove((Component)((Object)c));
            this.itensPaginaAtual.add(pos - 3, c);
            this.add((Component)((Object)c), pos - 1);
            this.revalidate();
            this.repaint();
        }
    }

    public void moverAbaixo(Componente c) {
        int pos = ScreenUtil.indiceComponente(this, (Component)((Object)c));
        if (pos != 1 && pos < this.getComponentCount() - 1) {
            this.itensPaginaAtual.remove(c);
            this.remove((Component)((Object)c));
            this.itensPaginaAtual.add(pos - 1, c);
            this.add((Component)((Object)c), pos + 1);
            this.revalidate();
            this.repaint();
        }
    }

    public void moverBase(Componente c) {
        int pos = ScreenUtil.indiceComponente(this, (Component)((Object)c));
        if (pos != -1 && pos < this.getComponentCount() - 1) {
            this.itensPaginaAtual.remove(c);
            this.remove((Component)((Object)c));
            this.itensPaginaAtual.add(c);
            this.add((Component)((Object)c));
            this.revalidate();
            this.repaint();
        }
    }

    public void limpar() {
        Iterator<Object> itr = ((ArrayList)this.linhasGuias.clone()).iterator();
        while (itr.hasNext()) {
            this.removerLinhaGuia((LinhaGuia)itr.next());
        }
        this.selecao.removerSelecao();
        itr = this.itensPaginaAtual.iterator();
        while (itr.hasNext()) {
            this.remove((Component)itr.next());
        }
        this.itensPaginaAtual.clear();
    }

    public void setCamposBanco(String[] campos) {
        this.camposBanco = campos;
    }

    public String[] getCamposBanco() {
        return this.camposBanco;
    }

    public void setCamposAssinatura(CampoAssinaturaLaudo[] campos) {
        this.camposAssinatura = campos;
    }

    public CampoAssinaturaLaudo[] getCamposAssinatura() {
        return this.camposAssinatura;
    }

    public void setCamposExternos(String[] campos) {
        if (campos != null) {
            this.camposExternos = campos;
        }
    }

    public String[] getCamposExternos() {
        return this.camposExternos;
    }

    public void setHistoricos(Map<String, Map<String, String>> historicos) {
        this.historicos = historicos;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getTags() {
        return this.tags;
    }

    public void setConferenciaAutomaticaResultado(String conferenciaAutomaticaResultado) {
        this.conferenciaAutomaticaResultado = conferenciaAutomaticaResultado;
    }

    public String getConferenciaAutomaticaResultado() {
        return this.conferenciaAutomaticaResultado;
    }

    public String getParametros() {
        return this.parametros;
    }

    public void setParametros(String parametros) {
        this.parametros = parametros;
    }

    public Map<String, Map<String, String>> getHistoricos() {
        return this.historicos;
    }

    public void setCamposResultadoAnterior(ArrayList<Componente> campos) {
        this.resultadosAnteriores = campos;
    }

    public ArrayList<Componente> getCamposResultadoAnterior() {
        return this.resultadosAnteriores;
    }

    public void setRedimensionavel(boolean valor) {
        this.reguaHoriz.setRedimensionavel(valor);
        this.reguaVerti.setRedimensionavel(valor);
    }

    public void travarItensTopo(int local) {
        for (Componente c : this.componentesNoRetangulo(this.retanguloArea(local))) {
            this.itensTravadosTopo.put(c, new Integer(c.getTopo()));
        }
    }

    public void travarItensEsquerda() {
        for (Componente c : this.itensPaginaAtual) {
            this.itensTravadosEsquerda.put(c, new Integer(c.getEsquerda()));
        }
    }

    public void destravarItens() {
        this.itensTravadosTopo.clear();
        this.itensTravadosEsquerda.clear();
    }

    public void atualizarItensTravados() {
        for (Componente c : this.itensTravadosTopo.keySet()) {
            c.setTopo(this.itensTravadosTopo.get(c));
        }
        for (Componente c : this.itensTravadosEsquerda.keySet()) {
            c.setEsquerda(this.itensTravadosEsquerda.get(c));
        }
    }

    public void setInterfaceRelacionamento(InterfaceRelacionamento inter) {
        this.interRel = inter;
    }

    public InterfaceRelacionamento getInterfaceRelacionamento() {
        return this.interRel;
    }

    public CamposImportacao getCamposImportacao() {
        return this.camposImportacao;
    }

    public void setVersaoSelecionada(CamposImportacao camposImportacao) {
        this.camposImportacao = camposImportacao;
        this.selecao.atualizarVersaoCampoImportacao(camposImportacao.toString());
    }

    public ArrayList<CamposImportacao> getCamposImportacaoDesm() {
        return this.camposImportacaoDesm;
    }

    public Map<String, CamposImportacao> getMapsCampoImportacao() {
        return this.mapsCampoImportacao;
    }

    public void setMapsCampoImportacao(Map<String, CamposImportacao> mapsCampoImportacao) {
        this.mapsCampoImportacao = mapsCampoImportacao;
    }

    public boolean contemComponenteComNome(String nome) {
        for (Integer key : this.itens.keySet()) {
            for (Componente c : this.itens.get(key)) {
                if (!c.getNome().equalsIgnoreCase(nome)) continue;
                return true;
            }
        }
        return false;
    }

    public Componente getComponenteComNome(String nome) {
        for (Componente comp : this.itensPaginaAtual) {
            if (!comp.getNome().equalsIgnoreCase(nome)) continue;
            return comp;
        }
        return null;
    }

    public Font getFontePadrao() {
        return this.fontePadrao;
    }

    public void setFontePadrao(Font fonte) {
        this.fontePadrao = fonte;
    }

    public String gerarNome(String nomeBase) {
        int num = 1;
        while (this.contemComponenteComNome(nomeBase + String.valueOf(num))) {
            ++num;
        }
        return nomeBase + String.valueOf(num);
    }

    public CamposImportacao carregarCamposImportacaoLabExternoAutomaticamente(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, boolean automaticamente, Integer codigoMaterialPai) {
        return this.carregarCamposImportacaoLabExternoAutomaticamente(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, automaticamente, null, codigoMaterialPai);
    }

    public CamposImportacao carregarCamposImportacaoLabExternoAutomaticamente(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, boolean automaticamente, ArrayList<CamposDesmembramento> listaDesm, Integer codigoMaterialPai) {
        Funcoes.validarNaoNull((Object)protocolo, "protocolo");
        Funcoes.validarNaoNull(codExameLabExterno, "codExameLabExterno");
        this.protocolo = protocolo;
        CamposImportacao campos = null;
        if (this.listaPreenchida(listaDesm)) {
            try {
                for (CamposDesmembramento campo : listaDesm) {
                    campos = automaticamente ? CarregaCamposImportacaoResultado.carregarCamposAutomaticamente(protocolo, codigoLabExterno, campo.getCodigoLabExterno(), campo.getXmlLabExterno(), campo.getCodigo(), campo.getMaterial()) : CarregaCamposImportacaoResultado.carregarCampos(protocolo, codigoLabExterno, campo.getCodigoLabExterno(), campo.getXmlLabExterno(), campo.getCodigo(), codigoMaterialPai);
                    if (!this.possuiCamposImportacao(campos)) continue;
                    this.camposImportacaoDesm.add(campos);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), e.getMessage());
            }
        } else {
            try {
                campos = automaticamente ? CarregaCamposImportacaoResultado.carregarCamposAutomaticamente(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, null, codigoMaterialPai) : CarregaCamposImportacaoResultado.carregarCampos(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, null, codigoMaterialPai);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), e.getMessage());
            }
        }
        if (this.possuiCamposImportacao(campos)) {
            this.camposImportacao = campos;
        }
        return campos;
    }

    private boolean possuiCamposImportacao(CamposImportacao campos) {
        return campos != null;
    }

    private boolean listaPreenchida(ArrayList<CamposDesmembramento> listaDesm) {
        return listaDesm != null && !listaDesm.isEmpty();
    }

    public Map<String, CamposImportacao> carregarCamposImportacaoAutomaticamentePardini(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, Integer codigoMaterialPai) {
        Funcoes.validarNaoNull((Object)protocolo, "protocolo");
        Funcoes.validarNaoNull(codExameLabExterno, "codExameLabExterno");
        this.protocolo = protocolo;
        Map<String, CamposImportacao> campos = CamposRelacionamentoHPardiniUtil.carregarListaCamposImportacaoPorVersao(codigoLabExterno, codExameLabExterno, null, codigoMaterialPai);
        this.setMapsCampoImportacao(campos);
        return campos;
    }

    public Map<String, CamposImportacao> carregarCamposImportacaoAutomaticamenteIndlab(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, Integer codigoMaterialPai) {
        Funcoes.validarNaoNull((Object)protocolo, "protocolo");
        Funcoes.validarNaoNull(codExameLabExterno, "codExameLabExterno");
        this.protocolo = protocolo;
        Map<String, CamposImportacao> campos = CamposRelacionamentoIndlabUtil.carregarListaCamposImportacaoPorVersao(codigoLabExterno, codExameLabExterno, null, codigoMaterialPai);
        this.setMapsCampoImportacao(campos);
        return campos;
    }

    public Map<String, CamposImportacao> carregarCamposImportacaoAutomaticamenteMercolab(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, Integer codigoMaterialPai) {
        Funcoes.validarNaoNull((Object)protocolo, "protocolo");
        Funcoes.validarNaoNull(codExameLabExterno, "codExameLabExterno");
        this.protocolo = protocolo;
        Map<String, CamposImportacao> campos = CamposRelacionamentoMercolabUtil.carregarListaCamposImportacaoPorVersao(codigoLabExterno, codExameLabExterno, null, codigoMaterialPai, xmlExameLabExterno);
        this.setMapsCampoImportacao(campos);
        return campos;
    }

    public Map<String, CamposImportacao> carregarCamposImportacaoAutomaticamenteShift(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, Integer codigoMaterialPai) {
        Funcoes.validarNaoNull((Object)protocolo, "protocolo");
        Funcoes.validarNaoNull(codExameLabExterno, "codExameLabExterno");
        this.protocolo = protocolo;
        Map<String, CamposImportacao> campos = CamposRelacionamentoShiftUtil.carregarListaCamposImportacaoPorVersao(codigoLabExterno, codExameLabExterno, codigoMaterialPai);
        this.setMapsCampoImportacao(campos);
        return campos;
    }

    public Protocolo getProtocolo() {
        return this.protocolo;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.desenharPagina(g);
        this.desenharGrade(g);
        this.desenharMargens(g);
        if (this.exibirLinhasGuias) {
            this.desenharLinhasGuias(g);
        }
        if (this.exibirLigacoes) {
            this.desenharLigacoes(g);
        }
        this.desenharMensagens(g);
    }

    private void desenharLigacoes(Graphics g) {
        int cor = 0;
        for (Componente c : this.itensPaginaAtual) {
            if (c.getLigacoes().size() > 0) {
                for (String s : c.getLigacoes()) {
                    Componente comp = this.getComponenteComNome(s);
                    if (comp == null) continue;
                    g.setColor(this.coresLigacao[cor]);
                    Rectangle pai = c.getDimensoes();
                    Rectangle filho = comp.getDimensoes();
                    if (pai.x < filho.x && pai.y > filho.y || pai.x > filho.x && pai.y > filho.y) {
                        g.drawLine(pai.x + 1, pai.y, filho.x + 1, filho.y + 1);
                        continue;
                    }
                    if (pai.x < filho.x && pai.y < filho.y || pai.x > filho.x && pai.y < filho.y) {
                        g.drawLine(pai.x + 1, pai.y + c.getAltura(), filho.x + 1, filho.y + 1);
                        continue;
                    }
                    g.drawLine(pai.x + 1, pai.y, filho.x, filho.y + 3);
                }
                ++cor;
            }
            if (cor <= this.coresLigacao.length - 1) continue;
            cor = 0;
        }
    }

    private Rectangle ajustarParaLocal(Rectangle rec) {
        Rectangle area = this.retanguloArea(this.localPonto(rec.getLocation()));
        Rectangle tmp = new Rectangle(rec);
        if (area != null) {
            if (tmp.x + tmp.width > area.x + area.width) {
                tmp.setBounds(area.x + area.width - tmp.width, tmp.y, tmp.width, tmp.height);
            }
            if (tmp.x < area.x) {
                tmp.setBounds(area.x, tmp.y, area.width, tmp.height);
            }
            if (tmp.y + tmp.height > area.y + area.height) {
                tmp.setBounds(tmp.x, area.y + area.height - tmp.height, tmp.width, tmp.height);
            }
            if (tmp.y < area.y) {
                tmp.setBounds(tmp.x, area.y, tmp.width, area.height);
            }
        }
        return tmp;
    }

    private boolean contemRec(int local, Rectangle rec) {
        Rectangle area = this.retanguloArea(local);
        if (area != null) {
            return area.contains(rec.getLocation());
        }
        return false;
    }

    private boolean componentesMesmoLocal(Rectangle area) {
        int local = -1;
        for (Componente comp : this.componentesNoRetangulo(area)) {
            if (local == -1) {
                local = comp.getLocal();
                continue;
            }
            if (local == comp.getLocal()) continue;
            return false;
        }
        return local != -1;
    }

    private void repintarMargem(int novaMargem, int pos) {
        if (this.tamanho != null) {
            if (this.tipoConfiguracao == 0) {
                Rectangle rec1 = this.retanguloArea(0);
                switch (pos) {
                    case 0: {
                        this.margemEsquerda = novaMargem;
                        break;
                    }
                    case 1: {
                        this.margemDireita = novaMargem;
                        break;
                    }
                    case 2: {
                        this.margemSuperior = novaMargem;
                        break;
                    }
                    case 3: {
                        this.margemInferior = novaMargem;
                    }
                }
                rec1.add(this.retanguloArea(0));
                this.repaint(rec1.x, rec1.y, rec1.width + 1, rec1.height + 1);
            } else if (this.tipoConfiguracao == 1) {
                Rectangle rec1 = this.retanguloArea(2);
                Rectangle rec2 = this.exibirSumario ? this.retanguloArea(4) : null;
                Rectangle rec3 = this.retanguloArea(3);
                Rectangle rec4 = this.retanguloArea(5);
                switch (pos) {
                    case 0: {
                        this.margemEsquerda = novaMargem;
                        break;
                    }
                    case 1: {
                        this.margemDireita = novaMargem;
                        break;
                    }
                    case 2: {
                        this.margemSuperior = novaMargem;
                        break;
                    }
                    case 3: {
                        this.margemInferior = novaMargem;
                    }
                }
                if (this.exibirSumario) {
                    rec2.add(this.retanguloArea(4));
                    this.repaint(rec2.x, rec2.y, rec2.width + 1, rec2.height + 1);
                }
                if (this.exibirRodapeExame) {
                    rec4.add(this.retanguloArea(5));
                    this.repaint(rec4.x, rec4.y, rec4.width + 1, rec4.height + 1);
                }
                rec1.add(this.retanguloArea(2));
                rec3.add(this.retanguloArea(3));
                this.repaint(rec1.x, rec1.y - 10, rec1.width + 1, rec1.height + 1);
                this.repaint(rec3.x, rec3.y, rec3.width + 1, rec3.height + 1);
            } else if (this.tipoConfiguracao == 2) {
                Rectangle rec1 = this.retanguloArea(2);
                rec1.add(this.retanguloArea(2));
                this.repaint(rec1.x, rec1.y - 10, rec1.width + 1, rec1.height + 1);
            }
        }
    }

    private void desenharPagina(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(15, 15, this.tamanho.width, this.tamanho.height);
        g.setColor(Color.BLACK);
        g.drawRect(15, 15, this.tamanho.width, this.tamanho.height);
        g.setColor(Color.GRAY);
        g.fillRect(15 + this.tamanho.width + 1, 19, 2, this.tamanho.height - 1);
        g.fillRect(18, 15 + this.tamanho.height + 1, this.tamanho.width, 3);
        this.desenharMensagens(g);
    }

    public void desenharMensagens(Graphics g) {
        if (this.mensagens.size() > 0) {
            MensagensConfigurador mensagem = this.mensagens.get(this.mensagens.size() - 1);
            g.setColor(Constantes.COR_FUNDO_CREME);
            g.fillRect(15, 10, this.tamanho.width, TAMANHO_MENSAGEM_CONFIGURADOR);
            g.setColor(Color.YELLOW);
            g.drawRect(15, 10, this.tamanho.width, TAMANHO_MENSAGEM_CONFIGURADOR);
            ImageIcon img = ICON_ERROR;
            if (img != null) {
                if (mensagem.getTipo() == 1) {
                    img = ICON_INFO;
                }
                g.drawImage(img.getImage(), 20, 17, img.getImageObserver());
            }
            g.setColor(Color.BLACK);
            g.setFont(FONTE);
            g.drawString(mensagem.getMensagem(), 25 + img.getIconWidth(), 35);
        }
    }

    private void desenharGrade(Graphics g) {
        double umMeio = 14.0;
        int contador = 1;
        double i = 15.0 + umMeio;
        while (i < (double)(15 + this.tamanho.width)) {
            g.setColor(contador == -1 ? COR_1 : COR_2);
            g.drawLine((int)i, 16, (int)i, 15 + this.tamanho.height - 1);
            i += umMeio;
            contador *= -1;
        }
        contador = 1;
        i = 15.0 + umMeio;
        while (i < (double)(15 + this.tamanho.height)) {
            g.setColor(contador == -1 ? COR_1 : COR_2);
            g.drawLine(16, (int)i, 15 + this.tamanho.width - 1, (int)i);
            i += umMeio;
            contador *= -1;
        }
    }

    private void desenharMargens(Graphics g) {
        if (this.tipoConfiguracao == 0) {
            this.desenharMargem(g, 0);
        } else if (this.tipoConfiguracao == 1) {
            this.desenharMargem(g, 2);
            if (this.assSumario.exibir()) {
                this.pintarAssinatura(g, 4);
            } else if (this.assSumario.exibirReferencia()) {
                this.pintarReferencia(g);
            }
            if (this.assRodape.exibir()) {
                this.pintarAssinatura(g, 3);
            }
            if (this.exibirSumario) {
                this.desenharMargem(g, 4);
            }
            if (this.exibirRodapeExame) {
                this.desenharMargem(g, 5);
            }
            this.desenharMargem(g, 3);
        } else if (this.tipoConfiguracao == 2) {
            this.desenharMargem(g, 2);
        }
    }

    private void desenharMargem(Graphics g, int local) {
        if (this.tamanho != null) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke strokeTmp = g2d.getStroke();
            g2d.setFont(this.getFontePadrao());
            g2d.setColor(Color.blue);
            g2d.setStroke(Regua.TRACEJADO);
            Rectangle rec = this.retanguloArea(local);
            String rotulo = "";
            switch (local) {
                case 2: {
                    rotulo = "Cabe\u00e7alho";
                    break;
                }
                case 0: {
                    rotulo = "Corpo (P\u00e1gina: " + this.controlePaginas.getPaginaAtual() + ")";
                    break;
                }
                case 4: {
                    rotulo = "Sum\u00e1rio";
                    break;
                }
                case 3: {
                    rotulo = "Rodap\u00e9";
                    break;
                }
                case 5: {
                    rotulo = "Rodap\u00e9 do exame";
                }
            }
            int w = g2d.getFontMetrics().stringWidth(rotulo);
            g2d.drawLine(rec.x, rec.y, rec.x + 10, rec.y);
            g2d.drawLine(rec.x + 12 + w, rec.y, rec.x + rec.width, rec.y);
            g2d.drawString(rotulo, rec.x + 11, rec.y);
            g2d.drawLine(rec.x, rec.y, rec.x, rec.y + rec.height);
            g2d.drawLine(rec.x, rec.y + rec.height, rec.x + rec.width, rec.y + rec.height);
            g2d.drawLine(rec.x + rec.width, rec.y, rec.x + rec.width, rec.y + rec.height);
            g2d.setStroke(strokeTmp);
        }
    }

    private void pintarAssinatura(Graphics g, int local) {
        if (local == 4 || local == 3) {
            ParametrosAssinatura assina = local == 4 ? this.assSumario : this.assRodape;
            Rectangle rec = this.retanguloArea(local);
            int h = assina.getAltura();
            int y = rec.y;
            y = local == 3 && assina.getTipo() == 0 && assina.getPosicao() == 11 && assina.getPosicaoAbsoluto() > 0 && assina.getPosicaoAbsoluto() < rec.height ? (y += assina.getPosicaoAbsoluto()) : (assina.getPosicao() == 1 ? (y += assina.getTipo() == 0 ? 0 : -h) : (y += rec.height - h));
            g.setColor(COR_1);
            g.fillRect(rec.x, y, rec.width, h);
            g.setColor(COR_BORDA_ASSINATURA);
            g.drawRect(rec.x, y, rec.width, h);
            g.setFont(new Font("Arial", 1, 20));
            g.setColor(COR_BORDA_ASSINATURA);
            String texto = local == 4 ? "Assinatura Sum\u00e1rio" : "Assinatura Rodap\u00e9";
            FontMetrics met = g.getFontMetrics();
            int yTmp = y + (met.getHeight() + h) / 2 - met.getDescent();
            int textoW = met.stringWidth(texto);
            int x = assina.getAlinhamento() == 2 ? rec.x : (assina.getAlinhamento() == 0 ? rec.x + (rec.width - textoW) / 2 : rec.x + rec.width - textoW);
            g.drawString(texto, x, yTmp);
            if (assina.getCampoBanco() != null) {
                g.setFont(new Font("Arial", 1, 12));
                met = g.getFontMetrics();
                texto = "(" + assina.getCampoBanco().getDescricao() + ")";
                g.drawString(texto, x + (textoW - met.stringWidth(texto)) / 2, yTmp + met.getHeight() - met.getDescent());
            }
        }
    }

    private void pintarReferencia(Graphics g) {
        ParametrosAssinatura assina = this.assSumario;
        if (this.exibirSumario && assina.exibirReferencia() && this.getAlturaReferenciaSumario() > 0) {
            Rectangle rec = this.retanguloArea(4);
            int y = rec.y + this.getPosicaoReferenciaSumario();
            int h = y + this.getAlturaReferenciaSumario() > rec.y + rec.height ? rec.height - this.getPosicaoReferenciaSumario() : this.getAlturaReferenciaSumario();
            g.setColor(COR_1);
            g.fillRect(rec.x, y, rec.width, h);
            g.setColor(COR_BORDA_ASSINATURA);
            g.drawRect(rec.x, y, rec.width, h);
            if (y + this.getAlturaReferenciaSumario() > rec.y + rec.height) {
                g.setColor(Color.PINK);
                g.fillRect(rec.x, y + (rec.height - this.getPosicaoReferenciaSumario()), rec.width, this.getAlturaReferenciaSumario() - (rec.height - this.getPosicaoReferenciaSumario()));
            }
            g.setFont(new Font("Arial", 1, 20));
            g.setColor(COR_BORDA_ASSINATURA);
            String texto = "Refer\u00eancias";
            FontMetrics met = g.getFontMetrics();
            int yTmp = y + (met.getHeight() + h) / 2 - met.getDescent();
            int textoW = met.stringWidth(texto);
            int x = this.getAlinhamentoReferenciaSumario() == 2 ? rec.x : (this.getAlinhamentoReferenciaSumario() == 0 ? rec.x + (rec.width - textoW) / 2 : rec.x + rec.width - textoW);
            g.drawString(texto, x, yTmp);
        }
    }

    private void desenharLinhasGuias(Graphics g) {
        Rectangle area = g.getClipBounds();
        for (LinhaGuia linha : this.linhasGuias) {
            g.setColor(linha.getCor());
            if (linha.getPosicao() <= 15) continue;
            if (linha.horizontal()) {
                g.drawLine(area.x, linha.getPosicao(), area.x + area.width, linha.getPosicao());
                continue;
            }
            g.drawLine(linha.getPosicao(), area.y, linha.getPosicao(), area.y + area.height);
        }
    }

    private String getAtributosLinhaGuia() {
        StringBuilder bui = new StringBuilder();
        for (LinhaGuia linha : this.linhasGuias) {
            if (!linha.getRedimensionar()) continue;
            String tmp = StringUtil.getTag("pos", String.valueOf(linha.getPosicao())) + StringUtil.getTag("orientacao", String.valueOf(linha.getOrientacao()));
            bui.append(StringUtil.getTag("linhaGuia", tmp));
        }
        return bui.toString();
    }

    private void setAtributosLinhaGuia(String atr, boolean redimensionar) {
        String[] linhas = StringUtil.getValores(atr, "linhaGuia");
        for (int i = 0; i < linhas.length; ++i) {
            int pos = StringUtil.getInt(linhas[i], "pos");
            int orientacao = StringUtil.getInt(linhas[i], "orientacao");
            LinhaGuia linha = new LinhaGuia(orientacao, redimensionar);
            linha.setPosicao(pos);
            this.adicionarLinhaGuia(linha);
        }
    }

    public void setMargensFromXML(String xmlExame) {
        if (xmlExame != null) {
            String propriedades = StringUtil.getValor(StringUtil.getValor(xmlExame, "pagina"), "propriedades");
            this.setMargem(StringUtil.getValor(propriedades, "margemEsquerda"), 0);
            this.setMargem(StringUtil.getValor(propriedades, "margemDireita"), 1);
            this.setMargem(StringUtil.getInt(propriedades, "margemSuperior") + StringUtil.getInt(propriedades, "alturaCabecalho"), 2);
            this.setMargem(StringUtil.getInt(propriedades, "margemInferior") + StringUtil.getInt(propriedades, "alturaRodape") + (StringUtil.getBoolean(propriedades, "exibirSumario") ? StringUtil.getInt(propriedades, "alturaSumario") : 0) + (StringUtil.getBoolean(propriedades, "exibirRodapeExame") ? StringUtil.getInt(propriedades, "alturaRodapeExame") : 0), 3);
            this.setTamanho(StringUtil.getValor(propriedades, "largura"), StringUtil.getValor(propriedades, "altura"));
        }
    }

    public void addMensagensUsuario(MensagensConfigurador msg) {
        this.mensagens.add(msg);
        if (this.mensagens.size() > 0) {
            this.revalidate();
            this.repaint();
        }
    }

    public void removerUltimaMensagem() {
        if (this.mensagens.size() > 0) {
            this.mensagens.remove(this.mensagens.size() - 1);
            this.revalidate();
            this.repaint();
        }
    }

    public PanelControlePagina getControlePaginas() {
        return this.controlePaginas;
    }

    public int getPaginaSelecionada() {
        return this.controlePaginas.getPaginaAtual();
    }

    private void removeComponentesPagina(int pagina) {
        this.preSelecao.removerSelecao();
        this.selecao.removerSelecao();
        if (this.getComponentesPagina(pagina) != null) {
            for (Componente c : this.getComponentesPagina(pagina)) {
                this.remove((Component)((Object)c));
            }
        }
    }

    @Override
    public void paginaAdicionada(int paginaAtual, int novaPaginaSelecionada) {
        if (this.itens.size() < novaPaginaSelecionada) {
            this.itens.put(this.itens.size() + 1, new ArrayList());
            this.removeComponentesPagina(paginaAtual);
        } else {
            ArrayList componenteAtual = new ArrayList();
            int quantidadePaginas = this.itens.size() + 1;
            for (int pagina = novaPaginaSelecionada; pagina <= quantidadePaginas; ++pagina) {
                if (novaPaginaSelecionada == pagina) {
                    componenteAtual = (ArrayList)this.itens.get(pagina);
                    this.itens.put(pagina, new ArrayList());
                    continue;
                }
                ArrayList componenteAnterior = componenteAtual;
                componenteAtual = (ArrayList)this.itens.get(pagina);
                this.itens.put(pagina, componenteAnterior);
            }
            if (paginaAtual == novaPaginaSelecionada) {
                ++paginaAtual;
            }
            this.removeComponentesPagina(paginaAtual);
        }
        final int novaPagina = novaPaginaSelecionada;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Pagina.this.itensPaginaAtual = (List)Pagina.this.itens.get(novaPagina);
                for (Componente c : Pagina.this.itensPaginaAtual) {
                    c.setSelecao(Pagina.this.selecao);
                    c.setPagina(Pagina.this);
                    Pagina.this.add((Component)((Object)c));
                }
                Pagina.this.revalidate();
                Pagina.this.repaint();
            }
        });
    }

    @Override
    public void proximaPagina() {
        if (this.controlePaginas.getPaginaAtual() <= this.itens.size()) {
            this.removeComponentesPagina(this.controlePaginas.getPaginaAtual() - 1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Pagina.this.itensPaginaAtual = (List)Pagina.this.itens.get(Pagina.this.controlePaginas.getPaginaAtual());
                    if (Pagina.this.itensPaginaAtual != null) {
                        for (Componente c : Pagina.this.itensPaginaAtual) {
                            c.setSelecao(Pagina.this.selecao);
                            Pagina.this.add((Component)((Object)c));
                        }
                    }
                    Pagina.this.revalidate();
                    Pagina.this.repaint();
                }
            });
        }
    }

    @Override
    public void paginaAnterior() {
        if (this.controlePaginas.getPaginaAtual() >= 1) {
            this.removeComponentesPagina(this.controlePaginas.getPaginaAtual() + 1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Pagina.this.itensPaginaAtual = (List)Pagina.this.itens.get(Pagina.this.controlePaginas.getPaginaAtual());
                    for (Componente c : Pagina.this.itensPaginaAtual) {
                        c.setSelecao(Pagina.this.selecao);
                        Pagina.this.add((Component)((Object)c));
                    }
                    Pagina.this.revalidate();
                    Pagina.this.repaint();
                }
            });
        }
    }

    @Override
    public void paginaRemovida(int paginaRemovida, int novaPaginaSelecionada) {
        if (this.controlePaginas.getTotalPaginas() > 1) {
            this.removeComponentesPagina(paginaRemovida);
            this.itens.remove(paginaRemovida);
            for (int i = paginaRemovida; i <= this.itens.size(); ++i) {
                if (this.itens.get(i) != null || this.itens.get(i + 1) == null) continue;
                this.itens.put(i, this.itens.get(i + 1));
                this.itens.remove(i + 1);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Pagina.this.itensPaginaAtual = (List)Pagina.this.itens.get(Pagina.this.controlePaginas.getPaginaAtual());
                for (Componente c : Pagina.this.itensPaginaAtual) {
                    c.setSelecao(Pagina.this.selecao);
                    Pagina.this.add((Component)((Object)c));
                }
                Pagina.this.revalidate();
                Pagina.this.repaint();
            }
        });
    }

    public String getMascaraPdf() {
        return this.mascaraPdf;
    }

    public void setMascaraPdf(String mascaraPdf) {
        this.mascaraPdf = mascaraPdf;
    }

    public HashMap<String, ComponenteEditor> getTagsEmUso() {
        return this.listaTagsEmUso;
    }

    public void adicionaTagEmUso(String tag, ComponenteEditor componente) {
        if (!Funcoes.textoVazio(tag) && componente != null) {
            this.listaTagsEmUso.put(tag, componente);
        }
    }

    public void removeTagEmUso(String tag) {
        if (!Funcoes.textoVazio(tag)) {
            this.listaTagsEmUso.remove(tag);
        }
    }

    private boolean existeCampo(CamposDesmembramento campo) {
        return campo != null;
    }
}

