/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.pagina;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Color;

public class LinhasCorpo {
    public static final String TIPO_INTERVALO = "Intervalo";
    public static final String TIPO_FIXO = "Fixo";
    private boolean habilitar = false;
    private boolean acompanharResultado = false;
    private String linhasX = "";
    private String linhasY = "";
    private String tipoLinhaX = "";
    private String tipoLinhaY = "";
    private Color cor = null;

    public Color getCor() {
        return this.cor;
    }

    public void setCor(Color cor) {
        this.cor = cor;
    }

    public boolean isHabilitar() {
        return this.habilitar;
    }

    public void setHabilitar(boolean habilitar) {
        this.habilitar = habilitar;
    }

    public String getLinhasX() {
        return this.linhasX;
    }

    public void setLinhasX(String linhasX) {
        this.linhasX = linhasX;
    }

    public String getLinhasY() {
        return this.linhasY;
    }

    public void setLinhasY(String linhasY) {
        this.linhasY = linhasY;
    }

    public String getTipoLinhaX() {
        return this.tipoLinhaX;
    }

    public void setTipoLinhaX(String tipoLinhaX) {
        this.tipoLinhaX = tipoLinhaX;
    }

    public String getTipoLinhaY() {
        return this.tipoLinhaY;
    }

    public void setTipoLinhaY(String tipoLinhaY) {
        this.tipoLinhaY = tipoLinhaY;
    }

    public void parseXML(String xml) {
        String tmp = StringUtil.getValor(xml, "linhascorpo");
        if (!Funcoes.textoVazio(tmp)) {
            this.habilitar = StringUtil.getBoolean(tmp, "habilitarlinhascorpo");
            this.acompanharResultado = StringUtil.getBoolean(tmp, "acompanharresultado");
            if (Funcoes.isNumeric(StringUtil.getValor(xml, "corlinhas"))) {
                this.cor = StringUtil.getColor(xml, "corlinhas");
            }
            String linha = StringUtil.getValor(tmp, "linhax");
            this.tipoLinhaX = StringUtil.getValor(linha, "tipolinhas");
            this.linhasX = StringUtil.getValor(linha, "pontoslinhas");
            linha = StringUtil.getValor(tmp, "linhay");
            this.tipoLinhaY = StringUtil.getValor(linha, "tipolinhas");
            this.linhasY = StringUtil.getValor(linha, "pontoslinhas");
        }
    }

    public String getXML() {
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("linhascorpo");
            xml.escrever("habilitarlinhascorpo", this.habilitar ? "sim" : "nao");
            xml.escrever("acompanharresultado", this.acompanharResultado ? "sim" : "nao");
            xml.abrir("linhax");
            xml.escrever("pontoslinhas", this.linhasX);
            xml.escrever("tipolinhas", this.tipoLinhaX);
            xml.fechar("linhax");
            xml.abrir("linhay");
            xml.escrever("pontoslinhas", this.linhasY);
            xml.escrever("tipolinhas", this.tipoLinhaY);
            xml.fechar("linhay");
            xml.escrever("corlinhas", this.cor != null ? String.valueOf(this.cor.getRGB()) : "");
            xml.fechar("linhascorpo");
            return xml.getXML();
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean isAcompanharResultado() {
        return this.acompanharResultado;
    }

    public void setAcompanharResultado(boolean acompanharResultado) {
        this.acompanharResultado = acompanharResultado;
    }
}

