/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.pagina;

import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class LinhaGuia {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientacao;
    private int pos;
    private Color cor;
    private JComponent pagina;
    private JComponent regua;
    private boolean redimensionar = true;

    public LinhaGuia(int orientacao) {
        this.init(orientacao, true);
    }

    public LinhaGuia(int orientacao, boolean redimensionar) {
        this.init(orientacao, redimensionar);
    }

    private void init(int orientacao, boolean redimensionar) {
        this.orientacao = orientacao;
        this.cor = redimensionar ? Color.red : Color.ORANGE;
        this.redimensionar = redimensionar;
        this.pagina = null;
        this.regua = null;
    }

    public void setCor(Color cor) {
        this.cor = cor;
    }

    public Color getCor() {
        return this.cor;
    }

    public void setPaginaRegua(JComponent pagina, JComponent regua) {
        this.pagina = pagina;
        this.regua = regua;
    }

    public void setPosicao(int pos) {
        if (this.pagina != null && this.regua != null) {
            if (this.orientacao == 0) {
                Rectangle tmp = this.regua.getBounds();
                Rectangle rec = new Rectangle(0, this.pos, tmp.width, 1);
                rec.add(new Rectangle(0, pos, tmp.width, 1));
                this.regua.repaint(rec.x, rec.y, rec.width, rec.height);
                tmp = this.pagina.getBounds();
                rec = new Rectangle(0, this.pos, tmp.width, 1);
                rec.add(new Rectangle(0, pos, tmp.width, 1));
                this.pagina.repaint(rec.x, rec.y, rec.width, rec.height);
            } else if (this.orientacao == 1) {
                Rectangle tmp = this.regua.getBounds();
                Rectangle rec = new Rectangle(this.pos, 0, 1, tmp.height);
                rec.add(new Rectangle(pos, 0, 1, tmp.height));
                this.regua.repaint(rec.x, rec.y, rec.width, rec.height);
                tmp = this.pagina.getBounds();
                rec = new Rectangle(this.pos, 0, 1, tmp.height);
                rec.add(new Rectangle(pos, 0, 1, tmp.height));
                this.pagina.repaint(rec.x, rec.y, rec.width, rec.height);
            }
        }
        this.pos = pos;
    }

    public int getPosicao() {
        return this.pos;
    }

    public boolean horizontal() {
        return this.orientacao == 0;
    }

    public boolean vertical() {
        return this.orientacao == 1;
    }

    public int getOrientacao() {
        return this.orientacao;
    }

    public boolean getRedimensionar() {
        return this.redimensionar;
    }
}

