/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.pagina;

import jalis.util.Funcoes;
import java.awt.Font;
import java.util.Objects;

public class DimensoesAssinaturaDigitalDTO {
    private final Font fonte;
    private final int larguraAssinatura;
    private final int larguraImagem;
    private final int alturaImagem;
    private final boolean estenderImagem;

    private DimensoesAssinaturaDigitalDTO(Builder builder) {
        this.fonte = builder.fonte;
        this.larguraAssinatura = builder.larguraAssinatura;
        this.larguraImagem = builder.larguraImagem;
        this.alturaImagem = builder.alturaImagem;
        this.estenderImagem = builder.estenderImagem;
    }

    public Font getFonte() {
        return this.fonte;
    }

    public int getLarguraAssinatura() {
        return this.larguraAssinatura;
    }

    public int getLarguraImagem() {
        return this.larguraImagem;
    }

    public float getProporcaoLarguraImagem() {
        return this.larguraAssinatura > 0 ? (float)this.larguraImagem / (float)this.larguraAssinatura : 0.0f;
    }

    public int getAlturaImagem() {
        return this.alturaImagem;
    }

    public boolean isEstenderImagem() {
        return this.estenderImagem;
    }

    public String getNomeFonte() {
        String nomeFonte = this.fonte.getName();
        if (!Funcoes.textoVazio(nomeFonte) && nomeFonte.contains(" ")) {
            String[] nomeFonteSeparado = nomeFonte.split(" ");
            nomeFonte = nomeFonteSeparado[0];
        }
        return nomeFonte;
    }

    public int hashCode() {
        return Objects.hash(this.alturaImagem, this.estenderImagem, this.fonte, this.larguraAssinatura, this.larguraImagem);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimensoesAssinaturaDigitalDTO other = (DimensoesAssinaturaDigitalDTO)obj;
        return this.alturaImagem == other.alturaImagem && this.estenderImagem == other.estenderImagem && Objects.equals(this.fonte, other.fonte) && this.larguraAssinatura == other.larguraAssinatura && this.larguraImagem == other.larguraImagem;
    }

    public static class Builder {
        private Font fonte;
        private int larguraAssinatura;
        private int larguraImagem;
        private int alturaImagem;
        private boolean estenderImagem;

        public Builder fonte(Font fonte) {
            this.fonte = fonte;
            return this;
        }

        public Builder larguraAssinatura(int larguraAssinatura) {
            this.larguraAssinatura = larguraAssinatura;
            return this;
        }

        public Builder larguraImagem(int larguraImagem) {
            this.larguraImagem = larguraImagem;
            return this;
        }

        public Builder alturaImagem(int alturaImagem) {
            this.alturaImagem = alturaImagem;
            return this;
        }

        public Builder estenderImagem(boolean estenderImagem) {
            this.estenderImagem = estenderImagem;
            return this;
        }

        public DimensoesAssinaturaDigitalDTO build() {
            return new DimensoesAssinaturaDigitalDTO(this);
        }
    }
}

