/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.pagina;

import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.configurador.pagina.DimensoesAssinaturaDigitalDTO;
import jalis.util.DialogoFonte;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DialogoDimensoesAssinaturaDigital
extends AbstractDialogoOKCancelar {
    private static final String TITULO = "Dimens\u00f5es Assinatura Digital";
    private static final int ALTURA_DIALOGO = 190;
    private static final int LARGURA_DIALOGO = 250;
    private TTextField textLarguraAssinatura = new TTextField(4, 1);
    private TTextField textLarguraImagem = new TTextField(4, 1);
    private TTextField textAlturaImagem = new TTextField(4, 1);
    private TTextField textFonte = new TTextField(40, 3);
    private JButton botaoFonte = ComponenteFactory.novoJButton("Fonte", this);
    private JCheckBox checkEstenderImagem = new JCheckBox("Estender Imagem");
    private Font fonte;
    private final transient DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigital;
    private final int alturaAssinatura;
    private final int larguraImpressao;

    public static DialogoDimensoesAssinaturaDigital novaInstancia(Object dialogoParametrosCorpo, int alturaAssinatura, int larguraImpressao, DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigital) {
        if (dialogoParametrosCorpo instanceof Dialog) {
            return new DialogoDimensoesAssinaturaDigital((Dialog)dialogoParametrosCorpo, alturaAssinatura, larguraImpressao, dimensoesAssinaturaDigital);
        }
        return new DialogoDimensoesAssinaturaDigital((Frame)dialogoParametrosCorpo, alturaAssinatura, larguraImpressao, dimensoesAssinaturaDigital);
    }

    private DialogoDimensoesAssinaturaDigital(Dialog pai, int alturaAssinatura, int larguraImpressao, DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigital) {
        super(pai, TITULO);
        this.alturaAssinatura = alturaAssinatura;
        this.larguraImpressao = larguraImpressao;
        this.dimensoesAssinaturaDigital = Objects.isNull(dimensoesAssinaturaDigital) ? new DimensoesAssinaturaDigitalDTO.Builder().build() : dimensoesAssinaturaDigital;
        this.montarTela();
    }

    private DialogoDimensoesAssinaturaDigital(Frame pai, int alturaAssinatura, int larguraImpressao, DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigital) {
        super(pai, TITULO);
        this.alturaAssinatura = alturaAssinatura;
        this.larguraImpressao = larguraImpressao;
        this.dimensoesAssinaturaDigital = Objects.isNull(dimensoesAssinaturaDigital) ? new DimensoesAssinaturaDigitalDTO.Builder().build() : dimensoesAssinaturaDigital;
        this.montarTela();
    }

    private void montarTela() {
        ScreenUtil.centralizar(this);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        this.setResizable(false);
        this.setModal(true);
        this.setSize(new Dimension(250, 190));
        this.setLocationRelativeTo(null);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 3, 0, 3);
        panel.add((Component)this.botaoFonte, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        this.textFonte.setEditable(false);
        panel.add((Component)this.textFonte, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        panel.add((Component)new JLabel("Largura Assinatura"), gbc);
        ++gbc.gridx;
        panel.add((Component)this.textLarguraAssinatura, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        panel.add((Component)new JLabel("Largura Imagem"), gbc);
        ++gbc.gridx;
        panel.add((Component)this.textLarguraImagem, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        panel.add((Component)new JLabel("Altura Imagem"), gbc);
        ++gbc.gridx;
        panel.add((Component)this.textAlturaImagem, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.checkEstenderImagem, gbc);
        this.carregarDimensoes();
        this.carregarFonte();
    }

    private void carregarDimensoes() {
        this.textAlturaImagem.setText(String.valueOf(this.dimensoesAssinaturaDigital.getAlturaImagem()));
        this.textLarguraAssinatura.setText(String.valueOf(this.dimensoesAssinaturaDigital.getLarguraAssinatura()));
        this.textLarguraImagem.setText(String.valueOf(this.dimensoesAssinaturaDigital.getLarguraImagem()));
        this.checkEstenderImagem.setSelected(this.dimensoesAssinaturaDigital.isEstenderImagem());
    }

    private void carregarFonte() {
        this.fonte = this.dimensoesAssinaturaDigital.getFonte();
        String nomeFonte = Funcoes.textoVazio(this.fonte.getName()) ? ParametrosGerais.getFontePadrao() : this.fonte.getName();
        int tamanho = this.fonte.getSize() < 1 ? 8 : this.fonte.getSize();
        this.fonte = new Font(nomeFonte, this.fonte.getStyle(), tamanho);
        this.textFonte.setText(this.fonte.getFontName());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object evento = e.getSource();
        if (evento == this.botaoFonte) {
            this.selecionarFonte();
        } else if (evento == this.buttonOK) {
            if (this.dimensoesValidas()) {
                this.ok = true;
                this.dispose();
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean dimensoesValidas() {
        int largura;
        if (Funcoes.textoVazio(this.textLarguraAssinatura) || Integer.parseInt(this.textLarguraAssinatura.getText()) <= 0) {
            this.exibirMensagem("Largura da assinatura n\u00e3o foi informada", this.textLarguraAssinatura);
            return false;
        }
        if (Funcoes.textoVazio(this.textAlturaImagem)) {
            this.exibirMensagem("Altura da imagem n\u00e3o foi informada", this.textLarguraAssinatura);
            return false;
        }
        if (Funcoes.textoVazio(this.textLarguraImagem)) {
            this.exibirMensagem("Largura da imagem n\u00e3o foi informada", this.textLarguraAssinatura);
            return false;
        }
        if (!(Funcoes.textoVazio(this.textLarguraAssinatura) || (largura = Integer.parseInt(this.textLarguraAssinatura.getText())) != 0 && largura <= this.larguraImpressao)) {
            this.exibirMensagem("Largura da assinatura superior a largura de impress\u00e3o", this.textLarguraAssinatura);
            return false;
        }
        String mensagemValidacaoImagem = this.validarDimensoesImagem();
        if (mensagemValidacaoImagem.length() > 0) {
            TTextField text = mensagemValidacaoImagem.contains("Altura") ? this.textAlturaImagem : this.textLarguraImagem;
            this.exibirMensagem(mensagemValidacaoImagem, text);
            return false;
        }
        return true;
    }

    private String validarDimensoesImagem() {
        String mensagem = "";
        int largura = Integer.parseInt(this.textLarguraImagem.getText());
        int altura = Integer.parseInt(this.textAlturaImagem.getText());
        if (largura > 0 && altura <= 0) {
            mensagem = "Altura da imagem n\u00e3o foi informada";
        }
        if (largura <= 0 && altura > 0) {
            mensagem = "Largura da imagem n\u00e3o foi informada";
        }
        if (altura > this.alturaAssinatura) {
            mensagem = "Altura da imagem superior a altura da assinatura";
        }
        if (largura > this.larguraImpressao) {
            mensagem = "Largura da imagem superior a largura de impress\u00e3o";
        }
        return mensagem;
    }

    private void exibirMensagem(String mensagem, TTextField text) {
        Funcoes.mensagem(this, mensagem, 2);
        ScreenUtil.requisitarFoco(text);
    }

    private void selecionarFonte() {
        DialogoFonte df = new DialogoFonte(this, "Configura\u00e7\u00e3o de fonte", true);
        df.setFonte(this.fonte);
        df.setVisible(true);
        if (df.ok()) {
            this.fonte = df.getFonte();
            this.textFonte.setText(this.fonte.getFontName());
        }
    }

    public DimensoesAssinaturaDigitalDTO getDimensoes() {
        int larguraAssinatura = Funcoes.textoVazio(this.textLarguraAssinatura) ? 0 : Integer.parseInt(this.textLarguraAssinatura.getText());
        int alturaImagem = Funcoes.textoVazio(this.textAlturaImagem) ? 0 : Integer.parseInt(this.textAlturaImagem.getText());
        int larguraImagem = Funcoes.textoVazio(this.textLarguraImagem) ? 0 : Integer.parseInt(this.textLarguraImagem.getText());
        return new DimensoesAssinaturaDigitalDTO.Builder().alturaImagem(alturaImagem).estenderImagem(this.checkEstenderImagem.isSelected()).fonte(this.fonte).larguraAssinatura(larguraAssinatura).larguraImagem(larguraImagem).build();
    }
}

