/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.historicos;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.digitacao.componente.ModeloTabelaHistoricos;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class DialogoHistorico
extends JDialog
implements DisposeListener,
ActionListener {
    private JTextField textLocalizar = new JTextField();
    private JButton buttonOk = ComponenteFactory.novoJButton("Ok", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private ModeloTabelaHistoricos modeloHistoricos = new ModeloTabelaHistoricos();
    private JTable tabelaHistoricos = new JTable(this.modeloHistoricos);
    private boolean ok;
    private String codigoSelecionado = "";
    private String descricaoSelecionado = "";

    public static DialogoHistorico novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoHistorico((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoHistorico((Dialog)pai);
        }
        return null;
    }

    public DialogoHistorico(Frame pai) {
        super(pai, "Hist\u00f3ricos", true);
        this.iniciar();
    }

    public DialogoHistorico(Dialog pai) {
        super(pai, "Hist\u00f3ricos", true);
        this.iniciar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            int linha = 0;
            this.ok = o == this.buttonOk && (linha = this.tabelaHistoricos.getSelectedRow()) > -1;
            if (this.ok) {
                this.codigoSelecionado = (String)this.modeloHistoricos.getValueAt(linha, 0);
                this.descricaoSelecionado = (String)this.modeloHistoricos.getValueAt(linha, 1);
            }
            if (o == this.buttonCancelar || this.ok) {
                this.dispose();
            }
        }
    }

    public void setHistoricos(Map<String, String> historicos) {
        if (historicos != null) {
            this.modeloHistoricos.setHistoricos(historicos);
            this.tabelaHistoricos.getColumnModel().getColumn(0).setMaxWidth(70);
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public String getDescricaoSelecionado() {
        return this.descricaoSelecionado;
    }

    public String getCodigoSelecionado() {
        return this.codigoSelecionado;
    }

    private void iniciar() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panel, "North");
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add((Component)ComponenteFactory.novoJLabel("Localizar: ", 'L', null, this.textLocalizar), "West");
        panel.add((Component)this.textLocalizar, "Center");
        this.tabelaHistoricos.getTableHeader().setReorderingAllowed(false);
        this.tabelaHistoricos.getTableHeader().addMouseListener(this.modeloHistoricos);
        this.getContentPane().add((Component)new JScrollPane(this.tabelaHistoricos), "Center");
        panel = new JPanel(new FlowLayout(2, 3, 3));
        this.getContentPane().add((Component)panel, "South");
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        this.textLocalizar.setBorder(BorderFactory.createTitledBorder(""));
        this.textLocalizar.setPreferredSize(new Dimension(10, 25));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                DialogoHistorico.this.modeloHistoricos.filtrar(DialogoHistorico.this.textLocalizar.getText());
                if (DialogoHistorico.this.modeloHistoricos.getRowCount() > 0) {
                    DialogoHistorico.this.tabelaHistoricos.setRowSelectionInterval(0, 0);
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(10, 0, false), "ENTER", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogoHistorico.this.buttonOk.isEnabled()) {
                    DialogoHistorico.this.buttonOk.doClick();
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(27, 0, true), "ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoHistorico.this.buttonCancelar.doClick();
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, true), "UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = 0;
                row = DialogoHistorico.this.tabelaHistoricos.getSelectedRow();
                if (row > -1 && row > 0) {
                    DialogoHistorico.this.tabelaHistoricos.setRowSelectionInterval(row - 1, row - 1);
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, true), "DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = DialogoHistorico.this.tabelaHistoricos.getSelectedRow();
                if (row < 0 && DialogoHistorico.this.tabelaHistoricos.getRowCount() > 0) {
                    DialogoHistorico.this.tabelaHistoricos.setRowSelectionInterval(0, 0);
                } else if (row > -1 && row < DialogoHistorico.this.tabelaHistoricos.getRowCount() - 1) {
                    DialogoHistorico.this.tabelaHistoricos.setRowSelectionInterval(row + 1, row + 1);
                }
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textLocalizar);
    }
}

