/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.expressao;

import jalis.laboratorio.configurador.expressao.SintaticoExpressao;
import java.util.ArrayList;
import java.util.List;

public class Token {
    public static final int IDENT = 0;
    public static final int TEXTO = 1;
    public static final int CHAR = 2;
    public static final int DECIMAL = 3;
    public static final int INTEIRO = 4;
    public static final int SE = 5;
    public static final int COPIA = 6;
    public static final int VAZIO = 7;
    public static final int ZERO = 8;
    public static final int DATA = 9;
    public static final int EXTENSO = 10;
    public static final int NUMERO = 11;
    public static final int SOMADATA = 12;
    public static final int TAMANHO = 13;
    public static final int E = 14;
    public static final int OU = 15;
    public static final int ABRE = 16;
    public static final int FECHA = 17;
    public static final int MENOR = 18;
    public static final int MAIOR = 19;
    public static final int MENOR_IGUAL = 20;
    public static final int MAIOR_IGUAL = 21;
    public static final int IGUAL = 22;
    public static final int DIFERENTE = 23;
    public static final int MULTI = 24;
    public static final int DIV = 25;
    public static final int MENOS = 26;
    public static final int MAIS = 27;
    public static final int PONTO_VIRGULA = 28;
    public static final int NULO = 29;
    public static final int EXPOENTE = 30;
    public static final int LOG10 = 31;
    public static final int CONVERTEDECIMAL = 32;
    public static final int VALIDARNORMAL = 33;
    public static final int CONTEM = 34;
    public static final int RAIZQUADRADA = 35;
    public static final int LIMPAMASCARA = 36;
    public static final int NOTACAOCIENTIFICA = 37;
    public static final int PEGAVALORCAMPO = 38;
    public static final int TP_LEXICO = 0;
    public static final int TP_SINTATICO = 1;
    public static final int TP_SEMANTICO = 2;
    public int tipoErro = -1;
    public boolean erro = false;
    public String erroDesc = "";
    public String lexema = "";
    public int id = -1;
    public int linha;
    public int coluna;
    public int pos;

    public String toString() {
        return this.lexema + (this.erro ? "  err: " + this.erroDesc : "  id: " + this.getIdStr()) + "  lin: " + Integer.toString(this.linha) + "  col: " + Integer.toString(this.coluna);
    }

    public boolean funcao() {
        switch (this.id) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return true;
            }
        }
        return false;
    }

    public boolean operadorMatematico() {
        switch (this.id) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 35: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public boolean operadorRelacional() {
        switch (this.id) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public boolean operadorLogico() {
        switch (this.id) {
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public boolean literal() {
        switch (this.id) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public Object instancia() {
        switch (this.id) {
            case 1: 
            case 2: {
                return this.lexema.substring(1, this.lexema.length() - 1);
            }
            case 3: {
                return new Double(this.lexema.replace(',', '.'));
            }
            case 4: {
                return new Long(this.lexema);
            }
        }
        return null;
    }

    private String getIdStr() {
        switch (this.id) {
            case 0: {
                return "IDENT";
            }
            case 5: {
                return "SE";
            }
            case 6: {
                return "COPIA";
            }
            case 7: {
                return "VAZIO";
            }
            case 8: {
                return "ZERO";
            }
            case 9: {
                return "DATA";
            }
            case 10: {
                return "EXTENSO";
            }
            case 11: {
                return "NUMERO";
            }
            case 12: {
                return "SOMADATA";
            }
            case 13: {
                return "TAMANHO";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "OU";
            }
            case 1: {
                return "TEXTO";
            }
            case 2: {
                return "CHAR";
            }
            case 4: {
                return "INTEIRO";
            }
            case 3: {
                return "DECIMAL";
            }
            case 16: {
                return "ABRE";
            }
            case 17: {
                return "FECHA";
            }
            case 27: {
                return "MAIS";
            }
            case 26: {
                return "MENOS";
            }
            case 24: {
                return "MULTI";
            }
            case 25: {
                return "DIV";
            }
            case 28: {
                return "PONTO_VIRGULA";
            }
            case 22: {
                return "IGUAL";
            }
            case 19: {
                return "MAIOR";
            }
            case 18: {
                return "MENOR";
            }
            case 21: {
                return "MAIOR_IGUAL";
            }
            case 20: {
                return "MENOR_IGUAL";
            }
            case 23: {
                return "DIFERENTE";
            }
            case 29: {
                return "NULO";
            }
            case 30: {
                return "EXPOENTE";
            }
            case 31: {
                return "LOG10";
            }
            case 32: {
                return "CONVERTEDECIMAL";
            }
            case 33: {
                return "VALIDARNORMAL";
            }
            case 34: {
                return "CONTEM";
            }
            case 35: {
                return "RAIZQUADRADA";
            }
            case 36: {
                return "LIMPAMASCARA";
            }
            case 37: {
                return "NOTACAOCIENTIFICA";
            }
            case 38: {
                return "PEGAVALORCAMPO";
            }
        }
        return "";
    }

    public static List<String> getIdentificadores(String expressao) {
        ArrayList<String> res = new ArrayList<String>();
        SintaticoExpressao sin = new SintaticoExpressao(expressao, 8);
        Token tk = sin.getProxToken();
        while (tk.id != 29 && !tk.erro) {
            if (tk.id == 0) {
                res.add(tk.lexema);
            }
            tk = sin.getProxToken();
        }
        return res;
    }
}

