/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.expressao;

import jalis.laboratorio.configurador.expressao.Token;

public class Lexico {
    private static final int q0 = 0;
    private static final int q1 = 1;
    private static final int q2 = 2;
    private static final int q3 = 3;
    private static final int q4 = 4;
    private static final int q5 = 5;
    private static final int q6 = 6;
    private static final int q7 = 7;
    private static final int q8 = 8;
    private static final int q9 = 9;
    private static final int q10 = 10;
    private static final int q11 = 11;
    private static final int q12 = 12;
    private static final int q13 = 13;
    private static final int q14 = 14;
    private static final int q15 = 15;
    private static final int q16 = 16;
    private static final int q17 = 17;
    private static final int q18 = 18;
    private static final int q19 = 19;
    private static final int q20 = 20;
    private static final int q21 = 21;
    private static final int q22 = 22;
    private static final int q23 = 23;
    private static final int q24 = 24;
    private static final int q25 = 25;
    private static final int q26 = 26;
    private static final int q27 = 27;
    private static final int q28 = 28;
    private static final int q29 = 29;
    private char[] exp;
    private int pos = 0;
    private int estado;
    private boolean erro;
    private String erroDesc;
    private int tamTab;
    private int lin;
    private int col;

    public Lexico(String exp, int tamTab) {
        this.exp = exp.toCharArray();
        this.tamTab = tamTab;
        this.lin = 1;
        this.col = 0;
    }

    public Token getProxToken() {
        char ch;
        String lex = "";
        this.estado = 0;
        this.erro = false;
        while (Character.isWhitespace(ch = this.getChar())) {
        }
        int linha = this.lin;
        int coluna = this.col;
        int posicao = this.pos;
        while (!this.estadoFinal() && !this.erro) {
            this.automato(ch);
            if (this.erro) continue;
            if (!this.estadoEspecial() && ch != '\u0000') {
                lex = lex + ch;
            }
            if (this.estadoFinal()) continue;
            ch = this.getChar();
        }
        if (this.estadoEspecial() && ch != '\u0000') {
            this.recuar();
        }
        Token tok = new Token();
        if (this.estado == 28) {
            tok.id = 29;
            tok.coluna = coluna + 1;
            tok.pos = posicao;
        } else {
            if (this.erro) {
                tok.erro = this.erro;
                tok.tipoErro = 0;
                tok.erroDesc = this.erroDesc;
            }
            tok.id = this.getId(lex);
            tok.lexema = lex;
            tok.coluna = coluna;
            tok.pos = posicao - 1;
        }
        tok.linha = linha;
        return tok;
    }

    private void automato(char ch) {
        switch (this.estado) {
            case 0: {
                if (Character.isLetter(ch) || ch == '_') {
                    this.estado = 1;
                    break;
                }
                if (ch == '\"') {
                    this.estado = 3;
                    break;
                }
                if (Character.isDigit(ch)) {
                    this.estado = 8;
                    break;
                }
                if (ch == '(') {
                    this.estado = 13;
                    break;
                }
                if (ch == ')') {
                    this.estado = 14;
                    break;
                }
                if (ch == '+') {
                    this.estado = 15;
                    break;
                }
                if (ch == '-') {
                    this.estado = 16;
                    break;
                }
                if (ch == '*') {
                    this.estado = 17;
                    break;
                }
                if (ch == '/') {
                    this.estado = 18;
                    break;
                }
                if (ch == ';') {
                    this.estado = 19;
                    break;
                }
                if (ch == '=') {
                    this.estado = 20;
                    break;
                }
                if (ch == '>') {
                    this.estado = 21;
                    break;
                }
                if (ch == '<') {
                    this.estado = 24;
                    break;
                }
                if (ch == '\u0000') {
                    this.estado = 28;
                    break;
                }
                if (ch == '^') {
                    this.estado = 29;
                    break;
                }
                this.erro = true;
                this.erroDesc = "Caractere inv\u00e1lido";
                break;
            }
            case 1: {
                if (Character.isLetterOrDigit(ch) || ch == '_') break;
                this.estado = 2;
                break;
            }
            case 3: {
                if (ch == '\"') {
                    this.estado = 6;
                    break;
                }
                if (ch == '\u0000') {
                    this.erro = true;
                    this.erroDesc = "Texto n\u00e3o terminado";
                    break;
                }
                this.estado = 4;
                break;
            }
            case 4: {
                if (ch == '\"') {
                    this.estado = 7;
                    break;
                }
                if (ch == '\u0000') {
                    this.erro = true;
                    this.erroDesc = "Texto n\u00e3o terminado";
                    break;
                }
                this.estado = 5;
                break;
            }
            case 5: {
                if (ch == '\"') {
                    this.estado = 6;
                    break;
                }
                if (ch != '\u0000') break;
                this.erro = true;
                this.erroDesc = "Texto n\u00e3o terminado";
                break;
            }
            case 8: {
                if (ch == ',') {
                    this.estado = 9;
                    break;
                }
                if (Character.isDigit(ch)) break;
                this.estado = 12;
                break;
            }
            case 9: {
                if (Character.isDigit(ch)) {
                    this.estado = 10;
                    break;
                }
                this.erro = true;
                this.erroDesc = "N\u00famero decimal inv\u00e1lido";
                break;
            }
            case 10: {
                if (Character.isDigit(ch)) break;
                this.estado = 11;
                break;
            }
            case 21: {
                if (ch == '=') {
                    this.estado = 23;
                    break;
                }
                this.estado = 22;
                break;
            }
            case 24: {
                this.estado = ch == '=' ? 26 : (ch == '>' ? 27 : 25);
            }
        }
    }

    private boolean estadoFinal() {
        switch (this.estado) {
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    private boolean estadoEspecial() {
        switch (this.estado) {
            case 2: 
            case 11: 
            case 12: 
            case 22: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    private int getId(String lex) {
        switch (this.estado) {
            case 2: {
                return this.lexParaId(lex);
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 2;
            }
            case 11: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 16;
            }
            case 14: {
                return 17;
            }
            case 15: {
                return 27;
            }
            case 16: {
                return 26;
            }
            case 17: {
                return 24;
            }
            case 18: {
                return 25;
            }
            case 19: {
                return 28;
            }
            case 20: {
                return 22;
            }
            case 22: {
                return 19;
            }
            case 23: {
                return 21;
            }
            case 25: {
                return 18;
            }
            case 26: {
                return 20;
            }
            case 27: {
                return 23;
            }
            case 28: {
                return 29;
            }
            case 29: {
                return 30;
            }
        }
        return -1;
    }

    private int lexParaId(String lex) {
        if (lex.equalsIgnoreCase("se")) {
            return 5;
        }
        if (lex.equalsIgnoreCase("copia")) {
            return 6;
        }
        if (lex.equalsIgnoreCase("vazio")) {
            return 7;
        }
        if (lex.equalsIgnoreCase("zero")) {
            return 8;
        }
        if (lex.equalsIgnoreCase("data")) {
            return 9;
        }
        if (lex.equalsIgnoreCase("extenso")) {
            return 10;
        }
        if (lex.equalsIgnoreCase("numero")) {
            return 11;
        }
        if (lex.equalsIgnoreCase("somadata")) {
            return 12;
        }
        if (lex.equalsIgnoreCase("tamanho")) {
            return 13;
        }
        if (lex.equalsIgnoreCase("log10")) {
            return 31;
        }
        if (lex.equalsIgnoreCase("convertedecimal")) {
            return 32;
        }
        if (lex.equalsIgnoreCase("validarnormal")) {
            return 33;
        }
        if (lex.equalsIgnoreCase("contem")) {
            return 34;
        }
        if (lex.equalsIgnoreCase("e")) {
            return 14;
        }
        if (lex.equalsIgnoreCase("ou")) {
            return 15;
        }
        if (lex.equalsIgnoreCase("raizquadrada")) {
            return 35;
        }
        if (lex.equalsIgnoreCase("limpamascara")) {
            return 36;
        }
        if (lex.equalsIgnoreCase("notacaocientifica")) {
            return 37;
        }
        if (lex.equalsIgnoreCase("pegavalorcampo")) {
            return 38;
        }
        return 0;
    }

    private char getChar() {
        char ch = '\u0000';
        if (this.pos < this.exp.length) {
            if ((ch = this.exp[this.pos++]) == '\r' || ch == '\n') {
                ++this.lin;
                this.col = 0;
            } else {
                this.col = ch == '\t' ? (this.col += this.tamTab - this.col % this.tamTab) : ++this.col;
            }
        }
        return ch;
    }

    private void recuar() {
        if (this.pos >= 0) {
            --this.pos;
            if (this.exp[this.pos] == '\r' || this.exp[this.pos] == '\n') {
                --this.lin;
            } else if (this.exp[this.pos] == '\t') {
                int i;
                for (i = this.pos; i > 0 && this.exp[i - 1] != '\r' && this.exp[i - 1] != '\n'; --i) {
                }
                this.col = 0;
                while (i < this.pos) {
                    this.col = this.exp[i] == '\t' ? (this.col += this.tamTab - this.col % this.tamTab) : ++this.col;
                    ++i;
                }
            } else {
                --this.col;
            }
        }
    }
}

