/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.expressao;

import jalis.laboratorio.configurador.expressao.Lexico;
import jalis.laboratorio.configurador.expressao.Token;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class EstiloDocumento
extends DefaultStyledDocument {
    private SimpleAttributeSet erro = new SimpleAttributeSet();
    private SimpleAttributeSet simples = new SimpleAttributeSet();
    private SimpleAttributeSet simbolo = new SimpleAttributeSet();
    private SimpleAttributeSet string = new SimpleAttributeSet();
    private SimpleAttributeSet numero = new SimpleAttributeSet();
    private SimpleAttributeSet funcao = new SimpleAttributeSet();
    private JTextComponent text;
    private ChangeEvent evento;

    public EstiloDocumento(JTextComponent text) {
        this.text = text;
        StyleConstants.setBold(this.funcao, true);
        StyleConstants.setForeground(this.string, Color.red);
        StyleConstants.setForeground(this.numero, Color.blue);
        StyleConstants.setForeground(this.simbolo, Color.blue);
        StyleConstants.setBackground(this.erro, Color.red);
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offs, str, a);
        this.highLight();
        this.fireStateChanged();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.highLight();
        this.fireStateChanged();
    }

    public void destacarErro(int pos) {
        try {
            if (pos >= this.getLength()) {
                super.insertString(pos, " ", this.erro);
            } else {
                String ident = this.getIdentErro(pos);
                super.remove(pos, ident.length());
                super.insertString(pos, ident, this.erro);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "EstiloDocumento: 62");
        }
    }

    public void highLight() throws BadLocationException {
        int caretPos = this.text.getCaretPosition();
        String str = this.getText(0, this.getLength());
        Lexico lex = new Lexico(str, 10);
        super.remove(0, str.length());
        super.insertString(0, str, this.simples);
        Token tok = lex.getProxToken();
        while (tok.id != 29 || tok.erro) {
            super.remove(tok.pos, tok.lexema.length());
            super.insertString(tok.pos, tok.lexema, this.estilo(tok));
            tok = lex.getProxToken();
        }
        this.text.setCaretPosition(caretPos);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public void fireStateChanged() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
            if (ouvintes[i] != ChangeListener.class) continue;
            if (this.evento == null) {
                this.evento = new ChangeEvent(this);
            }
            ((ChangeListener)ouvintes[i + 1]).stateChanged(this.evento);
        }
    }

    private String getIdentErro(int pos) throws BadLocationException {
        char[] str = this.getText(pos, this.getLength() - pos + 1).toCharArray();
        int tam = 1;
        if (Character.isJavaIdentifierPart(str[0]) || str[0] == '\"') {
            for (int i = 1; i < str.length && (Character.isJavaIdentifierPart(str[i]) || str[i] == '\"'); ++i) {
                ++tam;
            }
        }
        return this.getText(pos, tam);
    }

    private AttributeSet estilo(Token tok) {
        if (this.funcao(tok.id)) {
            return this.funcao;
        }
        if (this.simbolo(tok.id)) {
            return this.simbolo;
        }
        if (this.numero(tok.id)) {
            return this.numero;
        }
        if (this.string(tok.id)) {
            return this.string;
        }
        return this.simples;
    }

    private boolean funcao(int id) {
        return id == 5 || id == 6 || id == 7 || id == 8 || id == 9 || id == 10 || id == 11 || id == 12 || id == 13 || id == 31 || id == 32 || id == 33 || id == 34 || id == 14 || id == 15 || id == 35 || id == 36 || id == 37 || id == 38;
    }

    private boolean simbolo(int id) {
        return id == 16 || id == 17 || id == 27 || id == 26 || id == 24 || id == 25 || id == 30 || id == 28 || id == 19 || id == 18 || id == 21 || id == 20 || id == 22 || id == 23;
    }

    private boolean numero(int id) {
        return id == 4 || id == 3;
    }

    private boolean string(int id) {
        return id == 1 || id == 2;
    }
}

