/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.expressao;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.componente.Forma;
import jalis.laboratorio.configurador.componente.Imagem;
import jalis.laboratorio.configurador.componente.ResultadoAnterior;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.laboratorio.configurador.expressao.DialogoFuncao;
import jalis.laboratorio.configurador.expressao.DialogoFuncaoFactory;
import jalis.laboratorio.configurador.expressao.EstiloDocumento;
import jalis.laboratorio.configurador.expressao.Sintatico;
import jalis.laboratorio.configurador.expressao.SintaticoCondicao;
import jalis.laboratorio.configurador.expressao.SintaticoExpressao;
import jalis.laboratorio.configurador.expressao.Token;
import jalis.laboratorio.configurador.pagina.Pagina;
import jalis.laboratorio.impressao.Impressao;
import jalis.util.DialogoCor;
import jalis.util.DialogoLista;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DialogoExpressao
extends JDialog
implements ActionListener,
DisposeListener {
    JTextPane textExp = new JTextPane();
    JPanel panelBarra = new JPanel(new FlowLayout(2, 3, 3));
    JPanel panelCentro = new JPanel(new GridBagLayout());
    JPanel panelCampo = new JPanel(new FlowLayout(0, 3, 3));
    JPanel panelOpLogico = new JPanel(new FlowLayout(0, 3, 3));
    JPanel panelOpMatematico = new JPanel(new FlowLayout(0, 3, 3));
    JPanel panelOpRelacional = new JPanel(new FlowLayout(0, 3, 3));
    JPanel panelFuncao = new JPanel(new FlowLayout(0, 3, 3));
    JPanel panelFuncao2 = new JPanel(new FlowLayout(0, 3, 3));
    JPanel panelCor = new JPanel(new FlowLayout(0, 3, 3));
    Dimension dimTemp = new Dimension(40, 25);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    JButton buttonOk = ComponenteFactory.novoJButton("Ok", 'O', this, null, null);
    JButton buttonE = ComponenteFactory.novoJButton("E", '\u0000', this, null, this.dimTemp);
    JButton buttonOu = ComponenteFactory.novoJButton("Ou", '\u0000', this, null, this.dimTemp);
    JButton buttonMenos = ComponenteFactory.novoJButton("-", '\u0000', this, null, this.dimTemp);
    JButton buttonMais = ComponenteFactory.novoJButton("+", '\u0000', this, null, this.dimTemp);
    JButton buttonExp = ComponenteFactory.novoJButton("^", '\u0000', this, null, this.dimTemp);
    JButton buttonMulti = ComponenteFactory.novoJButton("*", '\u0000', this, null, this.dimTemp);
    JButton buttonDiv = ComponenteFactory.novoJButton("/", '\u0000', this, null, this.dimTemp);
    JButton buttonIgual = ComponenteFactory.novoJButton("=", '\u0000', this, null, this.dimTemp);
    JButton buttonDiferente = ComponenteFactory.novoJButton("<>", '\u0000', this, null, this.dimTemp);
    JButton buttonMaior = ComponenteFactory.novoJButton(">", '\u0000', this, null, this.dimTemp);
    JButton buttonMenor = ComponenteFactory.novoJButton("<", '\u0000', this, null, this.dimTemp);
    JButton buttonMaiorIgual = ComponenteFactory.novoJButton(">=", '\u0000', this, null, this.dimTemp);
    JButton buttonMenorIgual = ComponenteFactory.novoJButton("<=", '\u0000', this, null, this.dimTemp);
    JButton buttonVariaveis = ComponenteFactory.novoJButton("Vari\u00e1veis", '\u0000', this, null, null);
    JButton buttonExame = ComponenteFactory.novoJButton("Exame", '\u0000', this, null, null);
    JButton buttonBanco = ComponenteFactory.novoJButton("Banco", '\u0000', this, null, null);
    JButton buttonConfiguracaoCor = ComponenteFactory.novoJButton("Configura\u00e7\u00e3o de Cor", '\u0000', this, null, null);
    private ActionListener acaoFuncao = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogoFuncao de;
            Integer tipo = (Integer)DialogoExpressao.this.funcoes.get(e.getSource());
            if (tipo != null && (de = DialogoFuncaoFactory.criarDialogoFuncao(tipo, DialogoExpressao.this)) != null) {
                if (DialogoExpressao.this.pagina != null && DialogoExpressao.this.pagina.getTipoConfiguracao() == 0 && DialogoExpressao.this.pagina.getListaVariaveis() != null) {
                    de.setVariaveis(DialogoExpressao.this.pagina.getListaVariaveis());
                }
                if (DialogoExpressao.this.pagina != null && DialogoExpressao.this.pagina.getTipoConfiguracao() == 0) {
                    de.setVariaveis(new String[]{"dataAtual", "versaoLayout"});
                } else {
                    de.setVariaveis(Impressao.Variaveis.getVariaveis());
                }
                de.setCamposBanco(DialogoExpressao.this.camposBanco);
                de.setCamposExame(DialogoExpressao.this.camposExame);
                de.setVisible(true);
                if (de.ok()) {
                    DialogoExpressao.this.insereTexto(de.getExpressao());
                }
            }
        }
    };
    JButton buttonSe = ComponenteFactory.novoJButton("Se", '\u0000', this.acaoFuncao, null, this.dimTemp);
    JButton buttonCopia = ComponenteFactory.novoJButton("Copia", '\u0000', this.acaoFuncao, null, null);
    JButton buttonVazio = ComponenteFactory.novoJButton("Vazio", '\u0000', this.acaoFuncao, null, null);
    JButton buttonZero = ComponenteFactory.novoJButton("Zero", '\u0000', this.acaoFuncao, null, null);
    JButton buttonData = ComponenteFactory.novoJButton("Data", '\u0000', this.acaoFuncao, null, null);
    JButton buttonExtenso = ComponenteFactory.novoJButton("Extenso", '\u0000', this.acaoFuncao, null, null);
    JButton buttonSomaData = ComponenteFactory.novoJButton("SomaData", '\u0000', this.acaoFuncao, null, null);
    JButton buttonPegaValorCampo = ComponenteFactory.novoJButton("PegaValorCampo", '\u0000', this.acaoFuncao, null, null);
    JButton buttonTamanho = ComponenteFactory.novoJButton("Tamanho", '\u0000', this.acaoFuncao, null, null);
    JButton buttonNumero = ComponenteFactory.novoJButton("Numero", '\u0000', this.acaoFuncao, null, null);
    JButton buttonLog10 = ComponenteFactory.novoJButton("Log10", '\u0000', this.acaoFuncao, null, null);
    JButton buttonConverteDecimal = ComponenteFactory.novoJButton("ConverteDecimal", '\u0000', this.acaoFuncao, null, null);
    JButton buttonValidarNormal = ComponenteFactory.novoJButton("ValidarNormal", '\u0000', this.acaoFuncao, null, null);
    JButton buttonContem = ComponenteFactory.novoJButton("Contem", '\u0000', this.acaoFuncao, null, null);
    JButton buttonRaizQuadrada = ComponenteFactory.novoJButton("Raiz Quadrada", '\u0000', this.acaoFuncao, null, null);
    JButton buttonNotacaoCientifica = ComponenteFactory.novoJButton("Nota\u00e7\u00e3o Cient\u00edfica", '\u0000', this.acaoFuncao, null, null);
    JButton buttonLimpaMascara = ComponenteFactory.novoJButton("LimpaMascara", '\u0000', this.acaoFuncao, null, null);
    JLabel labelMsn = ComponenteFactory.novoJLabel(" ", this.dimTemp);
    EstiloDocumento doc = new EstiloDocumento(this.textExp);
    private String exp = "";
    private String[] camposBanco = new String[0];
    private String[] camposExame = new String[0];
    private Componente[] componentes = new Componente[0];
    private Pagina pagina;
    private int tipo;
    private Map<Object, Integer> funcoes = new HashMap<Object, Integer>();

    public static DialogoExpressao novaInstancia(Object pai, String titulo, int tipo) {
        if (pai instanceof Frame) {
            return new DialogoExpressao((Frame)pai, titulo, true, tipo);
        }
        if (pai instanceof Dialog) {
            return new DialogoExpressao((Dialog)pai, titulo, true, tipo);
        }
        return null;
    }

    public DialogoExpressao(Frame pai, String title, boolean modal, int tipo) {
        super(pai, title, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        try {
            this.tipo = tipo;
            this.iniciar();
            if (pai != null) {
                this.setLocation(ScreenUtil.getCentralizado(pai.getBounds(), this.getSize()));
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(pai, ex.getMessage(), ex.getStackTrace(), "DialogoExpressao: 135");
        }
    }

    public DialogoExpressao(Dialog pai, String title, boolean modal, int tipo) {
        super(pai, title, modal);
        try {
            this.tipo = tipo;
            this.iniciar();
            if (pai != null) {
                this.setLocation(ScreenUtil.getCentralizado(pai.getBounds(), this.getSize()));
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(pai, ex.getMessage(), ex.getStackTrace(), "DialogoExpressao: 155");
        }
    }

    private void iniciar() {
        this.setSize(new Dimension(850, 400));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.getContentPane().add((Component)this.panelBarra, "South");
        this.panelBarra.setBorder(BorderFactory.createEtchedBorder());
        this.panelBarra.add(this.buttonOk);
        this.panelBarra.add(this.buttonCancelar);
        this.panelCampo.add(ComponenteFactory.novoJLabel("Campo", new Dimension(100, 22)));
        this.panelCampo.add(this.buttonVariaveis);
        this.panelCampo.add(this.buttonBanco);
        this.panelCampo.add(this.buttonExame);
        this.panelOpLogico.add(ComponenteFactory.novoJLabel("Op. l\u00f3gico", new Dimension(100, 22)));
        this.panelOpLogico.add(this.buttonE);
        this.panelOpLogico.add(this.buttonOu);
        this.panelOpMatematico.add(ComponenteFactory.novoJLabel("Op. matem\u00e1tico", new Dimension(100, 22)));
        this.panelOpMatematico.add(this.buttonMais);
        this.panelOpMatematico.add(this.buttonMenos);
        this.panelOpMatematico.add(this.buttonMulti);
        this.panelOpMatematico.add(this.buttonDiv);
        this.panelOpMatematico.add(this.buttonExp);
        this.panelOpRelacional.add(ComponenteFactory.novoJLabel("Op. relacional", new Dimension(100, 22)));
        this.panelOpRelacional.add(this.buttonIgual);
        this.panelOpRelacional.add(this.buttonDiferente);
        this.panelOpRelacional.add(this.buttonMaior);
        this.panelOpRelacional.add(this.buttonMenor);
        this.panelOpRelacional.add(this.buttonMaiorIgual);
        this.panelOpRelacional.add(this.buttonMenorIgual);
        this.panelFuncao.add(ComponenteFactory.novoJLabel("Fun\u00e7\u00e3o", new Dimension(100, 22)));
        this.panelFuncao.add(this.buttonSe);
        this.panelFuncao.add(this.buttonCopia);
        this.panelFuncao.add(this.buttonVazio);
        this.panelFuncao.add(this.buttonZero);
        this.panelFuncao.add(this.buttonExtenso);
        this.panelFuncao.add(this.buttonTamanho);
        this.panelFuncao.add(this.buttonNumero);
        this.panelFuncao.add(this.buttonData);
        this.panelFuncao.add(this.buttonSomaData);
        this.panelFuncao.add(this.buttonPegaValorCampo);
        this.panelFuncao2.add(ComponenteFactory.novoJLabel("", new Dimension(100, 22)));
        this.panelFuncao2.add(this.buttonLog10);
        this.panelFuncao2.add(this.buttonConverteDecimal);
        this.panelFuncao2.add(this.buttonValidarNormal);
        this.panelFuncao2.add(this.buttonContem);
        this.panelFuncao2.add(this.buttonRaizQuadrada);
        this.panelFuncao2.add(this.buttonLimpaMascara);
        this.panelFuncao2.add(this.buttonNotacaoCientifica);
        this.panelCor.add(ComponenteFactory.novoJLabel("Cor", new Dimension(100, 22)));
        this.panelCor.add(this.buttonConfiguracaoCor);
        this.labelMsn.setBorder(BorderFactory.createTitledBorder(""));
        this.textExp.setFont(new Font("Monospaced", 0, 13));
        this.textExp.setStyledDocument(this.doc);
        this.doc.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DialogoExpressao.this.labelMsn.getText().length() > 1) {
                    DialogoExpressao.this.labelMsn.setText(" ");
                }
            }
        });
        this.buttonConfiguracaoCor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoExpressao.this.getConfigurarCor();
            }
        });
        this.funcoes.put(this.buttonSe, new Integer(0));
        this.funcoes.put(this.buttonCopia, new Integer(1));
        this.funcoes.put(this.buttonVazio, new Integer(2));
        this.funcoes.put(this.buttonZero, new Integer(3));
        this.funcoes.put(this.buttonExtenso, new Integer(4));
        this.funcoes.put(this.buttonTamanho, new Integer(5));
        this.funcoes.put(this.buttonNumero, new Integer(6));
        this.funcoes.put(this.buttonData, new Integer(7));
        this.funcoes.put(this.buttonSomaData, new Integer(8));
        this.funcoes.put(this.buttonPegaValorCampo, new Integer(16));
        this.funcoes.put(this.buttonLog10, new Integer(9));
        this.funcoes.put(this.buttonConverteDecimal, new Integer(10));
        this.funcoes.put(this.buttonValidarNormal, new Integer(11));
        this.funcoes.put(this.buttonContem, new Integer(12));
        this.funcoes.put(this.buttonRaizQuadrada, new Integer(13));
        this.funcoes.put(this.buttonNotacaoCientifica, new Integer(15));
        this.funcoes.put(this.buttonLimpaMascara, new Integer(14));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        this.panelCentro.add((Component)new JScrollPane(this.textExp), cons);
        cons.weighty = 0.0;
        cons.gridy = 1;
        this.panelCentro.add((Component)this.labelMsn, cons);
        cons.gridy = 2;
        this.panelCentro.add((Component)this.panelCampo, cons);
        cons.gridy = 3;
        this.panelCentro.add((Component)this.panelOpLogico, cons);
        cons.gridy = 4;
        this.panelCentro.add((Component)this.panelOpMatematico, cons);
        cons.gridy = 5;
        this.panelCentro.add((Component)this.panelOpRelacional, cons);
        cons.gridy = 6;
        this.panelCentro.add((Component)this.panelFuncao, cons);
        cons.gridy = 7;
        this.panelCentro.add((Component)this.panelFuncao2, cons);
        cons.gridy = 8;
        this.panelCentro.add((Component)this.panelCor, cons);
        this.textExp.setEditable(true);
        ScreenUtil.requisitarFoco(this.textExp);
    }

    public void setComponentes(Componente[] comp) {
        this.componentes = comp;
    }

    public void setPagina(Pagina pagina) {
        this.pagina = pagina;
        if (pagina != null) {
            this.camposBanco = pagina.getCamposBanco();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.buttonE) {
            this.insereTexto(" e ");
        } else if (obj == this.buttonOu) {
            this.insereTexto(" ou ");
        } else if (obj == this.buttonMais) {
            this.insereTexto(" + ");
        } else if (obj == this.buttonMenos) {
            this.insereTexto(" - ");
        } else if (obj == this.buttonMulti) {
            this.insereTexto(" * ");
        } else if (obj == this.buttonDiv) {
            this.insereTexto(" / ");
        } else if (obj == this.buttonExp) {
            this.insereTexto(" ^ ");
        } else if (obj == this.buttonIgual) {
            this.insereTexto(" = ");
        } else if (obj == this.buttonDiferente) {
            this.insereTexto(" <> ");
        } else if (obj == this.buttonMaior) {
            this.insereTexto(" > ");
        } else if (obj == this.buttonMenor) {
            this.insereTexto(" < ");
        } else if (obj == this.buttonMenorIgual) {
            this.insereTexto(" <= ");
        } else if (obj == this.buttonMaiorIgual) {
            this.insereTexto(" >= ");
        } else if (obj == this.buttonVariaveis) {
            DialogoLista dl = new DialogoLista(this, "Vari\u00e1veis de impress\u00e3o", true);
            if (this.pagina != null && this.pagina.getTipoConfiguracao() == 0 && this.pagina.getListaVariaveis() != null) {
                dl.setItens(this.pagina.getListaVariaveis());
            } else if (this.pagina != null && this.pagina.getTipoConfiguracao() == 0) {
                dl.setItens(new String[]{"dataAtual", "versaoLayout"});
            } else {
                dl.setItens(Impressao.Variaveis.getVariaveis());
            }
            dl.setVisible(true);
            this.insereTexto(dl.getItemSelecionado());
        } else if (obj == this.buttonExame) {
            DialogoLista dcc = new DialogoLista(this, "Campos do exame", true);
            dcc.setItens(this.camposExame);
            dcc.setVisible(true);
            this.insereTexto(dcc.getItemSelecionado());
        } else if (obj == this.buttonBanco) {
            DialogoLista dl = new DialogoLista(this, "Campos do banco", true);
            dl.setItens(this.camposBanco);
            dl.setVisible(true);
            this.insereTexto(dl.getItemSelecionado());
        } else if (obj == this.buttonOk) {
            boolean ok = true;
            if (this.textExp.getText().trim().length() > 0) {
                Sintatico sin = this.tipo == 0 ? new SintaticoExpressao(this.textExp.getText(), 8) : new SintaticoCondicao(this.textExp.getText(), 8);
                Token tok = sin.getProxToken();
                while (tok.id != 29 && !tok.erro) {
                    tok = sin.getProxToken();
                }
                if (tok.erro) {
                    this.labelMsn.setText("Erro: " + tok.erroDesc);
                    this.doc.destacarErro(tok.pos);
                    this.textExp.setCaretPosition(tok.pos);
                    this.textExp.grabFocus();
                    ok = false;
                } else {
                    String str = this.autoReferencia();
                    if (str.length() > 0) {
                        this.labelMsn.setText("Erro: a express\u00e3o n\u00e3o pode se auto referenciar.");
                        int pos = this.textExp.getText().toLowerCase().indexOf(str.toLowerCase());
                        this.doc.destacarErro(pos);
                        this.textExp.setCaretPosition(pos);
                        this.textExp.grabFocus();
                        ok = false;
                    } else {
                        String[] ref = this.campoReferencia();
                        if (ref.length == 2) {
                            this.labelMsn.setText("Erro: o item \"" + ref[0] + "\" j\u00e1 faz refer\u00eancia ao item " + ref[1]);
                            int pos = this.textExp.getText().toLowerCase().indexOf(ref[0].toLowerCase());
                            this.doc.destacarErro(pos);
                            this.textExp.setCaretPosition(pos);
                            this.textExp.grabFocus();
                            ok = false;
                        } else {
                            str = this.referenciaItemInvalido();
                            if (str.length() > 0) {
                                this.labelMsn.setText("Erro: a express\u00e3o n\u00e3o pode referenciar o item \"" + str + "\"");
                                int pos = this.textExp.getText().toLowerCase().indexOf(str);
                                this.doc.destacarErro(pos);
                                this.textExp.grabFocus();
                                ok = false;
                            }
                        }
                    }
                }
            }
            if (ok) {
                this.exp = this.textExp.getText();
                this.dispose();
            }
        } else if (obj == this.buttonCancelar) {
            this.dispose();
        }
    }

    private String referenciaItemInvalido() {
        if (this.pagina != null) {
            String exp = this.textExp.getText().toLowerCase();
            Component[] comp = this.pagina.getComponents();
            for (int i = 0; i < comp.length; ++i) {
                String nome;
                if (!(comp[i] instanceof Rotulo) && !(comp[i] instanceof ResultadoAnterior) && !(comp[i] instanceof Forma) && !(comp[i] instanceof Imagem) || exp.indexOf(nome = ((Componente)((Object)comp[i])).getNome().toLowerCase()) <= -1) continue;
                return nome;
            }
        }
        return "";
    }

    private String autoReferencia() {
        List<String> campos = Token.getIdentificadores(this.textExp.getText().toLowerCase());
        for (Componente comp : this.componentes) {
            if (!campos.contains(comp.getNome().toLowerCase())) continue;
            return comp.getNome();
        }
        return "";
    }

    private String[] campoReferencia() {
        if (this.pagina != null) {
            List<String> itens = Token.getIdentificadores(this.textExp.getText());
            Component[] comp = this.pagina.getComponents();
            for (int i = 0; i < comp.length; ++i) {
                if (!(comp[i] instanceof Expressao)) continue;
                Expressao expr = (Expressao)comp[i];
                for (String item : itens) {
                    if (!item.equalsIgnoreCase(expr.getNome())) continue;
                    String tmp = expr.getExpressao().toLowerCase();
                    for (int k = 0; k < this.componentes.length; ++k) {
                        if (tmp.indexOf(this.componentes[k].getNome().toLowerCase()) <= -1) continue;
                        return new String[]{expr.getNome(), this.componentes[k].getNome()};
                    }
                }
            }
        }
        return new String[0];
    }

    private void insereTexto(String texto) {
        try {
            int pos = this.textExp.getCaretPosition();
            this.doc.insertString(pos, texto, null);
            this.doc.highLight();
            this.textExp.setCaretPosition(pos + texto.length());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoExpressao: 450");
        }
    }

    public String getExpressao() {
        return this.exp;
    }

    public void setExpressao(String exp) {
        try {
            this.exp = exp;
            this.textExp.setText(exp);
            this.doc.highLight();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoExpressao: 473");
        }
    }

    public void setCamposBanco(String[] campos) {
        this.camposBanco = campos;
    }

    public void setCamposExame(String[] campos) {
        this.camposExame = campos;
        StringUtil.ordenar(this.camposExame);
    }

    public void getConfigurarCor() {
        DialogoCor dc = DialogoCor.novaInstancia(this, "Configura\u00e7\u00e3o de Cor");
        if (dc != null) {
            dc.setVisible(true);
            if (dc.ok()) {
                String corHexadecimal = "\"" + this.converteRgbParaHexadecimal(dc.getCor()) + "\"";
                this.insereTexto(corHexadecimal);
            }
        }
    }

    private String converteRgbParaHexadecimal(Color cor) {
        StringBuffer res = new StringBuffer();
        res.append("#");
        String val = Long.toHexString((long)cor.getRGB() & 0xFFFFFFL);
        for (int i = 0; i < 6 - val.length(); ++i) {
            res.append("0");
        }
        res.append(val);
        return res.toString();
    }
}

