/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.expressao;

import jalis.laboratorio.configurador.expressao.AbstractDialogoFuncao;
import jalis.laboratorio.configurador.expressao.AcaoBotao;
import jalis.laboratorio.configurador.expressao.DialogoFuncao;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

class BarraBotao
extends JPanel {
    private AbstractDialogoFuncao pai;

    BarraBotao(AbstractDialogoFuncao pai) {
        super(new FlowLayout(0, 3, 3));
        Funcoes.validarNaoNull(pai, "pai");
        this.setBorder(null);
        this.pai = pai;
    }

    void addBotao(String titulo, final AcaoBotao acao) {
        Funcoes.validarNaoNull(titulo, "titulo");
        Funcoes.validarNaoNull(acao, "acao");
        JButton button = new JButton(titulo);
        button.setFocusable(false);
        Insets margem = button.getMargin();
        margem.left = 7;
        margem.right = 7;
        button.setMargin(margem);
        Dimension dim = button.getPreferredSize();
        if (dim.width < 50) {
            dim.width = 50;
            button.setPreferredSize(dim);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component comp = BarraBotao.this.pai.getFocusOwner();
                if (comp instanceof JTextField) {
                    try {
                        JTextField text = (JTextField)comp;
                        Document doc = text.getDocument();
                        doc.insertString(text.getCaretPosition(), acao.acionouBotao(BarraBotao.this.pai), null);
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BarraBotao: 69");
                    }
                }
            }
        });
        this.add(button);
    }

    void addBotao(String titulo, final String retorno) {
        this.addBotao(titulo, new AcaoBotao(){

            @Override
            public String acionouBotao(DialogoFuncao pai) {
                return retorno;
            }
        });
    }
}

