/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontalTexto;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorCampoInterfaceamento;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorExpressao;
import jalis.laboratorio.configurador.propriedade.EditorFont;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.EditorTexto;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.TextoDigitacao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.BordaSimples;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Texto
extends AbstractComponente
implements KeyListener,
Digitavel,
ComponenteInterfaceamento,
ComponenteEditor {
    private boolean editavel = true;
    private boolean redimensionar = false;
    private boolean novoEditor = false;
    private String expressao = "";
    private JTextPane text = new JTextPane();
    private Dimension tamanhoMaximo = null;
    private String tagSelecionada = null;
    private String validacaoAutomaticaResultado = null;
    private int alinHor = 0;
    private String masc = "";
    private boolean simularAumentoDeFonte = false;

    public Texto() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(75, 50));
        this.text.setEditable(false);
        this.text.setFont(this.getFonte());
        this.text.setForeground(this.getForeground());
        this.text.setBackground(this.getBackground());
        this.text.setBorder(new BordaSimples(Color.gray, 3, 3, 3, 3));
        this.text.setSize(new Dimension(75, 50));
        this.text.setCaretColor(Color.red);
        this.text.setCursor(new Cursor(2));
        this.text.addKeyListener(this);
        this.setRelacionavelComCampoDeImportacao(true);
    }

    @Override
    public boolean editando() {
        return this.text.isEditable();
    }

    @Override
    public boolean editavel() {
        return true;
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (this.modoInterfaceamento()) {
            list.add(new Propriedade("campo interfaceamento", EditorCampoInterfaceamento.class));
        } else {
            list.add(new Propriedade("texto", EditorTexto.class));
            list.add(new Propriedade("fonte", EditorFont.class));
            list.add(new Propriedade("cor de fundo", EditorColor.class));
            list.add(new Propriedade("cor da fonte", EditorColor.class));
            list.add(new Propriedade("resultado anterior", EditorBoolean.class));
            if (this.getResultadoAnterior()) {
                list.add(new Propriedade(EditorTag.getDescricaoTag(), EditorTag.class));
            }
            list.add(new Propriedade("simular aumento de fonte", EditorBoolean.class));
            list.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
            list.add(new Propriedade("remover vazio", EditorBoolean.class));
            list.add(new Propriedade("edit\u00e1vel", EditorBoolean.class));
            list.add(new Propriedade("express\u00e3o", EditorExpressao.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            list.add(new Propriedade("opaco", EditorBoolean.class));
            list.add(new Propriedade("redimensionar", EditorBoolean.class));
            list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontalTexto.class));
        }
        return list;
    }

    public String getTexto() {
        return this.limpaCdata(this.text.getText());
    }

    public void setTexto(String texto) {
        this.text.setText(this.limpaCdata(texto));
        this.atualizar();
    }

    public boolean getEditavel() {
        return this.editavel;
    }

    public void setEditavel(boolean editavel) {
        this.editavel = editavel;
    }

    public String getExpressao() {
        return this.limpaCdata(this.expressao);
    }

    public void setExpressao(String expressao) {
        if (!Funcoes.textoVazio(expressao = this.limpaCdata(expressao))) {
            this.setEditavel(false);
        }
        this.expressao = expressao;
    }

    public boolean getRedimensionar() {
        return this.redimensionar;
    }

    public void setRedimensionar(boolean redimensionar) {
        this.redimensionar = redimensionar;
    }

    public Dimension getTamanhoMaximo() {
        return this.tamanhoMaximo;
    }

    public void setTamanhoMaximo(Dimension dim) {
        if (dim != null) {
            this.tamanhoMaximo = dim;
        }
    }

    @Override
    public Font getFonte() {
        return this.text.getFont();
    }

    @Override
    public void setFonte(Font fonte) {
        this.text.setFont(fonte);
        this.atualizar();
    }

    public Color getCorDeFundo() {
        return this.text.getBackground();
    }

    public void setOpaco(boolean opaco) {
        this.text.setOpaque(opaco);
        this.atualizar();
    }

    public boolean getOpaco() {
        return this.text.isOpaque();
    }

    public void setCorDeFundo(Color cor) {
        this.text.setBackground(cor);
        this.atualizar();
    }

    @Override
    public Color getCorDaFonte() {
        return this.text.getForeground();
    }

    @Override
    public void setCorDaFonte(Color cor) {
        this.text.setForeground(cor);
        this.atualizar();
    }

    @Override
    public void setEditando(boolean b) {
        if (b) {
            this.add((Component)this.text, "Center");
            this.text.setEditable(true);
            this.text.grabFocus();
            if (this.sel != null) {
                this.sel.setCorSelecao(Color.green);
            }
        } else {
            this.remove(this.text);
            this.sel.setCorSelecao(Color.blue);
        }
        this.atualizar();
        this.fireDadosAlterados();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\u001b') {
            this.setEditando(false);
        }
    }

    @Override
    public String getNomeBase() {
        return "Texto";
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("corDaFonte", String.valueOf(this.getCorDaFonte().getRGB())));
        bui.append(StringUtil.getTag("corDeFundo", String.valueOf(this.getCorDeFundo().getRGB())));
        bui.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(this.getFonte())));
        bui.append(StringUtil.getTag("texto", StringUtil.preencheCData(this.getTexto())));
        bui.append(StringUtil.getTag("editavel", String.valueOf(this.getEditavel())));
        bui.append(StringUtil.getTag("opaco", String.valueOf(this.getOpaco())));
        bui.append(StringUtil.getTag("expressao", StringUtil.preencheCData(String.valueOf(this.getExpressao()))));
        bui.append(StringUtil.getTag("redimensionar", String.valueOf(this.getRedimensionar())));
        bui.append(StringUtil.getTag("alturaMaxima", String.valueOf(this.getTamanhoMaximo() != null && this.tamanhoMaximo.height > this.getDimensoes().height ? this.tamanhoMaximo.height : this.getDimensoes().height)));
        bui.append(StringUtil.getTag("larguraMaxima", String.valueOf(this.getTamanhoMaximo() != null && this.tamanhoMaximo.width > this.getDimensoes().width ? this.tamanhoMaximo.width : this.getDimensoes().width)));
        if (this.getResultadoAnterior()) {
            bui.append(StringUtil.getTag("tagResultado", this.getTagResultado()));
        }
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
        this.setCorDeFundo(StringUtil.getColor(atr, "corDeFundo"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(atr, "fonte")));
        this.setTexto(StringUtil.getValor(atr, "texto"));
        this.setEditavel(StringUtil.getBoolean(atr, "editavel"));
        this.setOpaco(StringUtil.getBoolean(atr, "opaco"));
        this.setExpressao(StringUtil.getValor(atr, "expressao"));
        this.novoEditor = StringUtil.getValor(atr, "redimensionar").trim().length() > 0;
        this.setRedimensionar(StringUtil.getBoolean(atr, "redimensionar"));
        this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
        this.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
        if (StringUtil.getValor(atr, "alturaMaxima").matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && StringUtil.getValor(atr, "larguraMaxima").matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            this.setTamanhoMaximo(new Dimension(Integer.parseInt(StringUtil.getValor(atr, "larguraMaxima")), Integer.parseInt(StringUtil.getValor(atr, "alturaMaxima"))));
        }
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    public boolean getNovoEditor() {
        return this.novoEditor;
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Texto) {
            Texto txt = (Texto)comp;
            this.setTexto(txt.getTexto());
            this.setCorDeFundo(txt.getCorDeFundo());
            this.setFonte(txt.getFonte());
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setCorDaFonte(Color.decode(StringUtil.getValor(xml, "corDaFonte")));
        this.setCorDeFundo(Color.decode(StringUtil.getValor(xml, "corDeFundo")));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(xml, "fonte")));
        this.setTexto(StringUtil.getValor(xml, "texto"));
        this.setEditavel(StringUtil.getBoolean(xml, "editavel"));
        this.setOpaco(StringUtil.getBoolean(xml, "opaco"));
        this.setExpressao(StringUtil.getValor(xml, "expressao"));
        this.setRedimensionar(StringUtil.getBoolean(xml, "redimensionar"));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        boolean editar = this.editavel && (edicao || !this.salvoValor);
        TextoDigitacao texto = new TextoDigitacao();
        texto.setDono(this);
        texto.setNovoEditor(this.novoEditor);
        texto.setName(this.getNome());
        texto.setCampoInterfaceamento(this.getCampoInterfaceamento());
        texto.setDimensoes(this.getDimensoes());
        texto.setOpaque(this.getOpaco());
        texto.setBackground(this.getCorDeFundo());
        texto.setForeground(this.getCorDaFonte());
        texto.setValorPadrao(this.getTexto());
        texto.setFont(this.getFonte());
        texto.setImprimir(this.getImprimir());
        texto.setResultadoAnterior(this.getResultadoAnterior());
        texto.setLigacoes(this.getLigacoes());
        texto.setRemoverVazio(this.getRemoverVazio());
        texto.setSimularAumentoDeFonte(String.valueOf(this.getSimularAumentoDeFonte()));
        texto.setFocusable(editar);
        texto.setEditable(editar);
        texto.setRedimensionar(this.redimensionar);
        texto.setExpressao(this.getExpressao());
        this.setAlinhamentoHorizontal(this.alinHor);
        StyledDocument doc = texto.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, this.getAlinhamentoHorizontal());
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        if (this.getTamanhoMaximo() != null) {
            texto.setTamanhoMaximo(this.getTamanhoMaximo());
            if (!edicao && (texto.getTamanhoMaximo().getHeight() < texto.getDimensoes().getHeight() || texto.getTamanhoMaximo().getWidth() < texto.getDimensoes().getWidth())) {
                texto.setTamanhoMaximo(texto.getDimensoes().getSize());
            }
        } else {
            texto.setTamanhoMaximo(texto.getDimensoes().getSize());
        }
        texto.setBorder(new BordaSimples(editar ? Color.gray : null, 3, 3, 3, 3));
        texto.setText(this.salvoValor ? this.getValorResultado() : this.getTexto());
        if (!editar) {
            for (MouseListener mouseListener : texto.getMouseListeners()) {
                texto.removeMouseListener(mouseListener);
            }
            for (EventListener eventListener : texto.getMouseMotionListeners()) {
                texto.removeMouseMotionListener((MouseMotionListener)eventListener);
            }
        }
        return texto;
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.text.setSize(largura, altura);
        super.setDimensoes(esquerda, topo, largura, altura);
    }

    @Override
    public void setTamanho(Dimension tamanho) {
        this.text.setSize(tamanho);
        super.setTamanho(tamanho);
    }

    @Override
    public void paint(Graphics g) {
        this.text.paint(g);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void setTagResultado(String tag) {
        if (!Funcoes.textoVazio(this.tagSelecionada) && this.pag != null) {
            this.pag.removeTagEmUso(this.tagSelecionada);
        }
        this.tagSelecionada = tag;
        if (this.pag != null) {
            this.pag.adicionaTagEmUso(tag, this);
        }
    }

    @Override
    public String getTagResultado() {
        return this.tagSelecionada;
    }

    @Override
    public void setConferenciaAutomatica(String validacao) {
        this.validacaoAutomaticaResultado = validacao;
    }

    @Override
    public String getConferenciaAutomatica() {
        return this.validacaoAutomaticaResultado;
    }

    @Override
    public boolean isConferenciaAutomatica() {
        return false;
    }

    @Override
    public ValoresPercentualDeltaCheck getPercentualDeVariacao() {
        return new ValoresPercentualDeltaCheck();
    }

    @Override
    public String getTipoConferenciaAutomatica() {
        return null;
    }

    @Override
    public void atualizaComboTagResultado() {
        if (this.pag.getGerenciador() != null) {
            this.pag.getGerenciador().dadosAlterados(null);
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alinHor;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinHor = alinhamento;
        this.text.selectAll();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttributes(this.text.getParagraphAttributes());
        simpleAttributeSet.addAttribute(StyleConstants.Alignment, alinhamento);
        this.text.setParagraphAttributes(simpleAttributeSet, true);
        this.setAtualizar(true);
        this.atualizar();
    }
}

