/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.componente.Imagem;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorExpressao;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.RtfDigitacao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.BordaSimples;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Map;
import javax.swing.JTextPane;

public class Rtf
extends AbstractComponente
implements KeyListener,
Digitavel,
ComponenteInterfaceamento,
ComponenteEditor {
    private static final String ATR_COR_FONTE = "corDaFonte";
    private static final String ATR_COR_FUNDO = "corDeFundo";
    private static final String ATR_FONTE = "fonte";
    private static final String ATR_OPACO = "opaco";
    private static final String ATR_EXPRESSAO = "expressao";
    private static final String ATR_REDIMENSIONAR = "redimensionar";
    private static final String ATR_ALTURA_MAXIMA = "alturaMaxima";
    private static final String ATR_LARGURA_MAXIMA = "larguraMaxima";
    private static final String ALTURA = "altura";
    private static final String ESQUEDA = "esquerda";
    private static final String LARGURA = "largura";
    private static final String TOPO = "topo";
    private static final String NOME = "nome";
    private static final String TEXTO = "texto";
    private static final String RESULTADO_ANTERIOR = "resultadoAnterior";
    private static final String IMPRIMIR = "imprimir";
    private static final String AUTO_DIMENSIONAR = "autoDimensionar";
    private static final String COR_DA_FONTE = "corDaFonte";
    private static final String ALINHAMENTO_VERTICAL = "alinhamentoVertical";
    private static final String ALINHAMENTO_HORIZONTAL = "alinhamentoHorizontal";
    private JTextPane editorPane = new JTextPane();
    private boolean redimensionar = false;
    private String expressao = "";
    private Dimension tamanhoMaximo = null;
    private String pagina = "";
    private transient List<Component> componentsRtf;

    public Rtf() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(75, 50));
        this.editorPane.setEditable(false);
        this.editorPane.setFont(this.getFonte());
        this.editorPane.setForeground(this.getForeground());
        this.editorPane.setBackground(this.getBackground());
        this.editorPane.setBorder(new BordaSimples(Color.gray, 3, 3, 3, 3));
        this.editorPane.setSize(new Dimension(75, 50));
        this.editorPane.setCaretColor(Color.red);
        this.editorPane.setCursor(new Cursor(2));
        this.editorPane.addKeyListener(this);
        this.setRelacionavelComCampoDeImportacao(true);
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> propriedades = super.getPropriedades();
        propriedades.add(new Propriedade("cor de fundo", EditorColor.class));
        propriedades.add(new Propriedade("resultado anterior", EditorBoolean.class));
        if (this.getResultadoAnterior()) {
            propriedades.add(new Propriedade(EditorTag.getDescricaoTag(), EditorTag.class));
        }
        propriedades.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
        propriedades.add(new Propriedade("remover vazio", EditorBoolean.class));
        propriedades.add(new Propriedade("express\u00e3o", EditorExpressao.class));
        propriedades.add(new Propriedade(IMPRIMIR, EditorBoolean.class));
        propriedades.add(new Propriedade(ATR_OPACO, EditorBoolean.class));
        propriedades.add(new Propriedade(ATR_REDIMENSIONAR, EditorBoolean.class));
        return propriedades;
    }

    @Override
    public String getNomeBase() {
        return "Rtf";
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        RtfDigitacao rtf = new RtfDigitacao();
        rtf.setValor(this.getValorResultado());
        rtf.setDimensoes(this.getDimensoes());
        rtf.setDono(this);
        rtf.setName(this.getNome());
        rtf.setEditable(false);
        rtf.setOpaque(this.getOpaco());
        rtf.setImprimir(this.getImprimir());
        rtf.setRemoverVazio(this.getRemoverVazio());
        rtf.setRedimensionar(this.redimensionar);
        rtf.setExpressao(this.getExpressao());
        rtf.parseRTF();
        this.componentsRtf = rtf.getComponentsRtf();
        return rtf;
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }

    @Override
    public void setTagResultado(String tag) {
    }

    @Override
    public String getTagResultado() {
        return null;
    }

    @Override
    public void setConferenciaAutomatica(String validacao) {
    }

    @Override
    public String getConferenciaAutomatica() {
        return null;
    }

    @Override
    public boolean isConferenciaAutomatica() {
        return false;
    }

    @Override
    public ValoresPercentualDeltaCheck getPercentualDeVariacao() {
        return null;
    }

    @Override
    public String getTipoConferenciaAutomatica() {
        return null;
    }

    @Override
    public void atualizaComboTagResultado() {
        if (this.pag.getGerenciador() != null) {
            this.pag.getGerenciador().dadosAlterados(null);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\u001b') {
            this.setEditando(false);
        }
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.editorPane.setSize(largura, altura);
        super.setDimensoes(esquerda, topo, largura, altura);
    }

    @Override
    public void setTamanho(Dimension tamanho) {
        this.editorPane.setSize(tamanho);
        super.setTamanho(tamanho);
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("corDaFonte", String.valueOf(Color.BLACK.getRGB())));
        bui.append(StringUtil.getTag(ATR_COR_FUNDO, String.valueOf(this.getCorDeFundo().getRGB())));
        Font fonte = new Font("Courier New", 0, 10);
        bui.append(StringUtil.getTag(ATR_FONTE, StringUtil.getFonteAtributos(fonte)));
        bui.append(StringUtil.getTag(ATR_OPACO, String.valueOf(this.getOpaco())));
        bui.append(StringUtil.getTag(ATR_EXPRESSAO, StringUtil.preencheCData(String.valueOf(this.getExpressao()))));
        bui.append(StringUtil.getTag(ATR_REDIMENSIONAR, String.valueOf(this.getRedimensionar())));
        bui.append(StringUtil.getTag(ATR_ALTURA_MAXIMA, String.valueOf(this.getTamanhoMaximo() != null && this.tamanhoMaximo.height > this.getDimensoes().height ? this.tamanhoMaximo.height : this.getDimensoes().height)));
        bui.append(StringUtil.getTag(ATR_LARGURA_MAXIMA, String.valueOf(this.getTamanhoMaximo() != null && this.tamanhoMaximo.width > this.getDimensoes().width ? this.tamanhoMaximo.width : this.getDimensoes().width)));
        if (this.getResultadoAnterior()) {
            bui.append(StringUtil.getTag("tagResultado", this.getTagResultado()));
        }
        return bui.toString();
    }

    public String getComponenteJalis() {
        StringBuilder bui = new StringBuilder();
        for (Component comp : this.componentsRtf) {
            if (comp instanceof Rotulo && Funcoes.textoVazio(((Rotulo)comp).getTexto().trim()) || comp instanceof Imagem && Funcoes.textoVazio(((Imagem)comp).getValorResultado().trim())) continue;
            bui.append(this.getAtributosComponent(comp));
            if (comp instanceof Imagem) {
                Imagem imagem = (Imagem)comp;
                bui.append(StringUtil.getTag("valorResultado", StringUtil.preencheCData(imagem.getValorResultado())));
                bui.append(StringUtil.getTag("imagem", StringUtil.preencheCData(imagem.getValorResultado())));
                bui.append(StringUtil.getTag("salvoValor", String.valueOf(true)));
                bui.append(StringUtil.getTag("removerVazio", String.valueOf(true)));
                bui.append(StringUtil.getTag("estender", String.valueOf(false)));
                bui.append(StringUtil.getTag(ALINHAMENTO_VERTICAL, "0"));
                bui.append(StringUtil.getTag(ALINHAMENTO_HORIZONTAL, "0"));
            }
            if (comp instanceof Rotulo) {
                Rotulo rotulo = (Rotulo)comp;
                bui.append(StringUtil.getTag("resultadoRtf", String.valueOf(true)));
                bui.append(StringUtil.getTag(AUTO_DIMENSIONAR, String.valueOf(this.getRedimensionar())));
                bui.append(StringUtil.getTag("corDaFonte", String.valueOf(rotulo.getCorDaFonte().getRGB())));
                bui.append(StringUtil.getTag(ATR_COR_FUNDO, String.valueOf(this.getCorDeFundo().getRGB())));
                bui.append(StringUtil.getTag(TEXTO, StringUtil.preencheCData(rotulo.getTexto())));
                bui.append(StringUtil.getTag(ATR_FONTE, StringUtil.getFonteAtributos(((Rotulo)comp).getFonte())));
                bui.append(StringUtil.getTag(ALINHAMENTO_VERTICAL, "1"));
                bui.append(StringUtil.getTag(ALINHAMENTO_HORIZONTAL, "2"));
            }
            bui.append("</atributos>");
            bui.append("</componente>");
        }
        return bui.toString();
    }

    private String getAtributosComponent(Component comp) {
        StringBuilder bui = new StringBuilder();
        bui.append("<componente>");
        bui.append(StringUtil.getTag("tipo", comp.getClass().getName()));
        bui.append("<atributos>");
        bui.append(StringUtil.getTag(ALTURA, String.valueOf((int)comp.getBounds().getHeight())));
        bui.append(StringUtil.getTag(ESQUEDA, String.valueOf(comp.getX())));
        bui.append(StringUtil.getTag(LARGURA, String.valueOf((int)comp.getBounds().getWidth())));
        bui.append(StringUtil.getTag(TOPO, String.valueOf(comp.getY())));
        if (!Funcoes.textoVazio(comp.getName())) {
            bui.append(StringUtil.getTag(NOME, this.getNome() + comp.getName()));
        } else {
            bui.append(StringUtil.getTag(NOME, this.getNome()));
        }
        bui.append(StringUtil.getTag(IMPRIMIR, String.valueOf(this.getImprimir())));
        bui.append(StringUtil.getTag("contadorPagina", String.valueOf(this.getPagina())));
        bui.append(StringUtil.getTag(RESULTADO_ANTERIOR, String.valueOf(this.getResultadoAnterior())));
        bui.append(StringUtil.getTag(ATR_ALTURA_MAXIMA, String.valueOf(this.getTamanhoMaximo() != null && this.tamanhoMaximo.height > this.getDimensoes().height ? this.tamanhoMaximo.height : this.getDimensoes().height)));
        bui.append(StringUtil.getTag(ATR_LARGURA_MAXIMA, String.valueOf(this.getTamanhoMaximo() != null && this.tamanhoMaximo.width > this.getDimensoes().width ? this.tamanhoMaximo.width : this.getDimensoes().width)));
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
        this.setCorDeFundo(StringUtil.getColor(atr, ATR_COR_FUNDO));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(atr, ATR_FONTE)));
        this.setOpaco(StringUtil.getBoolean(atr, ATR_OPACO));
        this.setExpressao(StringUtil.getValor(atr, ATR_EXPRESSAO));
        this.setRedimensionar(StringUtil.getBoolean(atr, ATR_REDIMENSIONAR));
        this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
        this.setPagina(StringUtil.getValor(atr, "contadorPagina"));
        if (StringUtil.getValor(atr, ATR_ALTURA_MAXIMA).matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && StringUtil.getValor(atr, ATR_LARGURA_MAXIMA).matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            this.setTamanhoMaximo(new Dimension(Integer.parseInt(StringUtil.getValor(atr, ATR_LARGURA_MAXIMA)), Integer.parseInt(StringUtil.getValor(atr, ATR_ALTURA_MAXIMA))));
        }
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    public Color getCorDeFundo() {
        return this.editorPane.getBackground();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public String getTexto() {
        return this.editorPane.getText();
    }

    public boolean getOpaco() {
        return this.editorPane.isOpaque();
    }

    public String getExpressao() {
        return this.limpaCdata(this.expressao);
    }

    public void setExpressao(String expressao) {
        this.expressao = expressao = this.limpaCdata(expressao);
    }

    public boolean getRedimensionar() {
        return this.redimensionar;
    }

    public void setRedimensionar(boolean redimensionar) {
        this.redimensionar = redimensionar;
    }

    public Dimension getTamanhoMaximo() {
        return this.tamanhoMaximo;
    }

    public void setTamanhoMaximo(Dimension dim) {
        if (dim != null) {
            this.tamanhoMaximo = dim;
        }
    }

    public String getPagina() {
        return this.pagina;
    }

    public void setPagina(String pagina) {
        this.pagina = pagina;
    }

    public void setCorDeFundo(Color cor) {
        this.editorPane.setBackground(cor);
        this.atualizar();
    }

    public void setOpaco(boolean opaco) {
        this.editorPane.setOpaque(opaco);
        this.atualizar();
    }

    @Override
    public void paint(Graphics g) {
        this.editorPane.paint(g);
    }

    @Override
    public void setEditando(boolean b) {
        if (b) {
            this.add((Component)this.editorPane, "Center");
            this.editorPane.setEditable(true);
            this.editorPane.grabFocus();
            if (this.sel != null) {
                this.sel.setCorSelecao(Color.green);
            }
        } else {
            this.remove(this.editorPane);
            this.sel.setCorSelecao(Color.blue);
        }
        this.atualizar();
        this.fireDadosAlterados();
    }
}

