/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontal;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorFont;
import jalis.laboratorio.configurador.propriedade.EditorTexto;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Rotulo
extends AbstractComponente
implements ActionListener,
KeyListener {
    private JLabel rotulo = new JLabel("R\u00f3tulo");
    private JTextField edit;
    private boolean editando;
    private boolean autoDimen;
    private boolean resultadoRtf;

    public Rotulo() {
        this.add((Component)this.rotulo, null);
        this.rotulo.setHorizontalAlignment(2);
        this.rotulo.setForeground(this.getForeground());
        this.rotulo.setBackground(this.getBackground());
        this.rotulo.setFont(this.getFonte());
        this.editando = false;
        this.autoDimen = true;
        this.resultadoRtf = false;
        this.dimensionar(this.rotulo.getText());
        this.atualizar();
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Rotulo) {
            Rotulo rot = (Rotulo)comp;
            this.setAutoDimensionar(rot.getAutoDimensionar());
            this.setCorDeFundo(rot.getCorDeFundo());
            this.setCorDaFonte(rot.getCorDaFonte());
            this.setFonte(rot.getFonte());
            this.setTexto(rot.getTexto());
            this.setOpaco(rot.getOpaco());
            this.setResultadoRtf(rot.getResultadoRtf());
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setAutoDimensionar(StringUtil.getBoolean(StringUtil.getValor(xml, "autoDimensionar")));
        this.setCorDaFonte(StringUtil.getColor(xml, "corDaFonte"));
        this.setCorDeFundo(StringUtil.getColor(xml, "corDeFundo"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(xml, "fonte")));
        this.setOpaco(StringUtil.getBoolean(StringUtil.getValor(xml, "opaco")));
        this.setTexto(StringUtil.getValor(xml, "texto"));
        this.setResultadoRtf(StringUtil.getBoolean(StringUtil.getValor(xml, "resultadoRtf")));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    public void setAutoDimensionar(boolean b) {
        if (this.autoDimen != b) {
            this.autoDimen = b;
            if (this.autoDimen) {
                this.dimensionar(this.edit != null ? this.edit.getText() : this.rotulo.getText());
                this.atualizar();
            }
        }
    }

    public boolean getAutoDimensionar() {
        return this.autoDimen;
    }

    public boolean getResultadoRtf() {
        return this.resultadoRtf;
    }

    public void setResultadoRtf(boolean resultadoRtf) {
        this.resultadoRtf = resultadoRtf;
    }

    @Override
    public Font getFonte() {
        return this.rotulo.getFont();
    }

    @Override
    public void setFonte(Font fonte) {
        this.rotulo.setFont(fonte);
        if (this.editando) {
            this.edit.setFont(fonte);
        }
        if (this.autoDimen) {
            this.dimensionar(this.getTexto());
            this.atualizar();
        }
    }

    @Override
    public boolean editando() {
        return this.editando;
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade("texto", EditorTexto.class));
            list.add(new Propriedade("auto dimensionar", EditorBoolean.class));
            list.add(new Propriedade("fonte", EditorFont.class));
            list.add(new Propriedade("opaco", EditorBoolean.class));
            list.add(new Propriedade("cor de fundo", EditorColor.class));
            list.add(new Propriedade("cor da fonte", EditorColor.class));
            list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
        }
        return list;
    }

    public void setCorDeFundo(Color cor) {
        this.rotulo.setBackground(cor);
        if (this.editando) {
            this.edit.setBackground(cor);
        }
    }

    public Color getCorDeFundo() {
        return this.rotulo.getBackground();
    }

    @Override
    public void setCorDaFonte(Color cor) {
        this.rotulo.setForeground(cor);
        if (this.editando) {
            this.edit.setForeground(cor);
        }
    }

    @Override
    public Color getCorDaFonte() {
        return this.rotulo.getForeground();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.rotulo.getHorizontalAlignment();
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.rotulo.setHorizontalAlignment(alinhamento);
    }

    @Override
    public void setEditando(boolean b) {
        if (this.editando != b) {
            this.editando = b;
            if (this.editando) {
                this.edit = new JTextField(this.rotulo.getText());
                this.edit.setFont(this.rotulo.getFont());
                this.edit.setBackground(this.rotulo.getBackground());
                this.edit.setForeground(this.rotulo.getForeground());
                this.edit.setOpaque(this.rotulo.isOpaque());
                this.edit.setBorder(null);
                this.edit.addActionListener(this);
                this.edit.addKeyListener(this);
                this.edit.setBounds(this.getBounds());
                this.edit.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.edit.setCaretColor(Color.red);
                this.edit.setHorizontalAlignment(this.rotulo.getHorizontalAlignment());
                this.edit.selectAll();
                this.add((Component)this.edit, 0);
                this.atualizar();
                this.edit.grabFocus();
                this.rotulo.setText("");
                if (this.sel != null) {
                    this.sel.setCorSelecao(Color.green);
                }
            } else if (this.edit != null) {
                this.setTexto(this.edit.getText());
                this.remove(this.edit);
                this.edit = null;
                if (this.sel != null) {
                    this.sel.setCorSelecao(Color.blue);
                    this.sel.fireDadosAlterados();
                }
            }
        }
    }

    public void setTexto(String valor) {
        if (valor.length() > 0) {
            String tmp = valor.replace('\r', ' ');
            tmp = tmp.replace('\n', ' ');
            this.rotulo.setText(this.limpaCdata(tmp));
            if (this.editando) {
                this.remove(this.edit);
                this.edit = null;
            }
        } else {
            this.rotulo.setText("R\u00f3tulo");
        }
        if (this.autoDimen) {
            this.dimensionar(this.rotulo.getText());
            this.atualizar();
        }
    }

    public String getTexto() {
        return this.limpaCdata(this.rotulo.getText());
    }

    public boolean getOpaco() {
        return this.rotulo.isOpaque();
    }

    public void setOpaco(boolean opaco) {
        this.rotulo.setOpaque(opaco);
        if (this.editando) {
            this.edit.setOpaque(opaco);
        }
        super.atualizar();
    }

    @Override
    public boolean editavel() {
        return true;
    }

    @Override
    public void atualizar() {
        this.rotulo.setBounds(0, 0, this.getWidth(), this.getHeight());
        super.atualizar();
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        if (this.autoDimen) {
            Dimension dim = this.getDimensoesTexto(this.edit != null ? this.edit.getText() : this.rotulo.getText());
            super.setDimensoes(esquerda, topo, dim.width, dim.height);
            if (this.sel != null) {
                this.sel.atualizarDimensoes();
            }
        } else {
            super.setDimensoes(esquerda, topo, largura, altura);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setEditando(false);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\u001b') {
            this.setEditando(false);
        } else if (this.autoDimen) {
            this.dimensionar(Character.isISOControl(e.getKeyChar()) ? this.edit.getText() : this.edit.getText() + e.getKeyChar());
        }
    }

    private void dimensionar(String texto) {
        Dimension dim = this.getDimensoesTexto(texto);
        super.setDimensoes(this.getX(), this.getY(), dim.width, dim.height);
        if (this.edit != null) {
            this.edit.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.sel != null) {
            this.sel.atualizarDimensoes();
        }
    }

    private Dimension getDimensoesTexto(String texto) {
        FontMetrics met = this.rotulo.getFontMetrics(this.rotulo.getFont());
        if (met == null) {
            return new Dimension();
        }
        return new Dimension(met.stringWidth(texto) + 3, met.getHeight() + 3);
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("autoDimensionar", String.valueOf(this.getAutoDimensionar())));
        bui.append(StringUtil.getTag("corDaFonte", String.valueOf(this.getCorDaFonte().getRGB())));
        bui.append(StringUtil.getTag("corDeFundo", String.valueOf(this.getCorDeFundo().getRGB())));
        bui.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(this.getFonte())));
        bui.append(StringUtil.getTag("opaco", String.valueOf(this.getOpaco())));
        bui.append(StringUtil.getTag("texto", StringUtil.preencheCData(this.getTexto())));
        bui.append(StringUtil.getTag("resultadoRtf", String.valueOf(this.getResultadoRtf())));
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setAutoDimensionar(StringUtil.getBoolean(StringUtil.getValor(atr, "autoDimensionar")));
        this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
        this.setCorDeFundo(StringUtil.getColor(atr, "corDeFundo"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(atr, "fonte")));
        this.setOpaco(StringUtil.getBoolean(StringUtil.getValor(atr, "opaco")));
        this.setTexto(StringUtil.getValor(atr, "texto"));
        this.setResultadoRtf(StringUtil.getBoolean(StringUtil.getValor(atr, "resultadoRtf")));
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    public String getNomeBase() {
        return "Rotulo";
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        TextoEstatico rotulo = new TextoEstatico();
        rotulo.setDono(this);
        rotulo.setName(this.getNome());
        rotulo.setDimensoes(this.getDimensoes());
        rotulo.setOpaque(this.getOpaco());
        rotulo.setBackground(this.getCorDeFundo());
        rotulo.setForeground(this.getCorDaFonte());
        rotulo.setText(this.getTexto());
        rotulo.setFont(this.getFonte());
        rotulo.setImprimir(this.getImprimir());
        rotulo.setHorizontalAlignment(this.getAlinhamentoHorizontal());
        rotulo.setProcessarTagsHTML(true);
        return rotulo;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

