/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontal;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorFont;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorOrdem;
import jalis.laboratorio.configurador.propriedade.EditorOrigemResultadoAnterior;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.ResultadoAnteriorDigitacao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import java.util.Map;

public class ResultadoAnterior
extends AbstractComponente
implements Digitavel,
ComponenteEditor {
    public static final String HORA_RESULTADO = "horaResultado";
    public static final String DATA_RESULTADO = "dataResultado";
    public static final String REQUISICAO = "requisicao";
    private String texto = "Res. Anterior";
    private String origem = "";
    private String tag = "";
    private int alinHor = 2;
    private int ordem = 1;
    private String tagSelecionada = "";

    public ResultadoAnterior() {
        this.setTamanho(new Dimension(75, 25));
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof ResultadoAnterior) {
            ResultadoAnterior res = (ResultadoAnterior)comp;
            this.setOrdem(res.getOrdem());
            this.setOrigem(res.getOrigem());
            this.setFonte(res.getFonte());
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(xml, "fonte")));
        this.setOrigem(StringUtil.getValor(xml, "origem"));
        this.setOrdem(StringUtil.getInt(xml, "ordem"));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alinHor;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinHor = alinhamento;
        this.atualizar();
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        if (this.salvoValor && !edicao) {
            TextoEstatico texto = new TextoEstatico();
            texto.setDono(this);
            texto.setName(this.getNome());
            texto.setFont(this.getFont());
            texto.setDimensoes(this.getDimensoes());
            texto.setText(this.getValorResultado());
            texto.setForeground(this.getForeground());
            texto.setHorizontalAlignment(this.getAlinhamentoHorizontal());
            texto.setImprimir(this.imprimir);
            return texto;
        }
        ResultadoAnteriorDigitacao res = new ResultadoAnteriorDigitacao();
        res.setDono(this);
        res.setName(this.getNome());
        res.setDimensoes(this.getDimensoes());
        res.setForeground(this.getCorDaFonte());
        res.setFont(this.getFonte());
        res.setLigacoes(this.getLigacoes());
        res.setOrdem(this.getOrdem());
        res.setOrigem(this.getOrigem());
        res.setTagResultado(this.getTagResultado());
        res.setImprimir(this.getImprimir());
        res.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
        res.setRemoverVazio(this.getRemoverVazio());
        return res;
    }

    @Override
    public String getNomeBase() {
        return "ResAnterior";
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade("fonte", EditorFont.class));
            list.add(new Propriedade("cor da fonte", EditorColor.class));
            list.add(new Propriedade("origem", EditorOrigemResultadoAnterior.class));
            list.add(new Propriedade("ordem", EditorOrdem.class));
            list.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
            list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
            list.add(new Propriedade("remover vazio", EditorBoolean.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            if (!this.isOrigemDataHora()) {
                list.add(new Propriedade(EditorTag.getDescricaoTag(), EditorTag.class));
            }
        }
        return list;
    }

    public int getOrdem() {
        return this.ordem;
    }

    public void setOrdem(int ordem) {
        this.ordem = ordem;
    }

    public String getOrigem() {
        return this.origem;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setOrigem(String origem) {
        this.origem = origem == null ? "" : origem;
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(this.getFonte())));
        bui.append(StringUtil.getTag("corDaFonte", String.valueOf(this.getCorDaFonte().getRGB())));
        bui.append(StringUtil.getTag("origem", this.getOrigem()));
        bui.append(StringUtil.getTag("ordem", String.valueOf(this.getOrdem())));
        bui.append(StringUtil.getTag("tagResultado", !Funcoes.textoVazio(this.getTagResultado()) ? this.getTagResultado() : ""));
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(atr, "fonte")));
        this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
        this.setOrigem(StringUtil.getValor(atr, "origem"));
        this.setOrdem(StringUtil.getInt(atr, "ordem"));
        this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics met = g.getFontMetrics();
        String str = this.getNome().length() > 0 ? this.getNome() : this.texto;
        int h = met.getHeight();
        int x = this.alinHor == 2 ? 3 : (this.alinHor == 4 ? this.getWidth() - met.stringWidth(str) - 3 : (this.getWidth() - met.stringWidth(str)) / 2);
        g.drawString(str, x, this.getHeight() / 2 + h / 2 - 2);
        g.setColor(Color.gray);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public boolean isOrigemDataHora() {
        if (!Funcoes.textoVazio(this.origem)) {
            return this.getOrigem().equalsIgnoreCase(DATA_RESULTADO) || this.origem.equalsIgnoreCase(HORA_RESULTADO);
        }
        return false;
    }

    @Override
    public void setTagResultado(String tag) {
        this.tagSelecionada = tag;
    }

    @Override
    public String getTagResultado() {
        return this.tagSelecionada;
    }

    @Override
    @Deprecated
    public void setConferenciaAutomatica(String validacao) {
    }

    @Override
    @Deprecated
    public String getConferenciaAutomatica() {
        return null;
    }

    @Override
    @Deprecated
    public boolean isConferenciaAutomatica() {
        return false;
    }

    @Override
    @Deprecated
    public ValoresPercentualDeltaCheck getPercentualDeVariacao() {
        return null;
    }

    @Override
    @Deprecated
    public String getTipoConferenciaAutomatica() {
        return null;
    }

    @Override
    public void atualizaComboTagResultado() {
        if (this.pag.getGerenciador() != null) {
            this.pag.getGerenciador().dadosAlterados(null);
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

