/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.AtributosRegua;
import jalis.laboratorio.configurador.AtributosReguaMedia;
import jalis.laboratorio.configurador.AtributosReguaMediaCores;
import jalis.laboratorio.configurador.Constantes;
import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.propriedade.EditorAtributosRegua;
import jalis.laboratorio.configurador.propriedade.EditorAtributosReguaMedia;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorExpressao;
import jalis.laboratorio.configurador.propriedade.EditorMascaraHora;
import jalis.laboratorio.configurador.propriedade.EditorMascaraNumero;
import jalis.laboratorio.configurador.propriedade.EditorOrigemReguaReferencial;
import jalis.laboratorio.configurador.propriedade.EditorTipoRegua;
import jalis.laboratorio.configurador.propriedade.EditorTipoReguaReferencial;
import jalis.laboratorio.configurador.propriedade.EditorValorReferencia;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.ReguaReferencialDigitacao;
import jalis.laboratorio.impressao.componente.ReguaReferencialImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ReguaReferencial
extends AbstractComponente {
    public static final int REGUA_REFERENCIA = 0;
    public static final int REGUA_MEDIA = 1;
    private static final DecimalFormat decfor = new DecimalFormat("0.00");
    private int tipoRegua;
    private ValoresReferencia referencia;
    private String expressao = "";
    private AtributosRegua atributosNormal;
    private AtributosRegua atributosAlterado;
    private String origem;
    private String resultadoExpressaoMedia;
    private int tipo;
    private transient AtributosRegua atributosRegua;
    private String mascara;
    private boolean origemCampo;
    private transient AtributosReguaMedia atributosReguaMedia;

    public ReguaReferencial() {
        this.setSize(150, 20);
        this.tipoRegua = 0;
        this.atributosNormal = new AtributosRegua(Constantes.SOLIDO, new Color(0, 180, 0));
        this.atributosAlterado = new AtributosRegua(Constantes.SOLIDO, Color.black);
        this.atributosRegua = new AtributosRegua(Constantes.SOLIDO, Campo.COR_ALTERADO);
        this.atributosReguaMedia = new AtributosReguaMedia();
        this.origem = "";
        this.tipo = 1;
        this.mascara = "";
        this.setCorDeFundo(Color.white);
    }

    @Override
    public String getNomeBase() {
        return "Regua";
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> lista = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            Componente comp;
            lista.add(new Propriedade("imprimir", EditorBoolean.class));
            lista.add(new Propriedade("tipo r\u00e9gua", EditorTipoRegua.class));
            if (this.tipoRegua == 0) {
                lista.add(new Propriedade("origem", EditorOrigemReguaReferencial.class));
                lista.add(new Propriedade("atributos normal", EditorAtributosRegua.class));
                lista.add(new Propriedade("atributos alterado", EditorAtributosRegua.class));
            } else {
                lista.add(new Propriedade("atributos r\u00e9gua m\u00e9dia", EditorAtributosReguaMedia.class));
                lista.add(new Propriedade("expressao", EditorExpressao.class));
            }
            lista.add(new Propriedade("cor de fundo", EditorColor.class));
            Componente componente = comp = this.pag != null ? this.pag.getComponenteComNome(this.origem) : null;
            if (comp instanceof Expressao) {
                lista.add(new Propriedade("tipo", EditorTipoReguaReferencial.class));
                lista.add(new Propriedade("m\u00e1scara", this.tipo == 1 ? EditorMascaraNumero.class : EditorMascaraHora.class));
                if (this.referencia != null) {
                    lista.add(new Propriedade("valores de refer\u00eancia", EditorValorReferencia.class));
                }
            }
        }
        return lista;
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("origemCampo", String.valueOf(this.origemCampo)));
        bui.append(StringUtil.getTag("origem", this.origem));
        if (this.tipoRegua == 0) {
            bui.append(StringUtil.getTag("atributosNormal", this.atributosNormal.getAtributos()));
            bui.append(StringUtil.getTag("atributosAlterado", this.atributosAlterado.getAtributos()));
            bui.append(StringUtil.getTag("atributosRegua", this.atributosRegua.getAtributos()));
        } else {
            bui.append(StringUtil.getTag("atributosReguaMedia", this.atributosReguaMedia.getAtributos()));
            bui.append(StringUtil.getTag("resultadoExpressaoMedia", this.getResultadoExpressaoMedia()));
        }
        bui.append(StringUtil.getTag("tipo", String.valueOf(this.tipo)));
        bui.append(StringUtil.getTag("mascara", this.mascara));
        bui.append(StringUtil.getTag("expressao", StringUtil.preencheCData(this.expressao)));
        bui.append(StringUtil.getTag("tipoRegua", String.valueOf(this.tipoRegua)));
        bui.append(StringUtil.getTag("corDeFundo", String.valueOf(this.getCorDeFundo().getRGB())));
        if (this.referencia != null) {
            bui.append(StringUtil.getTag("valoresDeReferencia", this.referencia.getAtributos()));
        }
        return bui.toString();
    }

    @Override
    public void setAtributos(String atributos) {
        this.setAtualizar(false);
        this.origemCampo = StringUtil.getBoolean(atributos, "origemCampo");
        this.origem = StringUtil.getValor(atributos, "origem");
        this.atributosNormal.setAtributos(StringUtil.getValor(atributos, "atributosNormal"));
        this.atributosAlterado.setAtributos(StringUtil.getValor(atributos, "atributosAlterado"));
        this.atributosRegua.setAtributos(StringUtil.getValor(atributos, "atributosRegua"));
        this.atributosReguaMedia.setAtributos(StringUtil.getValor(atributos, "atributosReguaMedia"));
        this.setTipo(StringUtil.getInt(atributos, "tipo"));
        this.setTipoRegua(StringUtil.getInt(atributos, "tipoRegua"));
        this.setMascara(StringUtil.getValor(atributos, "mascara"));
        this.setCorDeFundo(StringUtil.getColor(atributos, "corDeFundo"));
        this.setExpressao(StringUtil.getValor(atributos, "expressao"));
        if (this.origemCampo) {
            this.referencia = ValoresReferencia.novaInstancia(1, "#");
        }
        if (this.referencia != null) {
            this.referencia.setAtributos(StringUtil.getValor(atributos, "valoresDeReferencia"));
        }
        if (this.tipoRegua == 1) {
            this.setResultadoExpressaoMedia(StringUtil.getValor(atributos, "resultadoExpressaoMedia"));
        }
        super.setAtributos(atributos);
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        if (comp instanceof ReguaReferencial) {
            ReguaReferencial regua = (ReguaReferencial)comp;
            this.origemCampo = regua.origemCampo;
            this.origem = regua.origem;
            this.atributosNormal = (AtributosRegua)regua.atributosNormal.clone();
            this.atributosAlterado = (AtributosRegua)regua.atributosAlterado.clone();
            this.atributosRegua = (AtributosRegua)regua.atributosRegua.clone();
            this.atributosReguaMedia = (AtributosReguaMedia)regua.atributosReguaMedia.clone();
            this.tipo = regua.tipo;
            this.tipoRegua = regua.tipoRegua;
            this.mascara = regua.mascara;
            this.setCorDeFundo(regua.getCorDeFundo());
            this.referencia = regua.referencia == null ? null : (ValoresReferencia)regua.referencia.clone();
            this.expressao = regua.expressao;
            super.copiarAtributosDe(comp);
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.origemCampo = StringUtil.getBoolean(xml, "origemCampo");
        this.origem = StringUtil.getValor(xml, "origem");
        this.atributosNormal.setAtributos(StringUtil.getValor(xml, "atributosNormal"));
        this.atributosAlterado.setAtributos(StringUtil.getValor(xml, "atributosAlterado"));
        this.atributosRegua.setAtributos(StringUtil.getValor(xml, "atributosRegua"));
        this.atributosReguaMedia.setAtributos(StringUtil.getValor(xml, "atributosReguaMedia"));
        this.setTipo(StringUtil.getInt(xml, "tipo"));
        this.setTipoRegua(StringUtil.getInt(xml, "tipoRegua"));
        this.setMascara(StringUtil.getValor(xml, "mascara"));
        this.setCorDeFundo(StringUtil.getColor(xml, "corDeFundo"));
        this.setExpressao(StringUtil.getValor(xml, "expressao"));
        if (this.referencia != null) {
            this.referencia.setAtributos(StringUtil.getValor(xml, "valoresDeReferencia"));
        }
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    public void setExpressao(String expressao) {
        this.expressao = this.limpaCdata(expressao);
    }

    public String getExpressao() {
        return this.limpaCdata(this.expressao);
    }

    public void setCorDeFundo(Color cor) {
        this.setBackground(cor);
    }

    public Color getCorDeFundo() {
        return this.getBackground();
    }

    public String getMascara() {
        return this.mascara;
    }

    public void setMascara(String mascara) {
        if (mascara != null) {
            this.referencia = null;
            this.mascara = "";
            if (this.tipo == 1 && mascara.matches("#+(\\.#+)*(\\,#+)?") || this.tipo == 3 && mascara.matches("[hH]{2}:[mM]{2}(:[sS]{2})?|[mM]{2}:[sS]{2}")) {
                this.mascara = mascara;
                this.referencia = ValoresReferencia.novaInstancia(this.tipo, mascara);
            }
            this.atualizar();
        }
    }

    public int getTipo() {
        return this.tipo;
    }

    public int getTipoRegua() {
        return this.tipoRegua;
    }

    public void setTipoRegua(int tipoRegua) {
        this.tipoRegua = tipoRegua;
        this.atualizar();
    }

    public void setTipo(int tipo) {
        if ((tipo == 1 || tipo == 3) && tipo != this.tipo) {
            this.tipo = tipo;
            this.mascara = "";
            this.referencia = null;
            this.atualizar();
        }
    }

    public void setOrigem(String origem) {
        if (origem != null) {
            this.origem = origem;
            Componente comp = this.pag == null ? null : this.pag.getComponenteComNome(origem);
            this.origemCampo = comp instanceof Campo;
            this.referencia = this.origemCampo ? ((Campo)comp).getValoresDeReferencia() : null;
            this.mascara = "";
            this.atualizar();
        }
    }

    public String getOrigem() {
        return this.origem;
    }

    public void setValoresDeReferencia(ValoresReferencia valores) {
        this.referencia = valores;
        this.atualizar();
    }

    public ValoresReferencia getValoresDeReferencia() {
        return this.referencia;
    }

    public void setAtributosNormal(AtributosRegua atributos) {
        this.atributosNormal = atributos;
        this.atualizar();
    }

    public AtributosRegua getAtributosNormal() {
        return this.atributosNormal;
    }

    public void setAtributosAlterado(AtributosRegua atributos) {
        this.atributosAlterado = atributos;
        this.atualizar();
    }

    public void setAtributosRegua(AtributosReguaMedia atributos) {
        if (this.tipoRegua == 0) {
            this.atributosRegua = atributos;
        } else {
            this.atributosReguaMedia = atributos;
        }
        this.atualizar();
    }

    public void setAtributosReguaMedia(AtributosReguaMedia atributosReguaMedia) {
        this.atributosReguaMedia = atributosReguaMedia;
        this.atualizar();
    }

    public AtributosReguaMedia getAtributosReguaMedia() {
        return this.atributosReguaMedia;
    }

    public AtributosRegua getAtributosRegua() {
        return this.atributosRegua;
    }

    public AtributosRegua getAtributosAlterado() {
        return this.atributosAlterado;
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        if (!edicao && this.salvoValor) {
            ReguaReferencialImpressao ri = new ReguaReferencialImpressao();
            ri.setDono(this);
            ri.setName(this.getNome());
            ri.setValor(this.getValorResultado());
            ri.setBounds(this.getDimensoes());
            return ri;
        }
        ReguaReferencialDigitacao rd = new ReguaReferencialDigitacao();
        rd.setDono(this);
        rd.setTipo(this.getTipoRegua());
        rd.setName(this.getNome());
        rd.setBounds(this.getDimensoes());
        return rd;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        int y = height / 2;
        if (this.tipoRegua == 0) {
            g2.setColor(this.getCorDeFundo());
            g2.fillRect(0, 0, width, height);
            if (this.referencia == null || this.referencia.zero() || this.referencia.invalido()) {
                g2.setColor(Color.black);
                g2.setStroke(Constantes.SOLIDO);
                g2.drawLine(0, y, width - 1, y);
            } else {
                float[] vlrs = this.converteValores(this.referencia);
                float dist = vlrs[3] - vlrs[0];
                int min = (int)((float)width * (vlrs[1] - vlrs[0]) / dist);
                int max = (int)((float)width * (vlrs[2] - vlrs[0]) / dist);
                this.atributosAlterado.aplicarAtributos(g2);
                g2.drawLine(0, y, min, y);
                g2.drawLine(max, y, width - 1, y);
                this.atributosNormal.aplicarAtributos(g2);
                g2.drawLine(min, y, max, y);
                g2.setStroke(Constantes.SOLIDO);
                g2.drawLine(min, 2, min, height - 3);
                g2.drawLine(max, 2, max, height - 3);
                g2.setColor(this.atributosAlterado.getCor());
            }
        } else {
            ReguaReferencial.paintReguaMedia(g2, width, height, this.atributosReguaMedia);
        }
        g2.drawLine(0, 0, 0, height - 1);
        g2.drawLine(width - 1, 0, width - 1, height - 1);
    }

    public static void paintReguaMedia(Graphics2D g2, int width, int height, AtributosReguaMedia atributosReguaMedia) {
        if (atributosReguaMedia.getTipoPreenchimento() == null || atributosReguaMedia.getTipoPreenchimento().equalsIgnoreCase("Degrad\u00ea")) {
            ReguaReferencial.paintReguaDegrade(g2, width, height, atributosReguaMedia);
        } else {
            height = height <= 10 ? 15 : height;
            ReguaReferencial.paintReguaFixa(g2, width, height - 8, atributosReguaMedia);
        }
    }

    public static LinearGradientPaint paintReguaFixa(Graphics2D g2, int width, int height, AtributosReguaMedia atributosReguaMedia) {
        int i;
        Color[] cores = new Color[atributosReguaMedia.getAtributosReguas().size()];
        float[] dist = new float[atributosReguaMedia.getAtributosReguas().size()];
        float intervalo = atributosReguaMedia.getMaximo().floatValue() - atributosReguaMedia.getMinimo().floatValue();
        for (i = 0; i < atributosReguaMedia.getAtributosReguas().size(); ++i) {
            Float valorInicial = Float.valueOf(atributosReguaMedia.getAtributosReguas().get(i).getValorInicial().replace(",", "."));
            Float valorFinal = Float.valueOf(atributosReguaMedia.getAtributosReguas().get(i).getValorFinal().replace(",", "."));
            float valorMedio = (valorInicial.floatValue() + valorFinal.floatValue()) / 2.0f;
            float valorMedioEscalaZero = ReguaReferencial.calcularValorNaEscalaZero(valorMedio, atributosReguaMedia.getMinimo().floatValue(), atributosReguaMedia.getMaximo().floatValue(), intervalo);
            float posicaoMedia = Float.parseFloat(decfor.format(valorMedioEscalaZero / intervalo).replace(",", "."));
            cores[i] = atributosReguaMedia.getAtributosReguas().get(i).getCor();
            dist[i] = ReguaReferencial.getPosicaoFixa(posicaoMedia, dist);
        }
        for (i = 0; i < dist.length; ++i) {
            if (i > 0 && dist[i] <= dist[i - 1]) {
                dist[i] = (float)((double)dist[i - 1] + 0.01);
            }
            if (i != dist.length - 1 || !(dist[i] > 1.0f)) continue;
            dist[i] = 1.0f;
        }
        LinearGradientPaint primary = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, dist, cores);
        g2.setPaint(primary);
        g2.fillRect(0, 5, width, height);
        return primary;
    }

    public static float[] getPosicoesReguaFixa(AtributosReguaMedia atributosReguaMedia) {
        float valorAnterior = 0.0f;
        float[] dist2 = new float[atributosReguaMedia.getAtributosReguas().size() * 2];
        float intervalo = atributosReguaMedia.getMaximo().floatValue() - atributosReguaMedia.getMinimo().floatValue();
        for (int i = 0; i < atributosReguaMedia.getAtributosReguas().size(); ++i) {
            int index = i * 2;
            Float valorFinal = Float.valueOf(atributosReguaMedia.getAtributosReguas().get(i).getValorFinal().replace(",", "."));
            Float diferencaValorFinal = Float.valueOf(valorFinal.floatValue() - atributosReguaMedia.getMinimo().floatValue());
            float posicaoFinal = Float.parseFloat(decfor.format(diferencaValorFinal.floatValue() / intervalo).replace(",", "."));
            dist2[index] = i == 0 ? 0.0f : ReguaReferencial.getPosicaoFixa(valorAnterior, dist2);
            dist2[index + 1] = ReguaReferencial.getPosicaoFixa(posicaoFinal, dist2);
            valorAnterior = posicaoFinal;
        }
        return dist2;
    }

    public static float getPosicaoFixa(float posicao, float[] dist) {
        for (int i = 0; i < dist.length; ++i) {
            if (dist[i] != posicao) continue;
            return posicao + 0.01f;
        }
        return posicao;
    }

    public static float calcularValorNaEscalaZero(float valorOriginal, float valorMinimoOriginal, float valorMaximoOriginal, float novoMaximo) {
        return (valorOriginal - valorMinimoOriginal) * (novoMaximo - 0.0f) / (valorMaximoOriginal - valorMinimoOriginal) + 0.0f;
    }

    private static void paintReguaDegrade(Graphics2D g2, int width, int height, AtributosReguaMedia atributosReguaMedia) {
        if (atributosReguaMedia.getAtributosReguas().isEmpty()) {
            AtributosReguaMediaCores novaRegua = new AtributosReguaMediaCores();
            novaRegua.setCor(Color.orange);
            novaRegua.setLinha(Constantes.SOLIDO);
            novaRegua.setNome("Laranja");
            atributosReguaMedia.setCorMedia(Color.black);
            atributosReguaMedia.getAtributosReguas().add(novaRegua);
            atributosReguaMedia.getAtributosReguas().add(novaRegua);
        }
        Color[] cores = new Color[atributosReguaMedia.getAtributosReguas().size()];
        float[] dist = new float[atributosReguaMedia.getAtributosReguas().size()];
        float parteLargura = 1.0f / (float)atributosReguaMedia.getAtributosReguas().size();
        for (int i = 0; i < atributosReguaMedia.getAtributosReguas().size(); ++i) {
            cores[i] = atributosReguaMedia.getAtributosReguas().get(i).getCor();
            dist[i] = (float)(i + 1) * parteLargura;
        }
        LinearGradientPaint primary = new LinearGradientPaint(0.0f, 0.0f, width, height, dist, cores);
        g2.setPaint(primary);
        g2.fillRect(0, 0, width, height);
    }

    public float[] converteValores(ValoresReferencia vr) {
        float[] vlrs = new float[4];
        String[] tmp = vr.getValores();
        for (int i = 0; i < tmp.length; ++i) {
            Object o = ReguaReferencial.getValorStringReguaReferencial(tmp[i]);
            if (o instanceof Number) {
                vlrs[i] = ((Number)o).floatValue();
                continue;
            }
            if (!(o instanceof Date)) continue;
            vlrs[i] = ((Number)o).floatValue();
        }
        return vlrs;
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }

    public String getResultadoExpressaoMedia() {
        return this.resultadoExpressaoMedia;
    }

    public void setResultadoExpressaoMedia(String resultadoExpressaoMedia) {
        this.resultadoExpressaoMedia = resultadoExpressaoMedia;
    }

    public static Object getValorStringReguaReferencial(String str) {
        if (str != null) {
            try {
                String tmp = StringUtil.trataPontuacao(str);
                if (tmp.matches("\\-?\\d+")) {
                    return new BigInteger(tmp);
                }
                if (tmp.matches("\\-?\\d+(\\.\\d+)?")) {
                    return new BigDecimal(tmp);
                }
                if (tmp.matches("(([01]\\d|2[0-3]):)?[0-5]\\d(:[0-5]\\d)?")) {
                    tmp = tmp.replace(":", "");
                    return new BigDecimal(tmp);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("N\u00e3o foi poss\u00edvel formatar a String:" + str, e);
            }
        }
        return str;
    }
}

