/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontal;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoVertical;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorCampoBanco;
import jalis.laboratorio.configurador.propriedade.EditorCampoInterfaceamento;
import jalis.laboratorio.configurador.propriedade.EditorCondicao;
import jalis.laboratorio.configurador.propriedade.EditorImagem;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorOrdem;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.ImagemDigitacao;
import jalis.laboratorio.impressao.componente.ImagemImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;

public class Imagem
extends AbstractComponente
implements ComponenteInterfaceamento {
    private boolean estender = false;
    private int alinHori = 0;
    private int alinVert = 0;
    private ImageIcon imagem;
    private String campoBanco = "";
    private String condicao = "";
    private boolean removerVazio = true;
    private int ordem;

    public Imagem() {
        this.setTamanho(new Dimension(75, 75));
        this.setRelacionavelComCampoDeImportacao(true);
        this.setRemoverVazio(true);
        this.setOrdem(0);
    }

    @Override
    public String getNomeBase() {
        return "Imagem";
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
            list.add(new Propriedade("estender", EditorBoolean.class));
            list.add(new Propriedade("imagem", EditorImagem.class));
            list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
            list.add(new Propriedade("alinhamento vertical", EditorAlinhamentoVertical.class));
            list.add(new Propriedade("campo do banco", EditorCampoBanco.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            list.add(new Propriedade("condi\u00e7\u00e3o", EditorCondicao.class));
            list.add(new Propriedade("remover vazio", EditorBoolean.class));
            list.add(new Propriedade("ordem", EditorOrdem.class));
        } else {
            list.add(new Propriedade("campo interfaceamento", EditorCampoInterfaceamento.class));
        }
        return list;
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Imagem) {
            Imagem img = (Imagem)comp;
            this.setImagem(img.getImagem());
            this.setCampoDoBanco(img.getCampoDoBanco());
            this.setCampoInterfaceamento(img.getCampoInterfaceamento());
            this.setCondicao(img.getCondicao());
            this.setEstender(img.getEstender());
            this.setRemoverVazio(img.getRemoverVazio());
            this.setOrdem(img.getOrdem());
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setEstender(StringUtil.getBoolean(StringUtil.getValor(xml, "estender")));
        this.setImagem(StringUtil.getValor(xml, "imagem"));
        this.setCampoDoBanco(StringUtil.getValor(xml, "campoBanco"));
        this.setCampoInterfaceamento(StringUtil.getValor(xml, "campoInterfaceamento"));
        this.setCondicao(StringUtil.getValor(xml, "expressao"));
        this.setOrdem(StringUtil.getInt(xml, "ordem"));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    public String getCondicao() {
        return this.condicao;
    }

    public void setCondicao(String condicao) {
        this.condicao = condicao;
    }

    public String getImagem() {
        if (this.imagem != null) {
            return new Base64().encodeAsString(ImagemUtils.imageToByte(this.imagem.getImage()));
        }
        return "";
    }

    public void setCampoDoBanco(String nomeCampo) {
        this.campoBanco = nomeCampo;
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    public int getOrdem() {
        return this.ordem;
    }

    public void setOrdem(int ordem) {
        this.ordem = ordem;
    }

    public void setImagem(String imagem) {
        if (imagem != null) {
            try {
                if (imagem.length() == 0) {
                    this.imagem = null;
                    this.alinHori = 0;
                } else {
                    byte[] bim = null;
                    if (!Funcoes.textoVazio(imagem = this.limpaCdata(imagem))) {
                        bim = ImagemUtils.converterBase64ParaByteArray(imagem);
                    }
                    if (bim != null) {
                        this.imagem = new ImageIcon(bim);
                    }
                }
                this.atualizar();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Imagem: 128");
            }
        }
    }

    public boolean getEstender() {
        return this.estender;
    }

    public void setEstender(boolean estender) {
        this.estender = estender;
        this.atualizar();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alinHori;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinHori = alinhamento;
        this.atualizar();
    }

    @Override
    public int getAlinhamentoVertical() {
        return this.alinVert;
    }

    @Override
    public void setAlinhamentoVertical(int alinhamento) {
        this.alinVert = alinhamento;
        this.atualizar();
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("estender", String.valueOf(this.getEstender())));
        bui.append(StringUtil.getTag("imagem", "<![CDATA[" + this.getImagem() + "]]>"));
        bui.append(StringUtil.getTag("campoBanco", this.getCampoDoBanco()));
        bui.append(StringUtil.getTag("campoInterfaceamento", this.getCampoInterfaceamento()));
        bui.append(StringUtil.getTag("condicao", "<![CDATA[" + this.getCondicao() + "]]>"));
        bui.append(StringUtil.getTag("ordem", String.valueOf(this.getOrdem())));
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setEstender(StringUtil.getBoolean(StringUtil.getValor(atr, "estender")));
        this.setImagem(StringUtil.getValor(atr, "imagem"));
        this.setCampoDoBanco(StringUtil.getValor(atr, "campoBanco"));
        this.setCampoInterfaceamento(StringUtil.getValor(atr, "campoInterfaceamento"));
        this.setCondicao(StringUtil.getValor(atr, "condicao"));
        super.setAtributos(atr);
        if (StringUtil.getValor(atr, "removerVazio").trim().length() == 0) {
            this.setRemoverVazio(true);
        }
        this.setOrdem(StringUtil.getInt(atr, "ordem"));
        this.setAtualizar(true);
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        if (!edicao && this.salvoValor) {
            ImagemImpressao img = new ImagemImpressao();
            img.setDono(this);
            img.setName(this.getNome());
            img.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
            img.setAlinhamentoVertical(this.getAlinhamentoVertical());
            img.setEstender(this.estender);
            img.setImagem(this.getValorResultado() != null ? this.getValorResultado() : this.getImagem());
            img.setDimensoes(this.getDimensoes());
            img.setImprimir(this.getImprimir());
            return img;
        }
        ImagemDigitacao img = new ImagemDigitacao();
        img.setDono(this);
        img.setName(this.getNome());
        img.setCampoInterfaceamento(this.getCampoInterfaceamento());
        img.setDimensoes(this.getDimensoes());
        img.setImprimir(this.getImprimir());
        img.setEstender(this.getEstender());
        img.setImagem(this.getValorResultado() != null && !Funcoes.textoVazio(this.getValorResultado()) ? this.getValorResultado() : this.getImagem());
        img.setCampoDoBanco(this.getCampoDoBanco());
        img.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
        img.setAlinhamentoVertical(this.getAlinhamentoVertical());
        img.setCondicao(this.getCondicao());
        img.setImprimir(this.getImprimir());
        img.setLigacoes(this.getLigacoes());
        img.setRemoverVazio(this.getRemoverVazio());
        img.setOrdem(this.getOrdem());
        return img;
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.imagem != null) {
            Graphics2D g2D = (Graphics2D)g;
            if (this.estender) {
                Image redimensionada = ImagemUtils.redimensionarImagemComBiblioteca(this.imagem.getImage(), this.getWidth(), this.getHeight());
                g2D.drawImage(redimensionada, 0, 0, null);
            } else {
                int x;
                int imgW = this.imagem.getIconWidth();
                int imgH = this.imagem.getIconHeight();
                int n = this.alinHori == 2 ? 0 : (x = this.alinHori == 4 ? d.width - imgW : (d.width - imgW) / 2);
                int y = this.alinVert == 1 ? 0 : (this.alinVert == 3 ? d.height - imgH : (d.height - imgH) / 2);
                g2D.drawImage(this.imagem.getImage(), x, y, this.imagem.getIconWidth(), this.imagem.getIconHeight(), null);
            }
        } else {
            FontMetrics m = g.getFontMetrics();
            int w = m.stringWidth("Imagem");
            int h = m.getHeight();
            int descent = m.getDescent();
            g.drawString("Imagem", (d.width - w) / 2, (d.height + h) / 2 - descent);
        }
        if (!this.estender || this.imagem == null) {
            g.setColor(Color.black);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

