/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontal;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorCampoInterfaceamento;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorFont;
import jalis.laboratorio.configurador.propriedade.EditorHistorico;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorQtdeHistorico;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.EditorValorPadraoHistorico;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.HistoricoDigitacao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Historico
extends AbstractComponente
implements Digitavel,
ComponenteInterfaceamento,
ComponenteEditor {
    private String texto = "Hist\u00f3rico";
    private List<String> codigos = new ArrayList<String>();
    private int qtdeMax = 1;
    private int alinHor = 2;
    private String tagSelecionada = null;

    public Historico() {
        this.setTamanho(new Dimension(75, 25));
        this.setRelacionavelComCampoDeImportacao(true);
        this.atualizar();
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (this.modoInterfaceamento()) {
            list.add(new Propriedade("campo interfaceamento", EditorCampoInterfaceamento.class));
        } else {
            list.add(new Propriedade("fonte", EditorFont.class));
            list.add(new Propriedade("cor da fonte", EditorColor.class));
            list.add(new Propriedade("resultado anterior", EditorBoolean.class));
            if (this.getResultadoAnterior()) {
                list.add(new Propriedade(EditorTag.getDescricaoTag(), EditorTag.class));
            }
            list.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
            list.add(new Propriedade("valor padr\u00e3o", EditorValorPadraoHistorico.class));
            list.add(new Propriedade("remover vazio", EditorBoolean.class));
            list.add(new Propriedade("hist\u00f3ricos", EditorHistorico.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            list.add(new Propriedade("quantidade", EditorQtdeHistorico.class));
            list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
        }
        return list;
    }

    @Override
    public String getNomeBase() {
        return "Historico";
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Historico) {
            Historico his = (Historico)comp;
            this.setHistoricos(his.getHistoricos());
            this.setQuantidade(his.getQuantidade());
            this.setFonte(his.getFonte());
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setCorDaFonte(StringUtil.getColor(xml, "corDaFonte"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(xml, "fonte")));
        this.setHistoricos(StringUtil.getListValores(StringUtil.getValor(xml, "historicos"), "his"));
        this.setQuantidade(StringUtil.getInt(xml, "quantidade"));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    public List<String> getHistoricos() {
        return this.codigos;
    }

    public void setHistoricos(List<String> historicos) {
        if (historicos != null) {
            this.codigos = historicos;
        }
    }

    public void setQuantidade(int qtde) {
        if (qtde > 0) {
            this.qtdeMax = qtde;
        }
    }

    public int getQuantidade() {
        return this.qtdeMax;
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("corDaFonte", String.valueOf(this.getCorDaFonte().getRGB())));
        bui.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(this.getFonte())));
        bui.append(StringUtil.getTag("historicos", StringUtil.getTag("his", this.getHistoricos())));
        bui.append(StringUtil.getTag("quantidade", String.valueOf(this.getQuantidade())));
        if (this.getResultadoAnterior()) {
            bui.append(StringUtil.getTag("tagResultado", this.getTagResultado()));
        }
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(atr, "fonte")));
        this.setHistoricos(StringUtil.getListValores(StringUtil.getValor(atr, "historicos"), "his"));
        this.setQuantidade(StringUtil.getInt(atr, "quantidade"));
        this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        if (!edicao && this.salvoValor) {
            TextoEstatico texto = new TextoEstatico();
            texto.setDono(this);
            texto.setName(this.getNome());
            texto.setFont(this.getFont());
            if (this.getValorResultado().indexOf("<html>") < 0) {
                this.setValorResultado(this.getValorResultado().replaceAll("&gt;", ">").replaceAll("&lt;", "<"));
            }
            texto.setText(this.getValorResultado());
            texto.setValor(this.getValorResultado());
            texto.setDimensoes(this.getDimensoes());
            texto.setForeground(this.getForeground());
            texto.setImprimir(this.getImprimir());
            texto.setProcessarTagsHTML(true);
            texto.setHorizontalAlignment(this.getAlinhamentoHorizontal());
            return texto;
        }
        HistoricoDigitacao historico = new HistoricoDigitacao();
        historico.setDono(this);
        historico.setName(this.getNome());
        historico.setCampoInterfaceamento(this.getCampoInterfaceamento());
        historico.setDimensoes(this.getDimensoes());
        historico.setForeground(this.getCorDaFonte());
        historico.setFont(this.getFonte());
        historico.setImprimir(this.getImprimir());
        historico.setLigacoes(this.getLigacoes());
        historico.setResultadoAnterior(this.getResultadoAnterior());
        historico.setRemoverVazio(this.getRemoverVazio());
        historico.setCodigoHistoricos(this.codigos);
        historico.setQuantidade(this.qtdeMax);
        historico.setValorPadrao(this.getValorPadrao());
        if (edicao) {
            historico.setValor(this.getValorResultado());
        }
        return historico;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics met = g.getFontMetrics();
        int h = met.getHeight();
        String str = this.getNome().length() > 0 ? this.getNome() : this.texto;
        g.drawString(str, 3, this.getHeight() / 2 + h / 2 - 2);
        g.setColor(Color.gray);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alinHor;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinHor = alinhamento;
        this.atualizar();
    }

    @Override
    public void setTagResultado(String tag) {
        if (!Funcoes.textoVazio(this.tagSelecionada) && this.pag != null) {
            this.pag.removeTagEmUso(this.tagSelecionada);
        }
        this.tagSelecionada = tag;
        if (this.pag != null) {
            this.pag.adicionaTagEmUso(tag, this);
        }
    }

    @Override
    public String getTagResultado() {
        return this.tagSelecionada;
    }

    @Override
    @Deprecated
    public void setConferenciaAutomatica(String validacao) {
    }

    @Override
    @Deprecated
    public String getConferenciaAutomatica() {
        return null;
    }

    @Override
    @Deprecated
    public boolean isConferenciaAutomatica() {
        return false;
    }

    @Override
    @Deprecated
    public ValoresPercentualDeltaCheck getPercentualDeVariacao() {
        return null;
    }

    @Override
    @Deprecated
    public String getTipoConferenciaAutomatica() {
        return null;
    }

    @Override
    public void atualizaComboTagResultado() {
        if (this.pag.getGerenciador() != null) {
            this.pag.getGerenciador().dadosAlterados(null);
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

