/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.AtributosHachuradoQuadrante;
import jalis.laboratorio.configurador.AtributosPosicaoQuadrante;
import jalis.laboratorio.configurador.Constantes;
import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorCampoValor;
import jalis.laboratorio.configurador.propriedade.EditorCamposGrafico;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorCondicao;
import jalis.laboratorio.configurador.propriedade.EditorDecimais;
import jalis.laboratorio.configurador.propriedade.EditorExpressao;
import jalis.laboratorio.configurador.propriedade.EditorFont;
import jalis.laboratorio.configurador.propriedade.EditorHachuradoQuadrante;
import jalis.laboratorio.configurador.propriedade.EditorInt;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorLinhasFixas;
import jalis.laboratorio.configurador.propriedade.EditorMascaraNumero;
import jalis.laboratorio.configurador.propriedade.EditorNumeroFormatado;
import jalis.laboratorio.configurador.propriedade.EditorOrientacaoTexto;
import jalis.laboratorio.configurador.propriedade.EditorOrigemGrafico;
import jalis.laboratorio.configurador.propriedade.EditorPosicaoQuadrante;
import jalis.laboratorio.configurador.propriedade.EditorQtdeResultados;
import jalis.laboratorio.configurador.propriedade.EditorRotulo;
import jalis.laboratorio.configurador.propriedade.EditorRotulosGrafico;
import jalis.laboratorio.configurador.propriedade.EditorRotulosGraficoReferencia;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.EditorTipoGrafico;
import jalis.laboratorio.configurador.propriedade.EditorTipoLinha;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.GraficoConfiguravelDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoQuadranteDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoReferenciaDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoResultadoAnteriorDigitacao;
import jalis.laboratorio.impressao.componente.GraficoImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Grafico
extends AbstractComponente
implements ComponenteEditor {
    public static final int GRAFICO_RESULTADO_ANTERIOR = 0;
    public static final int GRAFICO_CONFIGURAVEL = 1;
    public static final int GRAFICO_REFERENCIA = 2;
    public static final int GRAFICO_QUADRANTE = 3;
    public static final int ROTULO_DATA = 0;
    public static final int ROTULO_HORA = 1;
    public static final int ROTULO_DATA_HORA = 2;
    public static final int ROTULO_HORA_DATA = 3;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int DIAGONAL = 2;
    private int tipoGrafico;
    private int qtdeResultados;
    private int tipoRotulo;
    private int distanciaX;
    private int distanciaY;
    private int distanciaRotulo;
    private int distanciaEntreLinhas;
    private String campoOrigem;
    private Color corLinha;
    private Color corFonteRotulos;
    private Color corLinhaReferencia;
    private Color corEixos;
    private Font fonteRotulos;
    private Font fonteValoresReferencia;
    private int orientacaoValores;
    private int orientacaoValoresReferencia;
    private Stroke tipoLinha;
    private String valorMaximoY;
    private String valorMaximoX;
    private boolean exibirValores;
    private boolean valorMaximoResultado;
    private boolean exibirLinhasReferencia;
    private boolean exibirValoresReferencia;
    private ArrayList<String> rotulos;
    private ArrayList<String> campos;
    private ArrayList<String> linhasFixas;
    private ValoresReferencia referencia;
    private boolean origemTipoCampo;
    private String mascaraValor = "###,##";
    private int tamanhoPonto = 2;
    private Color corPonto = Color.BLUE;
    private double intervaloLinhasEixoY = 0.0;
    private String expressaoEixoX = "";
    private String retornoExpressaoEixoX = "";
    private String expressaoEixoY = "";
    private String retornoExpressaoEixoY = "";
    private boolean multiplosCampos = false;
    private String campoValor;
    private int intervaloEixoY = 10;
    private int intervaloEixoX = 10;
    private String expressaoAdicional = "";
    private String rotuloAdicional = "";
    private ArrayList<String> linhasEixoX;
    private ArrayList<String> linhasEixoY;
    private ArrayList<AtributosPosicaoQuadrante> itensIdentificacaoQuadrante;
    private AtributosHachuradoQuadrante atributoHachuradoQuadrante;
    private String tagSelecionada = "";
    private String condicao = "";

    public Grafico() {
        this.setSize(300, 85);
        this.removerVazio = true;
        this.tipoGrafico = 0;
        this.orientacaoValores = 0;
        this.orientacaoValoresReferencia = 1;
        this.qtdeResultados = 5;
        this.distanciaX = 16;
        this.distanciaY = 13;
        this.distanciaRotulo = 27;
        this.distanciaEntreLinhas = 3;
        this.corLinha = Color.blue;
        this.corLinhaReferencia = new Color(0, 180, 0);
        this.corEixos = Color.black;
        this.corFonteRotulos = this.getCorDaFonte();
        this.setFonteValores(new Font("Arial", 0, 9));
        this.fonteRotulos = this.getFonteValores();
        this.fonteValoresReferencia = this.getFonteValores();
        this.tipoLinha = Constantes.SOLIDO;
        this.valorMaximoY = "";
        this.exibirValores = true;
        this.exibirLinhasReferencia = true;
        this.campoOrigem = "";
        this.rotulos = new ArrayList();
        this.linhasFixas = new ArrayList();
        this.campos = new ArrayList();
        this.corPonto = this.corLinha;
        this.expressaoEixoX = "";
        this.expressaoEixoY = "";
        this.multiplosCampos = false;
        this.campoValor = "";
        this.linhasEixoY = new ArrayList();
        this.linhasEixoX = new ArrayList();
        this.itensIdentificacaoQuadrante = new ArrayList();
        this.atributoHachuradoQuadrante = new AtributosHachuradoQuadrante();
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            list.add(new Propriedade("condi\u00e7\u00e3o", EditorCondicao.class));
            list.add(new Propriedade("cor de fundo", EditorColor.class));
            list.add(new Propriedade("fonte r\u00f3tulos", EditorFont.class));
            list.add(new Propriedade("cor da fonte r\u00f3tulos", EditorColor.class));
            list.add(new Propriedade("cor ponto", EditorColor.class));
            list.add(new Propriedade("tipo gr\u00e1fico", EditorTipoGrafico.class));
            list.add(new Propriedade("cor da linha", EditorColor.class));
            list.add(new Propriedade("exibir valores", EditorBoolean.class));
            list.add(new Propriedade("tipo da linha", EditorTipoLinha.class));
            list.add(new Propriedade("cor dos eixos", EditorColor.class));
            if (this.tipoGrafico != 3) {
                if (this.tipoGrafico == 2) {
                    list.add(new Propriedade("valor m\u00e1ximo resultado", EditorBoolean.class));
                } else {
                    this.setValorMaximoResultado(false);
                }
                if (!this.getValorMaximoResultado()) {
                    list.add(new Propriedade("valor m\u00e1ximo", EditorNumeroFormatado.class));
                } else {
                    this.setValorMaximo(null);
                }
                list.add(new Propriedade("m\u00e1scara valor", EditorMascaraNumero.class));
            }
            list.add(new Propriedade("dist\u00e2ncia x", EditorInt.class));
            list.add(new Propriedade("dist\u00e2ncia y", EditorInt.class));
            list.add(new Propriedade("dist\u00e2ncia r\u00f3tulo eixo y", EditorInt.class));
            list.add(new Propriedade("dist\u00e2ncia entre linhas", EditorInt.class));
            list.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
            list.add(new Propriedade("remover vazio", EditorBoolean.class));
            list.add(new Propriedade("tamanho ponto", EditorInt.class));
            if (this.getExibirValores()) {
                list.add(new Propriedade("orienta\u00e7\u00e3o valores", EditorOrientacaoTexto.class));
                list.add(new Propriedade("fonte valores", EditorFont.class));
                list.add(new Propriedade("cor da fonte valores", EditorColor.class));
            }
            if (this.tipoGrafico == 0) {
                list.add(new Propriedade("quantidade resultados", EditorQtdeResultados.class));
                list.add(new Propriedade("origem", EditorOrigemGrafico.class));
                list.add(new Propriedade("tipo r\u00f3tulo", EditorRotulo.class));
                list.add(new Propriedade("expressao adicional", EditorExpressao.class));
                list.add(new Propriedade("rotulo adicional", EditorExpressao.class));
                list.add(new Propriedade(EditorTag.getDescricaoTag(), EditorTag.class));
                if (this.referencia != null) {
                    list.add(new Propriedade("cor linhas refer\u00eancia", EditorColor.class));
                    list.add(new Propriedade("exibir linhas refer\u00eancia", EditorBoolean.class));
                    if (this.exibirLinhasReferencia) {
                        list.add(new Propriedade("exibir valores refer\u00eancia", EditorBoolean.class));
                        list.add(new Propriedade("fonte valores refer\u00eancia", EditorFont.class));
                        if (this.getExibirValoresReferencia()) {
                            list.add(new Propriedade("orienta\u00e7\u00e3o valores refer\u00eancia", EditorOrientacaoTexto.class));
                        }
                    }
                }
            } else if (this.tipoGrafico == 2) {
                list.add(new Propriedade("intervalo linhas", EditorNumeroFormatado.class));
                list.add(new Propriedade("r\u00f3tulos", EditorRotulosGraficoReferencia.class));
                if (this.getMultiplosCampos()) {
                    list.add(new Propriedade("campos", EditorCamposGrafico.class));
                }
                list.add(new Propriedade("linhas fixas", EditorLinhasFixas.class));
                list.add(new Propriedade("m\u00faltiplos campos", EditorBoolean.class));
                if (!this.getMultiplosCampos()) {
                    list.add(new Propriedade("expressao eixo x", EditorExpressao.class));
                    list.add(new Propriedade("campo valor", EditorCampoValor.class));
                }
            } else if (this.tipoGrafico == 3) {
                list.add(new Propriedade("valor m\u00e1ximo x", EditorNumeroFormatado.class));
                list.add(new Propriedade("valor m\u00e1ximo y", EditorNumeroFormatado.class));
                list.add(new Propriedade("expressao eixo x", EditorExpressao.class));
                list.add(new Propriedade("expressao eixo y", EditorExpressao.class));
                list.add(new Propriedade("intervalo eixo x", EditorInt.class));
                list.add(new Propriedade("intervalo eixo y", EditorInt.class));
                list.add(new Propriedade("linhas eixo x", EditorDecimais.class));
                list.add(new Propriedade("linhas eixo y", EditorDecimais.class));
                list.add(new Propriedade("identificar quadrante", EditorPosicaoQuadrante.class));
                list.add(new Propriedade("hachurado", EditorHachuradoQuadrante.class));
            } else {
                list.add(new Propriedade("r\u00f3tulos", EditorRotulosGrafico.class));
                list.add(new Propriedade("campos", EditorCamposGrafico.class));
            }
        }
        return list;
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("condicao", "<![CDATA[" + this.getCondicao() + "]]>"));
        bui.append(StringUtil.getTag("corDeFundo", String.valueOf(this.getCorDeFundo().getRGB())));
        bui.append(StringUtil.getTag("corDaFonte", String.valueOf(this.getCorDaFonte().getRGB())));
        bui.append(StringUtil.getTag("fonteRotulos", StringUtil.getFonteAtributos(this.getFonteRotulos())));
        bui.append(StringUtil.getTag("fonteValores", StringUtil.getFonteAtributos(this.getFonteValores())));
        bui.append(StringUtil.getTag("fonteValoresReferencia", StringUtil.getFonteAtributos(this.getFonteValoresReferencia())));
        bui.append(StringUtil.getTag("tipoGrafico", String.valueOf(this.getTipoGrafico())));
        bui.append(StringUtil.getTag("tipoRotulo", String.valueOf(this.getTipoRotulo())));
        bui.append(StringUtil.getTag("corDaLinha", String.valueOf(this.getCorDaLinha().getRGB())));
        bui.append(StringUtil.getTag("tipoDaLinha", this.getTipoDaLinha().toString()));
        bui.append(StringUtil.getTag("corDosEixos", String.valueOf(this.getCorDosEixos().getRGB())));
        bui.append(StringUtil.getTag("valorMaximo", "<![CDATA[" + this.getValorMaximo() + "]]>"));
        bui.append(StringUtil.getTag("quantidadeResultados", String.valueOf(this.getQuantidadeResultados())));
        bui.append(StringUtil.getTag("expressaoAdicional", "<![CDATA[" + this.getExpressaoAdicional() + "]]>"));
        bui.append(StringUtil.getTag("rotuloAdicional", this.getRotuloAdicional()));
        bui.append(StringUtil.getTag("origem", this.getOrigem()));
        bui.append(StringUtil.getTag("origemTipoCampo", String.valueOf(this.origemTipoCampo)));
        bui.append(StringUtil.getTag("corLinhasReferencia", String.valueOf(this.getCorLinhasReferencia().getRGB())));
        bui.append(StringUtil.getTag("exibirLinhasReferencia", String.valueOf(this.getExibirLinhasReferencia())));
        bui.append(StringUtil.getTag("exibirValoresReferencia", String.valueOf(this.getExibirValoresReferencia())));
        bui.append(StringUtil.getTag("rotulos", "<![CDATA[" + StringUtil.getTag("rotulo", this.rotulos) + "]]>"));
        bui.append(StringUtil.getTag("tagResultado", this.getTagResultado()));
        bui.append(StringUtil.getTag("campos", StringUtil.getTag("campo", this.campos)));
        bui.append(StringUtil.getTag("exibirValores", String.valueOf(this.getExibirValores())));
        bui.append(StringUtil.getTag("distanciaX", String.valueOf(this.getDistanciaX())));
        bui.append(StringUtil.getTag("distanciaY", String.valueOf(this.getDistanciaY())));
        bui.append(StringUtil.getTag("distanciaRotulo", String.valueOf(this.getDistanciaRotuloEixoY())));
        bui.append(StringUtil.getTag("distanciaEntreLinhas", String.valueOf(this.getDistanciaEntreLinhas())));
        bui.append(StringUtil.getTag("orientacaoValores", String.valueOf(this.getOrientacaoValores())));
        bui.append(StringUtil.getTag("orientacaoValoresReferencia", String.valueOf(this.getOrientacaoValoresReferencia())));
        bui.append(StringUtil.getTag("mascaraValor", "<![CDATA[" + String.valueOf(this.getMascaraValor()) + "]]>"));
        bui.append(StringUtil.getTag("corPonto", String.valueOf(this.getCorPonto().getRGB())));
        bui.append(StringUtil.getTag("tamanhoPonto", String.valueOf(this.getTamanhoPonto())));
        bui.append(StringUtil.getTag("intervaloLinhaEixoY", this.getIntervaloLinhas()));
        bui.append(StringUtil.getTag("multiplosCampos", String.valueOf(this.getMultiplosCampos())));
        bui.append(StringUtil.getTag("expressaoEixoX", "<![CDATA[" + this.getExpressaoEixoX() + "]]>"));
        bui.append(StringUtil.getTag("retornoExpressaoEixoX", "<![CDATA[" + this.getRetornoExpressaoEixoX() + "]]>"));
        bui.append(StringUtil.getTag("campoValor", "<![CDATA[" + this.getCampoValor() + "]]>"));
        bui.append(StringUtil.getTag("linhasFixas", StringUtil.getTag("linhaFixa", this.getLinhasFixas())));
        bui.append(StringUtil.getTag("valorMaximoX", String.valueOf(this.getValorMaximoX() == null ? Integer.valueOf(0) : this.getValorMaximoX())));
        bui.append(StringUtil.getTag("valorMaximoY", this.getValorMaximoY()));
        bui.append(StringUtil.getTag("expressaoEixoY", "<![CDATA[" + this.getExpressaoEixoY() + "]]>"));
        bui.append(StringUtil.getTag("retornoExpressaoEixoY", "<![CDATA[" + this.getRetornoExpressaoEixoY() + "]]>"));
        bui.append(StringUtil.getTag("intervaloEixoX", String.valueOf(this.getIntervaloEixoX())));
        bui.append(StringUtil.getTag("intervaloEixoY", String.valueOf(this.getIntervaloEixoY())));
        bui.append(StringUtil.getTag("linhasEixoY", StringUtil.getTag("linhaEixoY", this.getLinhasEixoY())));
        bui.append(StringUtil.getTag("linhasEixoX", StringUtil.getTag("linhaEixoX", this.getLinhasEixoX())));
        bui.append(StringUtil.getTag("valorMaximoResultado", String.valueOf(this.getValorMaximoResultado())));
        bui.append(this.atributoHachuradoQuadrante.getXML());
        StringBuilder buf = new StringBuilder();
        for (AtributosPosicaoQuadrante at : this.itensIdentificacaoQuadrante) {
            buf.append(at.getXML());
        }
        bui.append(StringUtil.getTag("atributosPosicaoQuadrante", buf.toString()));
        if (this.referencia != null) {
            bui.append(StringUtil.getTag("valoresDeReferencia", this.referencia.getAtributos()));
        }
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        if (atr != null) {
            this.setAtualizar(false);
            this.setCondicao(StringUtil.getValor(atr, "condicao"));
            this.setCorDeFundo(StringUtil.getColor(atr, "corDeFundo"));
            this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
            this.setFonteRotulos(StringUtil.getFonte(StringUtil.getValor(atr, "fonteRotulos")));
            this.setFonteValores(StringUtil.getFonte(StringUtil.getValor(atr, "fonteValores")));
            this.setFonteValoresReferencia(StringUtil.getFonte(StringUtil.getValor(atr, "fonteValoresReferencia")));
            this.setTipoGrafico(StringUtil.getInt(atr, "tipoGrafico"));
            this.setTipoRotulo(StringUtil.getInt(atr, "tipoRotulo"));
            this.setCorDaLinha(StringUtil.getColor(atr, "corDaLinha"));
            this.setTipoDaLinha(this.stringParaLinha(StringUtil.getValor(atr, "tipoDaLinha")));
            this.setCorDosEixos(StringUtil.getColor(atr, "corDosEixos"));
            this.setValorMaximo(StringUtil.getValor(atr, "valorMaximo"));
            this.setQuantidadeResultados(StringUtil.getInt(atr, "quantidadeResultados"));
            this.setExpressaoAdicional(StringUtil.getValor(atr, "expressaoAdicional"));
            this.setRotuloAdicional(StringUtil.getValor(atr, "rotuloAdicional"));
            this.setOrigem(StringUtil.getValor(atr, "origem"));
            this.origemTipoCampo = StringUtil.getBoolean(atr, "origemTipoCampo");
            this.setCorLinhasReferencia(StringUtil.getColor(atr, "corLinhasReferencia"));
            this.setExibirLinhasReferencia(StringUtil.getBoolean(atr, "exibirLinhasReferencia"));
            this.setExibirValoresReferencia(StringUtil.getBoolean(atr, "exibirValoresReferencia"));
            this.setRotulos(StringUtil.getListValores(StringUtil.getValor(atr, "rotulos"), "rotulo"));
            this.setCampos(StringUtil.getListValores(StringUtil.getValor(atr, "campos"), "campo"));
            this.setExibirValores(StringUtil.getBoolean(atr, "exibirValores"));
            this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
            this.setDistanciaX(StringUtil.getInt(atr, "distanciaX"));
            this.setDistanciaY(StringUtil.getInt(atr, "distanciaY"));
            this.setDistanciaRotuloEixoY(StringUtil.getInt(atr, "distanciaRotulo"));
            this.setDistanciaEntreLinhas(StringUtil.getInt(atr, "distanciaEntreLinhas"));
            this.setOrientacaoValores(StringUtil.getInt(atr, "orientacaoValores"));
            this.setOrientacaoValoresReferencia(StringUtil.getInt(atr, "orientacaoValoresReferencia"));
            this.setMascaraValor(StringUtil.getValor(atr, "mascaraValor"));
            this.setIntervaloLinhas(StringUtil.getValor(atr, "intervaloLinhaEixoY"));
            this.setMultiplosCampos(StringUtil.getBoolean(atr, "multiplosCampos"));
            this.setExpressaoEixoX(StringUtil.getValor(atr, "expressaoEixoX"));
            this.retornoExpressaoEixoX = StringUtil.getValor(atr, "retornoExpressaoEixoX");
            this.setCampoValor(StringUtil.getValor(atr, "campoValor"));
            this.setLinhasFixas(StringUtil.getListValores(StringUtil.getValor(atr, "linhasFixas"), "linhaFixa"));
            if (StringUtil.getValor(atr, "corPonto").trim().length() > 0) {
                this.setCorPonto(StringUtil.getColor(atr, "corPonto"));
            } else {
                this.setCorPonto(this.getCorDaLinha());
            }
            if (StringUtil.getValor(atr, "tamanhoPonto").trim().length() > 0) {
                this.setTamanhoPonto(StringUtil.getInt(atr, "tamanhoPonto"));
            } else {
                this.setTamanhoPonto(4);
            }
            if (this.origemTipoCampo && null != this.getOrigem() && !this.getOrigem().trim().isEmpty()) {
                this.referencia = ValoresReferencia.novaInstancia(1, "#");
                this.referencia.setAtributos(StringUtil.getValor(atr, "valoresDeReferencia"));
            }
            this.setValorMaximoX(StringUtil.getValor(atr, "valorMaximoX"));
            this.setValorMaximoY(StringUtil.getValor(atr, "valorMaximoY"));
            this.setExpressaoEixoY(StringUtil.getValor(atr, "expressaoEixoY"));
            this.retornoExpressaoEixoY = StringUtil.getValor(atr, "retornoExpressaoEixoY");
            this.setIntervaloEixoX(StringUtil.getInt(atr, "intervaloEixoX"));
            this.setIntervaloEixoY(StringUtil.getInt(atr, "intervaloEixoY"));
            this.setLinhasEixoX((ArrayList)StringUtil.getListValores(StringUtil.getValor(atr, "linhasEixoX"), "linhaEixoX"));
            this.setLinhasEixoY((ArrayList)StringUtil.getListValores(StringUtil.getValor(atr, "linhasEixoY"), "linhaEixoY"));
            this.setValorMaximoResultado(StringUtil.getBoolean(atr, "valorMaximoResultado"));
            if (this.getTipoGrafico() == 0) {
                this.setResultadoAnterior(StringUtil.getBoolean(StringUtil.getValor(atr, "resultadoAnterior")));
                this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
            }
            this.itensIdentificacaoQuadrante.clear();
            for (String xmlAtributo : StringUtil.getListValores(StringUtil.getValor(atr, "atributosPosicaoQuadrante"), "atributoPosicaoQuadrante", true)) {
                AtributosPosicaoQuadrante at = AtributosPosicaoQuadrante.newFromXML(xmlAtributo);
                if (at == null) continue;
                this.itensIdentificacaoQuadrante.add(at);
            }
            if (StringUtil.getValor(atr, "atritubosHachuradoQuadrante").trim().length() > 0) {
                this.atributoHachuradoQuadrante = AtributosHachuradoQuadrante.newFromXML("<atributosHachuradoQuadrante>" + StringUtil.getValor(atr, "atritubosHachuradoQuadrante") + "</atributosHachuradoQuadrante>");
            }
            super.setAtributos(atr);
            this.setAtualizar(true);
        }
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        if (comp instanceof Grafico) {
            this.setAtualizar(false);
            Grafico grafico = (Grafico)comp;
            this.setCondicao(grafico.getCondicao());
            this.setCorDeFundo(grafico.getCorDeFundo());
            this.setCorDaFonte(grafico.getCorDaFonte());
            this.setFonteRotulos(grafico.getFonteRotulos());
            this.setFonteValores(grafico.getFonteValores());
            this.setFonteValoresReferencia(grafico.getFonteValoresReferencia());
            this.setTipoGrafico(grafico.getTipoGrafico());
            this.setTipoRotulo(grafico.getTipoRotulo());
            this.setCorDaLinha(grafico.getCorDaLinha());
            this.setTipoDaLinha(grafico.getTipoDaLinha());
            this.setCorDosEixos(grafico.getCorDosEixos());
            this.setValorMaximo(grafico.getValorMaximo());
            this.setQuantidadeResultados(grafico.getQuantidadeResultados());
            this.setExpressaoAdicional(grafico.getExpressaoAdicional());
            this.setRotuloAdicional(grafico.getRotuloAdicional());
            this.setOrigem(grafico.getOrigem());
            this.setCorLinhasReferencia(grafico.getCorLinhasReferencia());
            this.setExibirLinhasReferencia(grafico.getExibirLinhasReferencia());
            this.setExibirValoresReferencia(grafico.getExibirValoresReferencia());
            this.setRotulos(grafico.getRotulos());
            this.setCampos(grafico.getCampos());
            this.setExibirValores(grafico.getExibirValores());
            this.setDistanciaX(grafico.getDistanciaX());
            this.setDistanciaY(grafico.getDistanciaY());
            this.setDistanciaRotuloEixoY(grafico.getDistanciaRotuloEixoY());
            this.setDistanciaEntreLinhas(grafico.getDistanciaEntreLinhas());
            this.setOrientacaoValores(grafico.getOrientacaoValores());
            this.setOrientacaoValoresReferencia(grafico.getOrientacaoValoresReferencia());
            this.setMascaraValor(grafico.getMascaraValor());
            this.setTamanhoPonto(grafico.getTamanhoPonto());
            this.setCorPonto(grafico.getCorPonto());
            this.setIntervaloLinhas(grafico.getIntervaloLinhas());
            this.setMultiplosCampos(grafico.getMultiplosCampos());
            this.setLinhasFixas(grafico.getLinhasFixas());
            this.setExpressaoEixoX(grafico.getExpressaoEixoX());
            this.setCampoValor(grafico.getCampoValor());
            this.setValorMaximoX(String.valueOf(this.getValorMaximoX() == null ? Integer.valueOf(0) : this.getValorMaximoX()));
            this.setValorMaximoY(this.getValorMaximoY());
            this.setExpressaoEixoY(grafico.getExpressaoEixoY());
            this.setIntervaloEixoX(grafico.getIntervaloEixoX());
            this.setIntervaloEixoY(grafico.getIntervaloEixoY());
            this.setLinhasEixoX(grafico.getLinhasEixoX());
            this.setLinhasEixoY(grafico.getLinhasEixoY());
            this.setIdentificarQuadrante(grafico.getIdentificarQuadrante());
            this.setHachurado(grafico.getHachurado());
            super.copiarAtributosDe(comp);
            this.setAtualizar(true);
        }
    }

    @Override
    public void copiarAtributosDe(String xml) {
        if (xml != null) {
            this.setAtualizar(false);
            this.setCondicao(StringUtil.getValor(xml, "expressao"));
            this.setCorDeFundo(StringUtil.getColor(xml, "corDeFundo"));
            this.setCorDaFonte(StringUtil.getColor(xml, "corDaFonte"));
            this.setFonteRotulos(StringUtil.getFonte(StringUtil.getValor(xml, "fonteRotulos")));
            this.setFonteValores(StringUtil.getFonte(StringUtil.getValor(xml, "fonteValores")));
            this.setFonteValoresReferencia(StringUtil.getFonte(StringUtil.getValor(xml, "fonteValoresReferencia")));
            this.setTipoGrafico(StringUtil.getInt(xml, "tipoGrafico"));
            this.setTipoRotulo(StringUtil.getInt(xml, "tipoRotulo"));
            this.setCorDaLinha(StringUtil.getColor(xml, "corDaLinha"));
            this.setTipoDaLinha(this.stringParaLinha(StringUtil.getValor(xml, "tipoDaLinha")));
            this.setCorDosEixos(StringUtil.getColor(xml, "corDosEixos"));
            this.setValorMaximo(StringUtil.getValor(xml, "valorMaximo"));
            this.setQuantidadeResultados(StringUtil.getInt(xml, "quantidadeResultados"));
            this.setExpressaoAdicional(StringUtil.getValor(xml, "expressaoAdicional"));
            this.setRotuloAdicional(StringUtil.getValor(xml, "rotuloAdicional"));
            this.setOrigem(StringUtil.getValor(xml, "origem"));
            this.origemTipoCampo = StringUtil.getBoolean(xml, "origemTipoCampo");
            this.setCorLinhasReferencia(StringUtil.getColor(xml, "corLinhasReferencia"));
            this.setExibirLinhasReferencia(StringUtil.getBoolean(xml, "exibirLinhasReferencia"));
            this.setExibirValoresReferencia(StringUtil.getBoolean(xml, "exibirValoresReferencia"));
            this.setRotulos(StringUtil.getListValores(this.limpaCdata(StringUtil.getValor(xml, "rotulos")), "rotulo"));
            this.setCampos(StringUtil.getListValores(StringUtil.getValor(xml, "campos"), "campo"));
            this.setExibirValores(StringUtil.getBoolean(xml, "exibirValores"));
            this.setDistanciaX(StringUtil.getInt(xml, "distanciaX"));
            this.setDistanciaY(StringUtil.getInt(xml, "distanciaY"));
            this.setDistanciaRotuloEixoY(StringUtil.getInt(xml, "distanciaRotulo"));
            this.setDistanciaEntreLinhas(StringUtil.getInt(xml, "distanciaEntreLinhas"));
            this.setOrientacaoValores(StringUtil.getInt(xml, "orientacaoValores"));
            this.setOrientacaoValoresReferencia(StringUtil.getInt(xml, "orientacaoValoresReferencia"));
            this.setMascaraValor(StringUtil.getValor(xml, "mascaraValor"));
            this.setCorPonto(StringUtil.getColor(xml, "corPonto"));
            this.setTamanhoPonto(StringUtil.getInt(xml, "tamanhoPonto"));
            this.setIntervaloLinhas(StringUtil.getValor(xml, "intervaloLinhaEixoY"));
            this.setMultiplosCampos(StringUtil.getBoolean(xml, "multiplosCampos"));
            this.setExpressaoEixoX(StringUtil.getValor(xml, "expressaoEixoX"));
            this.setCampoValor(StringUtil.getValor(xml, "campoValor"));
            this.setLinhasFixas(StringUtil.getListValores(StringUtil.getValor(xml, "linhasFixas"), "linhaFixa"));
            this.setValorMaximoX(StringUtil.getValor(xml, "valorMaximoX"));
            this.setValorMaximoY(StringUtil.getValor(xml, "valorMaximoY"));
            this.setExpressaoEixoY(StringUtil.getValor(xml, "expressaoEixoY"));
            this.setIntervaloEixoX(StringUtil.getInt(xml, "intervaloEixoX"));
            this.setIntervaloEixoY(StringUtil.getInt(xml, "intervaloEixoY"));
            this.setLinhasEixoX((ArrayList)StringUtil.getListValores(StringUtil.getValor(xml, "linhasEixoX"), "linhaEixoX"));
            this.setLinhasEixoY((ArrayList)StringUtil.getListValores(StringUtil.getValor(xml, "linhasEixoY"), "linhaEixoY"));
            ArrayList<AtributosPosicaoQuadrante> tmp = new ArrayList<AtributosPosicaoQuadrante>();
            for (String xmlAtributo : StringUtil.getListValores(StringUtil.getValor(xml, "atributosPosicaoQuadrante"), "atributoPosicaoQuadrante")) {
                AtributosPosicaoQuadrante at = AtributosPosicaoQuadrante.newFromXML(xmlAtributo);
                if (at == null) continue;
                tmp.add(at);
            }
            this.setIdentificarQuadrante(tmp);
            if (StringUtil.getValor(xml, "atritubosHachuradoQuadrante").trim().length() > 0) {
                this.atributoHachuradoQuadrante = AtributosHachuradoQuadrante.newFromXML("<atributosHachuradoQuadrante>" + StringUtil.getValor(xml, "atritubosHachuradoQuadrante") + "</atributosHachuradoQuadrante>");
            }
            if (this.origemTipoCampo) {
                this.referencia = ValoresReferencia.novaInstancia(1, "#");
                this.referencia.setAtributos(StringUtil.getValor(xml, "valoresDeReferencia"));
            }
            super.copiarAtributosDe(xml);
            this.setAtualizar(true);
        }
    }

    public String getCondicao() {
        return this.condicao;
    }

    public void setCondicao(String condicao) {
        this.condicao = condicao;
    }

    @Override
    public String getNomeBase() {
        return "Grafico";
    }

    public void setDistanciaX(int distancia) {
        this.distanciaX = distancia;
        this.atualizar();
    }

    public int getDistanciaX() {
        return this.distanciaX;
    }

    public void setDistanciaY(int distancia) {
        this.distanciaY = distancia;
        this.atualizar();
    }

    public int getDistanciaY() {
        return this.distanciaY;
    }

    public void setDistanciaRotuloEixoY(int distancia) {
        this.distanciaRotulo = distancia;
        this.atualizar();
    }

    public int getDistanciaRotuloEixoY() {
        return this.distanciaRotulo;
    }

    public void setDistanciaEntreLinhas(int distancia) {
        this.distanciaEntreLinhas = distancia;
        this.atualizar();
    }

    public int getDistanciaEntreLinhas() {
        return this.distanciaEntreLinhas;
    }

    public void setCorDaLinha(Color cor) {
        this.corLinha = cor;
        this.atualizar();
    }

    public Color getCorDaLinha() {
        return this.corLinha;
    }

    public void setCorLinhasReferencia(Color cor) {
        this.corLinhaReferencia = cor;
        this.atualizar();
    }

    public Color getCorLinhasReferencia() {
        return this.corLinhaReferencia;
    }

    public void setHachurado(AtributosHachuradoQuadrante atr) {
        this.atributoHachuradoQuadrante = atr;
        this.atualizar();
    }

    public AtributosHachuradoQuadrante getHachurado() {
        return this.atributoHachuradoQuadrante;
    }

    public Font getFonteValores() {
        return this.getFonte();
    }

    public void setFonteValores(Font fonte) {
        this.setFonte(fonte);
        this.atualizar();
    }

    public Font getFonteRotulos() {
        return this.fonteRotulos;
    }

    public void setFonteRotulos(Font fonte) {
        this.fonteRotulos = fonte;
        this.atualizar();
    }

    public Font getFonteValoresReferencia() {
        return this.fonteValoresReferencia;
    }

    public void setFonteValoresReferencia(Font fonte) {
        this.fonteValoresReferencia = fonte;
        this.atualizar();
    }

    public int getOrientacaoValores() {
        return this.orientacaoValores;
    }

    public void setOrientacaoValores(int orientacao) {
        this.orientacaoValores = orientacao;
        this.atualizar();
    }

    public int getOrientacaoValoresReferencia() {
        return this.orientacaoValoresReferencia;
    }

    public void setOrientacaoValoresReferencia(int orientacao) {
        if (orientacao == 0 || orientacao == 1) {
            this.orientacaoValoresReferencia = orientacao;
            this.atualizar();
        }
    }

    public void setValorMaximo(String valor) {
        if (valor != null && valor.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") || valor == null && this.getValorMaximoResultado()) {
            this.valorMaximoY = this.limpaCdata(valor);
            this.atualizar();
        }
    }

    public String getValorMaximo() {
        return this.limpaCdata(this.valorMaximoY);
    }

    public void setValorMaximoY(String valor) {
        this.setValorMaximo(valor);
    }

    public String getValorMaximoY() {
        return this.getValorMaximo();
    }

    public void setValorMaximoX(String valor) {
        if (valor != null && valor.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            this.valorMaximoX = valor;
            this.atualizar();
        } else {
            this.valorMaximoX = this.valorMaximoY;
        }
    }

    public String getValorMaximoX() {
        return this.valorMaximoX;
    }

    public void setLinhasEixoX(ArrayList<String> valor) {
        if (valor != null) {
            this.linhasEixoX.clear();
            for (String s : valor) {
                this.linhasEixoX.add(s);
            }
            this.atualizar();
        }
    }

    public void setLinhasEixoY(ArrayList<String> valor) {
        if (valor != null) {
            this.linhasEixoY.clear();
            for (String s : valor) {
                this.linhasEixoY.add(s);
            }
            this.atualizar();
        }
    }

    public ArrayList<String> getLinhasEixoX() {
        return this.linhasEixoX;
    }

    public ArrayList<String> getLinhasEixoY() {
        return this.linhasEixoY;
    }

    public void setIdentificarQuadrante(ArrayList<AtributosPosicaoQuadrante> o) {
        this.itensIdentificacaoQuadrante.clear();
        for (AtributosPosicaoQuadrante at : o) {
            this.itensIdentificacaoQuadrante.add(at);
        }
        this.atualizar();
    }

    public ArrayList<AtributosPosicaoQuadrante> getIdentificarQuadrante() {
        return this.itensIdentificacaoQuadrante;
    }

    public void setTipoDaLinha(Stroke tipo) {
        this.tipoLinha = tipo;
        this.atualizar();
    }

    public Stroke getTipoDaLinha() {
        return this.tipoLinha;
    }

    public void setTipoGrafico(int tipo) {
        if (tipo != this.tipoGrafico) {
            this.tipoGrafico = tipo;
            this.campos.clear();
            this.rotulos.clear();
            this.campoOrigem = "";
            this.campoValor = "";
            this.referencia = null;
            this.origemTipoCampo = false;
            this.expressaoEixoX = "";
            this.expressaoEixoY = "";
            this.expressaoAdicional = "";
            this.rotuloAdicional = "";
            this.multiplosCampos = false;
            this.campoValor = "";
            this.atualizar();
        }
    }

    public int getTipoGrafico() {
        return this.tipoGrafico;
    }

    public void setValoresDeReferencia(ValoresReferencia valores) {
        this.referencia = valores;
        if (valores != null && !valores.invalido()) {
            this.setValorMaximo(valores.getValores()[3]);
        }
        this.atualizar();
    }

    public ValoresReferencia getValoresDeReferencia() {
        return this.referencia;
    }

    public void setExibirValores(boolean exibir) {
        this.exibirValores = exibir;
        this.atualizar();
    }

    public void setValorMaximoResultado(boolean exibir) {
        this.valorMaximoResultado = exibir;
        this.atualizar();
    }

    public boolean getExibirValores() {
        return this.exibirValores;
    }

    public boolean getValorMaximoResultado() {
        return this.valorMaximoResultado;
    }

    public void setExibirLinhasReferencia(boolean exibir) {
        this.exibirLinhasReferencia = exibir;
        this.atualizar();
    }

    public boolean getExibirLinhasReferencia() {
        return this.exibirLinhasReferencia;
    }

    public void setExibirValoresReferencia(boolean exibir) {
        this.exibirValoresReferencia = exibir;
        this.atualizar();
    }

    public boolean getExibirValoresReferencia() {
        return this.exibirValoresReferencia;
    }

    public void setQuantidadeResultados(int quantidade) {
        this.qtdeResultados = quantidade;
        this.atualizar();
    }

    public int getQuantidadeResultados() {
        return this.qtdeResultados;
    }

    public void setExpressaoAdicional(String expressao) {
        this.expressaoAdicional = this.limpaCdata(expressao);
        this.atualizar();
    }

    public void setRotuloAdicional(String expressao) {
        this.rotuloAdicional = this.limpaCdata(expressao);
        this.atualizar();
    }

    public String getExpressaoAdicional() {
        return this.limpaCdata(this.expressaoAdicional);
    }

    public String getRotuloAdicional() {
        return this.rotuloAdicional;
    }

    public void setTipoRotulo(int tipo) {
        if (tipo != this.tipoRotulo) {
            this.tipoRotulo = tipo;
            this.atualizar();
        }
    }

    public int getTipoRotulo() {
        return this.tipoRotulo;
    }

    public void setOrigem(String origem) {
        this.campoOrigem = origem == null ? "" : origem;
        Componente comp = this.pag == null ? null : this.pag.getComponenteComNome(this.campoOrigem);
        boolean bl = this.origemTipoCampo = comp instanceof Campo || comp instanceof Expressao;
        if (comp instanceof Campo) {
            this.referencia = this.origemTipoCampo ? ((Campo)comp).getValoresDeReferencia() : null;
        } else if (comp instanceof Expressao) {
            ValoresReferencia valoresReferencia = this.referencia = this.origemTipoCampo ? ((Expressao)comp).getValoresDeReferencia() : null;
        }
        if (this.referencia != null && !this.referencia.invalido()) {
            this.setValorMaximo(this.referencia.getValores()[3]);
        }
        this.atualizar();
    }

    public String getOrigem() {
        return this.campoOrigem;
    }

    public void setCorDeFundo(Color cor) {
        this.setBackground(cor);
        this.atualizar();
    }

    public Color getCorDeFundo() {
        return this.getBackground();
    }

    public void setCorDosEixos(Color cor) {
        this.corEixos = cor;
        this.atualizar();
    }

    public Color getCorDaFonteValores() {
        return this.getCorDaFonte();
    }

    public void setCorDaFonteValores(Color cor) {
        this.setCorDaFonte(cor);
        this.atualizar();
    }

    public Color getCorDaFonteRotulos() {
        return this.corFonteRotulos;
    }

    public void setCorDaFonteRotulos(Color cor) {
        this.corFonteRotulos = cor;
        this.atualizar();
    }

    public Color getCorDosEixos() {
        return this.corEixos;
    }

    public void setIntervaloLinhas(String valor) {
        if (valor != null && valor.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            this.intervaloLinhasEixoY = this.converter(valor);
            this.atualizar();
        }
    }

    public String getIntervaloLinhas() {
        return String.valueOf(this.intervaloLinhasEixoY);
    }

    public String getExpressaoEixoX() {
        return this.expressaoEixoX;
    }

    public void setExpressaoEixoX(String expressaoEixoX) {
        this.expressaoEixoX = this.limpaCdata(expressaoEixoX);
        this.atualizar();
    }

    public String getExpressaoEixoY() {
        return this.limpaCdata(this.expressaoEixoY);
    }

    public void setExpressaoEixoY(String expressaoEixoY) {
        this.expressaoEixoY = expressaoEixoY;
        this.atualizar();
    }

    public void setIntervaloEixoY(int intervalo) {
        this.intervaloEixoY = intervalo == 0 ? 1 : intervalo;
        this.atualizar();
    }

    public void setIntervaloEixoX(int intervalo) {
        this.intervaloEixoX = intervalo == 0 ? 1 : intervalo;
        this.atualizar();
    }

    public int getIntervaloEixoY() {
        return this.intervaloEixoY;
    }

    public int getIntervaloEixoX() {
        return this.intervaloEixoX;
    }

    public String getCampoValor() {
        return this.limpaCdata(this.campoValor);
    }

    public void setCampoValor(String campoValor) {
        this.campoValor = this.limpaCdata(campoValor);
        this.atualizar();
    }

    public boolean getMultiplosCampos() {
        return this.multiplosCampos;
    }

    public void setMultiplosCampos(boolean multiplosCampos) {
        this.multiplosCampos = multiplosCampos;
        this.atualizar();
    }

    public void setRotulos(List<String> list) {
        if (list != null) {
            this.rotulos.clear();
            this.rotulos.addAll(list);
            this.atualizar();
        }
    }

    public List<String> getRotulos() {
        return new ArrayList<String>(this.rotulos);
    }

    public void setCampos(List<String> list) {
        if (list != null) {
            this.campos.clear();
            this.campos.addAll(list);
            if (this.rotulos.isEmpty()) {
                for (int i = 0; i < this.campos.size(); ++i) {
                    this.rotulos.add(String.valueOf((char)(97 + i)));
                }
            }
            this.atualizar();
        }
    }

    public List<String> getCampos() {
        return new ArrayList<String>(this.campos);
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        if (!edicao && this.salvoValor) {
            GraficoImpressao grafico = new GraficoImpressao();
            grafico.setDono(this);
            grafico.setBounds(this.getDimensoes());
            grafico.setValorResultado(this.getValorResultado());
            grafico.setQuantidade(this.tipoGrafico == 0 ? this.qtdeResultados : this.rotulos.size());
            grafico.setRetornoExpressaoEixoX(this.retornoExpressaoEixoX);
            grafico.setRetornoExpressaoEixoY(this.getRetornoExpressaoEixoY());
            grafico.setCondicao(this.getCondicao());
            return grafico;
        }
        if (this.tipoGrafico == 0) {
            GraficoResultadoAnteriorDigitacao grafico = new GraficoResultadoAnteriorDigitacao();
            grafico.setDono(this);
            grafico.setBounds(this.getDimensoes());
            grafico.setTagResultado(this.getTagResultado());
            grafico.setCondicao(this.getCondicao());
            return grafico;
        }
        if (this.tipoGrafico == 1) {
            GraficoConfiguravelDigitacao grafico = new GraficoConfiguravelDigitacao();
            grafico.setDono(this);
            grafico.setBounds(this.getDimensoes());
            grafico.setCondicao(this.getCondicao());
            return grafico;
        }
        if (this.tipoGrafico == 2) {
            GraficoReferenciaDigitacao grafico = new GraficoReferenciaDigitacao();
            grafico.setDono(this);
            grafico.setBounds(this.getDimensoes());
            grafico.setCondicao(this.getCondicao());
            grafico.setLinhasFixas(this.linhasFixas);
            return grafico;
        }
        if (this.tipoGrafico == 3) {
            GraficoQuadranteDigitacao grafico = new GraficoQuadranteDigitacao();
            grafico.setDono(this);
            grafico.setBounds(this.getDimensoes());
            grafico.setCondicao(this.getCondicao());
            return grafico;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.desenharGrafico(g2);
        if (this.tipoGrafico != 3) {
            this.desenharRotulos(g2);
        }
        this.desenharIntervaloLinhas(g2);
        if (this.tipoGrafico == 2) {
            for (String linha : this.linhasFixas) {
                Color cor = StringUtil.getColor(linha, "cor");
                String[] valores = StringUtil.getValores(linha, "valor");
                int tipoPonto = StringUtil.getInt(linha, "tipoponto");
                int tipoLinha = StringUtil.getInt(linha, "tipolinha");
                this.desenharLinhaFixa(g2, this.rotulos.size(), valores, cor, tipoPonto, tipoLinha);
            }
        }
        g2.setColor(Color.lightGray);
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public void desenharGrafico(Graphics2D g2) {
        int w = this.getWidth();
        int h = this.getHeight();
        int xVert = this.distanciaY;
        int yHorz = h - this.distanciaX;
        int dist = 10;
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.tipoGrafico == 0 && this.exibirLinhasReferencia && this.valorMaximoY.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && this.referencia != null && !this.referencia.invalido()) {
            int yTemp;
            int xTemp;
            g2.setFont(this.getFonteValoresReferencia());
            g2.setColor(this.corLinhaReferencia);
            FontMetrics fm = g2.getFontMetrics();
            String[] vls = this.referencia.getValores();
            int hMax = yHorz - dist;
            int y = (int)(this.converter(vls[1]) * (float)hMax / this.converter(this.valorMaximoY));
            g2.drawLine(this.distanciaY, yHorz - y, w - dist - 5, yHorz - y);
            if (this.exibirValoresReferencia) {
                xTemp = this.distanciaY - (this.orientacaoValoresReferencia == 0 ? fm.stringWidth(vls[1]) : fm.getDescent());
                yTemp = yHorz - y + (this.orientacaoValoresReferencia == 0 ? fm.getHeight() / 2 - fm.getDescent() : fm.stringWidth(vls[1]) / 2);
                this.desenharTexto(g2, vls[1], xTemp, yTemp, this.orientacaoValoresReferencia);
            }
            y = (int)(this.converter(vls[2]) * (float)hMax / this.converter(this.valorMaximoY));
            g2.drawLine(this.distanciaY, yHorz - y, w - dist - 5, yHorz - y);
            if (this.exibirValoresReferencia) {
                xTemp = this.distanciaY - (this.orientacaoValoresReferencia == 0 ? fm.stringWidth(vls[2]) : fm.getDescent());
                yTemp = yHorz - y + (this.orientacaoValoresReferencia == 0 ? fm.getHeight() / 2 - fm.getDescent() : fm.stringWidth(vls[2]) / 2);
                this.desenharTexto(g2, vls[2], xTemp, yTemp, this.orientacaoValoresReferencia);
            }
        } else if (this.tipoGrafico == 3 && this.valorMaximoY.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && this.valorMaximoX.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            int x;
            int yTemp;
            g2.setFont(this.getFonteValoresReferencia());
            g2.setColor(this.corFonteRotulos);
            FontMetrics fm = g2.getFontMetrics();
            int hMax = yHorz - dist;
            this.valorMaximoY = this.valorMaximoY.replace(",", ".");
            for (int i = 1; i < (int)(Double.parseDouble(this.valorMaximoY) / (double)(this.intervaloEixoY == 0 ? 1 : this.intervaloEixoY)) + 1; ++i) {
                String valor = String.valueOf(this.intervaloEixoY * i);
                int y = (int)(this.converter(valor) * (float)hMax / this.converter(this.valorMaximoY));
                int xTemp = this.distanciaY - fm.stringWidth(valor) - 1;
                yTemp = yHorz - y + (this.orientacaoValoresReferencia == 0 ? fm.getHeight() / 2 - fm.getDescent() : fm.stringWidth(valor) / 2);
                this.desenharTexto(g2, valor, xTemp, yTemp, 0);
            }
            this.valorMaximoX = this.valorMaximoX.replace(",", ".");
            int xTemp = this.distanciaY;
            for (int i = 1; i < (int)(Double.parseDouble(this.valorMaximoX) / (double)(this.intervaloEixoX == 0 ? 1 : this.intervaloEixoX)) + 1; ++i) {
                String valor = String.valueOf(this.intervaloEixoX * i);
                x = (int)(this.converter(valor) * (float)(w - this.distanciaY) / this.converter(this.valorMaximoX));
                yTemp = h - (fm.getAscent() - fm.getDescent());
                this.desenharTexto(g2, valor, x, yTemp, 0);
            }
            g2.setColor(this.corLinha);
            for (String s : this.linhasEixoX) {
                x = (int)(this.converter(s) * (float)(w - this.distanciaY) / this.converter(this.valorMaximoX));
                g2.drawLine(x + 5, dist, x + 5, h - this.distanciaX);
            }
            for (String s : this.linhasEixoY) {
                int y = (int)(this.converter(s) * (float)hMax / this.converter(this.valorMaximoY));
                g2.drawLine(this.distanciaY, yHorz - y + 2, w - dist, yHorz - y + 2);
            }
            if (this.atributoHachuradoQuadrante != null && (this.atributoHachuradoQuadrante.getPosicaoXInicial() > 0.0 || this.atributoHachuradoQuadrante.getPosicaoXFinal() > 0.0 || this.atributoHachuradoQuadrante.getPosicaoYInicial() > 0.0 || this.atributoHachuradoQuadrante.getPosicaoYFinal() > 0.0)) {
                int xInicial = (int)(this.atributoHachuradoQuadrante.getPosicaoXInicial() * (double)(w - this.distanciaY) / (double)this.converter(this.valorMaximoX)) + 5;
                int yInicial = yHorz - (int)(this.atributoHachuradoQuadrante.getPosicaoYInicial() * (double)hMax / (double)this.converter(this.valorMaximoY)) + 2;
                int xFinal = (int)(this.atributoHachuradoQuadrante.getPosicaoXFinal() * (double)(w - this.distanciaY) / (double)this.converter(this.valorMaximoX)) + 5;
                int yFinal = yHorz - (int)(this.atributoHachuradoQuadrante.getPosicaoYFinal() * (double)hMax / (double)this.converter(this.valorMaximoY)) + 2;
                g2.setColor(this.atributoHachuradoQuadrante.getCor());
                g2.fillRect(xInicial, yInicial, xFinal - xInicial, yFinal - yInicial);
            }
            for (AtributosPosicaoQuadrante at : this.itensIdentificacaoQuadrante) {
                int posX = (int)(at.getPosicaoX() * (double)(w - this.distanciaY) / (double)this.converter(this.valorMaximoX)) + 5;
                int posY = yHorz - (int)(at.getPosicaoY() * (double)hMax / (double)this.converter(this.valorMaximoY)) + 2;
                g2.setFont(this.getFonteRotulos());
                g2.setColor(this.getCorDaFonteRotulos());
                g2.drawString(at.getIdentificacao(), posX, posY);
            }
        }
        g2.setColor(this.corEixos);
        g2.drawLine(xVert, dist, xVert, h - this.distanciaX + dist);
        g2.drawLine(this.distanciaY - dist, yHorz, w - dist, yHorz);
        g2.fillPolygon(new int[]{xVert, xVert + 3, xVert - 3, xVert}, new int[]{dist - 1, dist + 6, dist + 6, dist - 1}, 4);
        g2.fillPolygon(new int[]{w - dist + 1, w - dist - 5, w - dist - 5, w - dist + 1}, new int[]{yHorz, yHorz + 3, yHorz - 3, yHorz}, 4);
    }

    public void desenharIntervaloLinhas(Graphics2D g2) {
        int xVert = this.distanciaY;
        int dist = 10;
        g2.setFont(this.getFonteValores());
        int w = this.getWidth();
        int h = this.getHeight();
        int yHorz = h - this.distanciaX;
        int hMax = yHorz - 10;
        if (this.intervaloLinhasEixoY > 0.0 && (double)this.converter(this.valorMaximoY) / this.intervaloLinhasEixoY > 0.0) {
            float contador = 0.0f;
            while (true) {
                float f;
                contador = (float)((double)contador + this.intervaloLinhasEixoY);
                if (!(f < this.converter(this.valorMaximoY))) break;
                int posY = yHorz - (int)(contador * (float)hMax / this.converter(this.valorMaximoY));
                if (posY >= yHorz) continue;
                g2.setColor(Color.lightGray);
                g2.drawLine(xVert + 1, posY, w - dist, posY);
                g2.setFont(this.getFonteRotulos());
                g2.setColor(this.getCorDaFonteRotulos());
                g2.drawString(String.valueOf(contador), xVert - (this.distanciaY - 1), posY);
            }
        }
    }

    public void desenharValores(Graphics2D g2, int qtde, String[] valores, Integer pontoFaixa) {
        this.desenharValores(g2, qtde, valores, pontoFaixa, null, null);
    }

    public void desenharValores(Graphics2D g2, int qtde, String[] valores, Integer pontoFaixa, Double pontoEixoXQuadrante, Double pontoEixoYQuadrante) {
        if (g2 != null && this.valorMaximoY.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            int dif;
            g2.setFont(this.getFonteValores());
            g2.setStroke(new BasicStroke());
            FontMetrics fm = g2.getFontMetrics();
            ArrayList<int[]> pontos = new ArrayList<int[]>();
            int w = this.getWidth();
            int h = this.getHeight();
            int yHorz = h - this.distanciaX;
            int hMax = yHorz - 10;
            float dist = (float)(w - this.distanciaY - 10 - this.distanciaRotulo * 2) / (float)(qtde - 1);
            if (this.tipoGrafico == 3 && pontoEixoXQuadrante != null && pontoEixoYQuadrante != null && this.converter(this.valorMaximoX) > 0.0f && this.converter(this.valorMaximoY) > 0.0f) {
                int posicaoX = (int)(pontoEixoXQuadrante * (double)(w - this.distanciaY) / (double)this.converter(this.valorMaximoX)) + 5;
                int posicaoY = yHorz - (int)(pontoEixoYQuadrante * (double)hMax / (double)this.converter(this.valorMaximoY));
                g2.setColor(this.corPonto);
                dif = this.tamanhoPonto / 2;
                g2.fillOval(posicaoX - dif, posicaoY - dif, this.tamanhoPonto, this.tamanhoPonto);
                g2.setColor(this.corPonto);
                g2.drawOval(posicaoX - dif, posicaoY - dif, this.tamanhoPonto, this.tamanhoPonto);
            } else if (pontoFaixa != null && qtde > 0 && valores != null && valores.length > 0 && valores.length <= qtde && valores.length == 1) {
                int posicaoRotulo = -1;
                for (int i = 0; i < this.rotulos.size(); ++i) {
                    String xml = this.rotulos.get(i);
                    if (xml.indexOf("<rotuloreferencia>") <= -1) continue;
                    int x = this.distanciaY + this.distanciaRotulo;
                    int valorInicial = StringUtil.getInt(xml, "inicial");
                    int valorFinal = StringUtil.getInt(xml, "final");
                    if (pontoFaixa.compareTo(new Integer(valorInicial)) < 0 || pontoFaixa.compareTo(new Integer(valorFinal)) > 0) continue;
                    int y = (int)(this.converter(valores[0]) * (float)hMax / this.converter(this.valorMaximoY));
                    x = i == 0 ? x : (int)((float)x + dist * (float)i);
                    pontos.add(new int[]{x, yHorz - y});
                    if (!this.exibirValores) break;
                    String tmp = valores[0].matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && this.getMascaraValor().trim().length() > 0 ? Funcoes.formataDecimal(this.inverterMascara(this.getMascaraValor()), Double.parseDouble(Funcoes.limpaDecimal(valores[0]))) : valores[0];
                    y = yHorz - y - fm.getDescent() - this.distanciaEntreLinhas;
                    int n = this.orientacaoValores == 0 ? -fm.stringWidth(tmp) / 2 : fm.getHeight() / 2 - fm.getDescent();
                    g2.setColor(this.getCorDaFonteValores());
                    this.desenharTexto(g2, tmp, x += n, y, this.orientacaoValores, this.getBackground());
                    break;
                }
            } else if (valores != null) {
                for (int i = 0; i < valores.length; ++i) {
                    int posY;
                    int x = this.distanciaY + this.distanciaRotulo;
                    int y = (int)(this.converter(GraficoResultadoAnteriorDigitacao.tratarMaiorMenorResultadoAnterior(valores[i], this.getMascaraValor())) * (float)hMax / this.converter(this.valorMaximoY));
                    x = i == 0 ? x : (int)((float)x + dist * (float)i);
                    pontos.add(new int[]{x, yHorz - y});
                    if (i > 0) {
                        int[] ini = (int[])pontos.get(i - 1);
                        g2.setColor(this.corLinha);
                        g2.drawLine(ini[0], ini[1], x, yHorz - y);
                    }
                    if (y > (posY = this.getHeight() - 40)) {
                        int w2 = this.getWidth();
                        float dist2 = (float)(w2 - this.distanciaY - 10 - this.distanciaRotulo * 2) / (float)(qtde - 1);
                        y = dist2 > (float)posY ? posY : (int)dist2;
                    }
                    if (!this.exibirValores) continue;
                    String tmp = valores[i].matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && this.getMascaraValor().trim().length() > 0 ? Funcoes.formataDecimal(this.inverterMascara(this.getMascaraValor()), Double.parseDouble(Funcoes.limpaDecimal(valores[i]))) : valores[i];
                    y = yHorz - y - fm.getDescent() - this.distanciaEntreLinhas;
                    int n = this.orientacaoValores == 0 ? -fm.stringWidth(tmp) / 2 : fm.getHeight() / 2 - fm.getDescent();
                    g2.setColor(this.getCorDaFonteValores());
                    this.desenharTexto(g2, tmp, x += n, y, this.orientacaoValores, this.getBackground());
                }
            }
            for (int[] ponto : pontos) {
                g2.setColor(this.corPonto);
                dif = this.tamanhoPonto / 2;
                g2.fillOval(ponto[0] - dif, ponto[1] - dif, this.tamanhoPonto, this.tamanhoPonto);
                g2.setColor(this.corPonto);
                g2.drawOval(ponto[0] - dif, ponto[1] - dif, this.tamanhoPonto, this.tamanhoPonto);
            }
        }
    }

    public void desenhaLinhaFixa(Graphics2D g2) {
        for (String linha : this.linhasFixas) {
            Color cor = StringUtil.getColor(linha, "cor");
            String[] valores = StringUtil.getValores(linha, "valor");
            int tipoPonto = StringUtil.getInt(linha, "tipoponto");
            int tipoLinha = StringUtil.getInt(linha, "tipolinha");
            this.desenharLinhaFixa(g2, this.rotulos.size(), valores, cor, tipoPonto, tipoLinha);
        }
    }

    public void desenharLinhaFixa(Graphics2D g2, int qtde, String[] valores, Color cor, int tipoPonto, int tipoLinha) {
        if (g2 != null && qtde > 0 && valores != null && valores.length > 0 && valores.length <= qtde && this.valorMaximoY.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            g2.setFont(this.getFonteValores());
            FontMetrics fm = g2.getFontMetrics();
            ArrayList<int[]> pontos = new ArrayList<int[]>();
            int w = this.getWidth();
            int h = this.getHeight();
            int yHorz = h - this.distanciaX;
            int hMax = yHorz - 10;
            float dist = (float)(w - this.distanciaY - 10 - this.distanciaRotulo * 2) / (float)(qtde - 1);
            for (int i = 0; i < valores.length; ++i) {
                int x = this.distanciaY + this.distanciaRotulo;
                int y = (int)(this.converter(valores[i]) * (float)hMax / this.converter(this.valorMaximoY));
                x = i == 0 ? x : (int)((float)x + dist * (float)i);
                pontos.add(new int[]{x, yHorz - y});
                if (i > 0) {
                    float[] dash;
                    int[] ini = (int[])pontos.get(i - 1);
                    g2.setColor(cor);
                    Stroke originalStroke = g2.getStroke();
                    if (tipoLinha == 2) {
                        dash = new float[]{10.0f};
                        g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
                    } else if (tipoLinha == 3) {
                        dash = new float[]{3.0f};
                        g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
                    } else {
                        g2.setStroke(originalStroke);
                    }
                    g2.drawLine(ini[0], ini[1], x, yHorz - y);
                }
                if (!this.exibirValores) continue;
                String tmp = valores[i].matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && this.getMascaraValor().trim().length() > 0 ? Funcoes.formataDecimal(this.inverterMascara(this.getMascaraValor()), Double.parseDouble(Funcoes.limpaDecimal(valores[i]))) : valores[i];
                y = yHorz - y - fm.getDescent() - this.distanciaEntreLinhas;
                int n = this.orientacaoValores == 0 ? -fm.stringWidth(tmp) / 2 : fm.getHeight() / 2 - fm.getDescent();
                g2.setColor(this.getCorDaFonteValores());
                this.desenharTexto(g2, tmp, x += n, y, this.orientacaoValores, this.getBackground());
            }
            for (int[] ponto : pontos) {
                g2.setColor(cor);
                int dif = 2;
                if (tipoPonto == 2) {
                    g2.fillOval(ponto[0] - dif, ponto[1] - dif, 4, 4);
                    g2.drawOval(ponto[0] - dif, ponto[1] - dif, 4, 4);
                    continue;
                }
                if (tipoPonto == 3) {
                    g2.fillPolygon(new int[]{ponto[0] - dif, ponto[0] - dif + 2, ponto[0] - dif + 4}, new int[]{ponto[1] - dif + 4, ponto[1] - dif - 4, ponto[1] - dif + 4}, 3);
                    g2.drawPolygon(new int[]{ponto[0] - dif, ponto[0] - dif + 2, ponto[0] - dif + 4}, new int[]{ponto[1] - dif + 4, ponto[1] - dif - 4, ponto[1] - dif + 4}, 3);
                    continue;
                }
                g2.fillRect(ponto[0] - dif, ponto[1] - dif, 4, 4);
                g2.drawRect(ponto[0] - dif, ponto[1] - dif, 4, 4);
            }
        }
    }

    private String inverterMascara(String mascara) {
        String retorno = "";
        StringBuilder b = new StringBuilder();
        char[] c = mascara.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '.') {
                b.append(",");
                continue;
            }
            if (c[i] == ',') {
                b.append(".");
                continue;
            }
            b.append(c[i]);
        }
        retorno = b.length() != 0 && b.indexOf(".") > -1 ? b.substring(0, b.indexOf(".") - 1) + "0." + Funcoes.preencheZero(0, b.length() - (b.indexOf(".") + 1)) : b.toString();
        return retorno;
    }

    public void desenharRotulos(Graphics2D g2, int qtde, String[] rot1, String[] rot2) {
        if (g2 != null && rot1 != null && rot1.length > 0 && (rot2 == null || rot2.length == 0 || rot1.length == rot2.length)) {
            g2.setFont(this.getFonteRotulos());
            FontMetrics fm = g2.getFontMetrics();
            int w = this.getWidth();
            int h = this.getHeight();
            float dist = (float)(w - this.distanciaY - 10 - this.distanciaRotulo * 2) / (float)(qtde - 1);
            for (int i = 0; i < rot1.length; ++i) {
                int x = this.distanciaY + this.distanciaRotulo;
                x = i == 0 ? x : (int)((float)x + dist * (float)i);
                g2.setColor(this.corEixos);
                g2.drawLine(x, h - this.distanciaX - 2, x, h - this.distanciaX + 2);
                int xRot = x - fm.stringWidth(rot1[i]) / 2;
                int yRot = h + fm.getAscent() - this.distanciaX + this.distanciaEntreLinhas;
                g2.setColor(this.getCorDaFonteRotulos());
                g2.drawString(rot1[i], xRot, yRot);
                if (rot2 == null || rot2.length != rot1.length) continue;
                xRot = x - fm.stringWidth(rot2[i]) / 2;
                g2.drawString(rot2[i], xRot, yRot += fm.getAscent() - fm.getDescent() + this.distanciaEntreLinhas);
            }
        }
    }

    private void desenharRotulos(Graphics2D g2) {
        String[] rot1 = null;
        String[] rot2 = null;
        if (this.tipoGrafico == 1 && this.rotulos.size() > 1) {
            rot1 = this.rotulos.toArray(new String[this.rotulos.size()]);
        } else if (this.tipoGrafico == 0) {
            String rotulo1;
            String string = rotulo1 = this.tipoRotulo == 0 || this.tipoRotulo == 2 ? "00/00/0000" : "00:00";
            String rotulo2 = this.tipoRotulo == 2 ? "00:00" : (this.tipoRotulo == 3 ? "00/00/0000" : null);
            rot1 = new String[this.qtdeResultados];
            if (rotulo2 != null) {
                rot2 = new String[this.qtdeResultados];
            }
            for (int i = 0; i < rot1.length; ++i) {
                rot1[i] = rotulo1;
                if (rot2 == null) continue;
                rot2[i] = rotulo2;
            }
        } else if (this.tipoGrafico == 2 && this.rotulos.size() > 0) {
            rot1 = new String[this.rotulos.size()];
            int indice = 0;
            for (String xml : this.rotulos) {
                rot1[indice++] = StringUtil.getValor(xml, "titulo");
            }
        }
        if (rot1 != null) {
            this.desenharRotulos(g2, rot1.length, rot1, rot2);
        }
    }

    private void desenharTexto(Graphics2D g2, String texto, int x, int y, int orientacao) {
        this.desenharTexto(g2, texto, x, y, orientacao, null);
    }

    private void desenharTexto(Graphics2D g2, String texto, int x, int y, int orientacao, Color background) {
        g2.translate(x, y);
        if (orientacao == 1 || orientacao == 2) {
            g2.rotate(-Math.PI / (orientacao == 1 ? 2.0 : 4.0));
        }
        if (background != null) {
            Color tmp = g2.getColor();
            FontMetrics fm = g2.getFontMetrics();
            g2.setColor(background);
            g2.fillRect(0, -fm.getHeight() + fm.getDescent(), fm.stringWidth(texto), fm.getHeight());
            g2.setColor(tmp);
        }
        g2.drawString(texto, 0, 0);
        if (orientacao == 1 || orientacao == 2) {
            g2.rotate(Math.PI / (orientacao == 1 ? 2.0 : 4.0));
        }
        g2.translate(-x, -y);
    }

    private Stroke stringParaLinha(String linha) {
        if (Constantes.TRACEJADO.toString().equalsIgnoreCase(linha)) {
            return Constantes.TRACEJADO;
        }
        if (Constantes.PONTILHADO.toString().equalsIgnoreCase(linha)) {
            return Constantes.PONTILHADO;
        }
        return Constantes.SOLIDO;
    }

    private float converter(String valor) {
        try {
            return Float.parseFloat(StringUtil.strDecimal(valor.trim()));
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public String getMascaraValor() {
        return this.limpaCdata(this.mascaraValor);
    }

    public void setMascaraValor(String mascaraValor) {
        this.mascaraValor = this.limpaCdata(mascaraValor);
    }

    public int getTamanhoPonto() {
        return this.tamanhoPonto;
    }

    public void setTamanhoPonto(int tamanhoPonto) {
        this.tamanhoPonto = tamanhoPonto;
    }

    public Color getCorPonto() {
        return this.corPonto;
    }

    public void setCorPonto(Color corPonto) {
        this.corPonto = corPonto;
    }

    public List<String> getLinhasFixas() {
        return new ArrayList<String>(this.linhasFixas);
    }

    public void setLinhasFixas(List<String> linhasFixas) {
        if (linhasFixas != null) {
            this.linhasFixas.clear();
            this.linhasFixas.addAll(linhasFixas);
            this.atualizar();
        }
    }

    public void setRetornoExpressaoEixoX(String valor) {
        this.retornoExpressaoEixoX = this.limpaCdata(valor);
    }

    public void setRetornoExpressaoEixoY(String valor) {
        this.retornoExpressaoEixoY = this.limpaCdata(valor);
    }

    public String getRetornoExpressaoEixoX() {
        return this.limpaCdata(this.retornoExpressaoEixoX);
    }

    public String getRetornoExpressaoEixoY() {
        return this.limpaCdata(this.retornoExpressaoEixoY);
    }

    @Override
    public void setTagResultado(String tag) {
        this.tagSelecionada = tag;
    }

    @Override
    public String getTagResultado() {
        return this.limpaCdata(this.tagSelecionada);
    }

    @Override
    @Deprecated
    public boolean isConferenciaAutomatica() {
        return false;
    }

    @Override
    @Deprecated
    public ValoresPercentualDeltaCheck getPercentualDeVariacao() {
        return null;
    }

    @Override
    @Deprecated
    public String getTipoConferenciaAutomatica() {
        return null;
    }

    @Override
    public void atualizaComboTagResultado() {
        if (this.pag.getGerenciador() != null) {
            this.pag.getGerenciador().dadosAlterados(null);
        }
    }

    @Override
    @Deprecated
    public void setConferenciaAutomatica(String validacao) {
    }

    @Override
    @Deprecated
    public String getConferenciaAutomatica() {
        return null;
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

