/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorCondicao;
import jalis.laboratorio.configurador.propriedade.EditorForma;
import jalis.laboratorio.configurador.propriedade.EditorInt;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.impressao.componente.FormaImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Map;

public class Forma
extends AbstractComponente {
    public static final int RETANGULO = 0;
    public static final int ELIPSE = 1;
    public static final int LINHA_HORIZONTAL = 2;
    public static final int LINHA_VERTICAL = 3;
    public static final int TRIANGULO_ACIMA = 4;
    public static final int TRIANGULO_DIREITA = 5;
    public static final int TRIANGULO_ABAIXO = 6;
    public static final int TRIANGULO_ESQUERDA = 7;
    private int forma = 0;
    private int espessura = 1;
    private Color corLinha = Color.black;
    private Color corPreenchimento = Color.white;
    private String condicao = "";
    private int arredondada = 0;

    public Forma() {
        this.setTamanho(new Dimension(75, 75));
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        FormaImpressao forma = new FormaImpressao();
        forma.setDono(this);
        forma.setName(this.getNome());
        forma.setDimensoes(this.getDimensoes());
        forma.setForma(this.getForma());
        forma.setCorLinha(this.getCorDaLinha());
        forma.setCorPreenchimento(this.getCorDePreenchimento());
        forma.setEspessura(this.getEspessura());
        forma.setImprimir(this.getImprimir());
        forma.setCondicao(this.getCondicao());
        forma.setArredondada(this.getArredondada());
        return forma;
    }

    @Override
    public String getNomeBase() {
        return "Forma";
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade("cor da linha", EditorColor.class));
            list.add(new Propriedade("cor de preenchimento", EditorColor.class));
            list.add(new Propriedade("forma", EditorForma.class));
            list.add(new Propriedade("espessura", EditorInt.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            list.add(new Propriedade("condi\u00e7\u00e3o", EditorCondicao.class));
            if (this.forma == 0) {
                list.add(new Propriedade("arredondada", EditorInt.class));
            }
        }
        return list;
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("corDaLinha", String.valueOf(this.corLinha.getRGB())));
        bui.append(StringUtil.getTag("corDePreenchimento", String.valueOf(this.corPreenchimento.getRGB())));
        bui.append(StringUtil.getTag("forma", String.valueOf(this.getForma())));
        bui.append(StringUtil.getTag("espessura", String.valueOf(this.espessura)));
        bui.append(StringUtil.getTag("arredondada", String.valueOf(this.arredondada)));
        bui.append(StringUtil.getTag("condicao", "<![CDATA[" + this.getCondicao() + "]]>"));
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setCorDaLinha(StringUtil.getColor(atr, "corDaLinha"));
        this.setCorDePreenchimento(StringUtil.getColor(atr, "corDePreenchimento"));
        this.setForma(StringUtil.getInt(atr, "forma"));
        this.setEspessura(StringUtil.getInt(atr, "espessura"));
        this.setCondicao(StringUtil.getValor(atr, "condicao"));
        if (StringUtil.getValor(atr, "arredondada") != null) {
            this.setArredondada(StringUtil.getInt(atr, "arredondada"));
        }
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Forma) {
            Forma f = (Forma)comp;
            this.setCorDaLinha(f.getCorDaLinha());
            this.setCorDePreenchimento(f.getCorDePreenchimento());
            this.setForma(f.getForma());
            this.setEspessura(f.getEspessura());
            this.setCondicao(f.getCondicao());
            this.setArredondada(f.getArredondada());
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setCorDaLinha(StringUtil.getColor(xml, "corDaLinha"));
        this.setCorDePreenchimento(StringUtil.getColor(xml, "corDePreenchimento"));
        this.setForma(StringUtil.getInt(xml, "forma"));
        this.setEspessura(StringUtil.getInt(xml, "espessura"));
        this.setArredondada(StringUtil.getInt(xml, "arredondada"));
        this.setCondicao(StringUtil.getValor(xml, "expressao"));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    public String getCondicao() {
        return this.condicao;
    }

    public void setCondicao(String condicao) {
        this.condicao = condicao;
    }

    public Color getCorDaLinha() {
        return this.corLinha;
    }

    public void setCorDaLinha(Color cor) {
        this.corLinha = cor;
        this.atualizar();
    }

    public Color getCorDePreenchimento() {
        return this.corPreenchimento;
    }

    public void setCorDePreenchimento(Color cor) {
        this.corPreenchimento = cor;
        this.atualizar();
    }

    public int getForma() {
        return this.forma;
    }

    public void setForma(int forma) {
        this.forma = forma;
        this.atualizar();
    }

    public int getEspessura() {
        return this.espessura;
    }

    public void setEspessura(int espessura) {
        this.espessura = espessura;
        this.atualizar();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.corPreenchimento);
        switch (this.forma) {
            case 0: {
                g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arredondada, this.arredondada);
                break;
            }
            case 1: {
                g2.fillOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                break;
            }
            case 4: {
                g2.fillPolygon(new int[]{1, this.getWidth() / 2, this.getWidth() - 1}, new int[]{this.getHeight() - 1, 1, this.getHeight() - 1}, 3);
                break;
            }
            case 5: {
                g2.fillPolygon(new int[]{1, this.getWidth() - 1, 1}, new int[]{1, this.getHeight() / 2, this.getHeight() - 1}, 3);
                break;
            }
            case 6: {
                g2.fillPolygon(new int[]{1, this.getWidth() / 2, this.getWidth() - 1}, new int[]{1, this.getHeight() - 1, 1}, 3);
                break;
            }
            case 7: {
                g2.fillPolygon(new int[]{this.getWidth() - 1, 1, this.getWidth() - 1}, new int[]{1, this.getHeight() / 2, this.getHeight() - 1}, 3);
            }
        }
        g2.setColor(this.corLinha);
        g2.setStroke(new BasicStroke(this.espessura));
        switch (this.forma) {
            case 0: {
                g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arredondada, this.arredondada);
                break;
            }
            case 1: {
                g2.drawOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                break;
            }
            case 2: {
                g2.drawLine(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2);
                break;
            }
            case 3: {
                g2.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight() - 1);
                break;
            }
            case 4: {
                g2.drawPolygon(new int[]{1, this.getWidth() / 2, this.getWidth() - 1}, new int[]{this.getHeight() - 1, 1, this.getHeight() - 1}, 3);
                break;
            }
            case 5: {
                g2.drawPolygon(new int[]{1, this.getWidth() - 1, 1}, new int[]{1, this.getHeight() / 2, this.getHeight() - 1}, 3);
                break;
            }
            case 6: {
                g2.drawPolygon(new int[]{1, this.getWidth() / 2, this.getWidth() - 1}, new int[]{1, this.getHeight() - 1, 1}, 3);
                break;
            }
            case 7: {
                g2.drawPolygon(new int[]{this.getWidth() - 1, 1, this.getWidth() - 1}, new int[]{1, this.getHeight() / 2, this.getHeight() - 1}, 3);
            }
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }

    public void setArredondada(int arredondada) {
        this.arredondada = arredondada;
        this.atualizar();
    }

    public int getArredondada() {
        return this.arredondada;
    }
}

