/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Dados;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontal;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorCampoExterno;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorConferenciaAutomatica;
import jalis.laboratorio.configurador.propriedade.EditorFont;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorPercentual;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.ExternoDigitacao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import java.util.Map;

public class Externo
extends AbstractComponente
implements Digitavel,
ComponenteEditor {
    private String campoExterno = "";
    private int alinHor = 2;
    private String tagSelecionada = null;
    private String conferenciaAutomaticaResultado = "n\u00e3o";
    private ValoresPercentualDeltaCheck percentualDeVariacao;

    public Externo() {
        this.setTamanho(new Dimension(75, 25));
    }

    @Override
    public String getNomeBase() {
        return "Externo";
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> props = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            props.add(new Propriedade("cor da fonte", EditorColor.class));
            props.add(new Propriedade("cor de fundo", EditorColor.class));
            props.add(new Propriedade("fonte", EditorFont.class));
            props.add(new Propriedade("resultado anterior", EditorBoolean.class));
            if (this.getResultadoAnterior()) {
                props.add(new Propriedade(EditorTag.getDescricaoTag(), EditorTag.class));
            }
            if (!this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("Desativada")) {
                props.add(new Propriedade(EditorConferenciaAutomatica.getDescricao(), EditorConferenciaAutomatica.class));
            }
            if (this.isConferenciaAutomatica() && this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("Valores normais e m\u00e9dia") || this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("M\u00e9dia")) {
                props.add(new Propriedade("percentual de varia\u00e7\u00e3o", EditorPercentual.class));
            }
            props.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
            props.add(new Propriedade("remover vazio", EditorBoolean.class));
            props.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
            props.add(new Propriedade("opaco", EditorBoolean.class));
            props.add(new Propriedade("imprimir", EditorBoolean.class));
            props.add(new Propriedade("campoExterno", EditorCampoExterno.class));
        }
        return props;
    }

    @Override
    public String getAtributos() {
        StringBuffer str = new StringBuffer(super.getAtributos());
        str.append(StringUtil.getTag("corDaFonte", String.valueOf(this.getCorDaFonte().getRGB())));
        str.append(StringUtil.getTag("corDeFundo", String.valueOf(this.getCorDeFundo().getRGB())));
        str.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(this.getFonte())));
        str.append(StringUtil.getTag("campoExterno", this.getCampoExterno()));
        str.append(StringUtil.getTag("opaco", String.valueOf(this.getOpaco())));
        str.append(StringUtil.getTag("conferenciaResultadoAutomatico", this.getConferenciaAutomatica()));
        if (this.percentualDeVariacao != null) {
            str.append(StringUtil.getTag("percentualVariacao", this.percentualDeVariacao.toString()));
        }
        if (this.getResultadoAnterior()) {
            str.append(StringUtil.getTag("tagResultado", this.getTagResultado()));
        }
        return str.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
        this.setCorDeFundo(StringUtil.getColor(atr, "corDeFundo"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(atr, "fonte")));
        this.setCampoExterno(StringUtil.getValor(atr, "campoExterno"));
        this.setOpaco(StringUtil.getBoolean(atr, "opaco"));
        this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
        this.setConferenciaAutomatica(StringUtil.getValor(atr, "conferenciaResultadoAutomatico"));
        if (this.percentualDeVariacao == null) {
            this.percentualDeVariacao = new ValoresPercentualDeltaCheck();
        }
        this.percentualDeVariacao.setPercentualVariacao(StringUtil.getValor(atr, "percentualVariacao").replace(".", "").replace(",", "."));
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Dados) {
            Externo e = (Externo)comp;
            this.setCampoExterno(e.getCampoExterno());
            this.setOpaco(e.getOpaco());
            this.setCorDeFundo(e.getCorDeFundo());
            this.setCorDaFonte(e.getCorDaFonte());
            this.setFonte(e.getFonte());
            ValoresPercentualDeltaCheck valDeltaCheck = e.getPercentualDeVariacao();
            if (valDeltaCheck != null) {
                this.setPercentualDeVariacao((ValoresPercentualDeltaCheck)valDeltaCheck.clone());
            }
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setCorDeFundo(StringUtil.getColor(xml, "corDeFundo"));
        this.setCorDaFonte(StringUtil.getColor(xml, "corDaFonte"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(xml, "fonte")));
        this.setCampoExterno(StringUtil.getValor(xml, "campoExterno"));
        this.setOpaco(StringUtil.getBoolean(xml, "opaco"));
        if (this.percentualDeVariacao == null) {
            this.percentualDeVariacao = new ValoresPercentualDeltaCheck();
        }
        this.percentualDeVariacao.setPercentualVariacao(StringUtil.getValor(xml, "percentualVariacao").replace(".", "").replace(",", "."));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinHor = alinhamento;
        this.atualizar();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alinHor;
    }

    public boolean getOpaco() {
        return this.isOpaque();
    }

    public void setOpaco(boolean opaco) {
        this.setOpaque(opaco);
        this.atualizar();
    }

    public void setCampoExterno(String campo) {
        if (campo != null) {
            this.campoExterno = campo;
            this.atualizar();
        }
    }

    public String getCampoExterno() {
        return this.campoExterno;
    }

    public void setCorDeFundo(Color cor) {
        this.setBackground(cor);
        this.atualizar();
    }

    public Color getCorDeFundo() {
        return this.getBackground();
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        if (!edicao && this.salvoValor) {
            TextoEstatico texto = new TextoEstatico();
            texto.setDono(this);
            texto.setName(this.getNome());
            texto.setFont(this.getFont());
            texto.setDimensoes(this.getDimensoes());
            texto.setText(this.getValorResultado());
            texto.setValor(StringUtil.getValorString(StringUtil.strDecimal(this.getValorResultado())));
            texto.setOpaque(this.getOpaco());
            texto.setForeground(this.getForeground());
            texto.setBackground(this.getBackground());
            texto.setHorizontalAlignment(this.getAlinhamentoHorizontal());
            texto.setImprimir(this.getImprimir());
            return texto;
        }
        ExternoDigitacao ed = new ExternoDigitacao();
        ed.setDono(this);
        ed.setName(this.getNome());
        ed.setBounds(this.getDimensoes());
        ed.setOpaque(this.getOpaco());
        ed.setBackground(this.getCorDeFundo());
        ed.setForeground(this.getCorDaFonte());
        ed.setFont(this.getFonte());
        ed.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
        return ed;
    }

    @Override
    public void paint(Graphics g) {
        String str;
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(this.getForeground());
        FontMetrics met = g.getFontMetrics();
        int h = met.getHeight();
        String string = str = this.campoExterno.length() > 0 ? this.campoExterno : this.getNome();
        int x = this.alinHor == 2 ? 3 : (this.alinHor == 4 ? this.getWidth() - met.stringWidth(str) - 3 : (this.getWidth() - met.stringWidth(str)) / 2);
        g.drawString(str, x, this.getHeight() / 2 + h / 2 - 2);
        g.setColor(Color.gray);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    public void setTagResultado(String tag) {
        if (!Funcoes.textoVazio(this.tagSelecionada) && this.pag != null) {
            this.pag.removeTagEmUso(this.tagSelecionada);
        }
        this.tagSelecionada = tag;
        if (this.pag != null) {
            this.pag.adicionaTagEmUso(tag, this);
        }
    }

    @Override
    public ValoresPercentualDeltaCheck getPercentualDeVariacao() {
        return this.percentualDeVariacao;
    }

    public void setPercentualDeVariacao(ValoresPercentualDeltaCheck percentualVariacao) {
        this.percentualDeVariacao = percentualVariacao;
    }

    @Override
    public String getTagResultado() {
        return this.tagSelecionada;
    }

    @Override
    public void setConferenciaAutomatica(String validacao) {
        this.conferenciaAutomaticaResultado = validacao;
    }

    @Override
    public String getConferenciaAutomatica() {
        return this.conferenciaAutomaticaResultado;
    }

    @Override
    public boolean isConferenciaAutomatica() {
        String tipoCalculo = this.getTipoCalculoConferenciaAutomatica();
        if (Funcoes.textoVazio(tipoCalculo)) {
            return false;
        }
        return this.getConferenciaAutomatica().equalsIgnoreCase("sim") && !tipoCalculo.equalsIgnoreCase("Desativada") && (tipoCalculo.equalsIgnoreCase("M\u00e9dia") || tipoCalculo.equalsIgnoreCase("Valores normais e m\u00e9dia"));
    }

    @Override
    public String getTipoConferenciaAutomatica() {
        return this.getTipoCalculoConferenciaAutomatica();
    }

    @Override
    public void atualizaComboTagResultado() {
        if (this.pag.getGerenciador() != null) {
            this.pag.getGerenciador().dadosAlterados(null);
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

