/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.DialogoParametrosCorpo;
import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.configurador.componente.ReguaReferencial;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontal;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorConferenciaAutomatica;
import jalis.laboratorio.configurador.propriedade.EditorExpressao;
import jalis.laboratorio.configurador.propriedade.EditorFont;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorMascaraNumero;
import jalis.laboratorio.configurador.propriedade.EditorPercentual;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.EditorValorReferencia;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.ExpressaoDigitacao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Expressao
extends AbstractComponente
implements Digitavel,
ComponenteEditor {
    private String texto = "Express\u00e3o";
    private String exp = "";
    private int alinHor = 2;
    private String tagSelecionada = null;
    private String conferenciaAutomaticaResultado = "n\u00e3o";
    private ValoresPercentualDeltaCheck percentualDeVariacao;
    private ValoresReferencia valores;
    private String masc = "";
    private boolean valorAlterado = false;

    public Expressao() {
        this.setSize(new Dimension(75, 25));
        this.valores = ValoresReferencia.novaInstancia(1, this.getMascara().trim().length() == 0 ? "#####,####" : this.getMascara());
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Expressao) {
            Expressao exp = (Expressao)comp;
            this.setExpressao(exp.getExpressao());
            this.setFonte(exp.getFonte());
            this.setMascara(exp.masc);
            ValoresReferencia val = exp.getValoresDeReferencia();
            if (val != null) {
                this.setValoresDeReferencia((ValoresReferencia)val.clone());
            }
        }
        this.setAtualizar(false);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setCorDaFonte(StringUtil.getColor(xml, "corDaFonte"));
        this.setExpressao(StringUtil.getValor(xml, "expressao"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(xml, "fonte")));
        this.setMascara(StringUtil.getValor(xml, "mascara"));
        if (this.valores != null) {
            this.valores.setAtributos(StringUtil.getValor(xml, "valoresDeReferencia"));
        }
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    public void setMascara(String masc) {
        if (masc != null && !this.masc.equalsIgnoreCase(masc)) {
            this.masc = masc;
            if (masc.length() > 0) {
                this.setAlinhamentoHorizontal(4);
                this.valores = ValoresReferencia.novaInstancia(1, masc);
            }
        }
        this.atualizar();
    }

    public String getMascara() {
        return this.masc;
    }

    public ValoresReferencia getValoresDeReferencia() {
        return this.valores;
    }

    public void setValoresDeReferencia(ValoresReferencia valores) {
        this.valores = valores;
        this.atualizarDependentesValorDeReferencia();
    }

    public String getExpressao() {
        return this.limpaCdata(this.exp);
    }

    public void setExpressao(String exp) {
        this.exp = this.limpaCdata(exp);
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade("fonte", EditorFont.class));
            list.add(new Propriedade("cor da fonte", EditorColor.class));
            list.add(new Propriedade("express\u00e3o", EditorExpressao.class));
            list.add(new Propriedade("resultado anterior", EditorBoolean.class));
            if (DialogoParametrosCorpo.isDestacarValorReferencia()) {
                list.add(new Propriedade("colorir refer\u00eancia", EditorBoolean.class));
            }
            if (this.getResultadoAnterior()) {
                list.add(new Propriedade(EditorTag.getDescricaoTag(), EditorTag.class));
            }
            if (!this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("Desativada")) {
                list.add(new Propriedade(EditorConferenciaAutomatica.getDescricao(), EditorConferenciaAutomatica.class));
            }
            if (this.isConferenciaAutomatica() && this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("Valores normais e m\u00e9dia") || this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("M\u00e9dia")) {
                list.add(new Propriedade("percentual de varia\u00e7\u00e3o", EditorPercentual.class));
            }
            list.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
            list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
            list.add(new Propriedade("remover vazio", EditorBoolean.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            list.add(new Propriedade("m\u00e1scara", EditorMascaraNumero.class));
            list.add(new Propriedade("valores de refer\u00eancia", EditorValorReferencia.class));
        }
        return list;
    }

    @Override
    public String getNomeBase() {
        return "Expressao";
    }

    public void trocarIdent(String antigo, String novo) {
        if (!antigo.equalsIgnoreCase(novo)) {
            StringBuilder novaExp = new StringBuilder();
            StringBuilder buf = new StringBuilder();
            char[] c = this.exp.toCharArray();
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == '\"') {
                    novaExp.append((CharSequence)buf);
                    novaExp.append(c[i]);
                    do {
                        if (++i >= c.length) continue;
                        novaExp.append(c[i]);
                    } while (i < c.length && c[i] != '\"');
                    buf.delete(0, buf.length());
                    continue;
                }
                if (!Character.isLetterOrDigit(c[i])) {
                    novaExp.append(buf.toString().equalsIgnoreCase(antigo) ? novo : buf);
                    novaExp.append(c[i]);
                    buf.delete(0, buf.length());
                    continue;
                }
                buf.append(c[i]);
            }
            this.exp = novaExp.append(buf.toString().equalsIgnoreCase(antigo) ? novo : buf).toString();
        }
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("corDaFonte", String.valueOf(this.getCorDaFonte().getRGB())));
        bui.append(StringUtil.getTag("expressao", StringUtil.preencheCData(this.getExpressao())));
        bui.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(this.getFonte())));
        bui.append(StringUtil.getTag("conferenciaResultadoAutomatico", this.getConferenciaAutomatica()));
        bui.append(StringUtil.getTag("mascara", this.getMascara()));
        if (this.percentualDeVariacao != null) {
            bui.append(StringUtil.getTag("percentualVariacao", this.percentualDeVariacao.toString()));
        }
        bui.append(StringUtil.getTag("valorAlterado", String.valueOf(this.valorAlterado())));
        if (this.getResultadoAnterior()) {
            bui.append(StringUtil.getTag("tagResultado", this.getTagResultado()));
        }
        if (this.valores != null) {
            bui.append(StringUtil.getTag("valoresDeReferencia", this.valores.getAtributos()));
        }
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
        this.setExpressao(StringUtil.getValor(atr, "expressao"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(atr, "fonte")));
        this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
        this.setConferenciaAutomatica(StringUtil.getValor(atr, "conferenciaResultadoAutomatico"));
        if (this.percentualDeVariacao == null) {
            this.percentualDeVariacao = new ValoresPercentualDeltaCheck();
        }
        this.percentualDeVariacao.setPercentualVariacao(StringUtil.getValor(atr, "percentualVariacao").replace(",", "."));
        this.setValorAlterado(StringUtil.getBoolean(atr, "valorAlterado"));
        this.setMascara(StringUtil.getValor(atr, "mascara"));
        if (this.valores != null) {
            this.valores.setAtributos(StringUtil.getValor(atr, "valoresDeReferencia"));
        }
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    public void setValorAlterado(boolean alterado) {
        this.valorAlterado = alterado;
    }

    public boolean valorAlterado() {
        return this.valorAlterado;
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        if (!edicao && this.salvoValor) {
            TextoEstatico texto = new TextoEstatico();
            texto.setDono(this);
            texto.setName(this.getNome());
            texto.setFont(this.getFont());
            texto.setDimensoes(this.getDimensoes());
            texto.setText(this.getValorResultado());
            texto.setValor(this.converte(this.getValorResultado()));
            texto.setForeground(this.getForeground());
            texto.setHorizontalAlignment(this.getAlinhamentoHorizontal());
            texto.setProcessarTagsHTML(true);
            texto.setImprimir(this.getImprimir());
            return texto;
        }
        ExpressaoDigitacao exp = new ExpressaoDigitacao();
        exp.setDono(this);
        exp.setName(this.getNome());
        exp.setDimensoes(this.getDimensoes());
        exp.setForeground(this.getCorDaFonte());
        exp.setFont(this.getFonte());
        exp.setExpressao(this.getExpressao());
        exp.setImprimir(this.getImprimir());
        exp.setLigacoes(this.getLigacoes());
        exp.setResultadoAnterior(this.getResultadoAnterior());
        exp.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
        exp.setRemoverVazio(this.getRemoverVazio());
        exp.setMascara(this.getMascara());
        exp.setValoresReferencia(this.getValoresDeReferencia());
        return exp;
    }

    private void atualizarDependentesValorDeReferencia() {
        if (this.pag != null) {
            for (Componente comp : this.pag.getComponentes()) {
                if (comp instanceof ReguaReferencial && ((ReguaReferencial)comp).getOrigem().equalsIgnoreCase(this.getNome())) {
                    ((ReguaReferencial)comp).setValoresDeReferencia(this.valores);
                    continue;
                }
                if (!(comp instanceof Grafico)) continue;
                ((Grafico)comp).setValoresDeReferencia(this.valores);
            }
        }
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alinHor;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinHor = alinhamento;
        this.atualizar();
    }

    public String[] getComponentesComReferencia() {
        ArrayList<String> res = new ArrayList<String>();
        Container pai = this.getParent();
        if (pai != null) {
            Component[] comp = pai.getComponents();
            String nome = this.getNome();
            for (int i = 0; i < comp.length; ++i) {
                if (!(comp[i] instanceof Expressao) || ((Expressao)comp[i]).getExpressao().indexOf(nome) <= -1) continue;
                res.add(((Expressao)comp[i]).getNome());
            }
        }
        return res.toArray(new String[0]);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics met = g.getFontMetrics();
        String str = this.getNome().length() > 0 ? this.getNome() : this.texto;
        int h = met.getHeight();
        int x = this.alinHor == 2 ? 3 : (this.alinHor == 4 ? this.getWidth() - met.stringWidth(str) - 3 : (this.getWidth() - met.stringWidth(str)) / 2);
        g.drawString(str, x, this.getHeight() / 2 + h / 2 - 2);
        g.setColor(Color.gray);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private Object converte(String str) {
        String tmp = StringUtil.strDecimal(str);
        if (!Funcoes.textoVazio(tmp) && tmp.matches("\\-?\\d+(\\.\\d+)?")) {
            return new Double(tmp);
        }
        return str;
    }

    @Override
    public void setTagResultado(String tag) {
        if (!Funcoes.textoVazio(this.tagSelecionada) && this.pag != null) {
            this.pag.removeTagEmUso(this.tagSelecionada);
        }
        this.tagSelecionada = tag;
        if (this.pag != null) {
            this.pag.adicionaTagEmUso(tag, this);
        }
    }

    @Override
    public ValoresPercentualDeltaCheck getPercentualDeVariacao() {
        return this.percentualDeVariacao;
    }

    public void setPercentualDeVariacao(ValoresPercentualDeltaCheck percentualVariacao) {
        this.percentualDeVariacao = percentualVariacao;
    }

    @Override
    public String getTagResultado() {
        return this.tagSelecionada;
    }

    @Override
    public void setConferenciaAutomatica(String validacao) {
        this.conferenciaAutomaticaResultado = validacao;
    }

    @Override
    public String getConferenciaAutomatica() {
        return this.conferenciaAutomaticaResultado;
    }

    @Override
    public boolean isConferenciaAutomatica() {
        String tipoCalculo = this.getTipoCalculoConferenciaAutomatica();
        if (Funcoes.textoVazio(tipoCalculo)) {
            return false;
        }
        return this.getConferenciaAutomatica().equalsIgnoreCase("sim") && !tipoCalculo.equalsIgnoreCase("Desativada") && (tipoCalculo.equalsIgnoreCase("M\u00e9dia") || tipoCalculo.equalsIgnoreCase("Valores normais e m\u00e9dia"));
    }

    @Override
    public String getTipoConferenciaAutomatica() {
        return this.getTipoCalculoConferenciaAutomatica();
    }

    @Override
    public void atualizaComboTagResultado() {
        if (this.pag.getGerenciador() != null) {
            this.pag.getGerenciador().dadosAlterados(null);
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

