/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontal;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorCampoBanco;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorConferenciaAutomatica;
import jalis.laboratorio.configurador.propriedade.EditorFont;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorMascaraDados;
import jalis.laboratorio.configurador.propriedade.EditorPercentual;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.DadosDigitacao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import java.util.Map;

public class Dados
extends AbstractComponente
implements Digitavel,
ComponenteEditor {
    private String campoBanco = "";
    private String mascara = "";
    private int alinHor = 2;
    private boolean quebrarLinha = false;
    private String tagSelecionada = null;
    private String conferenciaAutomaticaResultado = "n\u00e3o";
    private ValoresPercentualDeltaCheck percentualDeVariacao;

    public Dados() {
        this.setTamanho(new Dimension(75, 25));
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade("cor da fonte", EditorColor.class));
            list.add(new Propriedade("cor de fundo", EditorColor.class));
            list.add(new Propriedade("fonte", EditorFont.class));
            list.add(new Propriedade("resultado anterior", EditorBoolean.class));
            if (this.getResultadoAnterior()) {
                list.add(new Propriedade(EditorTag.getDescricaoTag(), EditorTag.class));
            }
            if (!this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("Desativada")) {
                list.add(new Propriedade(EditorConferenciaAutomatica.getDescricao(), EditorConferenciaAutomatica.class));
            }
            if (this.isConferenciaAutomatica() && this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("Valores normais e m\u00e9dia") || this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("M\u00e9dia")) {
                list.add(new Propriedade("percentual de varia\u00e7\u00e3o", EditorPercentual.class));
            }
            list.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
            list.add(new Propriedade("campo do banco", EditorCampoBanco.class));
            list.add(new Propriedade("remover vazio", EditorBoolean.class));
            list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
            list.add(new Propriedade("opaco", EditorBoolean.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            list.add(new Propriedade("m\u00e1scara", EditorMascaraDados.class));
            list.add(new Propriedade("quebrar linha", EditorBoolean.class));
        }
        return list;
    }

    @Override
    public String getAtributos() {
        StringBuffer str = new StringBuffer(super.getAtributos());
        str.append(StringUtil.getTag("corDaFonte", String.valueOf(this.getCorDaFonte().getRGB())));
        str.append(StringUtil.getTag("corDeFundo", String.valueOf(this.getCorDeFundo().getRGB())));
        str.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(this.getFonte())));
        str.append(StringUtil.getTag("campoDoBanco", this.getCampoDoBanco()));
        str.append(StringUtil.getTag("opaco", String.valueOf(this.getOpaco())));
        str.append(StringUtil.getTag("mascara", this.getMascara()));
        str.append(StringUtil.getTag("quebrarLinha", String.valueOf(this.getQuebrarLinha())));
        str.append(StringUtil.getTag("conferenciaResultadoAutomatico", this.getConferenciaAutomatica()));
        if (this.percentualDeVariacao != null) {
            if (this.percentualDeVariacao.existeValoresDeltaCheck().booleanValue()) {
                str.append(StringUtil.getTag("deltaCheck", this.percentualDeVariacao.getAtributos()));
            }
            str.append(StringUtil.getTag("percentualVariacao", this.percentualDeVariacao.toString()));
        }
        if (this.getResultadoAnterior()) {
            str.append(StringUtil.getTag("tagResultado", this.getTagResultado()));
        }
        return str.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setCorDeFundo(StringUtil.getColor(atr, "corDeFundo"));
        this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(atr, "fonte")));
        this.setCampoDoBanco(StringUtil.getValor(atr, "campoDoBanco"));
        this.setMascara(StringUtil.getValor(atr, "mascara"));
        this.setQuebrarLinha(StringUtil.getBoolean(atr, "quebrarLinha"));
        this.setOpaco(StringUtil.getBoolean(atr, "opaco"));
        this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
        this.setConferenciaAutomatica(StringUtil.getValor(atr, "conferenciaResultadoAutomatico"));
        if (this.percentualDeVariacao == null) {
            this.percentualDeVariacao = new ValoresPercentualDeltaCheck();
        }
        this.percentualDeVariacao.setAtributos(StringUtil.getValor(atr, "deltaCheck"));
        this.percentualDeVariacao.setPercentualVariacao(StringUtil.getValor(atr, "percentualVariacao").replace(".", "").replace(",", "."));
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        if (!edicao && this.salvoValor) {
            TextoEstatico texto = new TextoEstatico();
            texto.setDono(this);
            texto.setName(this.getNome());
            texto.setFont(this.getFont());
            texto.setDimensoes(this.getDimensoes());
            texto.setText(this.getValorResultado());
            texto.setValor(this.converte(this.getValorResultado()));
            texto.setForeground(this.getCorDaFonte());
            texto.setBackground(this.getCorDeFundo());
            texto.setOpaque(this.getOpaco());
            texto.setHorizontalAlignment(this.getAlinhamentoHorizontal());
            texto.setImprimir(this.getImprimir());
            texto.setQuebrarLinha(this.getQuebrarLinha());
            return texto;
        }
        DadosDigitacao dados = new DadosDigitacao();
        dados.setDono(this);
        dados.setName(this.getNome());
        dados.setDimensoes(this.getDimensoes());
        dados.setOpaque(this.getOpaco());
        dados.setBackground(this.getCorDeFundo());
        dados.setForeground(this.getCorDaFonte());
        dados.setFont(this.getFonte());
        dados.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
        dados.setCampoBanco(this.getCampoDoBanco());
        dados.setMascara(this.getMascara());
        dados.setQuebrarLinha(this.getQuebrarLinha());
        dados.setImprimir(this.getImprimir());
        dados.setResultadoAnterior(this.getResultadoAnterior());
        dados.setLigacoes(this.getLigacoes());
        dados.setRemoverVazio(this.getRemoverVazio());
        return dados;
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Dados) {
            Dados d = (Dados)comp;
            this.setCampoDoBanco(d.getCampoDoBanco());
            this.setMascara(d.getMascara());
            this.setOpaco(d.getOpaco());
            this.setCorDeFundo(d.getCorDeFundo());
            this.setFonte(d.getFonte());
            this.setCorDaFonte(d.getCorDaFonte());
            this.setQuebrarLinha(d.getQuebrarLinha());
            ValoresPercentualDeltaCheck valDeltaCheck = d.getPercentualDeVariacao();
            if (valDeltaCheck != null) {
                this.setPercentualDeVariacao((ValoresPercentualDeltaCheck)valDeltaCheck.clone());
            }
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setCorDeFundo(StringUtil.getColor(xml, "corDeFundo"));
        this.setCorDaFonte(StringUtil.getColor(xml, "corDaFonte"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(xml, "fonte")));
        this.setCampoDoBanco(StringUtil.getValor(xml, "campoDoBanco"));
        this.setMascara(StringUtil.getValor(xml, "mascara"));
        this.setQuebrarLinha(StringUtil.getBoolean(xml, "quebrarLinha"));
        if (this.percentualDeVariacao == null) {
            this.percentualDeVariacao = new ValoresPercentualDeltaCheck();
        }
        this.percentualDeVariacao.setPercentualVariacao(StringUtil.getValor(xml, "percentualVariacao").replace(",", "."));
        this.percentualDeVariacao.setAtributos(StringUtil.getValor(xml, "deltaCheck"));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    @Override
    public String getNomeBase() {
        return "Dados";
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    public void setCampoDoBanco(String campo) {
        this.campoBanco = campo;
        this.atualizar();
    }

    public String getMascara() {
        return this.mascara;
    }

    public void setMascara(String mascara) {
        this.mascara = mascara;
    }

    public void setOpaco(boolean opaco) {
        this.setOpaque(opaco);
    }

    public boolean getOpaco() {
        return this.isOpaque();
    }

    public void setCorDeFundo(Color cor) {
        this.setBackground(cor);
    }

    public Color getCorDeFundo() {
        return this.getBackground();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alinHor;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinHor = alinhamento;
    }

    public void setQuebrarLinha(boolean wordWrap) {
        this.quebrarLinha = wordWrap;
    }

    public boolean getQuebrarLinha() {
        return this.quebrarLinha;
    }

    @Override
    public ValoresPercentualDeltaCheck getPercentualDeVariacao() {
        return this.percentualDeVariacao;
    }

    public void setPercentualDeVariacao(ValoresPercentualDeltaCheck percentualVariacao) {
        this.percentualDeVariacao = percentualVariacao;
    }

    @Override
    public void paint(Graphics g) {
        String str;
        super.paint(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(this.getForeground());
        FontMetrics met = g.getFontMetrics();
        int h = met.getHeight();
        String string = str = this.campoBanco.length() > 0 ? this.campoBanco : this.getNome();
        int x = this.alinHor == 2 ? 3 : (this.alinHor == 4 ? this.getWidth() - met.stringWidth(str) - 3 : (this.getWidth() - met.stringWidth(str)) / 2);
        g.drawString(str, x, this.getHeight() / 2 + h / 2 - 2);
        g.setColor(Color.gray);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private Object converte(String str) {
        String tmp = StringUtil.strDecimal(str);
        if (!Funcoes.textoVazio(tmp) && tmp.matches("\\-?\\d+(\\.\\d+)?")) {
            return new Double(tmp);
        }
        return str;
    }

    @Override
    public void setTagResultado(String tag) {
        if (!Funcoes.textoVazio(this.tagSelecionada) && this.pag != null) {
            this.pag.removeTagEmUso(this.tagSelecionada);
        }
        this.tagSelecionada = tag;
        if (this.pag != null) {
            this.pag.adicionaTagEmUso(tag, this);
        }
    }

    @Override
    public String getTagResultado() {
        return this.tagSelecionada;
    }

    @Override
    public void setConferenciaAutomatica(String validacao) {
        this.conferenciaAutomaticaResultado = validacao;
    }

    @Override
    public String getConferenciaAutomatica() {
        return this.conferenciaAutomaticaResultado;
    }

    @Override
    public boolean isConferenciaAutomatica() {
        String tipoCalculo = this.getTipoCalculoConferenciaAutomatica();
        if (Funcoes.textoVazio(tipoCalculo)) {
            return false;
        }
        return this.getConferenciaAutomatica().equalsIgnoreCase("sim") && !tipoCalculo.equalsIgnoreCase("Desativada") && (tipoCalculo.equalsIgnoreCase("M\u00e9dia") || tipoCalculo.equalsIgnoreCase("Valores normais e m\u00e9dia"));
    }

    @Override
    public String getTipoConferenciaAutomatica() {
        return this.getTipoCalculoConferenciaAutomatica();
    }

    @Override
    public void atualizaComboTagResultado() {
        if (this.pag.getGerenciador() != null) {
            this.pag.getGerenciador().dadosAlterados(null);
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

