/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.CorComboBox;
import jalis.util.DialogoCor;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfigurarCorValorReferencia
extends AbstractDialogoOKCancelar {
    private static String TITULO = "Valores de refer\u00eancia";
    private static String ABSURDO = "Absurdo";
    private static String LIMITROFE = "Limitrofe";
    private static String NORMAL = "Normal";
    private JLabel labelNormal = new JLabel("Normal:");
    private JLabel labelLimitrofe = new JLabel("Lim\u00edtrofe:");
    private JLabel labelAbsurdo = new JLabel("Absurdo:");
    private CorComboBox comboCorNormal = new CorComboBox();
    private CorComboBox comboCorLimitrofe = new CorComboBox();
    private CorComboBox comboCorAbsurdo = new CorComboBox();
    private JButton buttonCoresNormal = ComponenteFactory.novoJButton("...", '\u0000', this, null, new Dimension(22, 20));
    private JButton buttonCoresLimitrofe = ComponenteFactory.novoJButton("...", '\u0000', this, null, new Dimension(22, 20));
    private JButton buttonCoresAbsurdo = ComponenteFactory.novoJButton("...", '\u0000', this, null, new Dimension(22, 20));
    private HashMap<String, Color> mapColor = new HashMap();
    private XMLStringBuilder xmlCores;

    public static ConfigurarCorValorReferencia novaInstancia(Object dialogoParametrosCorpo) {
        if (dialogoParametrosCorpo instanceof Dialog) {
            return new ConfigurarCorValorReferencia((Dialog)dialogoParametrosCorpo, TITULO);
        }
        return new ConfigurarCorValorReferencia((Frame)dialogoParametrosCorpo, TITULO);
    }

    public ConfigurarCorValorReferencia(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    public ConfigurarCorValorReferencia(Frame pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    private void montarTela() {
        this.propriedadesTela();
        this.defineTamanhoComponentes();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 1, 0, 0);
        this.getPanelCentral().add((Component)this.labelNormal, gbc);
        ++gbc.gridx;
        this.getPanelCentral().add((Component)this.comboCorNormal, gbc);
        ++gbc.gridx;
        this.getPanelCentral().add((Component)this.buttonCoresNormal, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.getPanelCentral().add((Component)this.labelLimitrofe, gbc);
        ++gbc.gridx;
        this.getPanelCentral().add((Component)this.comboCorLimitrofe, gbc);
        ++gbc.gridx;
        this.getPanelCentral().add((Component)this.buttonCoresLimitrofe, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.getPanelCentral().add((Component)this.labelAbsurdo, gbc);
        ++gbc.gridx;
        this.getPanelCentral().add((Component)this.comboCorAbsurdo, gbc);
        ++gbc.gridx;
        this.getPanelCentral().add((Component)this.buttonCoresAbsurdo, gbc);
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(60, 20));
        ++gbc.gridx;
        this.getPanelCentral().add((Component)panel, gbc);
    }

    private void propriedadesTela() {
        ScreenUtil.centralizar(this);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelBotoesDireita().setBorder(new TitledBorder(""));
        this.setResizable(false);
        this.setModal(true);
        this.getPanelBotoesDireita().setPreferredSize(new Dimension(310, 35));
        this.getPanelBotoesDireita().setMinimumSize(new Dimension(310, 35));
        this.setSize(new Dimension(300, 150));
        this.setPreferredSize(new Dimension(300, 150));
    }

    private void defineTamanhoComponentes() {
        Dimension tamanhoCombo = new Dimension(130, 20);
        this.comboCorNormal.setPreferredSize(tamanhoCombo);
        this.comboCorNormal.setMinimumSize(tamanhoCombo);
        this.comboCorLimitrofe.setPreferredSize(tamanhoCombo);
        this.comboCorLimitrofe.setMinimumSize(tamanhoCombo);
        this.comboCorAbsurdo.setPreferredSize(tamanhoCombo);
        this.comboCorAbsurdo.setMinimumSize(tamanhoCombo);
        this.buttonCoresNormal.setPreferredSize(new Dimension(20, 20));
        this.buttonCoresNormal.setMinimumSize(new Dimension(20, 20));
        this.buttonCoresLimitrofe.setPreferredSize(new Dimension(20, 20));
        this.buttonCoresLimitrofe.setMinimumSize(new Dimension(20, 20));
        this.buttonCoresAbsurdo.setPreferredSize(new Dimension(20, 20));
        this.buttonCoresAbsurdo.setMinimumSize(new Dimension(20, 20));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonCoresAbsurdo) {
            this.chamaCor(ABSURDO);
        } else if (o == this.buttonCoresLimitrofe) {
            this.chamaCor(LIMITROFE);
        } else if (o == this.buttonCoresNormal) {
            this.chamaCor(NORMAL);
        } else {
            this.ok = o == this.buttonOK;
            this.dispose();
        }
    }

    private void chamaCor(String tipo) {
        DialogoCor dc = DialogoCor.novaInstancia(this, "Configura\u00e7\u00e3o de Cor");
        if (dc != null) {
            dc.setCor(this.mapColor.get(tipo));
            dc.setVisible(true);
            if (dc.ok()) {
                if (tipo.equals(NORMAL)) {
                    this.comboCorNormal.setCorSelecionada(dc.getCor());
                } else if (tipo.equals(LIMITROFE)) {
                    this.comboCorLimitrofe.setCorSelecionada(dc.getCor());
                } else if (tipo.equals(ABSURDO)) {
                    this.comboCorAbsurdo.setCorSelecionada(dc.getCor());
                }
                this.mapColor.put(NORMAL, this.comboCorNormal.getCorSelecionada());
                this.mapColor.put(LIMITROFE, this.comboCorLimitrofe.getCorSelecionada());
                this.mapColor.put(ABSURDO, this.comboCorAbsurdo.getCorSelecionada());
            }
            dc.dispose();
            this.atualizarCombos();
        }
    }

    public String getXmlCores() throws XMLStringBuilderException {
        this.xmlCores = new XMLStringBuilder();
        this.xmlCores.abrir("corValorReferencia");
        this.xmlCores.abrir(NORMAL);
        this.xmlCores.escrever(String.valueOf(this.comboCorNormal.getCorSelecionada().getRGB()));
        this.xmlCores.fechar(NORMAL);
        this.xmlCores.abrir(LIMITROFE);
        this.xmlCores.escrever(String.valueOf(this.comboCorLimitrofe.getCorSelecionada().getRGB()));
        this.xmlCores.fechar(LIMITROFE);
        this.xmlCores.abrir(ABSURDO);
        this.xmlCores.escrever(String.valueOf(this.comboCorAbsurdo.getCorSelecionada().getRGB()));
        this.xmlCores.fechar(ABSURDO);
        this.xmlCores.fechar("corValorReferencia");
        return this.xmlCores.toString();
    }

    public void setXmlCores(String cores) {
        if (!Funcoes.textoVazio(cores)) {
            this.mapColor.put(NORMAL, this.getCor(cores, NORMAL));
            this.mapColor.put(ABSURDO, this.getCor(cores, ABSURDO));
            this.mapColor.put(LIMITROFE, this.getCor(cores, LIMITROFE));
        }
        this.atualizarCombos();
    }

    private void atualizarCombos() {
        this.comboCorNormal.setCorSelecionada(Color.BLACK);
        this.comboCorLimitrofe.setCorSelecionada(Color.BLACK);
        this.comboCorAbsurdo.setCorSelecionada(Color.BLACK);
        if (this.mapColor.get(NORMAL) != null) {
            this.comboCorNormal.setCorSelecionada(this.mapColor.get(NORMAL));
        }
        if (this.mapColor.get(LIMITROFE) != null) {
            this.comboCorLimitrofe.setCorSelecionada(this.mapColor.get(LIMITROFE));
        }
        if (this.mapColor.get(ABSURDO) != null) {
            this.comboCorAbsurdo.setCorSelecionada(this.mapColor.get(ABSURDO));
        }
    }

    private Color getCor(String cores, String campo) {
        Color cor = null;
        if (!Funcoes.textoVazio(StringUtil.getValor(cores, campo).trim())) {
            int codigoCor = Integer.valueOf(StringUtil.getValor(cores, campo).trim());
            cor = new Color(codigoCor);
        }
        return cor;
    }
}

