/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.propriedade.EditorExpressao;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.impressao.componente.CodigoQRCodeImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;

public class CodigoQRCode
extends AbstractComponente {
    private static final String EXPRESSAO = "expressao";
    private String valorExpressao;
    private String valor;

    public CodigoQRCode() {
        this.setTamanho(new Dimension(40, 40));
        this.setDimensoes(new Rectangle(this.getTamanho()));
        this.valorExpressao = "";
        this.valor = "www.jalis.com.br";
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        CodigoQRCodeImpressao qrCode = new CodigoQRCodeImpressao();
        qrCode.setDono(this);
        qrCode.setName(this.getNome());
        qrCode.setDimensoes(this.getDimensoes());
        qrCode.setExpressao(this.getExpressao());
        qrCode.setImprimir(this.getImprimir());
        return qrCode;
    }

    @Override
    public String getNomeBase() {
        return "CodigoQRCode";
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade(EXPRESSAO, EditorExpressao.class));
        }
        return list;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle rec = this.getDimensoes();
        String textoQrCode = this.valorExpressao.isEmpty() ? this.valor : this.valorExpressao;
        BufferedImage imagemQrCode = ImagemUtils.gerarQrCodeImagem(textoQrCode, rec.width, rec.height);
        if (null != imagemQrCode) {
            int medidaPadrao = rec.width < rec.height ? rec.width : rec.height;
            g.drawImage(imagemQrCode, 0, 0, medidaPadrao, medidaPadrao, null);
        }
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag(EXPRESSAO, StringUtil.preencheCData(this.getExpressao())));
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setExpressao(StringUtil.getValor(atr, EXPRESSAO));
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setExpressao(StringUtil.getTag(xml, EXPRESSAO));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof CodigoQRCode) {
            CodigoQRCode tmp = (CodigoQRCode)comp;
            this.setExpressao(tmp.getExpressao());
        }
        this.setAtualizar(true);
    }

    public String getExpressao() {
        return this.valorExpressao;
    }

    public void setExpressao(String expressao) {
        if (expressao != null) {
            this.valorExpressao = expressao;
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }
}

