/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontal;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorCampoBanco;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorFormatoBarra;
import jalis.laboratorio.configurador.propriedade.EditorInt;
import jalis.laboratorio.configurador.propriedade.EditorString;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.CodigoBarrasDigitacao;
import jalis.laboratorio.impressao.componente.CodigoBarrasImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.barras.CodigoBarras25;
import jalis.util.barras.CodigoBarras39;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;

public class CodigoBarrasConf
extends AbstractComponente {
    private String valorExemplo = "123";
    private boolean autoDimen = true;
    private int formato = 0;
    private int alin = 2;
    private int colZeros;
    private String campoBanco = "";

    public CodigoBarrasConf() {
        this.setTamanho(new Dimension(100, 40));
        this.setCorDaBarra(Color.black);
        this.setCorDeFundo(Color.white);
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
            list.add(new Propriedade("auto dimensionar", EditorBoolean.class));
            list.add(new Propriedade("cor da barra", EditorColor.class));
            list.add(new Propriedade("cor de fundo", EditorColor.class));
            list.add(new Propriedade("formato", EditorFormatoBarra.class));
            list.add(new Propriedade("campo do banco", EditorCampoBanco.class));
            list.add(new Propriedade("remover vazio", EditorBoolean.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            list.add(new Propriedade("preencher zero", EditorInt.class));
            list.add(new Propriedade("valor de exemplo", EditorString.class));
        }
        return list;
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("autoDimensionar", String.valueOf(this.getAutoDimensionar())));
        bui.append(StringUtil.getTag("corDaBarra", String.valueOf(this.getForeground().getRGB())));
        bui.append(StringUtil.getTag("corDeFundo", String.valueOf(this.getBackground().getRGB())));
        bui.append(StringUtil.getTag("formato", String.valueOf(this.getFormato())));
        bui.append(StringUtil.getTag("campoDoBanco", this.getCampoDoBanco()));
        bui.append(StringUtil.getTag("preencherZero", String.valueOf(this.getPreencherZero())));
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setAutoDimensionar(StringUtil.getBoolean(StringUtil.getValor(atr, "autoDimensionar")));
        this.setCorDaBarra(StringUtil.getColor(atr, "corDaBarra"));
        this.setCorDeFundo(StringUtil.getColor(atr, "corDeFundo"));
        this.setFormato(StringUtil.getInt(atr, "formato"));
        this.setCampoDoBanco(StringUtil.getValor(atr, "campoDoBanco"));
        this.setPreencherZero(StringUtil.getInt(atr, "preencherZero"));
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof CodigoBarrasConf) {
            CodigoBarrasConf bar = (CodigoBarrasConf)comp;
            this.setFormato(bar.getFormato());
            this.setCorDaBarra(bar.getCorDaBarra());
            this.setCorDeFundo(bar.getCorDeFundo());
            this.setCampoDoBanco(bar.getCampoDoBanco());
            this.setAutoDimensionar(bar.getAutoDimensionar());
            this.setPreencherZero(bar.getPreencherZero());
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setAutoDimensionar(StringUtil.getBoolean(StringUtil.getValor(xml, "autoDimensionar")));
        this.setCorDaBarra(StringUtil.getColor(xml, "corDaBarra"));
        this.setCorDeFundo(StringUtil.getColor(xml, "corDeFundo"));
        this.setFormato(StringUtil.getInt(xml, "formato"));
        this.setCampoDoBanco(StringUtil.getValor(xml, "campoDoBanco"));
        this.setPreencherZero(StringUtil.getInt(xml, "preencherZero"));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    public void setFormato(int formato) {
        this.formato = formato;
        if (this.autoDimen) {
            this.atualizarTamanho();
        } else {
            this.atualizar();
        }
    }

    public int getFormato() {
        return this.formato;
    }

    public void setPreencherZero(int coluna) {
        this.colZeros = coluna;
        this.valorExemplo = Funcoes.preencheZero(this.valorExemplo, coluna);
        this.atualizarTamanho();
    }

    public int getPreencherZero() {
        return this.colZeros;
    }

    public void setValorDeExemplo(String valor) {
        if (valor == null || valor.length() == 0 || this.formato == 0 && !valor.matches("\\-?\\d+")) {
            return;
        }
        this.valorExemplo = Funcoes.preencheZero(valor, this.colZeros);
        this.atualizarTamanho();
    }

    public String getValorDeExemplo() {
        return this.valorExemplo;
    }

    public void setCorDaBarra(Color cor) {
        this.setForeground(cor);
    }

    public Color getCorDaBarra() {
        return this.getForeground();
    }

    public void setCorDeFundo(Color cor) {
        this.setBackground(cor);
    }

    public Color getCorDeFundo() {
        return this.getBackground();
    }

    public void setCampoDoBanco(String campo) {
        this.campoBanco = campo;
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    @Override
    public String getNomeBase() {
        return "CodigoBarras";
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alin = alinhamento;
        this.atualizar();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alin;
    }

    public boolean getAutoDimensionar() {
        return this.autoDimen;
    }

    public void setAutoDimensionar(boolean valor) {
        this.autoDimen = valor;
        if (this.autoDimen) {
            this.atualizarTamanho();
        }
        this.atualizar();
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        super.setDimensoes(esquerda, topo, largura, altura);
        if (this.autoDimen) {
            this.atualizarTamanho();
            if (this.sel != null) {
                this.sel.atualizarDimensoes();
            }
        }
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        if (!edicao && this.salvoValor) {
            CodigoBarrasImpressao barras = new CodigoBarrasImpressao();
            barras.setDono(this);
            barras.setName(this.getNome());
            barras.setDimensoes(this.getDimensoes());
            barras.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
            barras.setFormato(this.getFormato());
            barras.setValorCodigo(this.getValorResultado());
            barras.setForeground(this.getForeground());
            barras.setBackground(this.getBackground());
            barras.setImprimir(this.getImprimir());
            barras.setPreencherZero(this.colZeros);
            return barras;
        }
        CodigoBarrasDigitacao barra = new CodigoBarrasDigitacao();
        barra.setDono(this);
        barra.setName(this.getNome());
        barra.setDimensoes(this.getDimensoes());
        barra.setFormato(this.getFormato());
        barra.setCampoBanco(this.getCampoDoBanco());
        barra.setForeground(this.getCorDaBarra());
        barra.setBackground(this.getCorDeFundo());
        barra.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
        barra.setAutoDimensionar(this.getAutoDimensionar());
        barra.setRemoverVazio(this.getRemoverVazio());
        barra.setImprimir(this.getImprimir());
        barra.setPreencherZero(this.colZeros);
        return barra;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this.autoDimen) {
            g.setColor(Color.gray);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        g.setColor(this.getForeground());
        Rectangle[] barras = new Rectangle[]{};
        switch (this.formato) {
            case 0: {
                barras = CodigoBarras25.getBarras(this.valorExemplo, this.getHeight());
                break;
            }
            case 1: {
                barras = CodigoBarras39.getBarras(this.valorExemplo, this.getHeight());
            }
        }
        int larg = barras[barras.length - 1].x + barras[barras.length - 1].width;
        int off = 0;
        switch (this.alin) {
            case 0: {
                off = (this.getWidth() - larg) / 2;
                break;
            }
            case 4: {
                off = this.getWidth() - larg;
            }
        }
        for (int i = 0; i < barras.length; ++i) {
            g.fillRect(barras[i].x + off, 0, barras[i].width, barras[i].height);
        }
        String str = this.formato == 0 ? "2x5" : "3x9";
        int w = g.getFontMetrics().stringWidth(str);
        int h = g.getFontMetrics().getHeight();
        g.setColor(this.getBackground());
        g.fillRect(this.getWidth() - w + 1, this.getHeight() - h + 3, w - 2, h - 4);
        g.setColor(this.getForeground());
        g.drawString(str, this.getWidth() - w, this.getHeight() - 2);
    }

    private void atualizarTamanho() {
        Rectangle[] barras = new Rectangle[]{};
        switch (this.formato) {
            case 0: {
                barras = CodigoBarras25.getBarras(this.valorExemplo, 10);
                break;
            }
            case 1: {
                barras = CodigoBarras39.getBarras(this.valorExemplo, 10);
            }
        }
        int w = barras[barras.length - 1].x + barras[barras.length - 1].width;
        int h = this.getHeight();
        w = w < 10 ? 10 : w;
        h = h < 10 ? 10 : h;
        this.setTamanho(new Dimension(w, h));
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

