/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.DialogoParametrosCorpo;
import jalis.laboratorio.configurador.ValoresPercentualDeltaCheck;
import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.configurador.componente.ReguaReferencial;
import jalis.laboratorio.configurador.pagina.Pagina;
import jalis.laboratorio.configurador.propriedade.EditorAlinhamentoHorizontal;
import jalis.laboratorio.configurador.propriedade.EditorBoolean;
import jalis.laboratorio.configurador.propriedade.EditorCampoInterfaceamento;
import jalis.laboratorio.configurador.propriedade.EditorColor;
import jalis.laboratorio.configurador.propriedade.EditorConferenciaAutomatica;
import jalis.laboratorio.configurador.propriedade.EditorExpressao;
import jalis.laboratorio.configurador.propriedade.EditorFont;
import jalis.laboratorio.configurador.propriedade.EditorInt;
import jalis.laboratorio.configurador.propriedade.EditorItemVazioLista;
import jalis.laboratorio.configurador.propriedade.EditorItensCampo;
import jalis.laboratorio.configurador.propriedade.EditorLigacoes;
import jalis.laboratorio.configurador.propriedade.EditorMascaraData;
import jalis.laboratorio.configurador.propriedade.EditorMascaraHora;
import jalis.laboratorio.configurador.propriedade.EditorMascaraNumero;
import jalis.laboratorio.configurador.propriedade.EditorPercentual;
import jalis.laboratorio.configurador.propriedade.EditorTag;
import jalis.laboratorio.configurador.propriedade.EditorTipoCampo;
import jalis.laboratorio.configurador.propriedade.EditorValorPadraoCampo;
import jalis.laboratorio.configurador.propriedade.EditorValorPadraoLista;
import jalis.laboratorio.configurador.propriedade.EditorValorReferencia;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.digitacao.componente.CampoDigitacao;
import jalis.laboratorio.digitacao.componente.CampoListaDigitacao;
import jalis.laboratorio.digitacao.evento.MudaCorReferenciaListener;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;

public class Campo
extends AbstractComponente
implements Digitavel,
ComponenteInterfaceamento,
ComponenteEditor {
    public static final Color COR_ALTERADO = new Color(255, 160, 160);
    public static final int TEXTO = 0;
    public static final int NUMERO = 1;
    public static final int DATA = 2;
    public static final int HORA = 3;
    public static final int LISTA = 4;
    private String rotulo = "Campo";
    private String masc = "";
    private int limite = 0;
    private int alinHor = 2;
    private int tipo = 0;
    private String[] itens = new String[0];
    private ValoresReferencia valores;
    private boolean valorAlterado;
    private boolean bloquearFoco = false;
    private String itemVazio;
    private String tagSelecionada = "";
    private String conferenciaAutomaticaResultado = "n\u00e3o";
    private ValoresPercentualDeltaCheck percentualDeVariacao;

    public Campo() {
        JLabel l = new JLabel();
        this.setSize(new Dimension(75, l.getFontMetrics(l.getFont()).getHeight()));
        this.setRelacionavelComCampoDeImportacao(true);
    }

    @Override
    public List<Propriedade> getPropriedades() {
        List<Propriedade> list = super.getPropriedades();
        if (this.modoInterfaceamento()) {
            list.add(new Propriedade("campo interfaceamento", EditorCampoInterfaceamento.class));
        } else {
            list.add(new Propriedade("fonte", EditorFont.class));
            list.add(new Propriedade("cor da fonte", EditorColor.class));
            if (this.tipo != 3 && this.tipo != 2 && this.tipo != 0 && this.tipo != 4 && DialogoParametrosCorpo.isDestacarValorReferencia()) {
                list.add(new Propriedade("colorir refer\u00eancia", EditorBoolean.class));
            }
            if (this.tipo != 3 && this.tipo != 2 && this.tipo != 1) {
                list.add(new Propriedade("cor de refer\u00eancia", EditorBoolean.class));
            }
            if (this.getCorDeReferencia() && this.tipo != 3 && this.tipo != 2 && this.tipo != 1) {
                list.add(new Propriedade("express\u00e3o de cor", EditorExpressao.class));
            }
            list.add(new Propriedade("valor padr\u00e3o", this.tipo == 4 ? EditorValorPadraoLista.class : EditorValorPadraoCampo.class));
            list.add(new Propriedade("resultado anterior", EditorBoolean.class));
            if (this.getResultadoAnterior()) {
                list.add(new Propriedade(EditorTag.getDescricaoTag(), EditorTag.class));
            }
            if (this.tipo == 1 && !this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("Desativada")) {
                list.add(new Propriedade(EditorConferenciaAutomatica.getDescricao(), EditorConferenciaAutomatica.class));
            }
            if (this.isConferenciaAutomatica() && this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("Valores normais e m\u00e9dia") || this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("M\u00e9dia") || this.getTipoCalculoConferenciaAutomatica().equalsIgnoreCase("Valores normais ou m\u00e9dia")) {
                list.add(new Propriedade("percentual de varia\u00e7\u00e3o", EditorPercentual.class));
            }
            list.add(new Propriedade("liga\u00e7\u00f5es", EditorLigacoes.class));
            list.add(new Propriedade("remover vazio", EditorBoolean.class));
            list.add(new Propriedade("tipo", EditorTipoCampo.class));
            list.add(new Propriedade("imprimir", EditorBoolean.class));
            if (this.tipo == 4) {
                list.add(new Propriedade("itens", EditorItensCampo.class));
                list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
                if (this.getRemoverVazio()) {
                    list.add(new Propriedade("item vazio", EditorItemVazioLista.class));
                }
            } else {
                list.add(new Propriedade("alinhamento horizontal", EditorAlinhamentoHorizontal.class));
                list.add(new Propriedade("bloquear foco", EditorBoolean.class));
                if (this.tipo != 0) {
                    list.add(new Propriedade("m\u00e1scara", this.tipo == 1 ? EditorMascaraNumero.class : (this.tipo == 2 ? EditorMascaraData.class : EditorMascaraHora.class)));
                }
                if (this.masc == null || this.masc.length() == 0) {
                    list.add(new Propriedade("limite", EditorInt.class));
                } else if (this.tipo != 2 && this.tipo != 0) {
                    list.add(new Propriedade("valores de refer\u00eancia", EditorValorReferencia.class));
                }
            }
        }
        return list;
    }

    @Override
    public void setPagina(Pagina pagina) {
        super.setPagina(pagina);
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Campo) {
            ValoresPercentualDeltaCheck valDeltaCheck;
            Campo c = (Campo)comp;
            ValoresReferencia val = c.getValoresDeReferencia();
            if (val != null) {
                this.setValoresDeReferencia((ValoresReferencia)val.clone());
            }
            if ((valDeltaCheck = c.getPercentualDeVariacao()) != null) {
                this.setPercentualDeVariacao((ValoresPercentualDeltaCheck)valDeltaCheck.clone());
            }
            this.setTipo(c.tipo);
            this.setMascara(c.masc);
            this.setLimite(c.limite);
            this.setItens(c.itens);
            this.setCorDaFonte(c.getCorDaFonte());
            this.setFonte(c.getFonte());
            this.setBloquearFoco(c.getBloquearFoco());
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setCorDaFonte(StringUtil.getColor(xml, "corDaFonte"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(xml, "fonte")));
        this.setLimite(StringUtil.getInt(xml, "limite"));
        this.setTipo(StringUtil.getInt(xml, "tipoCampo"));
        this.setMascara(StringUtil.getValor(xml, "mascara"));
        if (this.valores != null) {
            this.valores.setAtributos(StringUtil.getValor(xml, "valoresDeReferencia"));
        }
        if (this.percentualDeVariacao == null) {
            this.percentualDeVariacao = new ValoresPercentualDeltaCheck();
        }
        this.percentualDeVariacao.setPercentualVariacao(StringUtil.getValor(xml, "percentualVariacao").replace(".", "").replace(",", "."));
        this.percentualDeVariacao.setAtributos(StringUtil.getValor(xml, "deltaCheck"));
        this.setItens(StringUtil.getValores(StringUtil.getValor(xml, "itensCampo"), "item"));
        this.setBloquearFoco(StringUtil.getBoolean(StringUtil.getValor(xml, "bloquearFoco")));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    public ValoresReferencia getValoresDeReferencia() {
        return this.valores;
    }

    public void setValoresDeReferencia(ValoresReferencia valores) {
        this.valores = valores;
        this.atualizarDependentesValorDeReferencia();
    }

    public void setMascara(String masc) {
        if (masc != null && !this.masc.equalsIgnoreCase(masc)) {
            this.masc = masc;
            if (masc.length() > 0) {
                this.setAlinhamentoHorizontal(4);
                if (this.tipo == 1 || this.tipo == 3) {
                    this.valores = ValoresReferencia.novaInstancia(this.tipo, masc);
                }
            }
        }
        this.atualizar();
    }

    public String getMascara() {
        return this.masc;
    }

    public void setLimite(int limite) {
        this.limite = limite;
    }

    public int getLimite() {
        return this.limite;
    }

    @Override
    public String getNomeBase() {
        return "Campo";
    }

    @Override
    public String getAtributos() {
        StringBuffer str = new StringBuffer(super.getAtributos());
        str.append(StringUtil.getTag("corDaFonte", String.valueOf(this.getCorDaFonte().getRGB())));
        str.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(this.getFonte())));
        str.append(StringUtil.getTag("limite", String.valueOf(this.getLimite())));
        str.append(StringUtil.getTag("mascara", this.getMascara()));
        str.append(StringUtil.getTag("tipoCampo", String.valueOf(this.getTipo())));
        str.append(StringUtil.getTag("valorAlterado", String.valueOf(this.valorAlterado())));
        str.append(StringUtil.getTag("bloquearFoco", String.valueOf(this.getBloquearFoco())));
        if (this.getResultadoAnterior()) {
            str.append(StringUtil.getTag("tagResultado", this.getTagResultado()));
        }
        if (this.tipo == 1) {
            str.append(StringUtil.getTag("conferenciaResultadoAutomatico", this.getConferenciaAutomatica()));
            if (this.percentualDeVariacao != null) {
                if (this.percentualDeVariacao.existeValoresDeltaCheck().booleanValue()) {
                    str.append(StringUtil.getTag("deltaCheck", this.percentualDeVariacao.getAtributos()));
                }
                str.append(StringUtil.getTag("percentualVariacao", this.percentualDeVariacao.toString()));
            }
        }
        if (this.valores != null) {
            str.append(StringUtil.getTag("valoresDeReferencia", this.valores.getAtributos()));
        }
        str.append(StringUtil.getTag("itensCampo", StringUtil.getTagComCdata("item", this.getItens())));
        if (this.getRemoverVazio()) {
            str.append(StringUtil.getTag("itemVazio", this.getItemVazio()));
        }
        str.append(StringUtil.getTag("itemVazio", ""));
        return str.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setCorDaFonte(StringUtil.getColor(atr, "corDaFonte"));
        this.setFonte(StringUtil.getFonte(StringUtil.getValor(atr, "fonte")));
        this.setLimite(StringUtil.getInt(atr, "limite"));
        this.setTipo(StringUtil.getInt(atr, "tipoCampo"));
        this.setValorAlterado(StringUtil.getBoolean(atr, "valorAlterado"));
        this.setBloquearFoco(StringUtil.getBoolean(atr, "bloquearFoco"));
        this.setMascara(StringUtil.getValor(atr, "mascara"));
        this.setTagResultado(StringUtil.getValor(atr, "tagResultado"));
        this.setConferenciaAutomatica(StringUtil.getValor(atr, "conferenciaResultadoAutomatico"));
        if (this.percentualDeVariacao == null) {
            this.percentualDeVariacao = new ValoresPercentualDeltaCheck();
        }
        this.percentualDeVariacao.setAtributos(StringUtil.getValor(atr, "deltaCheck"));
        this.percentualDeVariacao.setPercentualVariacao(StringUtil.getValor(atr, "percentualVariacao").replace(".", "").replace(",", "."));
        if (this.valores != null) {
            this.valores.setAtributos(StringUtil.getValor(atr, "valoresDeReferencia"));
        }
        this.setItens(StringUtil.getValores(StringUtil.getValor(atr, "itensCampo"), "item"));
        this.setItemVazio(StringUtil.getValor(atr, "itemVazio"));
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alinHor;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinHor = alinhamento;
        this.atualizar();
    }

    public void setTipo(int tipo) {
        if (this.tipo != tipo) {
            this.tipo = tipo;
            this.itens = new String[0];
            this.setValorPadrao("");
            this.masc = "";
            this.valores = null;
            this.limite = 0;
            this.alinHor = tipo == 4 ? 2 : this.alinHor;
            this.atualizar();
        }
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setItens(String[] itens) {
        if (itens != null) {
            this.itens = itens;
        }
    }

    public String[] getItens() {
        return this.itens;
    }

    public String getItemVazio() {
        return this.itemVazio;
    }

    public void setItemVazio(String itemVazio) {
        this.itemVazio = itemVazio;
    }

    public void setValorAlterado(boolean alterado) {
        this.valorAlterado = alterado;
    }

    public boolean valorAlterado() {
        return this.valorAlterado;
    }

    public boolean getBloquearFoco() {
        return this.bloquearFoco;
    }

    public void setBloquearFoco(boolean bloquearFoco) {
        this.bloquearFoco = bloquearFoco;
    }

    @Override
    public ValoresPercentualDeltaCheck getPercentualDeVariacao() {
        return this.percentualDeVariacao;
    }

    public void setPercentualDeVariacao(ValoresPercentualDeltaCheck percentualVariacao) {
        this.percentualDeVariacao = percentualVariacao;
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        try {
            if (!edicao && this.salvoValor) {
                TextoEstatico texto = new TextoEstatico();
                texto.setDono(this);
                texto.setName(this.getNome());
                texto.setFont(this.getFont());
                texto.setDimensoes(this.getDimensoes());
                texto.setText(this.getValorResultado());
                texto.setValor(this.converte(this.getValorResultado()));
                texto.setForeground(this.getForeground());
                texto.setImprimir(this.getImprimir());
                texto.setHorizontalAlignment(this.getAlinhamentoHorizontal());
                return texto;
            }
            if (this.tipo == 4) {
                CampoListaDigitacao campo = new CampoListaDigitacao(this.getItens());
                campo = new CampoListaDigitacao(ArraysUtil.concatenar(new String[]{""}, this.getItens()));
                campo.setDono(this);
                campo.setCampo(this);
                campo.setName(this.getNome());
                campo.setCampoInterfaceamento(this.getCampoInterfaceamento());
                campo.setFont(this.getFonte());
                campo.setDimensoes(this.getDimensoes());
                campo.setImprimir(this.getImprimir());
                campo.setResultadoAnterior(this.getResultadoAnterior());
                campo.setLigacoes(this.getLigacoes());
                String valorSelecionado = this.getValorPadrao();
                if (valorSelecionado.isEmpty() && this.getRemoverVazio()) {
                    valorSelecionado = this.getItemVazio();
                }
                if (!Funcoes.textoVazio(valorSelecionado) && Funcoes.textoVazio((String)campo.getItemAt(0))) {
                    campo.removeItem("");
                }
                campo.setValor(valorSelecionado);
                if (edicao) {
                    campo.setValor(this.getValorResultado());
                }
                campo.setRemoverVazio(this.getRemoverVazio());
                campo.setItemVazio(this.getItemVazio());
                return campo;
            }
            CampoDigitacao campo = new CampoDigitacao();
            campo.setDono(this);
            campo.setName(this.getNome());
            campo.setCampoInterfaceamento(this.getCampoInterfaceamento());
            campo.setFont(this.getFonte());
            campo.setDimensoes(this.getDimensoes());
            campo.setImprimir(this.getImprimir());
            campo.setResultadoAnterior(this.getResultadoAnterior());
            campo.setLigacoes(this.getLigacoes());
            campo.setTipoMascara(this.getTipo(), this.getMascara(), this.getLimite());
            campo.setForeground(this.getCorDaFonte());
            campo.setValorPadrao(this.getValorPadrao());
            campo.setBloquearFoco(this.getBloquearFoco());
            if (edicao) {
                campo.setValor(this.getValorResultado());
            }
            campo.setValoresReferencia(this.getValoresDeReferencia());
            campo.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
            campo.setRemoverVazio(this.getRemoverVazio());
            this.adicionarListenerMudaCorReferencia(campo);
            return campo;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Campo: 370");
            return null;
        }
    }

    private void adicionarListenerMudaCorReferencia(CampoDigitacao campo) {
        Campo c;
        if (campo.getDono() instanceof Campo && (c = (Campo)campo.getDono()).getColorirReferencia()) {
            campo.getDocument().addDocumentListener(new MudaCorReferenciaListener(this, campo, this.getValoresDeReferencia()));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int x;
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        FontMetrics met = g.getFontMetrics();
        String str = this.masc.length() > 0 ? this.masc : (this.getNome() != null && this.getNome().length() > 0 ? this.getNome() : this.rotulo);
        int hFont = met.getHeight();
        int wStr = met.stringWidth(str);
        int n = this.alinHor == 2 ? 3 : (x = this.alinHor == 4 ? w - wStr - 3 : (w - wStr) / 2);
        if (this.tipo == 4) {
            int y1 = (h - 7) / 2;
            int y2 = (h + 7) / 2;
            g.fillPolygon(new int[]{w - 17, w - 3, w - 10}, new int[]{y1, y1, y2}, 3);
        }
        g.drawString(str, x, h / 2 + hFont / 2 - 2);
        g.setColor(Color.gray);
        g.drawRect(0, 0, w - 1, h - 1);
    }

    private Object converte(String str) {
        String tmp;
        if (this.tipo == 1 && !Funcoes.textoVazio(tmp = StringUtil.strDecimal(str)) && tmp.matches("\\-?\\d+(\\.\\d+)?")) {
            return new Double(tmp);
        }
        return str;
    }

    private void atualizarDependentesValorDeReferencia() {
        if (this.pag != null) {
            for (Componente comp : this.pag.getComponentes()) {
                if (comp instanceof ReguaReferencial && ((ReguaReferencial)comp).getOrigem().equalsIgnoreCase(this.getNome())) {
                    ((ReguaReferencial)comp).setValoresDeReferencia(this.valores);
                    continue;
                }
                if (!(comp instanceof Grafico)) continue;
                ((Grafico)comp).setValoresDeReferencia(this.valores);
            }
        }
    }

    @Override
    public void setTagResultado(String tag) {
        if (!Funcoes.textoVazio(this.tagSelecionada) && this.pag != null) {
            this.pag.removeTagEmUso(this.tagSelecionada);
        }
        this.tagSelecionada = tag;
        if (this.pag != null) {
            this.pag.adicionaTagEmUso(tag, this);
        }
    }

    @Override
    public String getTagResultado() {
        return this.tagSelecionada;
    }

    @Override
    public void setConferenciaAutomatica(String validacao) {
        this.conferenciaAutomaticaResultado = validacao;
    }

    @Override
    public String getConferenciaAutomatica() {
        return this.conferenciaAutomaticaResultado;
    }

    @Override
    public boolean isConferenciaAutomatica() {
        String tipoCalculo = this.getTipoCalculoConferenciaAutomatica();
        if (Funcoes.textoVazio(tipoCalculo)) {
            return false;
        }
        return this.getConferenciaAutomatica().equalsIgnoreCase("sim") && !tipoCalculo.equalsIgnoreCase("Desativada") && (tipoCalculo.equalsIgnoreCase("M\u00e9dia") || tipoCalculo.equalsIgnoreCase("Valores normais e m\u00e9dia"));
    }

    @Override
    public String getTipoConferenciaAutomatica() {
        return this.getTipoCalculoConferenciaAutomatica();
    }

    @Override
    public void atualizaComboTagResultado() {
        if (this.pag.getGerenciador() != null) {
            this.pag.getGerenciador().dadosAlterados(null);
        }
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

