/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Imagem;
import jalis.laboratorio.impressao.componente.AssinaturaImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Map;

public class Assinatura
extends AbstractComponente {
    private boolean estender = false;
    private int alinHori = 0;
    private int alinVert = 0;
    private String campoBanco = "";

    public Assinatura() {
        this.setTamanho(new Dimension(75, 75));
    }

    @Override
    public String getNomeBase() {
        return "Assinatura";
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        this.setAtualizar(false);
        super.copiarAtributosDe(comp);
        if (comp instanceof Imagem) {
            Imagem img = (Imagem)comp;
            this.setCampoDoBanco(img.getCampoDoBanco());
            this.setEstender(img.getEstender());
        }
        this.setAtualizar(true);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setAtualizar(false);
        this.setEstender(StringUtil.getBoolean(StringUtil.getValor(xml, "estender")));
        this.setCampoDoBanco(StringUtil.getValor(xml, "campoBanco"));
        super.copiarAtributosDe(xml);
        this.setAtualizar(true);
    }

    public void setCampoDoBanco(String nomeCampo) {
        this.campoBanco = nomeCampo;
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    public boolean getEstender() {
        return this.estender;
    }

    public void setEstender(boolean estender) {
        this.estender = estender;
        this.atualizar();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.alinHori;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.alinHori = alinhamento;
        this.atualizar();
    }

    @Override
    public int getAlinhamentoVertical() {
        return this.alinVert;
    }

    @Override
    public void setAlinhamentoVertical(int alinhamento) {
        this.alinVert = alinhamento;
        this.atualizar();
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder(super.getAtributos());
        bui.append(StringUtil.getTag("estender", String.valueOf(this.getEstender())));
        bui.append(StringUtil.getTag("campoBanco", this.getCampoDoBanco()));
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.setAtualizar(false);
        this.setEstender(StringUtil.getBoolean(StringUtil.getValor(atr, "estender")));
        this.setCampoDoBanco(StringUtil.getValor(atr, "campoBanco"));
        super.setAtributos(atr);
        this.setAtualizar(true);
    }

    @Override
    public Component getComponenteDigitacao(boolean edicao) {
        AssinaturaImpressao ass = new AssinaturaImpressao();
        ass.setName(this.getNome());
        ass.setDono(this);
        ass.setDimensoes(this.getDimensoes());
        ass.setEstender(this.getEstender());
        ass.setAlinhamentoHorizontal(this.getAlinhamentoHorizontal());
        ass.setAlinhamentoVertical(this.getAlinhamentoVertical());
        ass.setCampoBanco(this.getCampoDoBanco());
        return ass;
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.black);
        FontMetrics m = g.getFontMetrics();
        int w = m.stringWidth("Assinatura");
        int h = m.getHeight();
        int descent = m.getDescent();
        g.drawString("Assinatura", (d.width - w) / 2, (d.height + h) / 2 - descent);
        g.drawRect(0, 0, d.width - 1, d.height - 1);
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCamposImportacao() {
        return this.mapCampoImportacao;
    }
}

