/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.componente;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.configurador.componente.ReguaReferencial;
import jalis.laboratorio.configurador.componente.ResultadoAnterior;
import jalis.laboratorio.configurador.pagina.Pagina;
import jalis.laboratorio.configurador.propriedade.EditorCampoImportacao;
import jalis.laboratorio.configurador.propriedade.EditorFixo;
import jalis.laboratorio.configurador.propriedade.EditorInt;
import jalis.laboratorio.configurador.propriedade.EditorNomeComponente;
import jalis.laboratorio.configurador.propriedade.Propriedade;
import jalis.laboratorio.configurador.selecao.Selecao;
import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public abstract class AbstractComponente
extends JComponent
implements Componente {
    protected int local;
    protected Pagina pag;
    protected Integer contadorPagina = 1;
    protected Selecao sel;
    protected boolean resultadoAnterior;
    protected boolean imprimir;
    protected ArrayList<String> ligacoes = new ArrayList();
    protected String valorPadrao;
    protected String valorResultado;
    protected boolean removerVazio;
    protected boolean salvoValor;
    protected String campoInterfaceamento = "";
    private boolean atualizar;
    private ProtocoloCampoImportacao campoImportacao;
    protected Map<String, ProtocoloCampoImportacao> mapCampoImportacao = new HashMap<String, ProtocoloCampoImportacao>();
    private boolean relacionavelComCampoDeImportacao;
    private boolean simularAumentoDeFonte;
    protected boolean colorirReferencia;
    protected boolean corDeReferencia;
    private String expressaoDeCor;
    private String coresValorReferencia;

    public AbstractComponente() {
        this.setLayout(null);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.local = -1;
        this.resultadoAnterior = false;
        this.imprimir = true;
        this.valorPadrao = "";
        this.valorResultado = "";
        this.removerVazio = false;
        this.salvoValor = false;
        this.atualizar = true;
        this.campoImportacao = new ProtocoloCampoImportacao(null, "");
        this.relacionavelComCampoDeImportacao = false;
    }

    @Override
    public Componente getDono() {
        return this;
    }

    @Override
    public int getLocal() {
        return this.local;
    }

    @Override
    public void setLocal(int local) {
        this.local = local;
    }

    @Override
    public String getValorPadrao() {
        return this.limpaCdata(this.valorPadrao);
    }

    @Override
    public void setValorPadrao(String valor) {
        this.valorPadrao = this.limpaCdata(valor);
    }

    @Override
    public void setValorResultado(String valor) {
        if (valor != null) {
            this.valorResultado = this.limpaCdata(valor);
        }
    }

    @Override
    public String getValorResultado() {
        return this.limpaCdata(this.valorResultado);
    }

    @Override
    public void setSalvoValor(boolean salvo) {
        this.salvoValor = salvo;
    }

    @Override
    public boolean getSalvoValor() {
        return this.salvoValor;
    }

    @Override
    public void setPagina(Pagina pag) {
        this.pag = pag;
        if (pag != null && pag.getFontePadrao() != null) {
            this.setFonte(pag.getFontePadrao());
        }
    }

    @Override
    public void setContadorPagina(Integer contador) {
        if (contador != null) {
            this.contadorPagina = contador;
        }
    }

    @Override
    public Integer getContadorPagina() {
        return this.contadorPagina;
    }

    @Override
    public Rectangle getDimensoes() {
        return this.getBounds();
    }

    @Override
    public void setDimensoes(Rectangle dim) {
        this.setDimensoes(dim.x, dim.y, dim.width, dim.height);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        largura = Math.max(largura, 3);
        altura = Math.max(altura, 3);
        this.setBounds(this.validarRec(esquerda, topo, largura, altura));
        this.atualizar();
    }

    @Override
    public Dimension getTamanho() {
        return this.getSize();
    }

    @Override
    public void setTamanho(Dimension tamanho) {
        this.setSize(tamanho);
        this.atualizar();
    }

    @Override
    public int getEsquerda() {
        if (this.pag != null) {
            return this.getX() - this.pag.getMargem(0) - this.pag.getDimensoes().x;
        }
        return this.getX();
    }

    @Override
    public void setEsquerda(int esquerda) {
        if (this.pag != null) {
            this.setDimensoes(this.pag.getDimensoes().x + this.pag.getMargem(0) + esquerda, this.getY(), this.getWidth(), this.getHeight());
        } else {
            this.setDimensoes(esquerda, this.getY(), this.getWidth(), this.getHeight());
        }
    }

    @Override
    public int getTopo() {
        if (this.pag != null) {
            if (this.pag.getTipoConfiguracao() == 0) {
                return this.getY() - this.pag.retanguloArea((int)0).y;
            }
            if (this.local == 2) {
                return this.getY() - this.pag.retanguloArea((int)2).y;
            }
            if (this.pag.exibeSumario() && this.local == 4) {
                return this.getY() - this.pag.retanguloArea((int)4).y;
            }
            if (this.pag.isExibirRodapeExame() && this.local == 5) {
                return this.getY() - this.pag.retanguloArea((int)5).y;
            }
            return this.getY() - this.pag.retanguloArea((int)3).y;
        }
        return this.getY();
    }

    @Override
    public void setTopo(int topo) {
        int tmp = 0;
        if (this.pag != null) {
            tmp = this.pag.getTipoConfiguracao() == 0 ? this.pag.retanguloArea((int)0).y : (this.local == 2 ? this.pag.retanguloArea((int)2).y : (this.pag.exibeSumario() && this.local == 4 ? this.pag.retanguloArea((int)4).y : (this.pag.isExibirRodapeExame() && this.local == 5 ? this.pag.retanguloArea((int)5).y : this.pag.retanguloArea((int)3).y)));
        }
        this.setDimensoes(this.getX(), tmp + topo, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean getImprimir() {
        return this.imprimir;
    }

    @Override
    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    @Override
    public int getLargura() {
        return this.getWidth();
    }

    @Override
    public void setLargura(int largura) {
        this.setDimensoes(this.getX(), this.getY(), largura, this.getHeight());
    }

    @Override
    public int getAltura() {
        return this.getHeight();
    }

    @Override
    public void setAltura(int altura) {
        this.setDimensoes(this.getX(), this.getY(), this.getWidth(), altura);
    }

    @Override
    public void setNome(String nome) {
        nome = nome.trim();
        if (this.getNome() == null || !this.getNome().equalsIgnoreCase(nome)) {
            if (nome.length() == 0) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "A propriedade nome n\u00e3o pode ser vazia");
            } else if (nome.equalsIgnoreCase("dataResultado")) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "O nome \"" + nome + "\" \u00e9 reservado e n\u00e3o pode ser atribu\u00eddo", "Nome reservado", 0);
            } else if (this.pag != null && this.pag.contemComponenteComNome(nome)) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "O nome \"" + nome + "\" j\u00e1 foi atribu\u00eddo a outro componente do exame", "Nome j\u00e1 existente", 0);
            } else {
                String temp = this.getNome();
                this.setName(nome);
                if (temp != null) {
                    this.atualizarNomes(temp, nome);
                }
                this.atualizar();
            }
        }
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    public String getComponente() {
        return this.getNomeBase();
    }

    public void setComponente(String tipo) {
    }

    @Override
    public void atualizar() {
        if (this.atualizar) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setSelecao(Selecao sel) {
        this.sel = sel;
    }

    @Override
    public void setEditando(boolean b) {
    }

    @Override
    public boolean editando() {
        return false;
    }

    @Override
    public boolean editavel() {
        return false;
    }

    @Override
    public Font getFonte() {
        return this.getFont();
    }

    @Override
    public void setFonte(Font fonte) {
        this.setFont(fonte);
    }

    @Override
    public Color getCorDaFonte() {
        return this.getForeground();
    }

    @Override
    public void setCorDaFonte(Color cor) {
        this.setForeground(cor);
    }

    @Override
    public boolean getResultadoAnterior() {
        return this.resultadoAnterior;
    }

    @Override
    public void setResultadoAnterior(boolean resultado) {
        this.resultadoAnterior = resultado;
        if (!resultado && this.pag != null && this.getNome() != null) {
            for (Componente comp : this.pag.getComponentes()) {
                if (comp instanceof ResultadoAnterior && ((ResultadoAnterior)comp).getOrigem().equalsIgnoreCase(this.getNome())) {
                    ((ResultadoAnterior)comp).setOrigem(null);
                    continue;
                }
                if (!(comp instanceof Grafico) || !((Grafico)comp).getOrigem().equalsIgnoreCase(this.getNome()) || ((Grafico)comp).getTipoGrafico() != 0) continue;
                ((Grafico)comp).setOrigem(null);
            }
        }
        if (!this.resultadoAnterior && this instanceof ComponenteEditor) {
            ((ComponenteEditor)((Object)this)).setTagResultado(null);
        }
    }

    @Override
    public List<Propriedade> getPropriedades() {
        ArrayList<Propriedade> list = new ArrayList<Propriedade>();
        list.add(new Propriedade("componente", EditorFixo.class));
        if (!this.modoInterfaceamento()) {
            list.add(new Propriedade("esquerda", EditorInt.class));
            list.add(new Propriedade("topo", EditorInt.class));
            list.add(new Propriedade("largura", EditorInt.class));
            list.add(new Propriedade("altura", EditorInt.class));
            list.add(new Propriedade("nome", EditorNomeComponente.class));
            if (this.pag != null && this.pag.getProtocolo() != null && this.relacionavelComCampoDeImportacao) {
                list.add(new Propriedade("campo importa\u00e7\u00e3o", EditorCampoImportacao.class));
            }
        }
        return list;
    }

    @Override
    public void prepararRemocao() {
        if (this.pag != null && this.getNome() != null) {
            for (Componente comp : this.pag.getComponentes()) {
                List<String> lig = comp.getLigacoes();
                for (String nome : lig) {
                    if (!this.getNome().equalsIgnoreCase(nome)) continue;
                    lig.remove(nome);
                    break;
                }
                comp.setLigacoes(lig);
                if (comp instanceof ResultadoAnterior && ((ResultadoAnterior)comp).getOrigem().equalsIgnoreCase(this.getNome())) {
                    ((ResultadoAnterior)comp).setOrigem(null);
                    continue;
                }
                if (!(comp instanceof Grafico) || !((Grafico)comp).getOrigem().equalsIgnoreCase(this.getNome())) continue;
                ((Grafico)comp).setOrigem(null);
            }
        }
    }

    private void atualizarNomes(String antigo, String novo) {
        if (this.pag != null && antigo != null && novo != null) {
            for (Componente comp : this.pag.getComponentes()) {
                List<String> lig = comp.getLigacoes();
                for (String nome : lig) {
                    if (!nome.equalsIgnoreCase(antigo)) continue;
                    lig.remove(nome);
                    lig.add(novo);
                    break;
                }
                comp.setLigacoes(lig);
                if (comp instanceof Expressao) {
                    ((Expressao)comp).trocarIdent(antigo, novo);
                    continue;
                }
                if (comp instanceof ResultadoAnterior && ((ResultadoAnterior)comp).getOrigem().equalsIgnoreCase(antigo)) {
                    ((ResultadoAnterior)comp).setOrigem(novo);
                    continue;
                }
                if (!(comp instanceof ReguaReferencial) || !((ReguaReferencial)comp).getOrigem().equalsIgnoreCase(antigo)) continue;
                ((ReguaReferencial)comp).setOrigem(novo);
            }
        }
    }

    private Rectangle validarRec(int esq, int top, int larg, int altu) {
        int x = esq;
        int y = top;
        int w = larg;
        int h = altu;
        if (this.pag != null && this.local != -1) {
            Rectangle area = this.pag.retanguloArea(this.local);
            x = esq < area.x ? area.x : esq;
            y = top < area.y ? area.y : top;
            w = x + larg > area.x + area.width ? area.x + area.width - x : larg;
            h = y + altu > area.y + area.height ? area.y + area.height - y : altu;
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    public String getAtributos() {
        Map<String, CamposImportacao> campos = null;
        if (this.pag != null) {
            campos = this.pag.getMapsCampoImportacao();
        }
        HashMap<String, ProtocoloCampoImportacao> mapCampoImportacaoAux = new HashMap<String, ProtocoloCampoImportacao>();
        mapCampoImportacaoAux.putAll(this.mapCampoImportacao);
        if (campos != null) {
            ArrayList<String> versoesExcluir = new ArrayList<String>();
            for (String c : mapCampoImportacaoAux.keySet()) {
                if (campos.containsKey(c)) continue;
                versoesExcluir.add(c);
            }
            for (String versao : versoesExcluir) {
                mapCampoImportacaoAux.remove(versao);
            }
        }
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("local", String.valueOf(this.getLocal())));
        bui.append(StringUtil.getTag("altura", String.valueOf(this.getAltura())));
        bui.append(StringUtil.getTag("esquerda", String.valueOf(this.getEsquerda())));
        bui.append(StringUtil.getTag("largura", String.valueOf(this.getLargura())));
        bui.append(StringUtil.getTag("topo", String.valueOf(this.getTopo())));
        bui.append(StringUtil.getTag("nome", this.getNome()));
        bui.append(StringUtil.getTag("resultadoAnterior", String.valueOf(this.getResultadoAnterior())));
        bui.append(StringUtil.getTag("imprimir", String.valueOf(this.getImprimir())));
        bui.append(StringUtil.getTag("ligacoes", StringUtil.getTag("lig", this.ligacoes)));
        bui.append(StringUtil.getTag("valorPadrao", "<![CDATA[" + this.getValorPadrao() + "]]>"));
        bui.append(StringUtil.getTag("alinhamentoHorizontal", String.valueOf(this.getAlinhamentoHorizontal())));
        bui.append(StringUtil.getTag("alinhamentoVertical", String.valueOf(this.getAlinhamentoVertical())));
        bui.append(StringUtil.getTag("salvoValor", String.valueOf(this.getSalvoValor())));
        bui.append(StringUtil.getTag("removerVazio", String.valueOf(this.getRemoverVazio())));
        bui.append(StringUtil.getTag("valorResultado", "<![CDATA[ " + String.valueOf(this.getValorResultado() + " ]]>")));
        bui.append(StringUtil.getTag("contadorPagina", String.valueOf(this.getContadorPagina())));
        bui.append(StringUtil.getTag("campoInterfaceamento", this.campoInterfaceamento));
        bui.append(StringUtil.getTag("simularAumentoDeFonte", String.valueOf(this.getSimularAumentoDeFonte())));
        bui.append(StringUtil.getTag("colorirReferencia", String.valueOf(this.getColorirReferencia())));
        bui.append(StringUtil.getTag("corDeReferencia", String.valueOf(this.getCorDeReferencia())));
        bui.append(StringUtil.getTag("expressaoDeCor", String.valueOf(this.getExpressaoDeCor())));
        StringBuilder tmp = new StringBuilder();
        if (this.campoImportacao != null && !this.campoImportacao.vazio()) {
            tmp.append(StringUtil.getTag("protocolo", this.campoImportacao.protocolo.toString()));
        }
        if (mapCampoImportacaoAux.isEmpty() && this.campoImportacao != null) {
            tmp.append(StringUtil.getTag("campo", this.campoImportacao == null || this.campoImportacao.vazio() ? "" : this.campoImportacao.campoImportacao));
        }
        for (String key : mapCampoImportacaoAux.keySet()) {
            ProtocoloCampoImportacao campo = (ProtocoloCampoImportacao)mapCampoImportacaoAux.get(key);
            if (this.campoImportacao == null || this.campoImportacao.vazio()) {
                tmp.append(StringUtil.getTag("protocolo", campo.protocolo.toString()));
                this.campoImportacao = campo;
            }
            if (this.campoImportacao != null && !this.campoImportacao.vazio() && campo.versao.equalsIgnoreCase(this.campoImportacao.versao)) {
                tmp.append(StringUtil.getTag("campo", campo.vazio() ? "" : this.campoImportacao.campoImportacao));
                continue;
            }
            tmp.append(StringUtil.getTag("campo", campo.vazio() ? "" : campo.campoImportacao));
        }
        bui.append(StringUtil.getTag("campoImportacao", Funcoes.textoVazio(tmp.toString()) ? "" : tmp.toString()));
        return bui.toString();
    }

    @Override
    public void setAtributos(String atr) {
        this.local = StringUtil.getInt(atr, "local");
        this.setName(StringUtil.getValor(atr, "nome"));
        this.setAltura(StringUtil.getInt(atr, "altura"));
        this.setEsquerda(StringUtil.getInt(atr, "esquerda"));
        this.setLargura(StringUtil.getInt(atr, "largura"));
        this.setTopo(StringUtil.getInt(atr, "topo"));
        this.resultadoAnterior = StringUtil.getBoolean(atr, "resultadoAnterior");
        this.imprimir = StringUtil.getBoolean(atr, "imprimir");
        this.setLigacoes(StringUtil.getListValores(StringUtil.getValor(atr, "ligacoes"), "lig"));
        this.valorPadrao = StringUtil.getValor(atr, "valorPadrao");
        this.setAlinhamentoHorizontal(StringUtil.getInt(atr, "alinhamentoHorizontal"));
        this.setAlinhamentoVertical(StringUtil.getInt(atr, "alinhamentoVertical"));
        this.salvoValor = StringUtil.getBoolean(atr, "salvoValor");
        this.removerVazio = StringUtil.getBoolean(atr, "removerVazio");
        this.simularAumentoDeFonte = !Funcoes.textoVazio(StringUtil.getValor(atr, "simularAumentoDeFonte")) ? StringUtil.getBoolean(atr, "simularAumentoDeFonte") : ParametrosLocais.getParametro("simularAumentoFonteImpressao") != null && ParametrosLocais.getParametro("simularAumentoFonteImpressao").equals("1");
        this.valorResultado = StringUtil.getValor(atr, "valorResultado");
        this.campoInterfaceamento = StringUtil.getValor(atr, "campoInterfaceamento");
        String tmp = StringUtil.getValor(atr, "contadorPagina");
        this.contadorPagina = tmp.trim().length() > 0 && tmp.matches("\\d+") ? Integer.parseInt(tmp) : 1;
        this.setColorirReferencia(StringUtil.getBoolean(atr, "colorirReferencia"));
        this.setCorDeReferencia(StringUtil.getBoolean(atr, "corDeReferencia"));
        this.setExpressaoDeCor(StringUtil.getValor(atr, "expressaoDeCor"));
        this.setCoresValorReferencia(StringUtil.getValor(atr, "corValorReferencia"));
        String tagCampoImportacao = StringUtil.getValor(atr, "campoImportacao");
        String[] campos = StringUtil.getValores(tagCampoImportacao, "campo");
        ProtocoloCampoImportacao campoSelecionado = null;
        if (campos != null && campos.length > 0) {
            for (String campoImp : campos) {
                if (Funcoes.textoVazio(campoImp)) continue;
                String versao = campoImp.startsWith("~") ? campoImp.substring(1, campoImp.indexOf("|")) : "";
                this.campoImportacao = new ProtocoloCampoImportacao(Protocolo.getProtocolo(StringUtil.getValor(tagCampoImportacao, "protocolo")), campoImp);
                if (this.pag != null && this.validarCampoHPardini(versao)) {
                    campoSelecionado = this.campoImportacao;
                }
                if (Funcoes.textoVazio(versao) || this.mapCampoImportacao.containsKey(versao)) continue;
                this.mapCampoImportacao.put(versao, this.campoImportacao);
            }
            if (campoSelecionado != null) {
                this.campoImportacao = campoSelecionado;
            }
        }
    }

    private boolean validarCampoHPardini(String versao) {
        return this.campoImportacao.protocolo != Protocolo.HPardini || this.pag.getCamposImportacao() != null && this.pag.getCamposImportacao().getVersao() != null && this.pag.getCamposImportacao().getVersao().equalsIgnoreCase(versao);
    }

    @Override
    public void copiarAtributosDe(String xml) {
        this.setLocal(StringUtil.getInt(xml, "local"));
        this.setAltura(StringUtil.getInt(xml, "altura"));
        this.setEsquerda(StringUtil.getInt(xml, "esquerda"));
        this.setLargura(StringUtil.getInt(xml, "largura"));
        this.setTopo(StringUtil.getInt(xml, "topo"));
        this.setResultadoAnterior(StringUtil.getBoolean(StringUtil.getValor(xml, "resultadoAnterior")));
        this.setImprimir(StringUtil.getBoolean(StringUtil.getValor(xml, "imprimir")));
        this.setLigacoes(StringUtil.getListValores(StringUtil.getValor(xml, "ligacoes"), "lig"));
        this.setValorPadrao(StringUtil.getValor(xml, "valorPadrao"));
        this.setAlinhamentoHorizontal(StringUtil.getInt(xml, "alinhamentoHorizontal"));
        this.setAlinhamentoVertical(StringUtil.getInt(xml, "alinhamentoVertical"));
        this.setRemoverVazio(StringUtil.getBoolean(StringUtil.getValor(xml, "removerVazio")));
        this.campoInterfaceamento = StringUtil.getValor(xml, "campoInterfaceamento");
        this.setSimularAumentoDeFonte(StringUtil.getBoolean(xml, "simularAumentoDeFonte"));
        String tagCampoImportacao = StringUtil.getValor(xml, "campoImportacao");
        String[] campos = StringUtil.getValores(tagCampoImportacao, "campo");
        ProtocoloCampoImportacao campoSelecionado = null;
        if (campos != null && campos.length > 0) {
            for (String campoImp : campos) {
                if (Funcoes.textoVazio(campoImp)) continue;
                String versao = campoImp.startsWith("~") ? campoImp.substring(1, campoImp.indexOf("|")) : "";
                this.campoImportacao = new ProtocoloCampoImportacao(Protocolo.getProtocolo(StringUtil.getValor(tagCampoImportacao, "protocolo")), campoImp);
                if (this.campoImportacao.protocolo != Protocolo.HPardini || this.pag.getCamposImportacao() != null && this.pag.getCamposImportacao().getVersao().equalsIgnoreCase(versao)) {
                    campoSelecionado = this.campoImportacao;
                }
                if (Funcoes.textoVazio(versao) || this.mapCampoImportacao.containsKey(versao)) continue;
                this.mapCampoImportacao.put(versao, this.campoImportacao);
            }
            this.campoImportacao = campoSelecionado != null ? campoSelecionado : new ProtocoloCampoImportacao(null, "");
        }
    }

    @Override
    public void copiarAtributosDe(Componente comp) {
        if (comp != null) {
            this.setDimensoes(comp.getDimensoes());
            this.setImprimir(comp.getImprimir());
            this.setValorPadrao(comp.getValorPadrao());
            this.setCorDaFonte(comp.getCorDaFonte());
            this.setResultadoAnterior(comp.getResultadoAnterior());
            this.setAlinhamentoHorizontal(comp.getAlinhamentoHorizontal());
            this.setAlinhamentoVertical(comp.getAlinhamentoVertical());
            this.setLigacoes(comp.getLigacoes());
            this.setRemoverVazio(comp.getRemoverVazio());
            this.setCampoInterfaceamento(comp.getCampoInterfaceamento());
            this.setCampoImportacao(comp.getCampoImportacao());
        }
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
    }

    @Override
    public void setAlinhamentoVertical(int alinhamento) {
    }

    @Override
    public int getAlinhamentoVertical() {
        return 0;
    }

    @Override
    public List<String> getLigacoes() {
        return new ArrayList<String>(this.ligacoes);
    }

    @Override
    public void setLigacoes(List<String> lig) {
        this.ligacoes.clear();
        this.ligacoes.addAll(lig);
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        this.removerVazio = valor;
    }

    @Override
    public boolean getRemoverVazio() {
        return this.removerVazio;
    }

    public void setSimularAumentoDeFonte(boolean valor) {
        this.simularAumentoDeFonte = valor;
    }

    public boolean getSimularAumentoDeFonte() {
        return this.simularAumentoDeFonte;
    }

    @Override
    public void setCampoInterfaceamento(String campo) {
        if (campo != null) {
            this.campoInterfaceamento = campo;
        }
    }

    @Override
    public String getCampoInterfaceamento() {
        return this.campoInterfaceamento;
    }

    @Override
    public void setCampoImportacao(ProtocoloCampoImportacao pci) {
        if (pci != null) {
            this.campoImportacao = pci;
        }
        if (this.campoImportacao != null && !this.campoImportacao.isAlteracao()) {
            if (this.protocoloUsaComboVersoesPorExame() && !Funcoes.textoVazio(this.campoImportacao.versao)) {
                if (this.campoImportacao.exclusao) {
                    this.mapCampoImportacao.remove(this.campoImportacao.versao);
                } else {
                    this.mapCampoImportacao.put(this.campoImportacao.versao, this.campoImportacao);
                }
            } else if (!this.campoImportacao.versao.equalsIgnoreCase("0")) {
                this.mapCampoImportacao.clear();
                this.mapCampoImportacao.put(this.campoImportacao.versao, this.campoImportacao);
            }
        }
    }

    private boolean protocoloUsaComboVersoesPorExame() {
        return this.campoImportacao.protocolo == Protocolo.HPardini || this.campoImportacao.protocolo == Protocolo.INDLab || this.campoImportacao.protocolo == Protocolo.MercolabWS || this.campoImportacao.protocolo == Protocolo.Shift;
    }

    @Override
    public ProtocoloCampoImportacao getCampoImportacao() {
        return this.campoImportacao;
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.relacionavelComCampoDeImportacao;
    }

    protected void setAtualizar(boolean valor) {
        this.atualizar = valor;
    }

    public boolean getColorirReferencia() {
        return this.colorirReferencia;
    }

    public void setColorirReferencia(boolean colorirReferencia) {
        this.colorirReferencia = colorirReferencia;
    }

    public boolean getCorDeReferencia() {
        return this.corDeReferencia;
    }

    public void setCorDeReferencia(boolean corDeReferencia) {
        this.corDeReferencia = corDeReferencia;
    }

    public String getExpressaoDeCor() {
        return this.expressaoDeCor;
    }

    public void setExpressaoDeCor(String expressaoDeCor) {
        this.expressaoDeCor = expressaoDeCor;
    }

    public String getCoresValorReferencia() {
        return this.coresValorReferencia;
    }

    public void setCoresValorReferencia(String coresValorReferencia) {
        this.coresValorReferencia = coresValorReferencia;
    }

    protected boolean modoInterfaceamento() {
        return this.pag != null && this.pag.getInterfaceRelacionamento() != null;
    }

    protected void setRelacionavelComCampoDeImportacao(boolean relacionavel) {
        this.relacionavelComCampoDeImportacao = relacionavel;
    }

    protected void fireDadosAlterados() {
        if (this.sel != null) {
            this.sel.fireDadosAlterados();
        }
    }

    public String getTipoCalculoConferenciaAutomatica() {
        if (this.pag == null || Funcoes.textoVazio(this.pag.getParametros())) {
            return "Desativada";
        }
        String xmlConferenciaAutomatica = StringUtil.getValor(this.pag.getParametros(), "conferenciaAutomatica");
        String tipoCalculo = StringUtil.getValor(xmlConferenciaAutomatica, "tipoCalculo");
        if (Funcoes.textoVazio(tipoCalculo)) {
            return "Desativada";
        }
        return tipoCalculo;
    }

    protected String limpaCdata(String valor) {
        return StringUtil.limpaCdata(valor);
    }
}

