/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.acoes;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class Conversor
extends AbstractDialogoOKCancelar {
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"De", "Para"});
    private JTable table = new JTable(this.modelo);
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("Adicionar", this);
    private TTextField textValor = new TTextField(20, 3);
    private JComboBox comboValor = ComponenteFactory.novoJComboBox(new String[]{""});
    private final int COLUNA_VALOR = 0;
    private final int COLUNA_CONVERSOR = 1;

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.buttonAdicionar) {
            this.adicionaConversao();
        }
    }

    public void setComboValorPorTipoDeCampo(Integer tipo) {
        block4: {
            String[] opcoesGrupo;
            block5: {
                String[] opcoesDU;
                block3: {
                    String[] opcoesFatorRh;
                    if (tipo != 1) break block3;
                    for (String opcao : opcoesFatorRh = new String[]{"+", "-"}) {
                        this.comboValor.addItem(opcao);
                    }
                    break block4;
                }
                if (tipo != 2) break block5;
                for (String opcao : opcoesDU = new String[]{"+", "-", "Fraco", "Parcial"}) {
                    this.comboValor.addItem(opcao);
                }
                break block4;
            }
            if (tipo != 3) break block4;
            for (String opcao : opcoesGrupo = new String[]{"A", "B", "O", "AB"}) {
                this.comboValor.addItem(opcao);
            }
        }
    }

    private void adicionaConversao() {
        if (Funcoes.textoVazio(this.textValor)) {
            Funcoes.mensagem(this, "O valor a ser convertido deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textValor);
            return;
        }
        if (Funcoes.textoVazio(this.comboValor.getSelectedItem().toString())) {
            Funcoes.mensagem(this, "O valor de convers\u00e3o deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.comboValor);
            return;
        }
        if (!this.getValorJaAdicionado(this.textValor.getText())) {
            this.modelo.addLine(new String[]{this.textValor.getText(), this.comboValor.getSelectedItem().toString()});
            this.textValor.clear();
            this.comboValor.setSelectedIndex(0);
            ScreenUtil.requisitarFoco(this.textValor);
        }
    }

    private boolean getValorJaAdicionado(String valor) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!this.modelo.getValueAt(i, 0).toString().equalsIgnoreCase(valor)) continue;
            return true;
        }
        return false;
    }

    private Conversor(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private Conversor(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public static Conversor novaInstancia(Window pai) {
        if (pai instanceof Dialog) {
            return new Conversor((Dialog)pai, "Convers\u00e3o");
        }
        if (pai instanceof Frame) {
            return new Conversor((Frame)pai, "Convers\u00e3o");
        }
        return null;
    }

    private void montaTela() {
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new GridBagLayout());
        Insets insetsEsquerda = new Insets(1, 1, 0, 0);
        Insets insetsDireita = new Insets(1, 0, 0, 1);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = insetsEsquerda;
        panelCentro.add((Component)new JLabel("Converter de"), c);
        ++c.gridx;
        panelCentro.add((Component)new JLabel("Para"), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 2;
        this.textValor.setPreferredSize(new Dimension(135, 20));
        this.textValor.setMinimumSize(new Dimension(135, 20));
        panelCentro.add((Component)this.textValor, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.comboValor.setPreferredSize(new Dimension(100, 20));
        this.comboValor.setMinimumSize(new Dimension(100, 20));
        panelCentro.add((Component)this.comboValor, c);
        ++c.gridx;
        c.insets = insetsDireita;
        this.buttonAdicionar.setPreferredSize(new Dimension(80, 20));
        this.buttonAdicionar.setMinimumSize(new Dimension(80, 20));
        this.buttonAdicionar.setMnemonic('A');
        panelCentro.add((Component)this.buttonAdicionar, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(1, 1, 1, 1);
        panelCentro.add((Component)new JScrollPane(this.table), c);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int resp;
                if (Conversor.this.table.getSelectedRow() > -1 && e.getKeyCode() == 127 && (resp = Funcoes.mensagem(Conversor.this, "Deseja excluir o registro selecionado?", 4)) == 0) {
                    Conversor.this.modelo.removeLine(Conversor.this.table.getSelectedRow());
                }
            }
        });
        this.setModal(true);
        this.setSize(new Dimension(375, 230));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        ScreenUtil.requisitarFoco(this.textValor);
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append("conversao").append(">");
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String valor = this.modelo.getValueAt(i, 0).toString();
            String conversor = this.modelo.getValueAt(i, 1).toString();
            buf.append("<").append("valores").append(">");
            buf.append("<").append("valor").append(">").append(StringUtil.preencheCData(valor)).append("</").append("valor").append(">");
            buf.append("<").append("conversor").append(">").append(StringUtil.preencheCData(conversor)).append("</").append("conversor").append(">");
            buf.append("</").append("valores").append(">");
        }
        buf.append("</").append("conversao").append(">");
        return buf.toString();
    }

    public void setXML(String xml) {
        String[] valores;
        this.modelo.clear();
        for (String s : valores = StringUtil.getValores(xml, "valores")) {
            String valor = StringUtil.getValor(s, "valor");
            String conversor = StringUtil.getValor(s, "conversor");
            this.modelo.addLine(new String[]{valor, conversor});
        }
    }
}

