/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.acoes;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.configurador.acoes.Conversor;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ConfiguradorAcaoGrupoSanguineo
extends AbstractDialogoOKCancelar {
    public static final String TAG_CONVERSAO = "conversao";
    public static final String TAG_CONVERSOR = "conversor";
    public static final String TAG_CONFIG = "config";
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_CAMPO_GRUPO = "campoGrupo";
    public static final String TAG_CAMPO_FATOR = "campoFator";
    public static final String TAG_CAMPO_DU = "campoDU";
    public static final String TAG_VALORES = "valores";
    public static final String TAG_VALOR = "valor";
    public static final String CAMPO_NAO_UTILIZAR = "N\u00e3o utilizar";
    private JComboBox comboCampoGrupo = new JComboBox();
    private JComboBox comboCampoFator = new JComboBox();
    private JComboBox comboCampoDU = new JComboBox();
    private JButton buttonGrupo = ComponenteFactory.novoJButton("Convers\u00e3o", this);
    private JButton buttonFator = ComponenteFactory.novoJButton("Convers\u00e3o", this);
    private JButton buttonDU = ComponenteFactory.novoJButton("Convers\u00e3o", this);
    private String configGrupo = "";
    private String configFator = "";
    private String configDU = "";
    private JLabel labelGrupo = new JLabel("Grupo:");
    private JLabel labelFator = new JLabel("Fator:");
    private JLabel labelDU = new JLabel("DU:");

    private ConfiguradorAcaoGrupoSanguineo(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        ScreenUtil.requisitarFoco(this.comboCampoGrupo);
    }

    private ConfiguradorAcaoGrupoSanguineo(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        ScreenUtil.requisitarFoco(this.comboCampoGrupo);
    }

    public static ConfiguradorAcaoGrupoSanguineo novaInstancia(Window pai) {
        if (pai instanceof Frame) {
            return new ConfiguradorAcaoGrupoSanguineo((Frame)pai, "Configurador de a\u00e7\u00e3o");
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorAcaoGrupoSanguineo((Dialog)pai, "Configurador de a\u00e7\u00e3o");
        }
        return null;
    }

    private void montaTela() {
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new GridBagLayout());
        Insets insetsEsquerda = new Insets(1, 1, 0, 0);
        Insets insetsDireita = new Insets(1, 0, 0, 1);
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.fill = 0;
        g.insets = insetsEsquerda;
        g.gridx = 0;
        g.gridy = 0;
        g.gridwidth = 3;
        g.weightx = 0.0;
        g.weighty = 0.0;
        panelCentro.add((Component)new JLabel("Selecione os campos e os valores para atualizar os dados do cadastro do paciente:"), g);
        ++g.gridy;
        g.gridx = 0;
        g.gridwidth = 1;
        this.labelGrupo.setLabelFor(this.comboCampoGrupo);
        this.labelGrupo.setDisplayedMnemonic('G');
        panelCentro.add((Component)this.labelGrupo, g);
        ++g.gridx;
        g.weightx = 1.0;
        g.fill = 2;
        this.comboCampoGrupo.setPreferredSize(new Dimension(20, 20));
        this.comboCampoGrupo.setMinimumSize(new Dimension(20, 20));
        panelCentro.add((Component)this.comboCampoGrupo, g);
        ++g.gridx;
        g.weightx = 0.0;
        g.fill = 0;
        g.insets = insetsDireita;
        this.buttonGrupo.setPreferredSize(new Dimension(100, 20));
        this.buttonGrupo.setMinimumSize(new Dimension(100, 20));
        panelCentro.add((Component)this.buttonGrupo, g);
        ++g.gridy;
        g.gridx = 0;
        g.insets = insetsEsquerda;
        this.labelFator.setLabelFor(this.comboCampoFator);
        this.labelFator.setDisplayedMnemonic('F');
        panelCentro.add((Component)this.labelFator, g);
        ++g.gridx;
        g.weightx = 1.0;
        g.fill = 2;
        this.comboCampoFator.setPreferredSize(new Dimension(20, 20));
        this.comboCampoFator.setMinimumSize(new Dimension(20, 20));
        panelCentro.add((Component)this.comboCampoFator, g);
        ++g.gridx;
        g.weightx = 0.0;
        g.fill = 0;
        g.insets = insetsDireita;
        this.buttonFator.setPreferredSize(new Dimension(100, 20));
        this.buttonFator.setMinimumSize(new Dimension(100, 20));
        panelCentro.add((Component)this.buttonFator, g);
        ++g.gridy;
        g.gridx = 0;
        g.insets = insetsEsquerda;
        this.labelDU.setLabelFor(this.comboCampoDU);
        this.labelDU.setDisplayedMnemonic('D');
        panelCentro.add((Component)this.labelDU, g);
        ++g.gridx;
        g.weightx = 1.0;
        g.fill = 2;
        this.comboCampoDU.setPreferredSize(new Dimension(100, 20));
        this.comboCampoDU.setMaximumSize(new Dimension(100, 20));
        panelCentro.add((Component)this.comboCampoDU, g);
        ++g.gridx;
        g.weightx = 0.0;
        g.fill = 0;
        g.insets = insetsDireita;
        this.buttonDU.setPreferredSize(new Dimension(100, 20));
        this.buttonDU.setMinimumSize(new Dimension(100, 20));
        panelCentro.add((Component)this.buttonDU, g);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(new Dimension(530, 165));
        this.setLocationRelativeTo(this.getParent());
    }

    public void setCampos(String[] campos) {
        this.comboCampoGrupo.removeAllItems();
        this.comboCampoFator.removeAllItems();
        this.comboCampoDU.removeAllItems();
        this.comboCampoGrupo.addItem(CAMPO_NAO_UTILIZAR);
        this.comboCampoFator.addItem(CAMPO_NAO_UTILIZAR);
        this.comboCampoDU.addItem(CAMPO_NAO_UTILIZAR);
        if (campos != null) {
            for (String s : campos) {
                if (this.achaCampo(this.comboCampoGrupo, s) < 0) {
                    this.comboCampoGrupo.addItem(s);
                }
                if (this.achaCampo(this.comboCampoFator, s) < 0) {
                    this.comboCampoFator.addItem(s);
                }
                if (this.achaCampo(this.comboCampoDU, s) >= 0) continue;
                this.comboCampoDU.addItem(s);
            }
            this.comboCampoGrupo.setSelectedIndex(0);
            this.comboCampoFator.setSelectedIndex(0);
            this.comboCampoDU.setSelectedIndex(0);
        }
    }

    private int achaCampo(JComboBox combo, String campo) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (combo.getItemAt(i) == null || !combo.getItemAt(i).toString().equalsIgnoreCase(campo)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonGrupo) {
            this.configurarGrupo();
        } else if (e.getSource() == this.buttonDU) {
            this.configurarDU();
        } else if (e.getSource() == this.buttonFator) {
            this.configurarFator();
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public boolean acaoOk() {
        return true;
    }

    private void configurarFator() {
        Conversor conversor = Conversor.novaInstancia(this);
        if (conversor != null) {
            conversor.setComboValorPorTipoDeCampo(1);
            conversor.setXML(this.configFator);
            conversor.setVisible(true);
            if (conversor.getOK()) {
                this.configFator = conversor.getXML();
            }
        }
    }

    private void configurarDU() {
        Conversor conversor = Conversor.novaInstancia(this);
        if (conversor != null) {
            conversor.setComboValorPorTipoDeCampo(2);
            conversor.setXML(this.configDU);
            conversor.setVisible(true);
            if (conversor.getOK()) {
                this.configDU = conversor.getXML();
            }
        }
    }

    private void configurarGrupo() {
        Conversor conversor = Conversor.novaInstancia(this);
        if (conversor != null) {
            conversor.setComboValorPorTipoDeCampo(3);
            conversor.setXML(this.configGrupo);
            conversor.setVisible(true);
            if (conversor.getOK()) {
                this.configGrupo = conversor.getXML();
            }
        }
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(TAG_CONFIG).append(">");
        buf.append("<").append(TAG_CAMPO_GRUPO).append(">");
        buf.append("<").append(TAG_CAMPO).append(">").append(StringUtil.preencheCData(this.comboCampoGrupo.getSelectedItem().toString())).append("</").append(TAG_CAMPO).append(">");
        buf.append(this.configGrupo);
        buf.append("</").append(TAG_CAMPO_GRUPO).append(">");
        buf.append("<").append(TAG_CAMPO_FATOR).append(">");
        buf.append("<").append(TAG_CAMPO).append(">").append(StringUtil.preencheCData(this.comboCampoFator.getSelectedItem().toString())).append("</").append(TAG_CAMPO).append(">");
        buf.append(this.configFator);
        buf.append("</").append(TAG_CAMPO_FATOR).append(">");
        buf.append("<").append(TAG_CAMPO_DU).append(">");
        buf.append("<").append(TAG_CAMPO).append(">").append(StringUtil.preencheCData(this.comboCampoDU.getSelectedItem().toString())).append("</").append(TAG_CAMPO).append(">");
        buf.append(this.configDU);
        buf.append("</").append(TAG_CAMPO_DU).append(">");
        buf.append("</").append(TAG_CONFIG).append(">");
        return buf.toString();
    }

    public void setXML(String xml) {
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(StringUtil.getValor(xml, TAG_CONFIG))) {
            int pos;
            String campo;
            String tmp = "";
            tmp = StringUtil.getValor(xml, TAG_CAMPO_GRUPO);
            if (!Funcoes.textoVazio(tmp)) {
                campo = StringUtil.getValor(tmp, TAG_CAMPO);
                pos = this.achaCampo(this.comboCampoGrupo, campo);
                if (pos < 0) {
                    this.comboCampoGrupo.addItem(campo);
                } else {
                    this.comboCampoGrupo.setSelectedIndex(pos);
                }
                this.configGrupo = StringUtil.getValor(xml, TAG_CAMPO_GRUPO);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(xml, TAG_CAMPO_FATOR))) {
                campo = StringUtil.getValor(tmp, TAG_CAMPO);
                pos = this.achaCampo(this.comboCampoFator, campo);
                if (pos < 0) {
                    this.comboCampoFator.addItem(campo);
                } else {
                    this.comboCampoFator.setSelectedIndex(pos);
                }
                this.configFator = StringUtil.getValor(xml, TAG_CAMPO_FATOR);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(xml, TAG_CAMPO_DU))) {
                campo = StringUtil.getValor(tmp, TAG_CAMPO);
                pos = this.achaCampo(this.comboCampoDU, campo);
                if (pos < 0) {
                    this.comboCampoDU.addItem(campo);
                } else {
                    this.comboCampoDU.setSelectedIndex(pos);
                }
                this.configDU = StringUtil.getValor(xml, TAG_CAMPO_DU);
            }
        }
    }
}

