/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador.acoes;

import jalis.comum.Conexao;
import jalis.laboratorio.configurador.acoes.AbstractAcoes;
import jalis.laboratorio.configurador.acoes.ConfiguradorAcaoGrupoSanguineo;
import jalis.laboratorio.configurador.acoes.ValoresRhDU;
import jalis.laboratorio.digitacao.Resultado;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Window;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class AcaoGrupoSanguineo
extends AbstractAcoes {
    private String[] camposExame = null;
    private Exception excecaoAcao = null;
    private String xmlConfiguracao = null;
    private String resultado = null;

    @Override
    public HashMap<String, Object> getCamposValoresLayout() {
        String campoGrupo = StringUtil.getValor(this.xmlConfiguracao, "campoGrupo");
        String nomeCampoGrupo = StringUtil.getValor(campoGrupo, "campo");
        String campoFator = StringUtil.getValor(this.xmlConfiguracao, "campoFator");
        String nomeCampoFator = StringUtil.getValor(campoFator, "campo");
        String campoDU = StringUtil.getValor(this.xmlConfiguracao, "campoDU");
        String nomeCampoDU = StringUtil.getValor(campoDU, "campo");
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado(this.resultado, false);
        String valorGrupo = null;
        String valorFator = null;
        String valorDU = null;
        if (mapaResultado != null) {
            String valorConvertido;
            String conversoes;
            Object valor;
            if (!Funcoes.textoVazio(nomeCampoGrupo) && !nomeCampoGrupo.equals("N\u00e3o utilizar")) {
                valor = mapaResultado.get(nomeCampoGrupo.toLowerCase());
                valorGrupo = valor == null ? null : valor.toString().toUpperCase();
                conversoes = StringUtil.getValor(campoGrupo, "conversao");
                if (!Funcoes.textoVazio(conversoes) && !Funcoes.textoVazio(valorConvertido = this.converterValor(conversoes, valorGrupo))) {
                    valorGrupo = valorConvertido;
                }
            }
            if (!Funcoes.textoVazio(nomeCampoFator) && !nomeCampoFator.equals("N\u00e3o utilizar")) {
                valor = mapaResultado.get(nomeCampoFator.toLowerCase());
                valorFator = valor == null ? null : valor.toString().toUpperCase();
                conversoes = StringUtil.getValor(campoFator, "conversao");
                if (!Funcoes.textoVazio(conversoes) && !Funcoes.textoVazio(valorConvertido = this.converterValor(conversoes, valorFator))) {
                    valorFator = valorConvertido;
                }
            }
            if (!Funcoes.textoVazio(nomeCampoDU) && !nomeCampoDU.equals("N\u00e3o utilizar")) {
                valor = mapaResultado.get(nomeCampoDU.toLowerCase());
                valorDU = valor == null ? null : valor.toString();
                conversoes = StringUtil.getValor(campoDU, "conversao");
                if (!Funcoes.textoVazio(conversoes) && !Funcoes.textoVazio(valorConvertido = this.converterValor(conversoes, valorDU))) {
                    valorDU = valorConvertido;
                }
            }
        }
        if (!Funcoes.textoVazio(valorGrupo) && ArraysUtil.contem(TiposSanguineos.getValores(), valorGrupo)) {
            retorno.put("pac_grpsangue", valorGrupo);
        }
        if (!Funcoes.textoVazio(valorFator) && ArraysUtil.contem(ValoresRhDU.getValores(), valorFator)) {
            retorno.put("pac_fatorrh", valorFator);
        }
        if (!Funcoes.textoVazio(valorDU) && ArraysUtil.contem(ValoresRhDU.getValores(), valorDU)) {
            retorno.put("pac_fatordu", valorDU);
        }
        return retorno;
    }

    private String converterValor(String xmlConversoes, String valorConverter) {
        String[] valores;
        if (!Funcoes.textoVazio(xmlConversoes) && (valores = StringUtil.getValores(xmlConversoes, "valores")) != null) {
            for (String valorConversao : valores) {
                String original = StringUtil.getValor(valorConversao, "valor");
                String conversor = StringUtil.getValor(valorConversao, "conversor");
                if (!original.equalsIgnoreCase(valorConverter)) continue;
                return conversor;
            }
        }
        return null;
    }

    @Override
    public boolean executarAcao(HashMap<String, Object> parametros) {
        if (parametros == null || parametros.size() == 0) {
            this.excecaoAcao = new Exception("N\u00e3o h\u00e1 informa\u00e7\u00f5es nos par\u00e2metros do exame.");
            return false;
        }
        Object codigoFilial = parametros.get("codigofilial");
        if (codigoFilial == null || Funcoes.textoVazio(codigoFilial.toString())) {
            this.excecaoAcao = new Exception("O c\u00f3digo da filial n\u00e3o foi informado.");
            return false;
        }
        Object codigoPaciente = parametros.get("codigopaciente");
        if (codigoPaciente == null || Funcoes.textoVazio(codigoPaciente.toString())) {
            this.excecaoAcao = new Exception("O c\u00f3digo do paciente n\u00e3o foi informado.");
            return false;
        }
        Object resultadoExame = parametros.get("resultadoexame");
        if (resultadoExame == null || Funcoes.textoVazio(resultadoExame.toString())) {
            this.excecaoAcao = new Exception("O resultado do exame n\u00e3o foi informado.");
            return false;
        }
        this.resultado = resultadoExame.toString();
        HashMap<String, Object> valores = this.getCamposValoresLayout();
        if (valores != null && valores.size() > 0) {
            return this.atualizaPaciente(valores, parametros);
        }
        return true;
    }

    private boolean atualizaPaciente(HashMap<String, Object> valores, HashMap<String, Object> parametros) {
        StringBuilder buf = new StringBuilder();
        buf.append(" update paciente ");
        int i = 0;
        for (String chave : valores.keySet()) {
            if (i++ > 0) {
                buf.append(" , ");
            } else {
                buf.append(" set ");
            }
            buf.append(chave).append(" = ").append(StringUtil.textoDBEscape(valores.get(chave).toString()));
        }
        String codigoFilial = parametros.get("codigofilial").toString();
        String codigoPaciente = parametros.get("codigopaciente").toString();
        buf.append(" where fil_codigo = ").append(codigoFilial);
        buf.append("   and pac_codigo = ").append(codigoPaciente);
        Statement st = Conexao.getStatement();
        int qtde = 0;
        try {
            qtde = Conexao.executeUpdate(codigoFilial, st, buf.toString());
        }
        catch (Exception e) {
            this.excecaoAcao = e;
            return false;
        }
        if (qtde == 1) {
            try {
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.excecaoAcao = e;
                return false;
            }
            return true;
        }
        this.excecaoAcao = new Exception("O paciente n\u00e3o foi atualizado.");
        return false;
    }

    @Override
    public String getNomeAmigavelAcao() {
        return "Atualizar grupo sangu\u00edneo";
    }

    @Override
    public Exception getExcecaoAcao() {
        return this.excecaoAcao;
    }

    @Override
    public boolean executarConfigurador(Window pai, String[] camposExame) {
        ConfiguradorAcaoGrupoSanguineo config = ConfiguradorAcaoGrupoSanguineo.novaInstancia(pai);
        if (config != null) {
            config.setCampos(camposExame);
            config.setXML(this.xmlConfiguracao);
            config.setVisible(true);
            if (config.getOK()) {
                this.xmlConfiguracao = config.getXML();
                return true;
            }
        }
        return false;
    }

    @Override
    public String getXML() {
        String retorno = "";
        StringBuilder xml = new StringBuilder();
        xml.append("<").append("acao").append(">");
        xml.append("<").append("tipo").append(">").append(StringUtil.preencheCData(this.getNomeInternoAcao())).append("</").append("tipo").append(">");
        xml.append(this.xmlConfiguracao);
        xml.append("</").append("acao").append(">");
        return xml.toString();
    }

    @Override
    public void setXML(String xml) {
        this.xmlConfiguracao = xml;
    }

    @Override
    public String getNomeInternoAcao() {
        return "acaoGrupoSanguineo";
    }

    @Override
    public AbstractAcoes.TiposEventosAcoes getTipoEvento() {
        return AbstractAcoes.TiposEventosAcoes.CONFERENCIA_RESULTADO;
    }

    private static enum TiposSanguineos {
        A("A"),
        B("B"),
        AB("AB"),
        O("O");

        String tipo = "";

        private TiposSanguineos(String tipo) {
            this.tipo = tipo;
        }

        public String toString() {
            return this.tipo;
        }

        public static String[] getValores() {
            String[] valores = new String[]{A.toString(), B.toString(), AB.toString(), O.toString()};
            return valores;
        }
    }
}

