/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import br.com.thread.pdfbox.pdmodel.PDDocument;
import br.com.thread.pdfbox.rendering.ImageType;
import br.com.thread.pdfbox.rendering.PDFRenderer;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.apache.commons.codec.binary.Base64;

class VisualizarPdf
extends JDialog
implements ActionListener {
    private JPanel pnlCenter = new JPanel();
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);

    public static VisualizarPdf novaInstancia(Object pai, String mascaraPdf) {
        if (pai instanceof Frame) {
            return new VisualizarPdf((Frame)pai, mascaraPdf);
        }
        if (pai instanceof Dialog) {
            return new VisualizarPdf((Dialog)pai, mascaraPdf);
        }
        return null;
    }

    private VisualizarPdf(Frame pai, String mascaraPdf) {
        super(pai);
        this.montaTela(mascaraPdf);
        ScreenUtil.centralizar(this.getParent());
    }

    private VisualizarPdf(Dialog pai, String mascaraPdf) {
        super(pai);
        this.montaTela(mascaraPdf);
        ScreenUtil.centralizar(this.getParent());
    }

    private void montaTela(String mascara) {
        this.setPreferredSize(new Dimension(800, 600));
        this.setSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        JPanel panel = new JPanel(new FlowLayout(2, 3, 3));
        this.add((Component)panel, "South");
        panel.add(this.buttonFechar);
        try {
            this.carregaPdf(mascara);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar o PDF", e.getStackTrace());
        }
        ScreenUtil.centralizar(this);
    }

    private void carregaPdf(String mascara) throws IOException {
        ByteArrayInputStream bai = new ByteArrayInputStream(Base64.decodeBase64((String)mascara));
        PDDocument pdf = PDDocument.load((InputStream)bai);
        PDFRenderer pdfRenderer = new PDFRenderer(pdf);
        BufferedImage image = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
        JLabel labelAux = new JLabel(new ImageIcon(image));
        JPanel pnl = new JPanel();
        pnl.add(labelAux);
        JScrollPane scroll = new JScrollPane(pnl);
        JScrollBar scrollBar = scroll.getVerticalScrollBar();
        this.add((Component)scroll, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.dispose();
        }
    }
}

