/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.text.SimpleDateFormat;

public class ValoresReferencia
implements Cloneable {
    public static final int NORMAL = 0;
    public static final int ABAIXO_NORMAL = 1;
    public static final int ABAIXO_ABSURDO = 2;
    public static final int ACIMA_NORMAL = 3;
    public static final int ACIMA_ABSURDO = 4;
    public static final int INVALIDO = 5;
    public static final int SEM_ERRO = 6;
    public static final int ERRO_MIN_ABS_MAIOR_MIN_NOR = 7;
    public static final int ERRO_MIN_NOR_MAIOR_IGUAL_MAX_NOR = 8;
    public static final int ERRO_MAX_NOR_MAIOR_MAX_ABS = 9;
    public static final int ERRO_VALORES_INCOMPLETOS = 10;
    public static final int MIN_ABS = 0;
    public static final int MIN_NOR = 1;
    public static final int MAX_NOR = 2;
    public static final int MAX_ABS = 3;
    private String[] valores;
    private int tipo;
    private String mascara = "";
    private SimpleDateFormat format;

    public static ValoresReferencia novaInstancia(int tipo, String mascara) {
        if (mascara != null && (tipo == 1 && mascara.matches("#+(\\.#+)*(\\,#+)?") || tipo == 3 && mascara.matches("[hH]{2}:[mM]{2}(:[sS]{2})?|[mM]{2}:[sS]{2}"))) {
            if (tipo == 3) {
                mascara = mascara.replaceAll("[h|H]", "k").replace('M', 'm').replace('S', 's');
            }
            return new ValoresReferencia(tipo, mascara);
        }
        return null;
    }

    private ValoresReferencia(int tipo, String mascara) {
        this.tipo = tipo;
        this.mascara = mascara == null ? "" : mascara;
        this.valores = new String[]{"", "", "", ""};
        if (tipo == 3) {
            this.format = new SimpleDateFormat(mascara);
        }
    }

    public void setValores(String[] valores) {
        if (this.tipo == 1 && this.validaNumeros(valores) || this.tipo == 3 && this.validaHoras(valores)) {
            this.valores = valores;
        }
    }

    public String[] getValores() {
        return this.valores;
    }

    public boolean zero() {
        block3: {
            block2: {
                if (this.tipo != 1) break block2;
                for (String num : this.valores) {
                    if (num.matches("[.,0]*")) continue;
                    return false;
                }
                break block3;
            }
            if (this.tipo != 3) break block3;
            for (String hora : this.valores) {
                if (hora.matches("[0:]*")) continue;
                return false;
            }
        }
        return true;
    }

    public int getTipo() {
        return this.tipo;
    }

    public int validar() {
        if (this.valores == null) {
            return 10;
        }
        if (this.compara(this.valores[0], this.valores[1]) > 0) {
            return 7;
        }
        if (this.compara(this.valores[1], this.valores[2]) >= 0) {
            return 8;
        }
        if (this.compara(this.valores[2], this.valores[3]) > 0) {
            return 9;
        }
        return 6;
    }

    public int verificaValor(String valor) {
        int pos;
        int tmp = this.validar();
        if (tmp != 6) {
            return tmp;
        }
        for (pos = 0; pos < valor.length() && "<> ".indexOf(valor.charAt(pos)) > -1; ++pos) {
        }
        if ((valor = valor.substring(pos, valor.length())) != null && (this.tipo == 1 && valor.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") || this.tipo == 3 && valor.matches("(([01]\\d|2[0-3]):)?[0-5]\\d(:[0-5]\\d)?"))) {
            if (this.compara(valor, this.valores[1]) < 0) {
                return this.compara(valor, this.valores[0]) <= 0 ? 2 : 1;
            }
            if (this.compara(valor, this.valores[2]) > 0) {
                return this.compara(valor, this.valores[3]) >= 0 ? 4 : 3;
            }
            return 0;
        }
        return 5;
    }

    public boolean invalido() {
        return this.validar() != 6;
    }

    public void setAtributos(String atr) {
        if (atr != null && atr.length() > 0) {
            try {
                this.mascara = StringUtil.getValor(atr, "mascara");
                this.tipo = StringUtil.getInt(atr, "tipo");
                this.valores[0] = StringUtil.getValor(atr, "minAbs");
                this.valores[1] = StringUtil.getValor(atr, "minNor");
                this.valores[2] = StringUtil.getValor(atr, "maxNor");
                this.valores[3] = StringUtil.getValor(atr, "maxAbs");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ValoresReferencia: 325");
            }
        }
    }

    public String getAtributos() {
        StringBuffer buf = new StringBuffer();
        buf.append(StringUtil.getTag("mascara", this.mascara));
        buf.append(StringUtil.getTag("tipo", String.valueOf(this.tipo)));
        buf.append(StringUtil.getTag("minAbs", this.valores[0]));
        buf.append(StringUtil.getTag("minNor", this.valores[1]));
        buf.append(StringUtil.getTag("maxNor", this.valores[2]));
        buf.append(StringUtil.getTag("maxAbs", this.valores[3]));
        return buf.toString();
    }

    public Object clone() {
        try {
            ValoresReferencia clone = (ValoresReferencia)super.clone();
            clone.valores = (String[])clone.valores.clone();
            return clone;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    private int compara(String a, String b) {
        if (this.tipo == 1 && a.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?") && b.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) {
            float nB;
            float nA = Float.parseFloat(StringUtil.removeCaractere(a, '.').replace(',', '.'));
            if (nA == (nB = Float.parseFloat(StringUtil.removeCaractere(b, '.').replace(',', '.')))) {
                return 0;
            }
            return nA > nB ? 1 : -1;
        }
        if (this.tipo == 3 && a.matches("(([01]\\d|2[0-3]):)?[0-5]\\d(:[0-5]\\d)?") && b.matches("(([01]\\d|2[0-3]):)?[0-5]\\d(:[0-5]\\d)?")) {
            try {
                return a.compareTo(b);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ValoresReferencia: 390");
            }
        }
        return 0;
    }

    private boolean validaNumeros(String[] numeros) {
        if (numeros == null || numeros.length != 4) {
            return false;
        }
        for (int i = 0; i < numeros.length; ++i) {
            if (numeros[i] == null || numeros[i].matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?")) continue;
            return false;
        }
        return true;
    }

    private boolean validaHoras(String[] horas) {
        if (horas == null || horas.length != 4) {
            return false;
        }
        for (int i = 0; i < horas.length; ++i) {
            if (horas[i] == null || horas[i].matches("(([01]\\d|2[0-3]):)?[0-5]\\d(:[0-5]\\d)?")) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder bui = new StringBuilder();
        bui.append("A=");
        bui.append(this.valores[0]);
        bui.append(" | N=");
        bui.append(this.valores[1]);
        bui.append(" <-> N=");
        bui.append(this.valores[2]);
        bui.append(" | A=");
        bui.append(this.valores[3]);
        return bui.toString();
    }
}

