/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;

public class ValoresPercentualDeltaCheck
implements Cloneable {
    private String percentualVariacao;
    private Double intraIndividual;
    private Double interIndividual;
    private Double analitico;
    private Boolean rcvI95;
    private Boolean rcvI99;
    private Boolean rcvII95;
    private Boolean rcvII99;

    public Boolean existeValoresDeltaCheck() {
        return this.intraIndividual != null && this.interIndividual != null && this.analitico != null && this.rcvI95 != null && this.rcvI99 != null && this.rcvII95 != null && this.rcvII99 != null;
    }

    public String getPercentualVariacao() {
        return this.percentualVariacao;
    }

    public void setPercentualVariacao(String percentualVariacao) {
        this.percentualVariacao = percentualVariacao;
    }

    public Double getIntraIndividual() {
        return this.intraIndividual;
    }

    public void setIntraIndividual(Double intraIndividual) {
        this.intraIndividual = intraIndividual;
    }

    public Double getInterIndividual() {
        return this.interIndividual;
    }

    public void setInterIndividual(Double interIndividual) {
        this.interIndividual = interIndividual;
    }

    public Double getAnalitico() {
        return this.analitico;
    }

    public void setAnalitico(Double analitico) {
        this.analitico = analitico;
    }

    public Boolean getRcvI95() {
        return this.rcvI95;
    }

    public void setRcvI95(Boolean rcvI95) {
        this.rcvI95 = rcvI95;
    }

    public Boolean getRcvI99() {
        return this.rcvI99;
    }

    public void setRcvI99(Boolean rcvI99) {
        this.rcvI99 = rcvI99;
    }

    public Boolean getRcvII95() {
        return this.rcvII95;
    }

    public void setRcvII95(Boolean rcvII95) {
        this.rcvII95 = rcvII95;
    }

    public Boolean getRcvII99() {
        return this.rcvII99;
    }

    public void setRcvII99(Boolean rcvII99) {
        this.rcvII99 = rcvII99;
    }

    public void setAtributos(String atr) {
        if (atr != null && atr.length() > 0) {
            try {
                this.intraIndividual = StringUtil.getValor(atr, "intraIndividual").isEmpty() ? null : Double.valueOf(StringUtil.getValor(atr, "intraIndividual").replace(".", "").replace(",", "."));
                this.interIndividual = StringUtil.getValor(atr, "interIndividual").isEmpty() ? null : Double.valueOf(StringUtil.getValor(atr, "interIndividual").replace(".", "").replace(",", "."));
                this.analitico = StringUtil.getValor(atr, "analitico").isEmpty() ? null : Double.valueOf(StringUtil.getValor(atr, "analitico").replace(".", "").replace(",", "."));
                this.rcvI95 = Boolean.valueOf(StringUtil.getValor(atr, "rcvI95"));
                this.rcvI99 = Boolean.valueOf(StringUtil.getValor(atr, "rcvI99"));
                this.rcvII95 = Boolean.valueOf(StringUtil.getValor(atr, "rcvII95"));
                this.rcvII99 = Boolean.valueOf(StringUtil.getValor(atr, "rcvII99"));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ValoresPercentualDeltaCheck: 82");
            }
        }
    }

    public String getAtributos() {
        StringBuffer buf = new StringBuffer();
        buf.append(StringUtil.getTag("intraIndividual", this.intraIndividual != null ? Funcoes.formataDecimal(this.intraIndividual) : ""));
        buf.append(StringUtil.getTag("interIndividual", this.interIndividual != null ? Funcoes.formataDecimal(this.interIndividual) : ""));
        buf.append(StringUtil.getTag("analitico", this.analitico != null ? Funcoes.formataDecimal(this.analitico) : ""));
        buf.append(StringUtil.getTag("rcvI95", String.valueOf(this.rcvI95)));
        buf.append(StringUtil.getTag("rcvI99", String.valueOf(this.rcvI99)));
        buf.append(StringUtil.getTag("rcvII95", String.valueOf(this.rcvII95)));
        buf.append(StringUtil.getTag("rcvII99", String.valueOf(this.rcvII99)));
        return buf.toString();
    }

    public String toString() {
        if (this.getPercentualVariacao().toString().isEmpty()) {
            return "";
        }
        return Funcoes.formataDecimal(Double.parseDouble(this.getPercentualVariacao().toString()));
    }

    public Object clone() {
        try {
            ValoresPercentualDeltaCheck clone = (ValoresPercentualDeltaCheck)super.clone();
            this.intraIndividual = clone.getIntraIndividual();
            this.interIndividual = clone.getInterIndividual();
            this.analitico = clone.getAnalitico();
            this.rcvI95 = clone.getRcvI95();
            this.rcvI99 = clone.getRcvI99();
            this.rcvII95 = clone.getRcvII95();
            this.rcvII99 = clone.getRcvII99();
            return clone;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }
}

