/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.configurador.AreaLivre;
import jalis.laboratorio.configurador.VisualizarPdf;
import jalis.laboratorio.configurador.pagina.DialogoDimensoesAssinaturaDigital;
import jalis.laboratorio.configurador.pagina.DimensoesAssinaturaDigitalDTO;
import jalis.laboratorio.configurador.pagina.LinhasCorpo;
import jalis.laboratorio.configurador.pagina.ParametrosAssinatura;
import jalis.laboratorio.impressao.CampoAssinaturaLaudo;
import jalis.util.CorComboBox;
import jalis.util.DialogoCor;
import jalis.util.DialogoFonte;
import jalis.util.DocumentoLimite;
import jalis.util.DocumentoMascara;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.apache.commons.codec.binary.Base64;

public class DialogoParamCabecRodape
extends JDialog
implements ActionListener,
DisposeListener {
    private JTextField textAlturaPag = new JTextField();
    private JTextField textLarguraPag = new JTextField();
    private JTextField textEsquerda = new JTextField();
    private JTextField textDireita = new JTextField();
    private JTextField textSuperior = new JTextField();
    private JTextField textInferior = new JTextField();
    private JTextField textAlturaSumario = new JTextField();
    private JTextField textAlturaRodape = new JTextField();
    private JTextField textDistancia = new JTextField();
    private JTextField textPosicaoRodape = new JTextField();
    private JCheckBox checkExibirSumario = ComponenteFactory.novoJCheckBox("Sum\u00e1rio", this);
    private JCheckBox checkExibirRodapeExame = ComponenteFactory.novoJCheckBox("Rodap\u00e9 Exame", this);
    private JCheckBox checkAssinaturaSumario = ComponenteFactory.novoJCheckBox("Assinatura Sum\u00e1rio", this);
    private JCheckBox checkAssinaturaRodape = ComponenteFactory.novoJCheckBox("Assinatura Rodap\u00e9", this);
    private JCheckBox checkReferenciaSumario = ComponenteFactory.novoJCheckBox("Refer\u00eancia Sum\u00e1rio", this);
    private JCheckBox checkImprimirAssinaturaEletronicaSumario = new JCheckBox("Imprimir assinatura eletr\u00f4nica");
    private JCheckBox checkImprimirAssinaturaEletronicaRodape = new JCheckBox("Imprimir assinatura eletr\u00f4nica");
    private JLabel labelMargemAssinaturaDigitalSumario = new JLabel("Margem Assinatura Digital:");
    private JLabel labelMargemAssinaturaDigitalRodape = new JLabel("Margem Assinatura Digital:");
    private TTextField textMargemAssinaturaDigitalSumario = new TTextField(5, 2);
    private TTextField textMargemAssinaturaDigitalRodape = new TTextField(5, 2);
    private JComboBox comboCampoSumario = ComponenteFactory.novoJComboBox(null, new Dimension(250, 20));
    private SteppedComboBox comboCampoSumarioAssinatura = new SteppedComboBox(180);
    private JComboBox comboCampoRodape = ComponenteFactory.novoJComboBox(null, new Dimension(250, 20));
    private SteppedComboBox comboCampoRodapeAssinatura = new SteppedComboBox(180);
    private JComboBox comboAlinSumario = ComponenteFactory.novoJComboBox(new String[]{"Esquerda", "Centralizado", "Direita"}, new Dimension(150, 20));
    private JComboBox comboAlinReferenciaSumario = ComponenteFactory.novoJComboBox(new String[]{"Esquerda", "Centralizado", "Direita"}, new Dimension(150, 20));
    private JComboBox comboAlinRodape = ComponenteFactory.novoJComboBox(new String[]{"Esquerda", "Centralizado", "Direita"}, new Dimension(150, 20));
    private JComboBox comboQtdeSumario = ComponenteFactory.novoJComboBox(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}, new Dimension(45, 20));
    private JComboBox comboQtdeRodape = ComponenteFactory.novoJComboBox(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}, new Dimension(45, 20));
    private JComboBox comboPosSumario = ComponenteFactory.novoJComboBox(new String[]{"Topo", "Base"}, new Dimension(80, 20));
    private JComboBox comboPosRodape = ComponenteFactory.novoJComboBox(new String[]{"Topo", "Base", "Absoluto"}, new Dimension(85, 20));
    private JComboBox comboTipoSumario = ComponenteFactory.novoJComboBox(new String[]{"Interno", "Externo"}, new Dimension(80, 20));
    private JComboBox comboTipoRodape = ComponenteFactory.novoJComboBox(new String[]{"Interno", "Externo"}, new Dimension(90, 20));
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JComboBox comboQualidadeImagem = ComponenteFactory.novoJComboBox(new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90", "100"}, new Dimension(45, 20));
    private String[] separadores = new String[]{",", ";", "/", "-", ".", "|"};
    private JComboBox comboSeparaCodigoExame = new JComboBox<String>(this.separadores);
    private JComboBox comboSeparaSOA = new JComboBox<String>(this.separadores);
    private JComboBox comboSeparaCOA = new JComboBox<String>(this.separadores);
    private JButton buttonFonteReferencia = ComponenteFactory.novoJButton("Fonte", this);
    private JTextField textAlturaReferencia = new JTextField();
    private JTextField textPosicaoReferencia = new JTextField();
    private Font fonteReferencia = null;
    private JCheckBox checkIdentificadorReferencia = ComponenteFactory.novoJCheckBox("Identificar refer\u00eancia no corpo do exame", this);
    private JTextField textPosicaoXIdentificadorReferencia = new JTextField();
    private JTextField textPosicaoYIdentificadorReferencia = new JTextField();
    private Font fonteIdentificadorReferencia = null;
    private JButton buttonFonteIdentificador = ComponenteFactory.novoJButton("Fonte", this);
    private JPanel panelLinhasCorpo = new JPanel(new GridBagLayout());
    private JCheckBox checkLinhasCorpo = ComponenteFactory.novoJCheckBox("Criar linhas no corpo do exame", this);
    private JCheckBox checkAcompanharResultado = ComponenteFactory.novoJCheckBox("Acompanhar altura do resultado", null);
    private TTextField textLinhaX = new TTextField();
    private JComboBox comboTipoLinhaX = new JComboBox<String>(new String[]{"Fixo", "Intervalo"});
    private TTextField textLinhaY = new TTextField();
    private JComboBox comboTipoLinhaY = new JComboBox<String>(new String[]{"Fixo", "Intervalo"});
    private CorComboBox comboCorLinha = new CorComboBox();
    private JButton buttonCorLinha = ComponenteFactory.novoJButton("...", this, new Dimension(20, 20), new Dimension(20, 20));
    private JButton buttonMascara = ComponenteFactory.novoJButton("M\u00e1scara", this);
    private JMenuItem itemImportar = new JMenuItem("Importar PDF");
    private JMenuItem itemRemover = new JMenuItem("Remover PDF");
    private JMenuItem itemVisualizar = new JMenuItem("Visualizar PDF");
    private JPopupMenu menu = new JPopupMenu();
    private AreaLivre areaLivre = new AreaLivre();
    private DecimalFormat parser = new DecimalFormat("0.00");
    private boolean ok = false;
    private boolean isPermitirConfigurarMascaraPDF = false;
    private String mascaraPdf = "";
    private DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigitalSumario;
    private DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigitalRodape;

    public static DialogoParamCabecRodape novaInstancia(Object pai, boolean isPermitirConfigurarMascaraPDF) {
        if (pai instanceof Frame) {
            return new DialogoParamCabecRodape((Frame)pai, isPermitirConfigurarMascaraPDF);
        }
        if (pai instanceof Dialog) {
            return new DialogoParamCabecRodape((Dialog)pai, isPermitirConfigurarMascaraPDF);
        }
        return null;
    }

    public DialogoParamCabecRodape(Frame pai, boolean isPermitirConfigurarMascaraPDF) {
        super(pai, "Configura\u00e7\u00e3o de par\u00e2metros de cabe\u00e7alho e rodap\u00e9", true);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.iniciar();
    }

    public DialogoParamCabecRodape(Dialog pai, boolean isPermitirConfigurarMascaraPDF) {
        super(pai, "Configura\u00e7\u00e3o de par\u00e2metros de cabe\u00e7alho e rodap\u00e9", true);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.iniciar();
    }

    private boolean validaCampos() {
        if (this.checkLinhasCorpo.isSelected()) {
            if (Funcoes.textoVazio(this.textLinhaX.getText()) || Funcoes.textoVazio(this.textLinhaY.getText())) {
                Funcoes.mensagem(this, "As posi\u00e7\u00f5es da coluna/linha devem ser informadas", 1);
                return false;
            }
            if (this.comboTipoLinhaX.getSelectedItem().toString().equalsIgnoreCase("Intervalo") && this.textLinhaX.getText().indexOf(",") > -1) {
                Funcoes.mensagem(this, "A posi\u00e7\u00e3o da linha X s\u00f3 pode ter um intervalo", 1);
                return false;
            }
            if (this.comboTipoLinhaY.getSelectedItem().toString().equalsIgnoreCase("Intervalo") && this.textLinhaY.getText().indexOf(",") > -1) {
                Funcoes.mensagem(this, "A posi\u00e7\u00e3o da linha Y s\u00f3 pode ter um intervalo", 1);
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            if (this.validaCampos()) {
                this.ok = o == this.buttonOk;
                this.dispose();
            }
        } else if (o == this.checkExibirSumario || o == this.checkAssinaturaSumario || o == this.checkAssinaturaRodape || o == this.checkReferenciaSumario) {
            if (o == this.checkExibirSumario && !this.checkExibirSumario.isSelected()) {
                this.checkAssinaturaSumario.setSelected(false);
                this.checkReferenciaSumario.setSelected(false);
            } else if (o == this.checkAssinaturaSumario && this.checkAssinaturaSumario.isSelected()) {
                this.checkExibirSumario.setSelected(true);
                this.checkReferenciaSumario.setSelected(false);
                if (this.comboCampoSumario.getSelectedIndex() == 5 || this.comboCampoSumario.getSelectedIndex() == 6) {
                    this.checkImprimirAssinaturaEletronicaSumario.setSelected(true);
                }
            } else if (o == this.checkAssinaturaSumario && !this.checkAssinaturaSumario.isSelected()) {
                this.checkImprimirAssinaturaEletronicaSumario.setSelected(false);
            } else if (o == this.checkReferenciaSumario && this.checkReferenciaSumario.isSelected()) {
                this.checkExibirSumario.setSelected(true);
                this.checkAssinaturaSumario.setSelected(false);
            }
            this.habilitarDesabilitar();
        } else if (o == this.checkLinhasCorpo) {
            this.habilitarLinhasCorpo();
        } else if (o == this.checkIdentificadorReferencia) {
            this.habilitarDesabilitar();
        } else if (o == this.buttonFonteReferencia) {
            DialogoFonte df = new DialogoFonte(this, "Configura\u00e7\u00e3o de Fonte", true);
            if (this.fonteReferencia != null) {
                df.setFonte(this.fonteReferencia);
            }
            df.setVisible(true);
            if (df.ok()) {
                this.fonteReferencia = df.getFonte();
            }
        } else if (o == this.buttonCorLinha) {
            DialogoCor dc = DialogoCor.novaInstancia(this, "Configura\u00e7\u00e3o de Cor");
            if (dc != null) {
                dc.setCor(this.comboCorLinha.getCorSelecionada());
                dc.setVisible(true);
                if (dc.ok()) {
                    this.comboCorLinha.setActionCommand("cancelado");
                    this.comboCorLinha.setCorPersonalizada(dc.getCor());
                    this.comboCorLinha.setCorSelecionada(dc.getCor());
                    this.comboCorLinha.setActionCommand("ok");
                }
            }
        } else if (o == this.buttonFonteIdentificador) {
            DialogoFonte df = new DialogoFonte(this, "Configura\u00e7\u00e3o de Fonte", true);
            if (this.fonteIdentificadorReferencia != null) {
                df.setFonte(this.fonteIdentificadorReferencia);
            }
            df.setVisible(true);
            if (df.ok()) {
                this.fonteIdentificadorReferencia = df.getFonte();
            }
        }
    }

    private void habilitarLinhasCorpo() {
        boolean b = this.checkLinhasCorpo.isSelected();
        this.textLinhaX.setEnabled(b);
        this.textLinhaY.setEnabled(b);
        this.comboTipoLinhaX.setEnabled(b);
        this.comboTipoLinhaY.setEnabled(b);
        this.comboCorLinha.setEnabled(b);
        this.buttonCorLinha.setEnabled(b);
        this.checkAcompanharResultado.setEnabled(b);
    }

    public void setAtributosPagina(double[] tamanho, double[] margens) {
        if (tamanho != null && tamanho.length == 2 && margens != null && margens.length == 4) {
            try {
                ((DocumentoMascara)this.textLarguraPag.getDocument()).setValor(this.parser.format(tamanho[0]));
                ((DocumentoMascara)this.textAlturaPag.getDocument()).setValor(this.parser.format(tamanho[1]));
                ((DocumentoMascara)this.textEsquerda.getDocument()).setValor(this.parser.format(margens[0]));
                ((DocumentoMascara)this.textDireita.getDocument()).setValor(this.parser.format(margens[1]));
                ((DocumentoMascara)this.textSuperior.getDocument()).setValor(this.parser.format(margens[2]));
                ((DocumentoMascara)this.textInferior.getDocument()).setValor(this.parser.format(margens[3]));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoParamCabecRodape: 160");
            }
        }
    }

    public double[] getTamanhoPagina() {
        try {
            return new double[]{this.parser.parse(((DocumentoMascara)this.textLarguraPag.getDocument()).getValor()).doubleValue(), this.parser.parse(((DocumentoMascara)this.textAlturaPag.getDocument()).getValor()).doubleValue()};
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoParamCabecRodape: 139");
            return new double[]{0.0, 0.0};
        }
    }

    public String getSeparadorExame() {
        return this.comboSeparaCodigoExame.getSelectedItem().toString();
    }

    public String getQualidadeImagem() {
        return this.comboQualidadeImagem.getSelectedItem().toString();
    }

    public String getSeparadorSOA() {
        return this.comboSeparaSOA.getSelectedItem().toString();
    }

    public String getSeparadorCOA() {
        return this.comboSeparaCOA.getSelectedItem().toString();
    }

    public void setDistanciaEntreExames(float distancia) {
        ((DocumentoMascara)this.textDistancia.getDocument()).setValor(this.parser.format(distancia));
    }

    public float getDistanciaEntreExames() {
        try {
            return this.parser.parse(((DocumentoMascara)this.textDistancia.getDocument()).getValor()).floatValue();
        }
        catch (ParseException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoParamCabecRodape: 162");
            return 0.0f;
        }
    }

    public Font getFonteReferencia() {
        return this.fonteReferencia;
    }

    public void setFonteReferencia(Font fonte) {
        this.fonteReferencia = fonte;
    }

    public void setSeparadorExame(String s) {
        if (s != null) {
            this.comboSeparaCodigoExame.setSelectedItem(s);
        }
    }

    public void setQualidadeImagem(String s) {
        if (s != null) {
            this.comboQualidadeImagem.setSelectedItem(s);
        }
    }

    public void setSeparadorSOA(String s) {
        if (s != null) {
            this.comboSeparaSOA.setSelectedItem(s);
        }
    }

    public void setSeparadorCOA(String s) {
        if (s != null) {
            this.comboSeparaCOA.setSelectedItem(s);
        }
    }

    public void setCamposAssinatura(CampoAssinaturaLaudo[] campos) {
        if (campos != null) {
            this.comboCampoSumario.removeAllItems();
            this.comboCampoRodape.removeAllItems();
            this.comboCampoSumarioAssinatura.removeAllItems();
            this.comboCampoRodapeAssinatura.removeAllItems();
            for (int i = 0; i < campos.length; ++i) {
                this.comboCampoSumario.addItem(campos[i]);
                this.comboCampoRodape.addItem(campos[i]);
                if (i <= 0 || i >= 5) continue;
                this.comboCampoSumarioAssinatura.addItem(campos[i]);
                this.comboCampoRodapeAssinatura.addItem(campos[i]);
            }
        }
    }

    public void setAssinaturas(ParametrosAssinatura sumario, ParametrosAssinatura rodape) {
        if (sumario != null && rodape != null) {
            try {
                this.setAssinaturaSumario(sumario);
                this.setAssinaturaRodape(rodape);
                this.mostrarCampoPosicao();
                this.habilitarDesabilitar();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoParamCabecRodape");
            }
        }
    }

    private void setAssinaturaSumario(ParametrosAssinatura sumario) {
        int i;
        this.checkAssinaturaSumario.setSelected(sumario.exibir());
        this.checkReferenciaSumario.setSelected(sumario.exibirReferencia());
        this.comboQtdeSumario.setSelectedItem(String.valueOf(sumario.getQuantidade()));
        this.comboAlinSumario.setSelectedIndex(this.getIndiceAlinhamentoAssinatura(sumario.getAlinhamento()));
        this.textAlturaSumario.setText(String.valueOf(sumario.getAltura()));
        this.comboPosSumario.setSelectedIndex(sumario.getPosicao() == 1 ? 0 : 1);
        this.comboTipoSumario.setSelectedIndex(this.getIndiceTipoAssinatura(sumario.getTipo()));
        for (i = 0; i < this.comboCampoSumario.getItemCount(); ++i) {
            if (!(this.comboCampoSumario.getItemAt(i) instanceof CampoAssinaturaLaudo) || !((CampoAssinaturaLaudo)((Object)this.comboCampoSumario.getItemAt(i))).getIdParaXML().equalsIgnoreCase(sumario.getCampoBanco().getIdParaXML())) continue;
            this.comboCampoSumario.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < this.comboCampoSumarioAssinatura.getItemCount(); ++i) {
            if (!(this.comboCampoSumarioAssinatura.getItemAt(i) instanceof CampoAssinaturaLaudo) || !((CampoAssinaturaLaudo)((Object)this.comboCampoSumarioAssinatura.getItemAt(i))).getIdParaXML().equalsIgnoreCase(sumario.getAssinaturaEletronica().getIdParaXML())) continue;
            this.comboCampoSumarioAssinatura.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < this.comboCampoRodapeAssinatura.getItemCount(); ++i) {
            if (!(this.comboCampoRodapeAssinatura.getItemAt(i) instanceof CampoAssinaturaLaudo) || !((CampoAssinaturaLaudo)((Object)this.comboCampoRodapeAssinatura.getItemAt(i))).getIdParaXML().equalsIgnoreCase(sumario.getAssinaturaEletronica().getIdParaXML())) continue;
            this.comboCampoRodapeAssinatura.setSelectedIndex(i);
            break;
        }
        this.setMargemAssinaturaDigitalSumario(sumario.getMargemAssinaturaDigital());
        boolean imprimeAssinaturaEletronica = sumario.isImprimirAssinaturaEletronica();
        this.setImprimirAssinaturaEletronicaSumario(imprimeAssinaturaEletronica);
        this.dimensoesAssinaturaDigitalSumario = sumario.getDimensoesAssinaturaDigital();
    }

    private void setAssinaturaRodape(ParametrosAssinatura rodape) {
        int i;
        this.checkAssinaturaRodape.setSelected(rodape.exibir());
        this.comboQtdeRodape.setSelectedItem(String.valueOf(rodape.getQuantidade()));
        this.comboAlinRodape.setSelectedIndex(this.getIndiceAlinhamentoAssinatura(rodape.getAlinhamento()));
        this.textAlturaRodape.setText(String.valueOf(rodape.getAltura()));
        int posicaoAux = rodape.getPosicao() == 3 ? 1 : 2;
        this.comboPosRodape.setSelectedIndex(rodape.getPosicao() == 1 ? 0 : posicaoAux);
        this.comboTipoRodape.setSelectedIndex(this.getIndiceTipoAssinatura(rodape.getTipo()));
        this.textPosicaoRodape.setText(String.valueOf(rodape.getPosicaoAbsoluto()));
        for (i = 0; i < this.comboCampoRodape.getItemCount(); ++i) {
            if (!(this.comboCampoRodape.getItemAt(i) instanceof CampoAssinaturaLaudo) || !((CampoAssinaturaLaudo)((Object)this.comboCampoRodape.getItemAt(i))).getIdParaXML().equalsIgnoreCase(rodape.getCampoBanco().getIdParaXML())) continue;
            this.comboCampoRodape.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < this.comboCampoRodapeAssinatura.getItemCount(); ++i) {
            if (!(this.comboCampoRodapeAssinatura.getItemAt(i) instanceof CampoAssinaturaLaudo) || !((CampoAssinaturaLaudo)((Object)this.comboCampoRodapeAssinatura.getItemAt(i))).getIdParaXML().equalsIgnoreCase(rodape.getAssinaturaEletronica().getIdParaXML())) continue;
            this.comboCampoRodapeAssinatura.setSelectedIndex(i);
            break;
        }
        this.setImprimirAssinaturaEletronicaRodape(rodape.isImprimirAssinaturaEletronica());
        this.setMargemAssinaturaDigitalRodape(rodape.getMargemAssinaturaDigital());
        this.dimensoesAssinaturaDigitalRodape = rodape.getDimensoesAssinaturaDigital();
    }

    private int getIndiceAlinhamentoAssinatura(int alinhamento) {
        int alinhamentoAux = alinhamento == 0 ? 1 : 2;
        return alinhamento == 2 ? 0 : alinhamentoAux;
    }

    private int getIndiceTipoAssinatura(int tipo) {
        return tipo == 0 ? 0 : 1;
    }

    public void setExibirSumario(boolean exibir) {
        this.checkExibirSumario.setSelected(exibir);
    }

    public void setExibirRodapeExame(boolean exibir) {
        this.checkExibirRodapeExame.setSelected(exibir);
    }

    public boolean exibirSumario() {
        return this.checkExibirSumario.isSelected();
    }

    public boolean isExibirRodapeExame() {
        return this.checkExibirRodapeExame.isSelected();
    }

    public int getAlinhamentoReferenciaSumario() {
        return this.comboAlinReferenciaSumario.getSelectedIndex() == 0 ? 2 : (this.comboAlinReferenciaSumario.getSelectedIndex() == 1 ? 0 : 4);
    }

    public void setAlinhamentoReferenciaSumario(int alinha) {
        this.comboAlinReferenciaSumario.setSelectedIndex(alinha == 2 ? 0 : (alinha == 0 ? 1 : 2));
    }

    public int getAlturaReferenciaSumario() {
        int retorno = 0;
        try {
            retorno = this.parser.parse(this.textAlturaReferencia.getText()).intValue();
        }
        catch (ParseException e) {
            return retorno;
        }
        return retorno;
    }

    public void setAlturaReferenciaSumario(int h) {
        this.textAlturaReferencia.setText(String.valueOf(h));
    }

    public int getPosicaoReferenciaSumario() {
        try {
            return this.parser.parse(this.textPosicaoReferencia.getText()).intValue();
        }
        catch (ParseException parseException) {
            return 0;
        }
    }

    public void setPosicaoReferenciaSumario(int h) {
        this.textPosicaoReferencia.setText(String.valueOf(h));
    }

    public double[] getMargens() {
        try {
            return new double[]{this.parser.parse(((DocumentoMascara)this.textEsquerda.getDocument()).getValor()).doubleValue(), this.parser.parse(((DocumentoMascara)this.textDireita.getDocument()).getValor()).doubleValue(), this.parser.parse(((DocumentoMascara)this.textSuperior.getDocument()).getValor()).doubleValue(), this.parser.parse(((DocumentoMascara)this.textInferior.getDocument()).getValor()).doubleValue()};
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoParamCabecRodape: 197");
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
    }

    public ParametrosAssinatura getAssinaturaSumario() {
        ParametrosAssinatura parametrosAssinaturaSumario = ParametrosAssinatura.novaInstanciaLimpa();
        try {
            CampoAssinaturaLaudo campoBanco = (CampoAssinaturaLaudo)((Object)this.comboCampoSumario.getSelectedItem());
            parametrosAssinaturaSumario.setCampoBanco(campoBanco);
            CampoAssinaturaLaudo campoSelecionado = (CampoAssinaturaLaudo)((Object)this.comboCampoSumarioAssinatura.getSelectedItem());
            parametrosAssinaturaSumario.setAssinaturaEletronica(campoSelecionado);
            String tmp = (String)this.comboQtdeSumario.getSelectedItem();
            parametrosAssinaturaSumario.setQuantidade(Funcoes.textoVazio(tmp) ? 5 : Integer.parseInt(tmp));
            int alinhamentoAux = this.comboAlinSumario.getSelectedIndex() == 1 ? 0 : 4;
            parametrosAssinaturaSumario.setAlinhamento(this.comboAlinSumario.getSelectedIndex() == 0 ? 2 : alinhamentoAux);
            tmp = this.textAlturaSumario.getText();
            parametrosAssinaturaSumario.setAltura(tmp.length() > 0 ? Integer.parseInt(tmp) : 75);
            parametrosAssinaturaSumario.setPosicao(this.comboPosSumario.getSelectedIndex() == 0 ? 1 : 3);
            parametrosAssinaturaSumario.setTipo(this.comboTipoSumario.getSelectedIndex() == 0 ? 0 : 1);
            parametrosAssinaturaSumario.setExibir(this.checkAssinaturaSumario.isSelected());
            parametrosAssinaturaSumario.setExibirReferencia(this.checkReferenciaSumario.isSelected());
            parametrosAssinaturaSumario.setImprimirAssinaturaEletronica(this.getImprimirAssinaturaEletronicaSumario());
            parametrosAssinaturaSumario.setMargemAssinaturaDigital(this.getMargemAssinaturaDigitalSumario());
            parametrosAssinaturaSumario.setDimensoesAssinaturaDigital(this.dimensoesAssinaturaDigitalSumario);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoParamCabecRodape: 285");
        }
        return parametrosAssinaturaSumario;
    }

    public ParametrosAssinatura getAssinaturaRodape() {
        ParametrosAssinatura parametrosAssinaturaRodape = ParametrosAssinatura.novaInstanciaLimpa();
        try {
            CampoAssinaturaLaudo campobanco = (CampoAssinaturaLaudo)((Object)this.comboCampoRodape.getSelectedItem());
            parametrosAssinaturaRodape.setCampoBanco(campobanco);
            CampoAssinaturaLaudo campoSelecionado = (CampoAssinaturaLaudo)((Object)this.comboCampoRodapeAssinatura.getSelectedItem());
            parametrosAssinaturaRodape.setAssinaturaEletronica(campoSelecionado);
            String tmp = (String)this.comboQtdeRodape.getSelectedItem();
            parametrosAssinaturaRodape.setQuantidade(Funcoes.textoVazio(tmp) ? 5 : Integer.parseInt(tmp));
            int alinhamentoAux = this.comboAlinRodape.getSelectedIndex() == 1 ? 0 : 4;
            parametrosAssinaturaRodape.setAlinhamento(this.comboAlinRodape.getSelectedIndex() == 0 ? 2 : alinhamentoAux);
            tmp = this.textAlturaRodape.getText();
            parametrosAssinaturaRodape.setAltura(tmp.length() > 0 ? Integer.parseInt(tmp) : 75);
            int posicaoAux = this.comboPosRodape.getSelectedIndex() == 1 ? 3 : 11;
            int posicao = this.comboPosRodape.getSelectedIndex() == 0 ? 1 : posicaoAux;
            parametrosAssinaturaRodape.setPosicao(posicao);
            parametrosAssinaturaRodape.setTipo(this.comboTipoRodape.getSelectedIndex() == 0 ? 0 : 1);
            parametrosAssinaturaRodape.setPosicaoAbsoluto(this.comboPosRodape.getSelectedIndex() == 2 && Funcoes.isNumeric(this.textPosicaoRodape.getText()) ? Integer.parseInt(this.textPosicaoRodape.getText()) : 0);
            parametrosAssinaturaRodape.setExibir(this.checkAssinaturaRodape.isSelected());
            parametrosAssinaturaRodape.setImprimirAssinaturaEletronica(this.getImprimirAssinaturaEletronicaRodape());
            parametrosAssinaturaRodape.setMargemAssinaturaDigital(this.getMargemAssinaturaDigitalRodape());
            parametrosAssinaturaRodape.setDimensoesAssinaturaDigital(this.dimensoesAssinaturaDigitalRodape);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoParamCabecRodape: 308");
        }
        return parametrosAssinaturaRodape;
    }

    public String getParametrosAreaLivre() {
        return this.areaLivre.getXML();
    }

    public void setParametrosAreaLivre(String xml) {
        if (xml != null && StringUtil.getValor(xml, "arealivre") != null && !Funcoes.textoVazio(StringUtil.getValor(xml, "arealivre"))) {
            this.areaLivre.setXML(xml);
        }
    }

    public void setParametrosLinhasCorpo(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            LinhasCorpo lc = new LinhasCorpo();
            lc.parseXML(xml);
            this.checkLinhasCorpo.setSelected(lc.isHabilitar());
            if (lc.isHabilitar()) {
                if (lc.getCor() != null) {
                    this.comboCorLinha.setCorSelecionada(lc.getCor());
                }
                this.textLinhaX.setText(lc.getLinhasX());
                this.textLinhaY.setText(lc.getLinhasY());
                this.comboTipoLinhaX.setSelectedItem(lc.getTipoLinhaX());
                this.comboTipoLinhaY.setSelectedItem(lc.getTipoLinhaY());
                this.checkAcompanharResultado.setSelected(lc.isAcompanharResultado());
            }
            this.habilitarLinhasCorpo();
        }
    }

    public String getParametrosLinhasCorpo() {
        LinhasCorpo lc = new LinhasCorpo();
        lc.setHabilitar(this.checkLinhasCorpo.isSelected());
        lc.setCor(this.comboCorLinha.getCorSelecionada());
        lc.setLinhasX(this.textLinhaX.getText());
        lc.setLinhasY(this.textLinhaY.getText());
        lc.setTipoLinhaX(this.comboTipoLinhaX.getSelectedItem().toString());
        lc.setTipoLinhaY(this.comboTipoLinhaY.getSelectedItem().toString());
        lc.setAcompanharResultado(this.checkAcompanharResultado.isSelected());
        return lc.getXML();
    }

    public boolean ok() {
        return this.ok;
    }

    private void habilitarDesabilitar() {
        ScreenUtil.habilitarDesabilitarComponentes(this.comboCampoSumario.getParent(), this.checkAssinaturaSumario.isSelected());
        ScreenUtil.habilitarDesabilitarComponentes(this.comboCampoRodape.getParent(), this.checkAssinaturaRodape.isSelected());
        ScreenUtil.habilitarDesabilitarComponentes(this.comboCampoSumarioAssinatura.getParent(), this.checkAssinaturaSumario.isSelected());
        ScreenUtil.habilitarDesabilitarComponentes(this.comboCampoRodapeAssinatura.getParent(), this.checkAssinaturaRodape.isSelected());
        ScreenUtil.habilitarDesabilitarComponentes(this.comboAlinReferenciaSumario.getParent(), this.checkReferenciaSumario.isSelected());
        ScreenUtil.habilitarDesabilitarComponentes(this.comboPosRodape.getParent(), this.checkAssinaturaRodape.isSelected());
        this.textPosicaoXIdentificadorReferencia.setEnabled(this.checkReferenciaSumario.isSelected() && this.checkIdentificadorReferencia.isSelected());
        this.textPosicaoYIdentificadorReferencia.setEnabled(this.checkReferenciaSumario.isSelected() && this.checkIdentificadorReferencia.isSelected());
        this.buttonFonteIdentificador.setEnabled(this.checkReferenciaSumario.isSelected() && this.checkIdentificadorReferencia.isSelected());
    }

    private void mostrarCampoPosicao() {
        this.textPosicaoRodape.setEnabled(this.comboPosRodape.getSelectedIndex() == 2);
    }

    private void adicionaPosicaoRodape() {
        int posicaoAtual = this.comboPosRodape.getSelectedIndex();
        this.comboPosRodape.removeAllItems();
        this.comboPosRodape.addItem("Topo");
        this.comboPosRodape.addItem("Base");
        if (this.comboTipoRodape.getSelectedIndex() == 0) {
            this.comboPosRodape.addItem("Absoluto");
        }
        if (posicaoAtual < this.comboPosRodape.getItemCount()) {
            this.comboPosRodape.setSelectedIndex(posicaoAtual);
        } else {
            this.comboPosRodape.setSelectedIndex(0);
        }
    }

    private void iniciar() {
        GridBagConstraints cons = new GridBagConstraints();
        GridBagConstraints consAux = new GridBagConstraints();
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panel, "South");
        GridBagConstraints consBtn = new GridBagConstraints();
        this.buttonMascara.setVisible(this.isPermitirConfigurarMascaraPDF);
        consBtn.fill = 1;
        consBtn.gridx = 0;
        consBtn.insets = new Insets(1, 3, 3, 3);
        consBtn.gridwidth = 1;
        consBtn.gridheight = 1;
        consBtn.weightx = 0.0;
        consBtn.weighty = 0.0;
        panel.add((Component)this.buttonMascara, consBtn);
        ++consBtn.gridx;
        consBtn.weightx = 1.0;
        panel.add((Component)new JPanel(), consBtn);
        ++consBtn.gridx;
        consBtn.weightx = 0.0;
        consBtn.insets = new Insets(1, 1, 3, 1);
        panel.add((Component)this.buttonOk, consBtn);
        consBtn.insets = new Insets(1, 1, 3, 3);
        ++consBtn.gridx;
        panel.add((Component)this.buttonCancelar, consBtn);
        Dimension dim = new Dimension(50, 20);
        Dimension dimLabel = new Dimension(100, 20);
        panel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panel, "Center");
        cons.gridy = 0;
        cons.fill = 1;
        cons.insets = new Insets(0, 1, 0, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        JPanel aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("P\u00e1gina"));
        panel.add((Component)aux, cons);
        consAux.fill = 1;
        consAux.insets = new Insets(0, 1, 0, 1);
        consAux.gridx = 0;
        consAux.gridy = 0;
        consAux.gridwidth = 1;
        cons.gridheight = 1;
        consAux.weightx = 0.0;
        aux.add((Component)ComponenteFactory.novoJLabel("Altura:", new Dimension(55, 20)), consAux);
        consAux.gridx = 1;
        aux.add((Component)this.configurar(this.textAlturaPag, dim, new DocumentoMascara(this.textAlturaPag, "##,##")), consAux);
        consAux.gridx = 0;
        consAux.gridy = 1;
        aux.add((Component)ComponenteFactory.novoJLabel("Largura:", new Dimension(55, 20)), consAux);
        consAux.gridx = 1;
        aux.add((Component)this.configurar(this.textLarguraPag, dim, new DocumentoMascara(this.textLarguraPag, "##,##")), consAux);
        cons.gridx = 1;
        aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Margens"));
        panel.add((Component)aux, cons);
        consAux.gridx = 0;
        consAux.gridy = 0;
        aux.add((Component)ComponenteFactory.novoJLabel("Esquerda:", new Dimension(60, 20)), consAux);
        consAux.gridx = 1;
        aux.add((Component)this.configurar(this.textEsquerda, dim, new DocumentoMascara(this.textEsquerda, "##,##")), consAux);
        consAux.gridx = 2;
        aux.add((Component)ComponenteFactory.novoJLabel("Direita:", new Dimension(55, 20)), consAux);
        consAux.gridx = 3;
        aux.add((Component)this.configurar(this.textDireita, dim, new DocumentoMascara(this.textDireita, "##,##")), consAux);
        consAux.gridx = 0;
        consAux.gridy = 1;
        aux.add((Component)ComponenteFactory.novoJLabel("Superior:", new Dimension(55, 20)), consAux);
        consAux.gridx = 1;
        aux.add((Component)this.configurar(this.textSuperior, dim, new DocumentoMascara(this.textSuperior, "##,##")), consAux);
        consAux.gridx = 2;
        aux.add((Component)ComponenteFactory.novoJLabel("Inferior:", new Dimension(55, 20)), consAux);
        consAux.gridx = 3;
        aux.add((Component)this.configurar(this.textInferior, dim, new DocumentoMascara(this.textInferior, "##,##")), consAux);
        cons.gridx = 2;
        cons.gridy = 0;
        cons.fill = 3;
        cons.weighty = 1.0;
        aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Laudo"));
        panel.add((Component)aux, cons);
        cons.gridx = 2;
        cons.fill = 1;
        consAux.gridx = 0;
        consAux.gridy = 0;
        aux.add((Component)ComponenteFactory.novoJLabel("Dist\u00e2ncia exames:", new Dimension(113, 20)), consAux);
        consAux.gridx = 1;
        aux.add((Component)this.configurar(this.textDistancia, dim, new DocumentoMascara(this.textDistancia, "##,##")), consAux);
        consAux.gridx = 0;
        consAux.gridy = 1;
        aux.add((Component)ComponenteFactory.novoJLabel("Qualidade imagem:", new Dimension(36, 17)), consAux);
        ++consAux.gridx;
        this.comboQualidadeImagem.setPreferredSize(new Dimension(36, 17));
        consAux.gridx = 1;
        aux.add((Component)this.comboQualidadeImagem, consAux);
        ++cons.gridx;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.gridx = 3;
        aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Separadores"));
        panel.add((Component)aux, cons);
        aux.add((Component)ComponenteFactory.novoJLabel("C\u00f3digo de exame:", new Dimension(113, 20)), consAux);
        ++consAux.gridx;
        this.comboSeparaCodigoExame.setPreferredSize(new Dimension(36, 17));
        aux.add((Component)this.comboSeparaCodigoExame, consAux);
        ++consAux.gridy;
        --consAux.gridx;
        aux.add((Component)ComponenteFactory.novoJLabel("SOA:", new Dimension(113, 20)), consAux);
        ++consAux.gridx;
        this.comboSeparaSOA.setPreferredSize(new Dimension(36, 17));
        aux.add((Component)this.comboSeparaSOA, consAux);
        --consAux.gridy;
        ++consAux.gridx;
        aux.add((Component)ComponenteFactory.novoJLabel("COA:", new Dimension(35, 20)), consAux);
        ++consAux.gridx;
        this.comboSeparaCOA.setPreferredSize(new Dimension(36, 17));
        aux.add((Component)this.comboSeparaCOA, consAux);
        ++consAux.gridx;
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 0;
        consAux.weightx = 0.5;
        aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Par\u00e2metros"));
        panel.add((Component)aux, cons);
        consAux.gridx = 0;
        consAux.gridy = 0;
        aux.add((Component)this.checkExibirSumario, consAux);
        ++consAux.gridx;
        aux.add((Component)this.checkExibirRodapeExame, consAux);
        ++consAux.gridx;
        aux.add((Component)this.checkAssinaturaSumario, consAux);
        ++consAux.gridx;
        aux.add((Component)this.checkAssinaturaRodape, consAux);
        ++consAux.gridx;
        aux.add((Component)this.checkReferenciaSumario, consAux);
        cons.gridx = 0;
        cons.gridy = 2;
        aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Assinatura Sum\u00e1rio"));
        panel.add((Component)aux, cons);
        consAux.gridx = 0;
        consAux.gridy = 0;
        aux.add((Component)ComponenteFactory.novoJLabel("Campo:", dimLabel), consAux);
        consAux.gridx = 1;
        aux.add((Component)this.comboCampoSumario, consAux);
        consAux.gridx = 2;
        aux.add((Component)ComponenteFactory.novoJLabel("Quantidade:", dimLabel), consAux);
        consAux.gridx = 3;
        aux.add((Component)this.comboQtdeSumario, consAux);
        consAux.gridx = 4;
        aux.add((Component)ComponenteFactory.novoJLabel("Tipo:", new Dimension(45, 20)), consAux);
        consAux.gridx = 5;
        aux.add((Component)this.comboTipoSumario, consAux);
        consAux.gridx = 0;
        consAux.gridy = 1;
        aux.add((Component)ComponenteFactory.novoJLabel("Alinhamento:", dimLabel), consAux);
        consAux.gridx = 1;
        this.comboAlinSumario.setPreferredSize(new Dimension(70, 20));
        aux.add((Component)this.comboAlinSumario, consAux);
        consAux.gridx = 2;
        aux.add((Component)ComponenteFactory.novoJLabel("Altura:", dimLabel), consAux);
        consAux.gridx = 3;
        aux.add((Component)this.configurar(this.textAlturaSumario, new Dimension(45, 20), new DocumentoLimite(this.textAlturaSumario, 3, "[0-9]+")), consAux);
        consAux.gridx = 4;
        aux.add((Component)ComponenteFactory.novoJLabel("Posi\u00e7\u00e3o:", new Dimension(116, 20)), consAux);
        consAux.gridx = 5;
        this.comboPosSumario.setPreferredSize(new Dimension(150, 20));
        aux.add((Component)this.comboPosSumario, consAux);
        JPanel panel2 = new JPanel(new FlowLayout(2, 0, 0));
        panel2.add(this.checkImprimirAssinaturaEletronicaSumario);
        this.comboCampoSumarioAssinatura.setPreferredSize(new Dimension(150, 20));
        panel2.add(this.comboCampoSumarioAssinatura);
        consAux.gridx = 0;
        ++consAux.gridy;
        consAux.gridwidth = 2;
        aux.add((Component)panel2, consAux);
        consAux.gridwidth = 3;
        ++consAux.gridx;
        ++consAux.gridx;
        consAux.fill = 1;
        this.labelMargemAssinaturaDigitalSumario.setHorizontalAlignment(4);
        aux.add((Component)this.labelMargemAssinaturaDigitalSumario, consAux);
        consAux.gridwidth = 1;
        ++consAux.gridx;
        ++consAux.gridx;
        ++consAux.gridx;
        consAux.fill = 2;
        this.textMargemAssinaturaDigitalSumario.setPreferredSize(new Dimension(100, 20));
        aux.add((Component)this.textMargemAssinaturaDigitalSumario, consAux);
        consAux.fill = 1;
        consAux.gridwidth = 1;
        cons.gridy = 3;
        aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Assinatura Rodap\u00e9"));
        panel.add((Component)aux, cons);
        consAux.gridx = 0;
        consAux.gridy = 0;
        aux.add((Component)ComponenteFactory.novoJLabel("Campo:", dimLabel), consAux);
        consAux.gridx = 1;
        aux.add((Component)this.comboCampoRodape, consAux);
        consAux.gridx = 2;
        aux.add((Component)ComponenteFactory.novoJLabel("Quantidade:", dimLabel), consAux);
        consAux.gridx = 3;
        aux.add((Component)this.comboQtdeRodape, consAux);
        consAux.gridx = 4;
        aux.add((Component)ComponenteFactory.novoJLabel("Tipo:", dimLabel), consAux);
        consAux.gridx = 5;
        aux.add((Component)this.comboTipoRodape, consAux);
        consAux.gridx = 0;
        consAux.gridy = 1;
        aux.add((Component)ComponenteFactory.novoJLabel("Alinhamento:", dimLabel), consAux);
        consAux.gridx = 1;
        aux.add((Component)this.comboAlinRodape, consAux);
        consAux.gridx = 2;
        aux.add((Component)ComponenteFactory.novoJLabel("Altura:", dimLabel), consAux);
        consAux.gridx = 3;
        aux.add((Component)this.configurar(this.textAlturaRodape, new Dimension(45, 15), new DocumentoLimite(this.textAlturaRodape, 3, "[0-9]+")), consAux);
        consAux.gridx = 4;
        aux.add((Component)ComponenteFactory.novoJLabel("Posi\u00e7\u00e3o:", dimLabel), consAux);
        consAux.gridx = 5;
        JPanel p = new JPanel(new FlowLayout(2, 0, 0));
        this.comboPosRodape.setPreferredSize(new Dimension(125, 20));
        p.add(this.comboPosRodape);
        p.add(this.configurar(this.textPosicaoRodape, new Dimension(40, 20), new DocumentoLimite(this.textPosicaoRodape, 3, "[0-9]+")));
        this.textPosicaoRodape.setEnabled(false);
        aux.add((Component)p, consAux);
        JPanel panel2RodapeAssinatura = new JPanel(new FlowLayout(2, 0, 0));
        panel2RodapeAssinatura.add(this.checkImprimirAssinaturaEletronicaRodape);
        this.comboCampoRodapeAssinatura.setPreferredSize(new Dimension(150, 20));
        panel2RodapeAssinatura.add(this.comboCampoRodapeAssinatura);
        ++consAux.gridy;
        consAux.gridx = 0;
        consAux.gridwidth = 2;
        consAux.fill = 17;
        aux.add((Component)panel2RodapeAssinatura, consAux);
        ++consAux.gridx;
        ++consAux.gridx;
        consAux.gridwidth = 3;
        this.labelMargemAssinaturaDigitalRodape.setHorizontalAlignment(4);
        aux.add((Component)this.labelMargemAssinaturaDigitalRodape, consAux);
        ++consAux.gridx;
        ++consAux.gridx;
        ++consAux.gridx;
        consAux.gridwidth = 1;
        consAux.fill = 2;
        aux.add((Component)this.textMargemAssinaturaDigitalRodape, consAux);
        consAux.gridwidth = 1;
        cons.gridy = 4;
        aux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Refer\u00eancia Sum\u00e1rio"));
        panel.add((Component)aux, cons);
        consAux.gridx = 0;
        consAux.gridy = 0;
        aux.add((Component)ComponenteFactory.novoJLabel("Alinhamento:", dimLabel), consAux);
        consAux.gridx = 1;
        aux.add((Component)this.comboAlinReferenciaSumario, consAux);
        consAux.insets = new Insets(0, 5, 0, 1);
        consAux.gridx = 2;
        aux.add((Component)ComponenteFactory.novoJLabel("Altura:", null), consAux);
        consAux.gridx = 4;
        aux.add((Component)ComponenteFactory.novoJLabel("Posi\u00e7\u00e3o:", null), consAux);
        cons.insets = new Insets(0, 1, 0, 1);
        consAux.gridx = 3;
        aux.add((Component)this.configurar(this.textAlturaReferencia, new Dimension(45, 20), new DocumentoLimite(this.textAlturaReferencia, 3, "[0-9]+")), consAux);
        consAux.gridx = 5;
        aux.add((Component)this.configurar(this.textPosicaoReferencia, new Dimension(45, 20), new DocumentoLimite(this.textPosicaoReferencia, 3, "[0-9]+")), consAux);
        consAux.gridx = 6;
        this.buttonFonteReferencia.setPreferredSize(new Dimension(50, 20));
        aux.add((Component)this.buttonFonteReferencia, consAux);
        consAux.gridx = 0;
        consAux.gridy = 1;
        consAux.gridwidth = 2;
        aux.add((Component)this.checkIdentificadorReferencia, consAux);
        consAux.gridx = 2;
        consAux.gridwidth = 1;
        aux.add((Component)new JLabel("Posi\u00e7\u00e3o X:"), consAux);
        consAux.gridx = 3;
        aux.add((Component)this.configurar(this.textPosicaoXIdentificadorReferencia, new Dimension(45, 20), new DocumentoLimite(this.textPosicaoXIdentificadorReferencia, 3, "[0-9]+")), consAux);
        consAux.gridx = 4;
        aux.add((Component)new JLabel("Posi\u00e7\u00e3o Y:"), consAux);
        consAux.gridx = 5;
        aux.add((Component)this.configurar(this.textPosicaoYIdentificadorReferencia, new Dimension(45, 20), new DocumentoLimite(this.textPosicaoYIdentificadorReferencia, 3, "[0-9]+")), consAux);
        consAux.gridx = 6;
        this.buttonFonteIdentificador.setPreferredSize(new Dimension(50, 20));
        aux.add((Component)this.buttonFonteIdentificador, consAux);
        ++cons.gridy;
        panel.add((Component)this.areaLivre, cons);
        ++cons.gridy;
        panel.add((Component)this.panelLinhasCorpo, cons);
        this.montaPanelLinhasCorpo();
        this.menu.add(this.itemImportar);
        this.menu.add(this.itemRemover);
        this.menu.add(this.itemVisualizar);
        this.controlaMenuButtonMascara();
        this.adicionarEventos();
        this.habilitarLinhasCorpo();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.centralizar(this);
    }

    private void adicionarEventos() {
        this.itemImportar.addActionListener(event -> {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivos PDF", "pdf"));
            if (chooser.showOpenDialog(this) == 0) {
                try {
                    ArrayList<Byte> dados = new ArrayList<Byte>();
                    int carac = -1;
                    try (FileInputStream fais = new FileInputStream(chooser.getSelectedFile());){
                        while ((carac = fais.read()) > -1) {
                            dados.add((byte)carac);
                        }
                    }
                    byte[] array = new byte[dados.size()];
                    for (int i = 0; i < dados.size(); ++i) {
                        array[i] = (Byte)dados.get(i);
                    }
                    this.mascaraPdf = new Base64().encodeAsString(array);
                    this.controlaMenuButtonMascara();
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel carregar PDF", e1.getStackTrace());
                }
                this.controlaMenuButtonMascara();
            }
        });
        this.itemRemover.addActionListener(event -> {
            this.mascaraPdf = "";
            this.controlaMenuButtonMascara();
        });
        this.buttonMascara.addActionListener(event -> this.menu.show(this.buttonMascara.getParent(), this.buttonMascara.getX(), this.buttonMascara.getY() + this.buttonMascara.getHeight()));
        this.itemVisualizar.addActionListener(event -> this.visualizaMascaraPdf());
        this.comboTipoRodape.addActionListener(event -> this.adicionaPosicaoRodape());
        this.comboPosRodape.addActionListener(event -> this.mostrarCampoPosicao());
        this.comboCampoSumario.addActionListener(event -> this.checkImprimirAssinaturaEletronicaSumario.setSelected(this.comboCampoSumario.getSelectedIndex() == 5 || this.comboCampoSumario.getSelectedIndex() == 6));
        this.comboCampoRodape.addActionListener(event -> this.checkImprimirAssinaturaEletronicaRodape.setSelected(this.comboCampoRodape.getSelectedIndex() == 5 || this.comboCampoRodape.getSelectedIndex() == 6));
        this.checkAssinaturaRodape.addActionListener(event -> this.checkImprimirAssinaturaEletronicaRodape.setSelected(this.comboCampoRodape.getSelectedIndex() == 5 || this.comboCampoRodape.getSelectedIndex() == 6));
        this.checkImprimirAssinaturaEletronicaRodape.addActionListener(event -> this.configurarDimensoesAssinaturaDigitalRodape());
        this.checkImprimirAssinaturaEletronicaSumario.addActionListener(event -> this.configurarDimensoesAssinaturaDigitalSumario());
    }

    private void configurarDimensoesAssinaturaDigitalSumario() {
        if (this.checkImprimirAssinaturaEletronicaSumario.isSelected()) {
            DialogoDimensoesAssinaturaDigital dimensoesAssinaturaDigital = this.getDialogoDimensoesAssinaturaDigital(this.dimensoesAssinaturaDigitalSumario);
            dimensoesAssinaturaDigital.setVisible(true);
            if (dimensoesAssinaturaDigital.getOK()) {
                this.dimensoesAssinaturaDigitalSumario = dimensoesAssinaturaDigital.getDimensoes();
            }
        }
    }

    private void configurarDimensoesAssinaturaDigitalRodape() {
        if (this.checkImprimirAssinaturaEletronicaRodape.isSelected()) {
            DialogoDimensoesAssinaturaDigital dimensoesAssinaturaDigital = this.getDialogoDimensoesAssinaturaDigital(this.dimensoesAssinaturaDigitalRodape);
            dimensoesAssinaturaDigital.setVisible(true);
            if (dimensoesAssinaturaDigital.getOK()) {
                this.dimensoesAssinaturaDigitalRodape = dimensoesAssinaturaDigital.getDimensoes();
            }
        }
    }

    private DialogoDimensoesAssinaturaDigital getDialogoDimensoesAssinaturaDigital(DimensoesAssinaturaDigitalDTO dimensoesAssinaturaDigital) {
        int larguraImpressao = this.calcularLarguraImpressao();
        return DialogoDimensoesAssinaturaDigital.novaInstancia(this, Integer.valueOf(this.textAlturaRodape.getText()), 28 * larguraImpressao, dimensoesAssinaturaDigital);
    }

    private int calcularLarguraImpressao() {
        double largura = Double.parseDouble(this.textLarguraPag.getText().replace(",", "."));
        double margemDireita = Double.parseDouble(this.textDireita.getText().replace(",", "."));
        double margemEsquerda = Double.parseDouble(this.textEsquerda.getText().replace(",", "."));
        return (int)(largura - margemDireita - margemEsquerda);
    }

    protected void visualizaMascaraPdf() {
        VisualizarPdf pdf = VisualizarPdf.novaInstancia(this, this.mascaraPdf);
        if (pdf != null) {
            pdf.setVisible(true);
        }
    }

    public void setMascaraPdf(String mascaraPdf) {
        this.mascaraPdf = mascaraPdf;
        this.controlaMenuButtonMascara();
    }

    public String getMascaraPdf() {
        return this.mascaraPdf;
    }

    private void controlaMenuButtonMascara() {
        this.itemRemover.setEnabled(!Funcoes.textoVazio(this.mascaraPdf));
        this.itemVisualizar.setEnabled(!Funcoes.textoVazio(this.mascaraPdf));
    }

    private void setImprimirAssinaturaEletronicaSumario(boolean imprimir) {
        this.checkImprimirAssinaturaEletronicaSumario.setSelected(imprimir);
    }

    private boolean getImprimirAssinaturaEletronicaSumario() {
        return this.checkImprimirAssinaturaEletronicaSumario.isSelected();
    }

    private void setImprimirAssinaturaEletronicaRodape(boolean imprimir) {
        this.checkImprimirAssinaturaEletronicaRodape.setSelected(imprimir);
    }

    private boolean getImprimirAssinaturaEletronicaRodape() {
        return this.checkImprimirAssinaturaEletronicaRodape.isSelected();
    }

    private void setMargemAssinaturaDigitalSumario(float tamanho) {
        this.textMargemAssinaturaDigitalSumario.setText(Funcoes.formataDecimal(tamanho, 2));
    }

    private float getMargemAssinaturaDigitalSumario() {
        return Funcoes.textoVazio(this.textMargemAssinaturaDigitalSumario) ? 0.0f : Float.valueOf(this.textMargemAssinaturaDigitalSumario.getText()).floatValue();
    }

    private void setMargemAssinaturaDigitalRodape(float tamanho) {
        this.textMargemAssinaturaDigitalRodape.setText(Funcoes.formataDecimal(tamanho, 2));
    }

    private float getMargemAssinaturaDigitalRodape() {
        return Funcoes.textoVazio(this.textMargemAssinaturaDigitalRodape) ? 0.0f : Float.valueOf(this.textMargemAssinaturaDigitalRodape.getText()).floatValue();
    }

    private void montaPanelLinhasCorpo() {
        this.panelLinhasCorpo.setBorder(new TitledBorder("Linhas no corpo do laudo"));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 10;
        JPanel panelTemp = new JPanel();
        panelTemp.setPreferredSize(new Dimension(120, 12));
        this.panelLinhasCorpo.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, 0, 0, this.checkLinhasCorpo, panelTemp, this.checkAcompanharResultado), c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridy = 1;
        c.fill = 0;
        this.panelLinhasCorpo.add((Component)new JLabel("Linha X:"), c);
        c.gridx = 1;
        this.comboTipoLinhaX.setPreferredSize(new Dimension(80, 20));
        this.panelLinhasCorpo.add((Component)this.comboTipoLinhaX, c);
        c.gridx = 2;
        this.textLinhaX.setPreferredSize(new Dimension(70, 20));
        this.panelLinhasCorpo.add((Component)this.textLinhaX, c);
        c.gridx = 3;
        this.panelLinhasCorpo.add((Component)new JLabel("   Linha Y:"), c);
        c.gridx = 4;
        this.comboTipoLinhaY.setPreferredSize(new Dimension(80, 20));
        this.panelLinhasCorpo.add((Component)this.comboTipoLinhaY, c);
        c.gridx = 5;
        this.textLinhaY.setPreferredSize(new Dimension(70, 20));
        this.panelLinhasCorpo.add((Component)this.textLinhaY, c);
        c.gridx = 6;
        this.panelLinhasCorpo.add((Component)new JLabel("   Cor:"), c);
        c.gridx = 7;
        this.comboCorLinha.setPreferredSize(new Dimension(160, 20));
        this.panelLinhasCorpo.add((Component)this.comboCorLinha, c);
        c.gridx = 8;
        this.buttonCorLinha.setPreferredSize(new Dimension(20, 20));
        this.buttonCorLinha.setMaximumSize(new Dimension(20, 20));
        this.panelLinhasCorpo.add((Component)this.buttonCorLinha, c);
        c.gridx = 9;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelLinhasCorpo.add((Component)new JPanel(), c);
        this.textLinhaY.setToolTipText("<html>Define os intervalos ou espa\u00e7o entre as colunas no corpo do laudo.<br>As colunas ser\u00e3o apresentadas na impress\u00e3o do laudo.<br>Para utilizar as colunas por intervalos, separe por , (v\u00edrgula)</html>");
        this.textLinhaX.setToolTipText(this.textLinhaY.getToolTipText());
    }

    private JTextField configurar(JTextField text, Dimension preferredSize, Document doc) {
        return this.configurar(text, preferredSize, doc, 4);
    }

    private JTextField configurar(JTextField text, Dimension preferredSize, Document doc, int alinHorz) {
        text.setPreferredSize(preferredSize);
        text.setDocument(doc);
        text.setHorizontalAlignment(alinHorz);
        return text;
    }
}

