/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.configurador.AtributosEstilo;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogoConfiguradorEstilos
extends JDialog
implements ActionListener,
DisposeListener,
ListSelectionListener {
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("Adicionar", 'A', this);
    private TTextField textNomeEstilo = new TTextField();
    private JLabel labelNomeEstilo = ComponenteFactory.novoJLabel("Estilo:", 'l', null, null, this.textNomeEstilo);
    private DefaultListModel modelo = new DefaultListModel();
    private JList listEstilos = new JList(this.modelo);
    private JScrollPane scrollEstilos = new JScrollPane(this.listEstilos);
    private JLabel labelExemplo = new JLabel("Exemplo de estilo");
    private JList listFontes = new JList<String>(this.getFontes());
    private JCheckBox checkNegrito = new JCheckBox("Negrito");
    private JCheckBox checkItalico = new JCheckBox("It\u00e1lico");
    private JComboBox comboTamanhoFonte = new JComboBox();
    private boolean ok = false;
    private boolean atualizandoEstilo = false;
    private ArrayList<AtributosEstilo> estilos = new ArrayList();

    public static DialogoConfiguradorEstilos novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoConfiguradorEstilos((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoConfiguradorEstilos((Dialog)pai);
        }
        return null;
    }

    public DialogoConfiguradorEstilos(Frame owner) {
        super(owner, "Configurar de estilos");
        this.montaTela();
    }

    public DialogoConfiguradorEstilos(Dialog owner) {
        super(owner, "Configurador de estilos");
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(500, 350));
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        this.add((Component)this.labelNomeEstilo, c);
        c.gridx = 2;
        this.add((Component)this.buttonAdicionar, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.textNomeEstilo.setPreferredSize(new Dimension(100, 20));
        this.textNomeEstilo.setMinimumSize(new Dimension(100, 20));
        this.add((Component)this.textNomeEstilo, c);
        JPanel panelCentro = new JPanel(new BorderLayout());
        JPanel panelEstilos = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Estilos"));
        panelEstilos.add((Component)this.scrollEstilos, "Center");
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)panelCentro, c);
        panelCentro.add((Component)panelEstilos, "Center");
        JPanel panelFonte = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Fonte"));
        panelFonte.setPreferredSize(new Dimension(210, 20));
        panelCentro.add((Component)panelFonte, "East");
        JPanel panelExemplo = ComponenteFactory.novoJPanel(new FlowLayout(), new TitledBorder("Exemplo"));
        panelExemplo.setPreferredSize(new Dimension(100, 50));
        panelExemplo.add(this.labelExemplo);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.gridy = 2;
        c.fill = 2;
        this.add((Component)panelExemplo, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonOK);
        panelBotoes.add(this.buttonCancelar);
        c.gridy = 3;
        this.add((Component)panelBotoes, c);
        this.listEstilos.addListSelectionListener(this);
        this.listFontes.addListSelectionListener(this);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridwidth = 2;
        panelFonte.add((Component)new JScrollPane(this.listFontes), gc);
        gc.fill = 2;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weighty = 0.0;
        panelFonte.add((Component)this.checkNegrito, gc);
        gc.gridx = 1;
        panelFonte.add((Component)this.checkItalico, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 2;
        panelFonte.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, new JLabel("Tamanho:"), this.comboTamanhoFonte), gc);
        this.comboTamanhoFonte.removeAllItems();
        for (int i = 3; i <= 100; ++i) {
            this.comboTamanhoFonte.addItem(String.valueOf(i));
        }
        this.comboTamanhoFonte.setSelectedItem("10");
        this.checkNegrito.addActionListener(this);
        this.checkItalico.addActionListener(this);
        this.comboTamanhoFonte.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar || e.getSource() == this.buttonOK) {
            this.ok = e.getSource() == this.buttonOK;
            this.dispose();
        } else if (e.getSource() == this.buttonAdicionar) {
            this.adicionarEstilo();
        } else if (e.getSource() == this.checkNegrito || e.getSource() == this.checkItalico || e.getSource() == this.comboTamanhoFonte) {
            this.fonteSelecionada();
        }
    }

    public boolean getOK() {
        return this.ok;
    }

    private void adicionarEstilo() {
        if (this.textNomeEstilo.getText().trim().length() == 0) {
            return;
        }
        int posicao = this.achaEstilo(this.textNomeEstilo.getText());
        if (posicao < 0) {
            AtributosEstilo estilo = new AtributosEstilo(this.textNomeEstilo.getText());
            this.estilos.add(estilo);
            this.modelo.addElement(estilo);
            this.listEstilos.setSelectedIndex(this.modelo.getSize() - 1);
        } else {
            this.listEstilos.setSelectedIndex(posicao);
        }
        this.textNomeEstilo.clear();
        ScreenUtil.requisitarFoco(this.textNomeEstilo);
    }

    private int achaEstilo(String nome) {
        for (int i = 0; i < this.estilos.size(); ++i) {
            if (!this.estilos.get(i).getNome().equalsIgnoreCase(nome)) continue;
            return i;
        }
        return -1;
    }

    public boolean isOK() {
        return this.ok;
    }

    private String[] getFontes() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.listFontes) {
            this.fonteSelecionada();
        } else if (e.getSource() == this.listEstilos) {
            this.estiloSelecionado();
        }
    }

    private void fonteSelecionada() {
        if (this.atualizandoEstilo) {
            return;
        }
        int estiloFonte = 0;
        if (this.checkNegrito.isSelected() && this.checkItalico.isSelected()) {
            estiloFonte = 3;
        } else if (this.checkNegrito.isSelected()) {
            estiloFonte = 1;
        } else if (this.checkItalico.isSelected()) {
            estiloFonte = 2;
        }
        if (this.listEstilos.getSelectedValue() != null && this.listFontes.getSelectedValue() != null) {
            ((AtributosEstilo)this.listEstilos.getSelectedValue()).setFonte(new Font(this.listFontes.getSelectedValue().toString(), estiloFonte, Integer.parseInt(this.comboTamanhoFonte.getSelectedItem().toString())));
            this.aplicarFonteExemplo(((AtributosEstilo)this.listEstilos.getSelectedValue()).getFonte());
        }
    }

    private void estiloSelecionado() {
        if (((AtributosEstilo)this.listEstilos.getSelectedValue()).getFonte() != null) {
            Font fonte = ((AtributosEstilo)this.listEstilos.getSelectedValue()).getFonte();
            this.aplicarFonteExemplo(fonte);
            this.atualizandoEstilo = true;
            this.listFontes.setSelectedValue(fonte.getName(), true);
            this.comboTamanhoFonte.setSelectedItem(String.valueOf(fonte.getSize()));
            this.checkNegrito.setSelected(fonte.getStyle() == 1 || fonte.getStyle() == 3);
            this.checkItalico.setSelected(fonte.getStyle() == 2 || fonte.getStyle() == 3);
            this.atualizandoEstilo = false;
        } else {
            this.fonteSelecionada();
        }
    }

    private void aplicarFonteExemplo(Font fonte) {
        this.labelExemplo.setFont(fonte);
    }

    public void setEstilos(ArrayList<AtributosEstilo> estilos) {
        this.modelo.clear();
        if (estilos != null) {
            for (AtributosEstilo estilo : estilos) {
                this.modelo.addElement(estilo);
            }
        }
    }

    public ArrayList<AtributosEstilo> getEstilos() {
        ArrayList<AtributosEstilo> estilos = new ArrayList<AtributosEstilo>();
        for (int i = 0; i < this.modelo.getSize(); ++i) {
            if (!(this.modelo.get(i) instanceof AtributosEstilo)) continue;
            estilos.add((AtributosEstilo)this.modelo.get(i));
        }
        return estilos;
    }
}

