/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.configurador.AtributosEstilo;
import jalis.laboratorio.configurador.DialogoConfiguradorEstilos;
import jalis.laboratorio.configurador.DialogoParamCabecRodape;
import jalis.laboratorio.configurador.DialogoParametrosCorpo;
import jalis.laboratorio.configurador.InterfaceRelacionamento;
import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Assinatura;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.CodigoBarrasConf;
import jalis.laboratorio.configurador.componente.CodigoQRCode;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.Dados;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.componente.Externo;
import jalis.laboratorio.configurador.componente.Forma;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.configurador.componente.Historico;
import jalis.laboratorio.configurador.componente.Imagem;
import jalis.laboratorio.configurador.componente.ReguaReferencial;
import jalis.laboratorio.configurador.componente.ResultadoAnterior;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.laboratorio.configurador.componente.Rtf;
import jalis.laboratorio.configurador.componente.Texto;
import jalis.laboratorio.configurador.pagina.Pagina;
import jalis.laboratorio.configurador.propriedade.EditorValorReferencia;
import jalis.laboratorio.configurador.propriedade.Gerenciador;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.componente.TextoDigitacao;
import jalis.laboratorio.digitacao.evento.DigitacaoAdapter;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.impressao.CampoAssinaturaLaudo;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.ExameMaterialPagina;
import jalis.laboratorio.impressao.Impressao;
import jalis.laboratorio.util.parsers.CamposDesmembramento;
import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.indlab.resultado.CamposImportacaoIndlab;
import jalis.laboratorio.util.parsers.mercolabws.resultado.CamposImportacaoMercolab;
import jalis.laboratorio.util.parsers.pardini.resultado.CamposImportacaoHPardini;
import jalis.laboratorio.util.parsers.shift.CamposImportacaoShift;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class DialogoConfigurador
extends JDialog
implements ComponentListener,
ActionListener,
DisposeListener {
    private static final String CAMPOS_CARREGADOS = "Campos Carregados";
    private static final String CAMPOS_NAO_CARREGADOS = "Campos N\u00e3o Carregados";
    JButton buttonVisualizar = ComponenteFactory.novoJButton("Visualizar", '\u0000', this);
    JButton buttonImportar = ComponenteFactory.novoJButton("Importar", '\u0000', this);
    JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", '\u0000', this);
    JButton buttonOcultarLinhas = ComponenteFactory.novoJButton("Ocultar linhas", '\u0000', this);
    JButton buttonParametros = ComponenteFactory.novoJButton("Par\u00e2metros", 'P', this);
    JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonEstilos = ComponenteFactory.novoJButton("Estilos", '\u0000', this);
    JToggleButton buttonLigacoes = new JToggleButton("Liga\u00e7\u00f5es", false);
    JButton buttonSeta = this.criarBotaoComponente("seta", "Seta");
    JButton buttonRotulo = this.criarBotaoComponente("rotulo", "R\u00f3tulo");
    JButton buttonCampo = this.criarBotaoComponente("campo", "Campo");
    JButton buttonTexto = this.criarBotaoComponente("texto", "Texto");
    JButton buttonHistorico = this.criarBotaoComponente("historico", "Hist\u00f3rico");
    JButton buttonDados = this.criarBotaoComponente("campo_banco", "Dados");
    JButton buttonExpressao = this.criarBotaoComponente("expressao", "Express\u00e3o");
    JButton buttonImagem = this.criarBotaoComponente("imagem", "Imagem");
    JButton buttonAssinatura = this.criarBotaoComponente("assina", "Assinatura");
    JButton buttonForma = this.criarBotaoComponente("forma", "Forma");
    JButton buttonResAnterior = this.criarBotaoComponente("res_ant", "Resultado Anterior");
    JButton buttonCodBarras = this.criarBotaoComponente("cod_bar", "C\u00f3digo de Barras");
    JButton buttonRegua = this.criarBotaoComponente("regua_ref", "R\u00e9gua Referencial");
    JButton buttonExterno = this.criarBotaoComponente("campo_externo", "Campo Externo");
    JButton buttonGrafico = this.criarBotaoComponente("grafico", "Gr\u00e1fico");
    JButton buttonRTF = this.criarBotaoComponente("rtf", "RTF");
    JButton buttonCodigoQRCode = this.criarBotaoComponente("qrcode_32x32", "C\u00f3digo QRCode");
    JPanel panelBotoesEsq = ComponenteFactory.novoJPanelFlowLayout(0, this.buttonVisualizar, this.buttonParametros, this.buttonImportar, this.buttonExportar, this.buttonOcultarLinhas, this.buttonEstilos, this.buttonLigacoes);
    JPanel panelBotoesDir = ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOk, this.buttonCancelar);
    JPanel panelPaginador = new JPanel(new BorderLayout());
    JPanel panelBarra = ComponenteFactory.novoJPanelBorderLayout(BorderFactory.createEtchedBorder(), null, (Component)this.panelPaginador, null, (Component)this.panelBotoesDir, (Component)this.panelBotoesEsq);
    JPanel panelComponentes = ComponenteFactory.novoJPanelFlowLayout(0, this.buttonSeta, this.buttonRotulo, this.buttonCampo, this.buttonTexto, this.buttonHistorico, this.buttonDados, this.buttonExpressao, this.buttonResAnterior, this.buttonImagem, this.buttonAssinatura, this.buttonForma, this.buttonCodBarras, this.buttonRegua, this.buttonExterno, this.buttonGrafico, this.buttonCodigoQRCode, this.buttonRTF);
    JScrollPane scrollArea = new JScrollPane();
    JSplitPane splitDivisor = new JSplitPane();
    Pagina pagina = new Pagina();
    JPanel panelCamposImportacao = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Campos de laborat\u00f3rio externo"));
    JLabel labelCamposCarregados = ComponenteFactory.novoJLabel("", new Dimension(10, 22), 0);
    JLabel labelExameExterno = ComponenteFactory.novoJLabel("", new Dimension(10, 22));
    JLabel labelVersaoCampos = ComponenteFactory.novoJLabel("", new Dimension(10, 22));
    JComboBox comboVersoes = ComponenteFactory.novoJComboBox(null, this, new Dimension(10, 20));
    Map<JButton, Class<? extends Componente>> botoes = new HashMap<JButton, Class<? extends Componente>>();
    private boolean ok;
    private boolean isConfiguracaoCampoResult;
    private String propriedadeCampoNome;
    private String parametros = "";
    private String versaoExameLabExterno = "";
    private HashMap<String, CamposImportacao> versoesExameLabExterno = new HashMap();
    private Protocolo protocolo;
    private String codigoLabExterno;
    private String xml;
    private String versaoExame = "0";
    private ArrayList examesDesmembradosLabExterno = null;
    boolean reconfigurarLabExterno = false;
    private String xmlOriginal = null;
    private String impressoraPadraoSistema = "";
    private String cabecalhoImpressaoSistema = "";
    private boolean ocultarImprimirVisualizacao = false;
    private ArrayList<Componente> resultadosAnteriores = new ArrayList();
    private ArrayList<AtributosEstilo> estilos = new ArrayList();
    private ExameMaterialPagina exameMaterialPagina;
    private boolean isPermitirConfigurarMascaraPDF = false;
    private Map<String, CamposImportacao> camposHPardini = null;
    private Map<String, CamposImportacao> camposIndLab = null;
    private Map<String, CamposImportacao> camposMercolab = null;
    private Map<String, CamposImportacao> camposShift = null;
    private static final String NULL = "null";

    public DialogoConfigurador(Frame pai, String titulo, boolean modal, boolean isPermitirConfigurarMascaraPDF) {
        super(pai, titulo, modal);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.iniciar();
    }

    public DialogoConfigurador(Dialog pai, String titulo, boolean modal, boolean isPermitirConfigurarMascaraPDF, Protocolo protocolo) {
        super(pai, titulo, modal);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.protocolo = protocolo;
        this.iniciar();
    }

    public DialogoConfigurador(Dialog pai, String titulo, boolean modal, boolean isPermitirConfigurarMascaraPDF, Protocolo protocolo, String codLabExterno, String codExameLabExterno, String xml) {
        super(pai, titulo, modal);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.protocolo = protocolo;
        this.codigoLabExterno = codLabExterno;
        this.xml = xml;
        if (protocolo == Protocolo.HPardini) {
            this.carregarCamposHPardini(protocolo, codLabExterno, codExameLabExterno, StringUtil.getValor(xml, "codigo-material"), null);
        } else if (protocolo == Protocolo.INDLab) {
            this.carregarCamposIndlab(protocolo, codLabExterno, codExameLabExterno, xml, null);
        } else if (protocolo == Protocolo.MercolabWS) {
            this.carregarCamposMercolab(protocolo, codLabExterno, codExameLabExterno, xml, null);
        } else if (protocolo == Protocolo.Shift) {
            this.carregarCamposShift(protocolo, codLabExterno, codExameLabExterno, null);
        }
        this.iniciar();
    }

    public DialogoConfigurador(Dialog pai, String titulo, boolean modal, boolean isPermitirConfigurarMascaraPDF, Protocolo protocolo, boolean isConfiguraCamposResult) {
        super(pai, titulo, modal);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.protocolo = protocolo;
        this.isConfiguracaoCampoResult = isConfiguraCamposResult;
        this.iniciarConfiguraCampoResult();
    }

    public DialogoConfigurador(Dialog pai, String titulo, boolean modal, boolean isPermitirConfigurarMascaraPDF, Protocolo protocolo, String codLabExterno, String codExameLabExterno, String xml, boolean isConfiguraCamposResult) {
        super(pai, titulo, modal);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.protocolo = protocolo;
        this.codigoLabExterno = codLabExterno;
        this.isConfiguracaoCampoResult = isConfiguraCamposResult;
        this.xml = xml;
        this.carregarCamposHPardini(protocolo, codLabExterno, codExameLabExterno, StringUtil.getValor(xml, "codigo-material"), null);
        this.iniciarConfiguraCampoResult();
    }

    public DialogoConfigurador(Dialog pai, String titulo, boolean modal, boolean isPermitirConfigurarMascaraPDF) {
        super(pai, titulo, modal);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.iniciar();
    }

    public DialogoConfigurador(Frame pai) {
        super(pai, "", true);
        this.iniciar();
    }

    public DialogoConfigurador(Dialog pai, String titulo, boolean modal, boolean isPermitirConfigurarMascaraPDF, String[] camposVariaveis) {
        super(pai, titulo, modal);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.pagina.setListaVariaveis(camposVariaveis);
        this.iniciar();
    }

    public DialogoConfigurador(Frame pai, String titulo, boolean modal, boolean isPermitirConfigurarMascaraPDF, String[] camposVariaveis) {
        super(pai, titulo, modal);
        this.isPermitirConfigurarMascaraPDF = isPermitirConfigurarMascaraPDF;
        this.pagina.setListaVariaveis(camposVariaveis);
        this.iniciar();
    }

    public void setExameLabExterno(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, Integer codigoMaterialPai) {
        this.setExameLabExterno(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, null, codigoMaterialPai);
    }

    public void setExameLabExterno(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, ArrayList examesDesmembradosLabExterno, Integer codigoMaterialPai) {
        this.protocolo = protocolo;
        this.codigoLabExterno = codigoLabExterno;
        this.examesDesmembradosLabExterno = examesDesmembradosLabExterno;
        CamposImportacao campos = null;
        if (protocolo == Protocolo.HPardini) {
            this.camposHPardini = this.carregarCamposHPardini(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, codigoMaterialPai);
        } else if (protocolo == Protocolo.INDLab) {
            this.camposIndLab = this.carregarCamposIndlab(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, codigoMaterialPai);
        } else if (protocolo == Protocolo.MercolabWS) {
            this.camposMercolab = this.carregarCamposMercolab(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, codigoMaterialPai);
        } else if (protocolo == Protocolo.Shift) {
            this.camposShift = this.carregarCamposShift(protocolo, codigoLabExterno, codExameLabExterno, codigoMaterialPai);
        }
        if (examesDesmembradosLabExterno == null || examesDesmembradosLabExterno.isEmpty()) {
            campos = this.pagina.carregarCamposImportacaoLabExternoAutomaticamente(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, true, codigoMaterialPai);
        } else {
            ArrayList<CamposDesmembramento> listaDesmembrados = this.getExamesDesm();
            for (CamposDesmembramento campoDesm : listaDesmembrados) {
                String codigoLab = FabricaConfigurador.getCodigoIdentExameLabExternoSelecionado(protocolo, codigoLabExterno, campoDesm.getXmlLabExterno());
                campoDesm.setCodigoLabExterno(codigoLab);
            }
            campos = this.pagina.carregarCamposImportacaoLabExternoAutomaticamente(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, true, listaDesmembrados, codigoMaterialPai);
        }
        if (protocolo == Protocolo.HPardini && !this.camposHPardini.isEmpty() && this.camposHPardini.size() > 0) {
            this.exibirDadosCamposImportacaoPardini(this.camposHPardini);
        } else if (protocolo == Protocolo.INDLab && !this.camposIndLab.isEmpty() && this.camposIndLab.size() > 0) {
            this.exibirDadosCamposImportacaoIndlab(this.camposIndLab);
        } else if (protocolo == Protocolo.MercolabWS && !this.camposMercolab.isEmpty() && this.camposMercolab.size() > 0) {
            this.exibirDadosCamposImportacaoMercolab(this.camposMercolab);
        } else if (protocolo == Protocolo.Shift && !this.camposShift.isEmpty() && this.camposShift.size() > 0) {
            this.exibirDadosCamposImportacaoShift(this.camposShift);
        } else {
            this.exibirDadosCamposImportacao(campos);
        }
        this.panelCamposImportacao.setVisible(true);
    }

    private Map<String, CamposImportacao> carregarCamposHPardini(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, Integer codigoMaterialPai) {
        this.camposHPardini = this.pagina.carregarCamposImportacaoAutomaticamentePardini(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, codigoMaterialPai);
        return this.camposHPardini;
    }

    private Map<String, CamposImportacao> carregarCamposIndlab(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, Integer codigoMaterialPai) {
        this.camposIndLab = this.pagina.carregarCamposImportacaoAutomaticamenteIndlab(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, codigoMaterialPai);
        return this.camposIndLab;
    }

    private Map<String, CamposImportacao> carregarCamposMercolab(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, Integer codigoMaterialPai) {
        this.camposMercolab = this.pagina.carregarCamposImportacaoAutomaticamenteMercolab(protocolo, codigoLabExterno, codExameLabExterno, xmlExameLabExterno, codigoMaterialPai);
        return this.camposMercolab;
    }

    private Map<String, CamposImportacao> carregarCamposShift(Protocolo protocolo, String codigoLabExterno, String codExameLabExterno, Integer codigoMaterialPai) {
        this.camposShift = this.pagina.carregarCamposImportacaoAutomaticamenteShift(protocolo, codigoLabExterno, codExameLabExterno, codigoMaterialPai);
        return this.camposShift;
    }

    private ArrayList<CamposDesmembramento> getExamesDesm() {
        ArrayList<CamposDesmembramento> listaDesm = new ArrayList<CamposDesmembramento>();
        ArrayList exameDesm = this.examesDesmembradosLabExterno;
        Statement st = Conexao.getStatement();
        for (InterfaceDesmembrar interfaceDesmembrar : exameDesm) {
            StringBuilder buf = new StringBuilder();
            buf.append("SELECT b.exa_codigo, b.exa_kodigo, b.mco_kodigo,a.ele_padrao, a.ele_bloqueado, a.ele_xmllabexterno ");
            buf.append("FROM examematcoletalabextdesm  b ");
            buf.append("LEFT JOIN examematcoletalabexterno  a ON b.fil_codigo = a.fil_codigo ");
            buf.append(" and b.exa_kodigo = a.exa_codigo  ");
            buf.append(" and  b.lae_codigo = a.lae_codigo ");
            buf.append(" and b.mco_kodigo = a.mco_codigo ");
            buf.append("where b.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("  and b.exa_codigo = '").append(interfaceDesmembrar.getCodigoPai()).append("' ");
            buf.append("  and b.mco_codigo = '").append(interfaceDesmembrar.getMaterialPai() == null ? interfaceDesmembrar.getMaterial().getCodigo() : interfaceDesmembrar.getMaterialPai().intValue()).append("' ");
            buf.append("  and b.lae_codigo = '").append(this.codigoLabExterno).append("' ");
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    CamposDesmembramento desm = new CamposDesmembramento();
                    desm.setCodigo(rs.getString("exa_kodigo"));
                    desm.setMaterial(rs.getInt("mco_kodigo"));
                    desm.setXmlLabExterno(rs.getString("ele_xmllabexterno"));
                    desm.setPadrao(rs.getBoolean("ele_padrao"));
                    desm.setBloqueado(rs.getBoolean("ele_bloqueado"));
                    desm.setCodigoLabExterno(this.codigoLabExterno);
                    if (listaDesm.contains(desm)) continue;
                    listaDesm.add(desm);
                }
                rs.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Conexao.fecharStatement(st);
        return listaDesm;
    }

    private void exibirDadosCamposImportacao(CamposImportacao campos) {
        this.versaoExameLabExterno = campos == null ? "" : campos.getVersao();
        this.labelCamposCarregados.setText(campos == null ? CAMPOS_NAO_CARREGADOS : CAMPOS_CARREGADOS);
        this.labelCamposCarregados.setForeground(campos == null ? Color.red : Color.black);
        this.labelExameExterno.setText(campos == null ? "" : campos.getCodigoExameLabExterno());
        this.labelVersaoCampos.setText(campos == null ? "" : campos.getVersao());
    }

    private void exibirDadosCamposImportacaoPardini(Map<String, CamposImportacao> campos) {
        this.versaoExameLabExterno = campos == null ? "" : campos.get(this.comboVersoes.getSelectedItem());
        this.labelCamposCarregados.setText(campos == null ? CAMPOS_NAO_CARREGADOS : CAMPOS_CARREGADOS);
        this.labelCamposCarregados.setForeground(campos == null ? Color.red : Color.black);
        if (campos != null && !campos.isEmpty()) {
            for (String key : campos.keySet()) {
                this.labelExameExterno.setText(((CamposImportacaoHPardini)campos.get(key)).getCodigoExameLabExterno());
                this.comboVersoes.addItem((CamposImportacaoHPardini)campos.get(key));
                this.versoesExameLabExterno.put(key, (CamposImportacaoHPardini)campos.get(key));
                if (this.versaoExameLabExterno != null) continue;
                this.labelVersaoCampos.setText(key);
            }
            if (this.examesDesmembradosLabExterno.isEmpty()) {
                this.pagina.setVersaoSelecionada((CamposImportacao)this.comboVersoes.getSelectedItem());
            }
        }
    }

    private void exibirDadosCamposImportacaoIndlab(Map<String, CamposImportacao> campos) {
        this.versaoExameLabExterno = campos == null ? "" : campos.get(this.comboVersoes.getSelectedItem());
        this.labelCamposCarregados.setText(campos == null ? CAMPOS_NAO_CARREGADOS : CAMPOS_CARREGADOS);
        this.labelCamposCarregados.setForeground(campos == null ? Color.red : Color.black);
        if (campos != null && !campos.isEmpty()) {
            for (String key : campos.keySet()) {
                this.labelExameExterno.setText(((CamposImportacaoIndlab)campos.get(key)).getCodigoExameLabExterno());
                this.comboVersoes.addItem((CamposImportacaoIndlab)campos.get(key));
                this.versoesExameLabExterno.put(key, (CamposImportacaoIndlab)campos.get(key));
                if (this.comboVersoes.getItemCount() > 1) continue;
                this.labelVersaoCampos.setText(key);
            }
            if (this.examesDesmembradosLabExterno.isEmpty()) {
                this.pagina.setVersaoSelecionada((CamposImportacao)this.comboVersoes.getItemAt(0));
            }
        }
    }

    private void exibirDadosCamposImportacaoMercolab(Map<String, CamposImportacao> campos) {
        this.versaoExameLabExterno = campos == null ? "" : campos.get(this.comboVersoes.getSelectedItem());
        this.labelCamposCarregados.setText(campos == null ? CAMPOS_NAO_CARREGADOS : CAMPOS_CARREGADOS);
        this.labelCamposCarregados.setForeground(campos == null ? Color.red : Color.black);
        if (campos != null && !campos.isEmpty()) {
            for (String key : campos.keySet()) {
                this.labelExameExterno.setText(((CamposImportacaoMercolab)campos.get(key)).getCodigoExameLabExterno());
                this.comboVersoes.addItem((CamposImportacaoMercolab)campos.get(key));
                this.versoesExameLabExterno.put(key, (CamposImportacaoMercolab)campos.get(key));
                if (this.versaoExameLabExterno != null) continue;
                this.labelVersaoCampos.setText(key);
            }
            if (this.examesDesmembradosLabExterno.isEmpty()) {
                this.pagina.setVersaoSelecionada((CamposImportacao)this.comboVersoes.getSelectedItem());
            }
        }
    }

    private void exibirDadosCamposImportacaoShift(Map<String, CamposImportacao> campos) {
        this.versaoExameLabExterno = campos == null ? "" : campos.get(this.comboVersoes.getSelectedItem());
        this.labelCamposCarregados.setText(campos == null ? CAMPOS_NAO_CARREGADOS : CAMPOS_CARREGADOS);
        this.labelCamposCarregados.setForeground(campos == null ? Color.red : Color.black);
        if (campos != null && !campos.isEmpty()) {
            for (String key : campos.keySet()) {
                this.labelExameExterno.setText(((CamposImportacaoShift)campos.get(key)).getCodigoExameLabExterno());
                this.comboVersoes.addItem(campos.get(key));
                this.versoesExameLabExterno.put(key, campos.get(key));
                if (this.versaoExameLabExterno != null) continue;
                this.labelVersaoCampos.setText(key);
            }
            if (this.examesDesmembradosLabExterno.isEmpty()) {
                this.pagina.setVersaoSelecionada((CamposImportacao)this.comboVersoes.getSelectedItem());
            }
        }
    }

    public void setImpressoraPadraoSistema(String impressora) {
        this.impressoraPadraoSistema = impressora;
    }

    public void setCabecalhoImpressaoSistema(String cabecalho) {
        this.cabecalhoImpressaoSistema = cabecalho;
    }

    public void setOcultarImprimirVisualizacao(boolean b) {
        this.ocultarImprimirVisualizacao = b;
    }

    public void setCamposResultadoAnterior(ArrayList<Componente> campos) {
        this.resultadosAnteriores = campos;
        this.pagina.setCamposResultadoAnterior(this.resultadosAnteriores);
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        int pos = this.getWidth() - 250;
        this.splitDivisor.setDividerLocation(pos);
    }

    @Override
    public void componentShown(ComponentEvent ce) {
        this.componentResized(ce);
    }

    public String getPropriedadeCampoNome() {
        return this.propriedadeCampoNome;
    }

    public void setPropriedadeCampoNome(String propriedadeCampoNome) {
        this.propriedadeCampoNome = propriedadeCampoNome;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.buttonSeta) {
            this.pagina.setNovoComponente(null);
        } else if (this.botoes.containsKey(source)) {
            this.pagina.setNovoComponente(this.botoes.get(ae.getSource()));
        } else if (source == this.buttonOk && this.isConfiguracaoCampoResult) {
            this.ok = true;
            try {
                String propriedadeNome = (String)((Gerenciador)this.pagina.getTablePropriedades().getModel()).valorProp("nome");
                if (!Funcoes.textoVazio(propriedadeNome)) {
                    this.setPropriedadeCampoNome(propriedadeNome);
                }
            }
            catch (Exception propriedadeNome) {
                // empty catch block
            }
            if (this.ok) {
                this.dispose();
            }
        } else if (source == this.buttonOk) {
            this.getAtributos();
            boolean bl = this.ok = this.validarConfiguracao() && this.validaCamposImportacao() && this.validarPropriedades();
            if (this.ok) {
                this.dispose();
            }
        } else if (source == this.buttonCancelar) {
            this.dispose();
        } else if (source == this.buttonVisualizar) {
            this.exibirPreVisualizacao(this.ocultarImprimirVisualizacao);
        } else if (source == this.buttonImportar) {
            JFileChooser fc = ComponenteFactory.novoJFileChooser();
            fc.setFileFilter(ComponenteFactory.novoFileFilter("Configura\u00e7\u00e3o de exame", "xml"));
            if (fc.showOpenDialog(this) == 0) {
                this.pagina.limpar();
                try {
                    this.setAtributos(StringUtil.lerArquivoTexto(fc.getSelectedFile().getPath()));
                }
                catch (Exception e) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel ler o arquivo de configura\u00e7\u00e3o.\nMensagem: " + e.getMessage(), 1);
                }
                this.pagina.repaint();
            }
        } else if (source == this.buttonExportar) {
            JFileChooser fc = ComponenteFactory.novoJFileChooser();
            fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de relat\u00f3rio", "xml"));
            if (fc.showSaveDialog(this) == 0) {
                try {
                    StringUtil.escreverArquivoTexto(StringUtil.concatenarExtensao(fc.getSelectedFile().getPath(), ".xml"), this.getAtributos());
                }
                catch (Exception e) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel exportar modelo para o arquivo selecionado.\nMensagem: " + e.getMessage(), 1);
                }
            }
        } else if (source == this.buttonCodigoQRCode) {
            this.pagina.setNovoComponente(CodigoQRCode.class);
        } else if (source == this.buttonEstilos) {
            this.configurarEstilos();
        } else if (source == this.buttonLigacoes) {
            this.mostrarLigacoes(this.buttonLigacoes.isSelected());
        } else if (source == this.buttonOcultarLinhas) {
            this.pagina.setExibirLinhasGuias(!this.pagina.getExibirLinhasGuias());
            this.buttonOcultarLinhas.setText(this.pagina.getExibirLinhasGuias() ? "Ocultar linhas" : "Exibir linhas");
            this.scrollArea.repaint();
        } else if (source == this.buttonParametros) {
            DialogoParametrosCorpo dpc;
            if (this.pagina.getTipoConfiguracao() == 1) {
                DialogoParamCabecRodape dp = DialogoParamCabecRodape.novaInstancia(this, this.isPermitirConfigurarMascaraPDF);
                if (dp != null) {
                    dp.setAtributosPagina(this.pagina.getTamanho(), this.pagina.getMargens());
                    dp.setDistanciaEntreExames(this.pagina.getDistanciaEntreExamesCentimetros());
                    dp.setExibirSumario(this.pagina.exibeSumario());
                    dp.setExibirRodapeExame(this.pagina.isExibirRodapeExame());
                    dp.setCamposAssinatura(this.pagina.getCamposAssinatura());
                    dp.setAssinaturas(this.pagina.getAssinaturaSumario(), this.pagina.getAssinaturaRodape());
                    dp.setParametrosAreaLivre(this.pagina.getParametrosAreaLivre());
                    dp.setSeparadorCOA(this.pagina.getSeparadorCOA());
                    dp.setSeparadorSOA(this.pagina.getSeparadorSOA());
                    dp.setSeparadorExame(this.pagina.getSeparadorExames());
                    dp.setParametrosLinhasCorpo(this.pagina.getParametrosLinhasCorpo());
                    dp.setAlinhamentoReferenciaSumario(this.pagina.getAlinhamentoReferenciaSumario());
                    dp.setFonteReferencia(this.pagina.getFonteReferenciaSumario());
                    dp.setAlturaReferenciaSumario(this.pagina.getAlturaReferenciaSumario());
                    dp.setPosicaoReferenciaSumario(this.pagina.getPosicaoReferenciaSumario());
                    dp.setMascaraPdf(this.pagina.getMascaraPdf());
                    dp.setQualidadeImagem(this.pagina.getQualidadeImagensLaudo());
                    dp.setVisible(true);
                    if (dp.ok()) {
                        this.pagina.setExibirSumario(dp.exibirSumario());
                        this.pagina.setExibirRodapeExame(dp.isExibirRodapeExame());
                        this.pagina.setDistanciaEntreExames(dp.getDistanciaEntreExames());
                        this.pagina.setTamanho(dp.getTamanhoPagina());
                        this.pagina.setMargens(dp.getMargens());
                        this.pagina.setParametrosAreaLivre(dp.getParametrosAreaLivre());
                        this.pagina.setSeparadorSOA(dp.getSeparadorSOA());
                        this.pagina.setSeparadorCOA(dp.getSeparadorCOA());
                        this.pagina.setQualidadeImagensLaudo(dp.getQualidadeImagem());
                        this.pagina.setSeparadorExames(dp.getSeparadorExame());
                        this.pagina.setParametrosLinhasCorpo(dp.getParametrosLinhasCorpo());
                        this.pagina.setAlinhamentoReferenciaSumario(dp.getAlinhamentoReferenciaSumario());
                        this.pagina.setFonteReferenciaSumario(dp.getFonteReferencia());
                        this.pagina.setAlturaReferenciaSumario(dp.getAlturaReferenciaSumario());
                        this.pagina.setPosicaoReferenciaSumario(dp.getPosicaoReferenciaSumario());
                        this.pagina.setMascaraPdf(dp.getMascaraPdf());
                        this.pagina.setAssinaturaSumario(dp.getAssinaturaSumario());
                        this.pagina.setAssinaturaRodape(dp.getAssinaturaRodape());
                    }
                }
            } else if (this.pagina.getTipoConfiguracao() == 0 && (dpc = DialogoParametrosCorpo.novaInstancia(this, "Configura\u00e7\u00e3o de par\u00e2metros do corpo do exame")) != null) {
                dpc.setAtributos(this.parametros);
                dpc.setPagina(this.pagina);
                dpc.setCamposExame(this.getCamposExame());
                dpc.setVisible(true);
                if (dpc.ok()) {
                    this.parametros = dpc.getAtributos();
                    this.pagina.setParametros(this.parametros);
                }
            }
        } else if (source == this.comboVersoes) {
            this.pagina.setVersaoSelecionada((CamposImportacao)this.comboVersoes.getSelectedItem());
        }
    }

    private boolean validarPropriedades() {
        Component[] c;
        String mensagemErro = "Valor incorreto para propriedade ";
        for (Component component : c = this.pagina.getComponents()) {
            if (this.validarPropriedadesCampo(component)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), mensagemErro + "bloquear foco do componente " + component.getName(), 1);
                return false;
            }
            if (!this.validarPropriedadesTexto(component)) continue;
            Funcoes.mensagem(Laboratorio.getInstancia(), mensagemErro + "edit\u00e1vel do componente " + component.getName(), 1);
            return false;
        }
        return true;
    }

    private boolean validarPropriedadesTexto(Component componente) {
        if (this.validarTipoComponenteTexto(componente)) {
            Texto texto = (Texto)componente;
            if (!StringUtil.getBoolean(this.parametros, "destacarValorReferencia")) {
                texto.setColorirReferencia(false);
            }
            return !texto.getEditavel() && Funcoes.textoVazio(texto.getTexto()) && Funcoes.textoVazio(texto.getExpressao()) && Funcoes.textoVazio(texto.getCampoImportacao().campoImportacao);
        }
        return false;
    }

    private boolean validarPropriedadesCampo(Component componente) {
        if (this.validarTipoComponenteCampo(componente)) {
            Campo campo = (Campo)componente;
            if (!StringUtil.getBoolean(this.parametros, "destacarValorReferencia")) {
                campo.setColorirReferencia(false);
            }
            return campo.getBloquearFoco() && !campo.getRemoverVazio() && Funcoes.textoVazio(campo.getValorPadrao()) && Funcoes.textoVazio(campo.getCampoImportacao().campoImportacao);
        }
        return false;
    }

    private boolean validarTipoComponenteTexto(Component component) {
        return component instanceof Texto;
    }

    private boolean validarTipoComponenteCampo(Component component) {
        return component instanceof Campo;
    }

    private boolean validaCamposImportacao() {
        if (this.protocoloUsaComboVersoesPorExame()) {
            boolean isTodosConfigurados = true;
            for (Componente comp : this.pagina.getComponentes()) {
                if (comp.getMapCamposImportacao().isEmpty() || comp.getMapCamposImportacao().size() == this.comboVersoes.getItemCount()) continue;
                isTodosConfigurados = false;
                break;
            }
            if (!isTodosConfigurados && Funcoes.mensagem(this, "Existem Formatos que n\u00e3o foram configurados para importa\u00e7\u00e3o de resultados. Deseja continuar?", 4) != 0) {
                return false;
            }
        }
        return true;
    }

    public String[] getCampos() {
        ArrayList<String> campos = new ArrayList<String>();
        for (Componente c : this.pagina.getComponentes()) {
            campos.add(c.getNome());
        }
        return campos.toArray(new String[campos.size()]);
    }

    public boolean contemConfiguracao() {
        if (this.pagina.getTipoConfiguracao() == 0) {
            return !this.pagina.getComponentes().isEmpty();
        }
        return !this.pagina.getComponentes().isEmpty() || this.pagina.getAssinaturaSumario().exibir() || this.pagina.getAssinaturaRodape().exibir();
    }

    public void setTipoConfiguracao(int tipo) {
        this.pagina.setTipoConfiguracao(tipo);
        this.pagina.setRedimensionavel(tipo == 1 || tipo == 2);
        this.buttonVisualizar.setVisible(tipo == 0);
        this.buttonCampo.setVisible(tipo == 0);
        this.buttonTexto.setVisible(tipo == 0 || tipo == 2);
        this.buttonHistorico.setVisible(tipo == 0);
        this.buttonAssinatura.setVisible(tipo == 0);
        this.buttonResAnterior.setVisible(tipo == 0);
        this.buttonCodBarras.setVisible(tipo == 1 || tipo == 2);
        this.buttonRegua.setVisible(tipo == 0);
        this.buttonExterno.setVisible(tipo == 0);
        this.buttonGrafico.setVisible(tipo == 0);
        this.buttonRTF.setVisible(tipo == 0);
        this.buttonEstilos.setVisible(false);
        this.buttonLigacoes.setVisible(tipo == 0);
        this.buttonCodigoQRCode.setVisible(false);
        this.panelPaginador.setVisible(tipo == 0);
        if (tipo == 0) {
            this.panelPaginador.add((Component)this.pagina.getControlePaginas(), "Center");
        }
    }

    public void setTipoConfiguracaoCampoResultados(int tipo) {
        this.pagina.setTipoConfiguracao(tipo);
        this.pagina.setRedimensionavel(tipo == 1 || tipo == 2);
        this.buttonCampo.setVisible(tipo == 0);
        this.buttonTexto.setVisible(tipo == 0);
        this.buttonHistorico.setVisible(tipo == 0);
        this.buttonAssinatura.setVisible(tipo == 0);
        this.buttonResAnterior.setVisible(tipo == 0);
        this.buttonCodBarras.setVisible(tipo == 1 || tipo == 2);
        this.buttonCodigoQRCode.setVisible(false);
        this.buttonRegua.setVisible(tipo == 0);
        this.buttonExterno.setVisible(tipo == 0);
        this.buttonGrafico.setVisible(tipo == 0);
        this.buttonRTF.setVisible(tipo == 0);
        this.buttonEstilos.setVisible(false);
        this.panelPaginador.setVisible(tipo == 0);
        if (tipo == 0) {
            this.panelPaginador.add((Component)this.pagina.getControlePaginas(), "Center");
        }
    }

    public void setInterfaceRelacionamento(InterfaceRelacionamento inter) {
        this.pagina.setInterfaceRelacionamento(inter);
        this.panelComponentes.setVisible(inter == null);
        this.panelBotoesEsq.setVisible(inter == null);
    }

    public boolean ok() {
        return this.ok;
    }

    private void mostrarLigacoes(boolean selecionado) {
        this.pagina.setExibirLigacoes(selecionado);
    }

    public boolean isReconfigurarLabExterno() {
        return this.reconfigurarLabExterno;
    }

    public void configurarEstilos() {
        DialogoConfiguradorEstilos de = DialogoConfiguradorEstilos.novaInstancia(this);
        de.setEstilos(this.estilos);
        de.setVisible(true);
        if (de.getOK()) {
            this.estilos = de.getEstilos();
        }
    }

    public String getAtributos() {
        StringBuilder bui = new StringBuilder();
        String hashOriginal = null;
        String hashAtual = null;
        if (!Funcoes.textoVazio(this.xmlOriginal)) {
            try {
                hashOriginal = StringUtil.calcularCodigoHash(this.xmlOriginal);
                hashAtual = StringUtil.calcularCodigoHash(this.pagina.getAtributos());
            }
            catch (NoSuchAlgorithmException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel calcular o hash do configurador. \n" + e.getMessage(), e.getStackTrace());
            }
        }
        int versao = Integer.parseInt(this.versaoExame);
        if (!(Funcoes.textoVazio(hashOriginal) || Funcoes.textoVazio(hashAtual) || hashOriginal.equals(hashAtual))) {
            versao = Integer.parseInt(this.versaoExame) + 1;
        }
        bui.append(StringUtil.getTag("versaoExame", String.valueOf(versao)));
        bui.append(StringUtil.getTag("versao", "3.0"));
        bui.append(StringUtil.getTag("tipo", "configuracao"));
        if (this.versoesExameLabExterno != null && this.versoesExameLabExterno.size() >= 1) {
            String versoes = this.versoesExameLabExterno.values().toString().replace("[", "").replace("]", "");
            bui.append(StringUtil.getTag("versaoExameLabExterno", versoes));
        } else {
            bui.append(StringUtil.getTag("versaoExameLabExterno", this.versaoExameLabExterno));
        }
        bui.append(StringUtil.getTag("pagina", this.pagina.getAtributos()));
        bui.append(StringUtil.getTag("parametros", this.parametros));
        if (this.isPermitirConfigurarMascaraPDF && this.pagina.getMascaraPdf().trim().length() > 0) {
            bui.append(StringUtil.getTag("mascaraPDF", this.pagina.getMascaraPdf()));
        }
        if (this.estilos != null && this.estilos.size() > 0) {
            StringBuilder buf = new StringBuilder();
            for (AtributosEstilo estilo : this.estilos) {
                buf.append(estilo.getXML());
            }
            bui.append(StringUtil.getTag("estilos", buf.toString()));
        }
        return StringUtil.getTag("exame", bui.toString());
    }

    public static String getAtributosParaExportacao(String formato, boolean tratarHTML, boolean cdata) throws XMLStringBuilderException {
        Pagina pagina = new Pagina();
        if (formato != null) {
            String exame = StringUtil.getValor(formato, "exame");
            String versao = StringUtil.getValor(exame, "exame");
            if (Funcoes.textoVazio(versao) || !Funcoes.isNumeric(versao)) {
                versao = "0";
            }
            exame = StringUtil.getValor(exame, "pagina");
            String tmp = StringUtil.getValor(exame, "propriedades");
            pagina.setMargem(StringUtil.getValor(tmp, "margemEsquerda"), 0);
            pagina.setMargem(StringUtil.getValor(tmp, "margemDireita"), 1);
            pagina.setMargem(StringUtil.getInt(tmp, "margemSuperior") + StringUtil.getInt(tmp, "alturaCabecalho"), 2);
            pagina.setMargem(StringUtil.getInt(tmp, "margemInferior") + StringUtil.getInt(tmp, "alturaRodape") + (StringUtil.getBoolean(tmp, "exibirSumario") ? StringUtil.getInt(tmp, "alturaSumario") : 0), 3);
            pagina.setTamanho(StringUtil.getValor(tmp, "largura"), StringUtil.getValor(tmp, "altura"));
            pagina.limpar();
            pagina.setTipoConfiguracao(0);
            pagina.setAtributos(exame, versao);
            List<Componente> lista = pagina.getComponentes();
            XMLStringBuilder xml = new XMLStringBuilder();
            if (lista.size() > 0) {
                xml.abrir("exame");
                xml.escrever("versaoExame", versao);
                for (Componente c : lista) {
                    String texto;
                    XMLStringBuilder temp = new XMLStringBuilder();
                    temp.escrever("nome", c.getNome());
                    temp.escrever("tipo", c instanceof Digitavel ? "CAMPO" : "TEXTO");
                    temp.escrever("altura", String.valueOf(c.getAltura()));
                    temp.escrever("largura", String.valueOf(c.getLargura()));
                    temp.escrever("nomeFonte", c.getFonte().getFontName());
                    temp.escrever("tamanhoFonte", String.valueOf(c.getFonte().getSize()));
                    temp.escrever("esquerda", String.valueOf(c.getEsquerda()));
                    temp.escrever("topo", String.valueOf(c.getTopo()));
                    String string = texto = c instanceof Rotulo ? ((Rotulo)c).getTexto() : c.getValorPadrao();
                    if (tratarHTML) {
                        texto = StringUtil.tratarEntidadesHTML(texto);
                    }
                    if (cdata) {
                        texto = "<![CDATA[" + texto + "]]>";
                    }
                    temp.escrever("texto", texto);
                    xml.escrever("componente", temp);
                }
                xml.fechar("exame");
            }
            return xml.getXML();
        }
        return "";
    }

    public static String getAtributosParaExportacao(String formato, boolean tratarHTML) throws XMLStringBuilderException {
        return DialogoConfigurador.getAtributosParaExportacao(formato, tratarHTML, false);
    }

    public void setAtributos(String atr) {
        if (atr != null) {
            String tmp = StringUtil.getValor(atr, "exame");
            this.xmlOriginal = StringUtil.getValor(tmp, "pagina");
            this.setVersaoExame(StringUtil.getValor(tmp, "versaoExame"));
            this.setVersaoExameLabExterno(StringUtil.getValor(atr, "versaoExameLabExterno"));
            this.parametros = StringUtil.getValor(atr, "parametros", false, null, false);
            this.pagina.setParametros(this.parametros);
            String mascaraPdf = StringUtil.getValor(atr, "mascaraPDF");
            if (!Funcoes.textoVazio(mascaraPdf)) {
                this.pagina.setMascaraPdf(mascaraPdf);
            }
            String versaoXMLLayout = StringUtil.getValor(atr, "versao");
            this.adicionarParametroAtualizacaoVersao1DoCorpo(versaoXMLLayout);
            this.pagina.limpar();
            this.pagina.setAtributos(StringUtil.getValor(tmp, "pagina"), versaoXMLLayout);
            String estilosXML = StringUtil.getValor(tmp, "estilos");
            if (estilosXML != null && estilosXML.trim().length() > 0) {
                String[] temp;
                for (String s : temp = StringUtil.getValores(estilosXML, "estilo")) {
                    AtributosEstilo estilo = new AtributosEstilo();
                    estilo.setXML(StringUtil.getTag("estilo", s));
                    this.estilos.add(estilo);
                }
            }
        }
    }

    private void adicionarParametroAtualizacaoVersao1DoCorpo(String versaoXMLLayout) {
        DialogoParametrosCorpo dpc;
        if (this.pagina.getTipoConfiguracao() == 0 && (dpc = DialogoParametrosCorpo.novaInstancia(this, "")) != null) {
            dpc.setAtributos(this.parametros);
            if (versaoXMLLayout.equals("1.0") || StringUtil.getValor(this.parametros, "reposicionarComponentes").trim().length() == 0) {
                this.parametros = dpc.getAtributos();
            }
        }
    }

    public void setAtributosDaPagina(String xml) {
        if (xml != null) {
            String tmp = StringUtil.getValor(xml, "exame");
            tmp = StringUtil.getValor(tmp, "pagina");
            tmp = StringUtil.getValor(tmp, "propriedades");
            this.pagina.setMargem(StringUtil.getValor(tmp, "margemEsquerda"), 0);
            this.pagina.setMargem(StringUtil.getValor(tmp, "margemDireita"), 1);
            this.pagina.setMargem(StringUtil.getInt(tmp, "margemSuperior") + StringUtil.getInt(tmp, "alturaCabecalho"), 2);
            this.pagina.setMargem(StringUtil.getInt(tmp, "margemInferior") + StringUtil.getInt(tmp, "alturaRodape") + (StringUtil.getBoolean(tmp, "exibirSumario") ? StringUtil.getInt(tmp, "alturaSumario") : 0), 3);
            this.pagina.setTamanho(StringUtil.getValor(tmp, "largura"), StringUtil.getValor(tmp, "altura"));
            this.pagina.setLinhaGuiaCabecalho(StringUtil.getValor(tmp, "linhasGuia"));
        }
    }

    public void setFormatacaoExterna(String xml) {
        if (xml != null) {
            try {
                ArrayList<String> externos = new ArrayList<String>();
                Class<Digitavel> ClassDigitavel = Digitavel.class;
                String tmp = StringUtil.getValor(xml, "exame");
                tmp = StringUtil.getValor(tmp, "pagina");
                tmp = StringUtil.getValor(StringUtil.getValor(tmp, "itens"), "corpo");
                for (String item : StringUtil.getValores(tmp, "componente")) {
                    tmp = StringUtil.getValor(item, "tipo");
                    if (!ClassDigitavel.isAssignableFrom(Class.forName(tmp))) continue;
                    externos.add(StringUtil.getValor(StringUtil.getValor(item, "atributos"), "nome"));
                }
                this.pagina.setCamposExternos(externos.toArray(new String[externos.size()]));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoConfigurador : 463");
            }
        }
    }

    public void setCamposBanco(String[] campos) {
        if (campos != null) {
            StringUtil.ordenar(campos);
            this.pagina.setCamposBanco(campos);
        }
    }

    public void setCamposAssinatura(CampoAssinaturaLaudo[] campos) {
        if (campos != null) {
            this.pagina.setCamposAssinatura(campos);
        }
    }

    public void setHistoricos(Map<String, Map<String, String>> historicos) {
        this.pagina.setHistoricos(historicos);
    }

    public void setTags(String tags) {
        this.pagina.setTags(tags);
    }

    public Pagina getPagina() {
        return this.pagina;
    }

    private boolean validarConfiguracao() {
        this.validarValoresDeReferencia();
        boolean res = this.validarExpressoes();
        if (res) {
            res = this.validarComponentesComOrigem();
        }
        if (res) {
            res = this.validarComponentesComTagResultado();
        }
        if (res) {
            res = this.validarComponentesComConferenciaAutomaticaResultado();
        }
        if (res) {
            res = this.validaRemoverVazio();
        }
        if (res && this.pagina.getTipoConfiguracao() == 1 && this.pagina.exibeSumario() && !(res = this.pagina.validaAlturaSumarioReferencia())) {
            Funcoes.mensagem(this, "A altura informada para as refer\u00eancias n\u00e3o pode ser maior que a altura do sum\u00e1rio", 1);
        }
        return res;
    }

    private boolean validaRemoverVazio() {
        for (Component c : this.pagina.getComponents()) {
            if (!(c instanceof Campo) || !this.verificaConfigComponente(c)) continue;
            Funcoes.mensagem(Laboratorio.getInstancia(), "Selecione um item para a propriedade \"item vazio\" no campo " + ((Campo)c).getNome(), 2);
            return false;
        }
        return true;
    }

    private boolean verificaConfigComponente(Component c) {
        String itemVazio = ((Campo)c).getItemVazio();
        String[] itens = ((Campo)c).getItens();
        return ((Campo)c).getRemoverVazio() && StringUtil.getBoolean(this.parametros, "validarItemVazio") && (Funcoes.textoVazio(itemVazio) || itemVazio.equalsIgnoreCase(NULL)) && itens.length > 0;
    }

    private void exibirPreVisualizacao(boolean ocultarImprimir) {
        final JDialog dialogo = new JDialog(this, "Pre-visualiza\u00e7\u00e3o de digita\u00e7\u00e3o do exame", true);
        final Digitacao dig = new Digitacao();
        HashMap<Integer, String> resAnte = new HashMap<Integer, String>();
        resAnte.put(1, "<campo1>10,50</campo1><dataResultado>10/08/2006</dataResultado><horaResultado>15:35</horaResultado>");
        resAnte.put(2, "<campo1>5,00</campo1><dataResultado>06/07/2006</dataResultado><horaResultado>09:23</horaResultado>");
        resAnte.put(3, "<campo1>8,45</campo1><dataResultado>25/06/2006</dataResultado><horaResultado>16:00</horaResultado>");
        resAnte.put(4, "<campo1>6,75</campo1><dataResultado>18/06/2006</dataResultado><horaResultado>10:50</horaResultado>");
        dig.carregarCampos(this.getAtributos(), null, null, this.pagina.getHistoricos().get("historicoporcodigo"), this.pagina.getHistoricos().get("historicopormnemonico"), resAnte, 1, null);
        dig.setFocoPrimeiroCampo();
        dig.exibirBotaoFechar(true);
        dig.exibirBotaoSalvar(false);
        dig.exibirBotaoSalvarParcial(false);
        dig.exibirCheckBoxImprimir(false);
        dig.exibirBotaoImprimir(!this.ocultarImprimirVisualizacao);
        dig.addDigitacaoListener(new DigitacaoAdapter(){

            @Override
            public void acaoFechar(DigitacaoEvento e) {
                dialogo.dispose();
            }

            @Override
            public void acaoImprimir(DigitacaoEvento e) {
                Documento doc = new Documento();
                if (!Funcoes.textoVazio(DialogoConfigurador.this.cabecalhoImpressaoSistema)) {
                    doc.setCabecalhoRodape(DialogoConfigurador.this.cabecalhoImpressaoSistema);
                }
                doc.setCopias(1);
                DialogoConfigurador.this.exameMaterialPagina = new ExameMaterialPagina("", -1, null);
                doc.addResultados(new ExameMaterialPagina[]{DialogoConfigurador.this.exameMaterialPagina}, new String[]{dig.getResultado()});
                Impressao imp = new Impressao(DialogoConfigurador.this.impressoraPadraoSistema);
                imp.imprimir(doc);
            }
        });
        ScreenUtil.addActionMap(dig, KeyStroke.getKeyStroke(10, 0, false), "ENTER", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                if (owner instanceof JButton) {
                    ((JButton)owner).doClick();
                } else if (!(owner instanceof TextoDigitacao)) {
                    dig.setFocoProximo();
                }
            }
        });
        ScreenUtil.addActionMap(dig, KeyStroke.getKeyStroke(27, 0, true), "ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogo.dispose();
            }
        });
        ScreenUtil.addActionMap(dig, KeyStroke.getKeyStroke(38, 0, true), "UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dig.setFocoAnterior();
            }
        });
        ScreenUtil.addActionMap(dig, KeyStroke.getKeyStroke(40, 0, true), "DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dig.setFocoProximo();
            }
        });
        dialogo.getContentPane().setLayout(new BorderLayout());
        dialogo.getContentPane().add((Component)dig, "Center");
        dialogo.pack();
        Dimension tamanhoJanela = dialogo.getPreferredSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (dialogo.getPreferredSize().getWidth() >= screenSize.getWidth()) {
            tamanhoJanela.setSize((double)screenSize.width * 0.95, (double)tamanhoJanela.height);
        }
        if (dialogo.getPreferredSize().getHeight() >= screenSize.getHeight()) {
            tamanhoJanela.setSize((double)tamanhoJanela.width, (double)screenSize.height * 0.95);
        }
        dialogo.setSize(tamanhoJanela);
        ScreenUtil.centralizar(dialogo);
        dialogo.setVisible(true);
    }

    private boolean validarExpressoes() {
        Component[] c = this.pagina.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof Expressao)) continue;
            for (int j = 0; j < c.length; ++j) {
                String nome;
                if (!(c[j] instanceof Rotulo) && !(c[j] instanceof ResultadoAnterior) && !(c[j] instanceof Forma) && !(c[j] instanceof Imagem) && !(c[j] instanceof CodigoQRCode)) continue;
                String nomeExp = ((Componente)((Object)c[i])).getNome();
                String exp = ((Expressao)c[i]).getExpressao().toLowerCase();
                if (exp.indexOf(nome = ((Componente)((Object)c[j])).getNome().toLowerCase()) <= -1) continue;
                JOptionPane.showMessageDialog(this, "A express\u00e3o \"" + nomeExp + "\" n\u00e3o pode referenciar o item \"" + nome + "\"", "Erro com a express\u00e3o \"" + nomeExp + "\"", 0);
                return false;
            }
        }
        return true;
    }

    private void validarValoresDeReferencia() {
        ValoresReferencia vlr;
        int i;
        Component[] c = this.pagina.getComponents();
        ArrayList<Campo> tmp = new ArrayList<Campo>();
        for (int i2 = 0; i2 < c.length; ++i2) {
            if (!(c[i2] instanceof Campo)) continue;
            tmp.add((Campo)c[i2]);
        }
        Campo[] campos = tmp.toArray(new Campo[tmp.size()]);
        boolean semValoresReferencia = false;
        for (i = campos.length - 1; i >= 0; --i) {
            vlr = campos[i].getValoresDeReferencia();
            if (vlr == null || !vlr.zero()) continue;
            semValoresReferencia = true;
            break;
        }
        if (semValoresReferencia && Funcoes.mensagem(this, "H\u00e1 campos sem configura\u00e7\u00e3o de valores de refer\u00eancia.\nDeseja salvar o modelo sem os valores de refer\u00eancia?", 4) == 0) {
            return;
        }
        for (i = campos.length - 1; i >= 0; --i) {
            EditorValorReferencia.DialogoValorReferencia dvr;
            vlr = campos[i].getValoresDeReferencia();
            if (vlr == null || !vlr.zero() || (dvr = EditorValorReferencia.DialogoValorReferencia.novaInstancia(this, "Valores de refer\u00eancia [" + campos[i].getNome() + "]", campos[i].getMascara(), campos[i].getTipo())) == null) continue;
            dvr.setValores(vlr);
            dvr.setVisible(true);
            if (!dvr.ok()) continue;
            campos[i].setValoresDeReferencia(dvr.getValores());
        }
    }

    private boolean validarComponentesComOrigem() {
        for (Componente comp : this.pagina.getComponentesParaArray()) {
            if (!(comp instanceof ReguaReferencial && !this.validarReguaReferencial((ReguaReferencial)comp) || comp instanceof Grafico && !this.validarGrafico((Grafico)comp)) && (!(comp instanceof ResultadoAnterior) || this.validarResultadoAnterior((ResultadoAnterior)comp))) continue;
            return false;
        }
        return true;
    }

    private boolean validarComponentesComTagResultado() {
        for (Componente comp : this.pagina.getComponentesParaArray()) {
            if (!(comp instanceof AbstractComponente) || !(comp instanceof ComponenteEditor) || Funcoes.textoVazio(this.pagina.getTags()) || this.validarTagResultadoComponente((ComponenteEditor)((Object)comp))) continue;
            Funcoes.mensagem(Laboratorio.getInstancia(), "A tag de resultado do componente \"" + comp.getNome() + "\" deve ser selecionada.", 2);
            return false;
        }
        return true;
    }

    private boolean validarComponentesComConferenciaAutomaticaResultado() {
        for (Componente comp : this.pagina.getComponentesParaArray()) {
            boolean validarMedia;
            if (!(comp instanceof AbstractComponente) || !(comp instanceof ComponenteEditor) || Funcoes.textoVazio(((ComponenteEditor)((Object)comp)).getConferenciaAutomatica()) || ((ComponenteEditor)((Object)comp)).getConferenciaAutomatica().equalsIgnoreCase("Desativada")) continue;
            if (!this.validarValorSelecionadoConferenciaResultado((ComponenteEditor)((Object)comp))) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A confer\u00eancia autom\u00e1tica de resultado do componente \"" + comp.getNome() + "\" deve ser selecionada.", 2);
                return false;
            }
            String xml = StringUtil.getValor(this.parametros, "conferenciaAutomatica");
            String tipoCalculo = StringUtil.getValor(xml, "tipoCalculo");
            boolean bl = validarMedia = !Funcoes.textoVazio(tipoCalculo) && tipoCalculo.equalsIgnoreCase("M\u00e9dia");
            if (!validarMedia || !((ComponenteEditor)((Object)comp)).getConferenciaAutomatica().equalsIgnoreCase("sim") || this.validarPercentualVariacao((ComponenteEditor)((Object)comp))) continue;
            Funcoes.mensagem(Laboratorio.getInstancia(), "O percentual de varia\u00e7\u00e3o deve ser informado para o componente \"" + comp.getNome() + "\".", 2);
            return false;
        }
        return true;
    }

    private boolean validarValorSelecionadoConferenciaResultado(ComponenteEditor comp) {
        return !Funcoes.textoVazio(comp.getConferenciaAutomatica());
    }

    private boolean validarPercentualVariacao(ComponenteEditor comp) {
        if (Funcoes.textoVazio(comp.getPercentualDeVariacao().getPercentualVariacao())) {
            return false;
        }
        String valor = Funcoes.limpaDecimal(comp.getPercentualDeVariacao().getPercentualVariacao());
        Double percentual = !Funcoes.textoVazio(comp.getPercentualDeVariacao().getPercentualVariacao()) ? Double.parseDouble(valor) : 0.0;
        return percentual >= 0.0;
    }

    private boolean validarTagResultadoComponente(ComponenteEditor comp) {
        if (comp instanceof Expressao || comp instanceof Historico) {
            return true;
        }
        ComponenteEditor editor = null;
        if (comp instanceof ComponenteEditor) {
            editor = comp;
        }
        return editor != null && (!editor.getResultadoAnterior() || editor.getTagResultado() != null);
    }

    private boolean validarReguaReferencial(ReguaReferencial regua) {
        String origem = regua.getOrigem().trim();
        if (origem.length() == 0 && regua.getTipoRegua() == 0) {
            Funcoes.mensagem(this, "Nenhuma origem foi especificada para o item \"" + regua.getName() + "\"", 1);
            return false;
        }
        if (regua.getExpressao().isEmpty() && regua.getTipoRegua() == 1) {
            Funcoes.mensagem(this, "Nenhuma express\u00e3o foi especificada para o item \"" + regua.getName() + "\"", 1);
            return false;
        }
        return true;
    }

    private boolean validarGrafico(Grafico grafico) {
        if (grafico.getValorMaximoResultado()) {
            return true;
        }
        if (Funcoes.textoVazio(grafico.getValorMaximo()) || grafico.getValorMaximo().trim().length() == 0) {
            Funcoes.mensagem(this, "O valor m\u00e1ximo n\u00e3o foi especificado para o item \"" + grafico.getNome() + "\"", 1);
            return false;
        }
        if (grafico.getTipoGrafico() == 0) {
            String origem = grafico.getOrigem().trim();
            if (origem.length() == 0) {
                Funcoes.mensagem(this, "Nenhuma origem foi especificada para o item \"" + grafico.getNome() + "\"", 1);
                return false;
            }
        } else if (grafico.getTipoGrafico() == 1 && grafico.getCampos().size() == 0) {
            Funcoes.mensagem(this, "Nenhum campo foi especificado para o item \"" + grafico.getNome() + "\"", 1);
            return false;
        }
        return true;
    }

    private boolean validarResultadoAnterior(ResultadoAnterior resultado) {
        String origem = resultado.getOrigem().trim();
        Component c = ScreenUtil.getComponenteComNome(this.pagina.getComponentesParaArray(), origem);
        if (origem.length() == 0) {
            JOptionPane.showMessageDialog(this, "Nenhuma origem foi especificada para o item \"" + resultado.getName() + "\"");
            return false;
        }
        if (!(origem.equalsIgnoreCase("dataResultado") || origem.equalsIgnoreCase("horaResultado") || c != null || this.origemNosResultadosAnteriores(origem))) {
            JOptionPane.showMessageDialog(this, "A origem \"" + origem + "\" especificada para \no item \"" + resultado.getName() + "\" n\u00e3o existe neste exame");
            return false;
        }
        if (c instanceof Componente && !((Componente)((Object)c)).getResultadoAnterior()) {
            JOptionPane.showMessageDialog(this, "A origem \"" + origem + "\" especificada para \no item \"" + resultado.getName() + "\" n\u00e3o foi definido como resultado anterior");
            return false;
        }
        return true;
    }

    private boolean origemNosResultadosAnteriores(String origem) {
        if (this.resultadosAnteriores != null) {
            for (Componente c : this.resultadosAnteriores) {
                if (!c.getNome().equalsIgnoreCase(origem)) continue;
                return true;
            }
        }
        return this.resultadosAnteriores == null;
    }

    private String[] getCamposExame() {
        ArrayList<String> res = new ArrayList<String>();
        Component[] c = this.pagina.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof Componente)) continue;
            res.add(c[i].getName());
        }
        String[] tmp = res.toArray(new String[res.size()]);
        StringUtil.ordenar(tmp);
        return tmp;
    }

    public static String[] getCamposResultado(String xmlAtributos) {
        if (xmlAtributos == null) {
            return null;
        }
        ArrayList<String> tmp = new ArrayList<String>();
        Pagina p = new Pagina();
        String exame = StringUtil.getValor(xmlAtributos, "exame");
        p.setMargensFromXML(exame);
        p.setTipoConfiguracao(0);
        p.setAtributos(StringUtil.getValor(exame, "pagina"), StringUtil.getValor(exame, "versao"));
        List<Componente> comps = p.getComponentes();
        for (Componente c : comps) {
            if (!(c instanceof Componente)) continue;
            tmp.add(c.getNome());
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    private void iniciar() {
        this.pagina.setFontePadrao(new Font(Funcoes.textoVazio(ParametrosGerais.getFontePadrao()) ? "Arial" : ParametrosGerais.getFontePadrao(), 0, 12));
        DisplayMode display = this.getGraphicsConfiguration().getDevice().getDisplayMode();
        int larguraTela = display.getWidth();
        int alturaTela = display.getHeight();
        this.setSize(new Dimension(larguraTela - 5, alturaTela - 25));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(SystemColor.control);
        this.getContentPane().add((Component)this.panelBarra, "South");
        this.getContentPane().add((Component)this.panelComponentes, "North");
        this.getContentPane().add((Component)this.splitDivisor, "Center");
        this.setTitle("Configura\u00e7\u00e3o de layout");
        this.addComponentListener(this);
        this.splitDivisor.setLeftComponent(this.scrollArea);
        this.splitDivisor.setRightComponent(this.montarPanelDireita());
        this.splitDivisor.setDividerLocation(400);
        this.splitDivisor.setDividerSize(2);
        this.scrollArea.setColumnHeaderView(this.pagina.getReguaHorizontal());
        this.scrollArea.setRowHeaderView(this.pagina.getReguaVertical());
        this.scrollArea.getViewport().add((Component)this.pagina, null);
        this.configurarPagina();
        Insets margens = this.buttonParametros.getMargin();
        margens.left = 4;
        margens.right = 4;
        this.buttonParametros.setMargin(margens);
        this.buttonVisualizar.setMargin(margens);
        this.buttonImportar.setMargin(margens);
        this.buttonExportar.setMargin(margens);
        this.buttonOcultarLinhas.setMargin(margens);
        this.botoes.put(this.buttonRotulo, Rotulo.class);
        this.botoes.put(this.buttonCampo, Campo.class);
        this.botoes.put(this.buttonTexto, Texto.class);
        this.botoes.put(this.buttonHistorico, Historico.class);
        this.botoes.put(this.buttonExpressao, Expressao.class);
        this.botoes.put(this.buttonResAnterior, ResultadoAnterior.class);
        this.botoes.put(this.buttonDados, Dados.class);
        this.botoes.put(this.buttonImagem, Imagem.class);
        this.botoes.put(this.buttonAssinatura, Assinatura.class);
        this.botoes.put(this.buttonForma, Forma.class);
        this.botoes.put(this.buttonCodBarras, CodigoBarrasConf.class);
        this.botoes.put(this.buttonRegua, ReguaReferencial.class);
        this.botoes.put(this.buttonExterno, Externo.class);
        this.botoes.put(this.buttonGrafico, Grafico.class);
        this.botoes.put(this.buttonRTF, Rtf.class);
        this.botoes.put(this.buttonCodigoQRCode, CodigoQRCode.class);
        this.buttonLigacoes.addActionListener(this);
    }

    private void iniciarConfiguraCampoResult() {
        this.pagina.setFontePadrao(new Font(Funcoes.textoVazio(ParametrosGerais.getFontePadrao()) ? "Arial" : ParametrosGerais.getFontePadrao(), 0, 12));
        DisplayMode display = this.getGraphicsConfiguration().getDevice().getDisplayMode();
        int larguraTela = display.getWidth();
        int alturaTela = display.getHeight();
        this.setSize(new Dimension(larguraTela - 5, alturaTela - 25));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(SystemColor.control);
        this.getContentPane().add((Component)this.panelBarra, "South");
        this.getContentPane().add((Component)this.panelComponentes, "North");
        this.getContentPane().add((Component)this.splitDivisor, "Center");
        this.setTitle("Configura\u00e7\u00e3o de layout");
        this.addComponentListener(this);
        this.splitDivisor.setLeftComponent(this.scrollArea);
        this.splitDivisor.setRightComponent(this.montarPanelDireita());
        this.splitDivisor.setDividerLocation(400);
        this.splitDivisor.setDividerSize(2);
        this.scrollArea.setColumnHeaderView(this.pagina.getReguaHorizontal());
        this.scrollArea.setRowHeaderView(this.pagina.getReguaVertical());
        this.scrollArea.getViewport().add((Component)this.pagina, null);
        this.configurarPagina();
        Insets margens = this.buttonParametros.getMargin();
        margens.left = 4;
        margens.right = 4;
        this.buttonParametros.setVisible(false);
        this.buttonVisualizar.setVisible(false);
        this.buttonImportar.setVisible(false);
        this.buttonExportar.setVisible(false);
        this.buttonOcultarLinhas.setVisible(false);
        this.botoes.put(this.buttonRotulo, Rotulo.class);
        this.botoes.put(this.buttonCampo, Campo.class);
        this.botoes.put(this.buttonTexto, Texto.class);
        this.botoes.put(this.buttonHistorico, Historico.class);
        this.botoes.put(this.buttonExpressao, Expressao.class);
        this.botoes.put(this.buttonResAnterior, ResultadoAnterior.class);
        this.botoes.put(this.buttonDados, Dados.class);
        this.botoes.put(this.buttonImagem, Imagem.class);
        this.botoes.put(this.buttonAssinatura, Assinatura.class);
        this.botoes.put(this.buttonForma, Forma.class);
        this.botoes.put(this.buttonCodBarras, CodigoBarrasConf.class);
        this.botoes.put(this.buttonRegua, ReguaReferencial.class);
        this.botoes.put(this.buttonExterno, Externo.class);
        this.botoes.put(this.buttonGrafico, Grafico.class);
        this.botoes.put(this.buttonRTF, Rtf.class);
        this.botoes.put(this.buttonCodigoQRCode, CodigoQRCode.class);
        this.buttonOk.setText("Selecionar");
        this.buttonLigacoes.setVisible(false);
        this.panelComponentes.setVisible(false);
    }

    private JButton criarBotaoComponente(String imagem, String toolTipText) {
        JButton button = new JButton(imagem == null ? new ImageIcon() : ImagemUtils.carregaImagemJalis("editor/" + imagem + ".jpg"));
        button.addActionListener(this);
        button.setBackground(Color.white);
        button.setPreferredSize(new Dimension(50, 40));
        button.setToolTipText(toolTipText);
        return button;
    }

    private void configurarPagina() {
        this.pagina.setLayout(null);
        this.pagina.setTipoConfiguracao(0);
        this.pagina.setAlturaCabecalho(2.0);
        this.pagina.setAlturaSumario(2.0);
        this.pagina.setAlturaRodape(2.0);
        this.pagina.setTamanho(21.0, 29.7f);
        this.pagina.setMargem(1.5, 0);
        this.pagina.setMargem(1.5, 1);
        this.pagina.setMargem(1.5, 2);
        this.pagina.setMargem(1.5, 3);
        this.pagina.setResultadoCampo(this.isConfiguracaoCampoResult);
        this.pagina.getControlePaginas().setPermitirPaginacao(this.isConfiguracaoCampoResult);
    }

    private JPanel montarPanelDireita() {
        JPanel propriedades = ComponenteFactory.novoJPanelBorderLayout("Propriedades", new JScrollPane(this.pagina.getTablePropriedades()));
        GridBagConstraints cons = new GridBagConstraints(0, 0, 4, 1, 0.5, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0);
        this.panelCamposImportacao.add((Component)this.labelCamposCarregados, cons);
        cons.gridy = 1;
        cons.gridwidth = 1;
        this.panelCamposImportacao.add((Component)ComponenteFactory.novoJLabel("Exame: ", new Dimension(10, 22)), cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.panelCamposImportacao.add((Component)this.labelExameExterno, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.gridwidth = 1;
        this.panelCamposImportacao.add((Component)ComponenteFactory.novoJLabel("Vers\u00e3o: ", new Dimension(10, 22)), cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        if (this.protocoloUsaComboVersoesPorExame()) {
            this.panelCamposImportacao.add((Component)this.comboVersoes, cons);
        } else {
            this.panelCamposImportacao.add((Component)this.labelVersaoCampos, cons);
            cons.gridx = 3;
            cons.gridy = 3;
            cons.gridwidth = 1;
            cons.weightx = 0.0;
        }
        cons.gridx = 3;
        cons.gridy = 3;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        this.panelCamposImportacao.add((Component)new JPanel(), cons);
        this.panelCamposImportacao.setVisible(false);
        return ComponenteFactory.novoJPanelBorderLayout(propriedades, null, this.panelCamposImportacao, null, null);
    }

    private boolean protocoloUsaComboVersoesPorExame() {
        return this.protocolo == Protocolo.HPardini && this.camposHPardini.size() > 1 || this.protocolo == Protocolo.INDLab && this.camposIndLab.size() > 1 || this.protocolo == Protocolo.MercolabWS && this.camposMercolab.size() > 1 || this.protocolo == Protocolo.Shift && this.camposShift.size() > 1;
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
    }

    public void setHabilitarQRCode() {
        this.buttonCodigoQRCode.setVisible(true);
    }

    public void setVersaoExame(String versaoExame) {
        if (!Funcoes.textoVazio(versaoExame) && Funcoes.isNumeric(versaoExame)) {
            this.versaoExame = versaoExame;
        }
    }

    public void setVersaoExameLabExterno(String versaoExameLabExterno) {
        if (versaoExameLabExterno.trim().length() > 0 && Funcoes.textoVazio(this.versaoExameLabExterno)) {
            this.versaoExameLabExterno = versaoExameLabExterno;
        }
    }
}

