/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import jalis.laboratorio.configurador.AtributosRegua;
import jalis.laboratorio.configurador.Constantes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class AtributosReguaMediaCores
extends AtributosRegua
implements Cloneable {
    private int posicao;
    private String valorInicial;
    private String valorFinal;

    public AtributosReguaMediaCores() {
    }

    public AtributosReguaMediaCores(Stroke linha, Color cor) {
        super(linha, cor);
    }

    public AtributosReguaMediaCores(int posicao, Color cor, String valorInicial, String valorFinal) {
        this.posicao = posicao;
        this.cor = cor;
        this.valorInicial = valorInicial;
        this.valorFinal = valorFinal;
    }

    public int getPosicao() {
        return this.posicao;
    }

    public void setPosicao(int posicao) {
        this.posicao = posicao;
    }

    public String getValorInicial() {
        return this.valorInicial;
    }

    public void setValorInicial(String valorInicial) {
        this.valorInicial = valorInicial;
    }

    public String getValorFinal() {
        return this.valorFinal;
    }

    public void setValorFinal(String valorFinal) {
        this.valorFinal = valorFinal;
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder();
        bui.append("<particao>");
        bui.append(StringUtil.getTag("linha", this.linha.toString()));
        bui.append(StringUtil.getTag("posicao", String.valueOf(this.posicao)));
        bui.append(StringUtil.getTag("nome", String.valueOf(this.nome)));
        bui.append(StringUtil.getTag("cor", this.cor != null ? String.valueOf(this.cor.getRGB()) : ""));
        bui.append(StringUtil.getTag("valorInicial", this.valorInicial));
        bui.append(StringUtil.getTag("valorFinal", this.valorFinal));
        bui.append("</particao>");
        return bui.toString();
    }

    @Override
    public void setAtributos(String xml) {
        if (!StringUtil.isEmpty(xml)) {
            this.posicao = !StringUtil.isEmpty(StringUtil.getValor(xml, "posicao")) ? Integer.valueOf(StringUtil.getValor(xml, "posicao")) : 0;
            this.cor = StringUtil.getColor(xml, "cor");
            this.nome = StringUtil.getValor(xml, "nome");
            this.valorInicial = !StringUtil.isEmpty(StringUtil.getValor(xml, "valorInicial")) ? StringUtil.getValor(xml, "valorInicial") : "0,0000";
            this.valorFinal = !StringUtil.isEmpty(StringUtil.getValor(xml, "valorFinal")) ? StringUtil.getValor(xml, "valorFinal") : "0,0000";
        }
    }

    @Override
    public void aplicarAtributos(Graphics2D g2d) {
        g2d.setColor(this.cor);
        g2d.setStroke(Constantes.SOLIDO);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }
}

