/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import jalis.laboratorio.configurador.AtributosRegua;
import jalis.laboratorio.configurador.AtributosReguaMediaCores;
import jalis.laboratorio.configurador.Constantes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class AtributosReguaMedia
extends AtributosRegua
implements Cloneable {
    private BigDecimal minimo;
    private BigDecimal maximo;
    private int larguraMedia;
    private Color corMedia;
    private String tipoPreenchimento;
    private List<AtributosReguaMediaCores> atributosReguas = new ArrayList<AtributosReguaMediaCores>();

    public AtributosReguaMedia() {
    }

    public AtributosReguaMedia(BigDecimal minimo, BigDecimal maximo, int larguraMedia, Color corMedia, List<AtributosReguaMediaCores> atributosReguas, String tipoPreenchimento) {
        this.minimo = minimo;
        this.maximo = maximo;
        this.larguraMedia = larguraMedia;
        this.corMedia = corMedia;
        this.atributosReguas = atributosReguas;
        this.tipoPreenchimento = tipoPreenchimento;
    }

    public BigDecimal getMinimo() {
        return this.minimo;
    }

    public void setMinimo(BigDecimal minimo) {
        this.minimo = minimo;
    }

    public BigDecimal getMaximo() {
        return this.maximo;
    }

    public void setMaximo(BigDecimal maximo) {
        this.maximo = maximo;
    }

    public int getLarguraMedia() {
        return this.larguraMedia;
    }

    public void setLarguraMedia(int larguraMedia) {
        this.larguraMedia = larguraMedia;
    }

    public Color getCorMedia() {
        return this.corMedia;
    }

    public void setCorMedia(Color corMedia) {
        this.corMedia = corMedia;
    }

    public List<AtributosReguaMediaCores> getAtributosReguas() {
        return this.atributosReguas;
    }

    public void setAtributosReguas(List<AtributosReguaMediaCores> atributosReguas) {
        this.atributosReguas = atributosReguas;
    }

    public String getTipoPreenchimento() {
        return this.tipoPreenchimento;
    }

    public void setTipoPreenchimento(String tipoPreenchimento) {
        this.tipoPreenchimento = tipoPreenchimento;
    }

    @Override
    public String getAtributos() {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("minimo", String.valueOf(this.minimo)));
        bui.append(StringUtil.getTag("maximo", String.valueOf(this.maximo)));
        bui.append(StringUtil.getTag("larguraMedia", String.valueOf(this.larguraMedia)));
        bui.append(StringUtil.getTag("corMedia", this.corMedia != null ? String.valueOf(this.corMedia.getRGB()) : ""));
        bui.append(StringUtil.getTag("tipoPreenchimento", this.tipoPreenchimento));
        bui.append("<cores>");
        for (AtributosReguaMediaCores atrRegua : this.atributosReguas) {
            bui.append(atrRegua.getAtributos());
        }
        bui.append("</cores>");
        return bui.toString();
    }

    @Override
    public void setAtributos(String xml) {
        if (!StringUtil.isEmpty(xml)) {
            this.minimo = new BigDecimal(StringUtil.getValor(xml, "minimo"));
            this.maximo = new BigDecimal(StringUtil.getValor(xml, "maximo"));
            this.larguraMedia = Integer.valueOf(StringUtil.getValor(xml, "larguraMedia"));
            this.corMedia = StringUtil.getColor(xml, "corMedia");
            this.tipoPreenchimento = StringUtil.isEmpty(StringUtil.getValor(xml, "tipoPreenchimento")) ? "Degrad\u00ea" : StringUtil.getValor(xml, "tipoPreenchimento");
            String[] valoresCores = StringUtil.getValores(xml, "particao");
            this.atributosReguas = new ArrayList<AtributosReguaMediaCores>();
            for (String particao : valoresCores) {
                AtributosReguaMediaCores atrRegua = new AtributosReguaMediaCores(Constantes.SOLIDO, StringUtil.getColor(particao, "cor"));
                atrRegua.setAtributos(particao);
                this.atributosReguas.add(atrRegua);
            }
        }
    }

    @Override
    public void aplicarAtributos(Graphics2D g2d) {
        g2d.setColor(this.corMedia);
        g2d.setStroke(Constantes.SOLIDO);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }
}

