/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import jalis.laboratorio.configurador.Constantes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class AtributosRegua
implements Cloneable {
    protected Stroke linha;
    protected Color cor;
    protected String nome;

    public AtributosRegua() {
    }

    public AtributosRegua(Stroke linha, Color cor) {
        this.linha = linha;
        this.cor = cor;
    }

    public void setLinha(Stroke linha) {
        this.linha = linha;
    }

    public Stroke getLinha() {
        return this.linha;
    }

    public void setCor(Color cor) {
        this.cor = cor;
    }

    public Color getCor() {
        return this.cor;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getAtributos() {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("tipoLinha", this.linha.toString()));
        bui.append(StringUtil.getTag("corLinha", String.valueOf(this.cor.getRGB())));
        return bui.toString();
    }

    public void setAtributos(String xml) {
        String tmp = StringUtil.getValor(xml, "tipoLinha");
        this.linha = tmp.equalsIgnoreCase(Constantes.SOLIDO.toString()) ? Constantes.SOLIDO : (tmp.equalsIgnoreCase(Constantes.TRACEJADO.toString()) ? Constantes.TRACEJADO : Constantes.PONTILHADO);
        this.cor = StringUtil.getColor(xml, "corLinha");
    }

    public void aplicarAtributos(Graphics2D g2d) {
        g2d.setColor(this.cor);
        g2d.setStroke(this.linha);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }
}

