/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configurador;

import jalis.util.CorComboBox;
import jalis.util.DialogoCor;
import jalis.util.DialogoFonte;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

class AreaLivre
extends JPanel
implements ActionListener {
    public static final String TIPO_COR = "cor";
    public static final String TIPO_TEXTO = "texto";
    private Font fonteMensagem = null;
    private JRadioButton checkCor = ComponenteFactory.novoJRadioButton("Cor", this);
    private JRadioButton checkTexto = ComponenteFactory.novoJRadioButton("Texto", this);
    private ButtonGroup group = new ButtonGroup();
    private JCheckBox checkPreencher = ComponenteFactory.novoJCheckBox("Preencher a \u00e1rea livre entre o sum\u00e1rio e o rodap\u00e9, pertencente ao corpo do exame", this);
    private CorComboBox comboCor = new CorComboBox();
    private JButton buttonCor = ComponenteFactory.novoJButton("...", this, new Dimension(20, 20), new Dimension(20, 20));
    private TTextField textMensagem = new TTextField();
    private JButton buttonFonte = ComponenteFactory.novoJButton("Fonte", this);

    public AreaLivre() {
        super(new GridBagLayout());
        this.setBorder(new TitledBorder("\u00c1rea livre"));
        this.setPreferredSize(new Dimension(100, 100));
        this.montaTela();
        this.checkPreencher.setSelected(false);
        this.habilita(false);
        this.controlaCampos();
    }

    private void montaTela() {
        this.group.add(this.checkCor);
        this.group.add(this.checkTexto);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.gridwidth = 2;
        this.add((Component)this.checkPreencher, c);
        c.fill = 0;
        c.gridwidth = 1;
        c.gridy = 1;
        this.add((Component)this.checkCor, c);
        c.gridy = 2;
        this.add((Component)this.checkTexto, c);
        this.comboCor.setPreferredSize(new Dimension(200, 20));
        c.gridy = 1;
        c.gridx = 1;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(this.comboCor);
        p.add(this.buttonCor);
        this.add((Component)p, c);
        c.gridy = 2;
        c.gridwidth = 1;
        this.textMensagem.setPreferredSize(new Dimension(100, 20));
        this.add((Component)this.textMensagem, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.buttonFonte.setPreferredSize(new Dimension(70, 20));
        this.add((Component)this.buttonFonte, c);
    }

    private void habilita(boolean b) {
        this.checkCor.setEnabled(b);
        this.checkTexto.setEnabled(b);
        this.comboCor.setEnabled(b);
        this.buttonCor.setEnabled(b);
        this.textMensagem.setEnabled(b);
        this.buttonFonte.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.checkPreencher) {
            this.habilita(this.checkPreencher.isSelected());
        } else if (e.getSource() instanceof JRadioButton) {
            this.controlaCampos();
        } else if (e.getSource() == this.buttonCor) {
            DialogoCor dc = DialogoCor.novaInstancia(this.getTopLevelAncestor(), "Configura\u00e7\u00e3o de Cor");
            if (dc != null) {
                dc.setCor(this.comboCor.getCorSelecionada());
                dc.setVisible(true);
                if (dc.ok()) {
                    this.comboCor.setActionCommand("cancelado");
                    this.comboCor.setCorPersonalizada(dc.getCor());
                    this.comboCor.setCorSelecionada(dc.getCor());
                    this.comboCor.setActionCommand("ok");
                }
            }
        } else if (e.getSource() == this.buttonFonte && this.getTopLevelAncestor() instanceof JDialog) {
            DialogoFonte df = new DialogoFonte((JDialog)this.getTopLevelAncestor(), "Configura\u00e7\u00e3o de Fonte", true);
            if (this.fonteMensagem != null) {
                df.setFonte(this.fonteMensagem);
            }
            df.setVisible(true);
            if (df.ok()) {
                this.fonteMensagem = df.getFonte();
                this.textMensagem.setFont(this.fonteMensagem);
            }
        }
    }

    private void controlaCampos() {
        boolean b = this.checkPreencher.isSelected();
        this.comboCor.setEnabled(this.checkCor.isSelected() && b);
        this.buttonCor.setEnabled(this.checkCor.isSelected() && b);
        this.textMensagem.setEnabled(this.checkTexto.isSelected() && b);
        this.buttonFonte.setEnabled(this.checkTexto.isSelected() && b);
    }

    public String getXML() {
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("arealivre");
            xml.escrever("preencher", this.checkPreencher.isSelected() ? "true" : "false");
            xml.escrever("tipo", this.checkCor.isSelected() ? TIPO_COR : TIPO_TEXTO);
            xml.escrever("valor", this.checkCor.isSelected() ? String.valueOf(this.comboCor.getCorSelecionada().getRGB()) : this.textMensagem.getText());
            xml.escrever("fontemensagem", this.fonteMensagem != null ? StringUtil.getFonteAtributos(this.fonteMensagem) : "");
            xml.fechar("arealivre");
            return xml.getXML();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setXML(String xml) {
        String tmp;
        if (!Funcoes.textoVazio(xml) && !Funcoes.textoVazio(tmp = StringUtil.getValor(xml, "arealivre"))) {
            boolean preencher = StringUtil.getValor(tmp, "preencher").equalsIgnoreCase("true");
            String tipo = StringUtil.getValor(tmp, "tipo");
            String valor = StringUtil.getValor(tmp, "valor");
            String fonte = StringUtil.getValor(tmp, "fontemensagem");
            this.checkPreencher.setSelected(preencher);
            if (tipo.equals(TIPO_COR)) {
                this.checkCor.setSelected(true);
                Color cor = StringUtil.getColor(tmp, "valor");
                this.comboCor.setCorSelecionada(cor);
            } else {
                this.checkTexto.setSelected(true);
                this.textMensagem.setText(valor);
                if (!Funcoes.textoVazio(fonte)) {
                    this.fonteMensagem = StringUtil.getFonte(fonte);
                    if (this.fonteMensagem != null) {
                        this.textMensagem.setFont(this.fonteMensagem);
                    }
                }
            }
            this.habilita(preencher);
            this.controlaCampos();
        }
    }
}

