/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao.material;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.material.MaterialUsuarioVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.MaterialService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class AvisarMaterial
extends AbstractDialogoOKCancelar {
    private static final Integer COLUNA_CODIGO = 0;
    private String titulo;
    private JLabel labelMaterial = new JLabel("Material");
    private TTextField textCodMaterial = ComponenteFactory.novoTTextField(5, 1);
    private JLabel labelDescMaterial = ComponenteFactory.novoJLabel("", new Dimension(235, 20), new TitledBorder(""));
    private JButton buttonBuscaMaterial = new JButton();
    private JButton buttonOkMaterial = new JButton("OK");
    private JPanel panelMaterial = new JPanel();
    private ModeloGridTable modeloMaterial = new ModeloGridTable(new String[]{"C\u00f3digo", "Material"});
    private JTable tabelaMaterial = new JTable(this.modeloMaterial);
    private List<MaterialUsuarioVO> listaMaterialUsuarios = new ArrayList<MaterialUsuarioVO>();
    private static String tipo;

    public AvisarMaterial(Dialog pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public AvisarMaterial(Frame pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public static AvisarMaterial novaInstancia(Object owner, String titulo, String tipoMaterial) {
        tipo = tipoMaterial;
        if (owner instanceof Dialog) {
            return new AvisarMaterial((Dialog)owner, titulo);
        }
        if (owner instanceof Frame) {
            return new AvisarMaterial((Frame)owner, titulo);
        }
        return null;
    }

    private void iniciar() {
        this.setSize(new Dimension(450, 200));
        ScreenUtil.centralizar(this);
        this.setLayout(new BorderLayout());
        this.buttonBuscaMaterial.setFocusable(false);
        this.buttonBuscaMaterial.setText("");
        Funcoes.imagemPesquisa(this.buttonBuscaMaterial);
        this.modeloMaterial.setColumnSize(new int[]{80, 0}, this.tabelaMaterial);
        this.add((Component)this.getPanelBotoesDireita(), "South");
        this.setPreferredSize(new Dimension(400, 300));
        this.setMinimumSize(new Dimension(400, 300));
        this.panelMaterial.setBorder(ScreenUtil.criarBordaVazia());
        this.panelMaterial.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.panelMaterial.add((Component)this.labelMaterial, gbc);
        ++gbc.gridy;
        this.textCodMaterial.setPreferredSize(new Dimension(60, 20));
        this.textCodMaterial.setMinimumSize(new Dimension(60, 20));
        this.panelMaterial.add((Component)this.textCodMaterial, gbc);
        ++gbc.gridx;
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setMaximumSize(new Dimension(20, 20));
        this.panelMaterial.add((Component)this.buttonBuscaMaterial, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 1, 1, 1);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.labelDescMaterial.setMinimumSize(new Dimension(60, 20));
        this.labelDescMaterial.setPreferredSize(this.labelDescMaterial.getMinimumSize());
        this.panelMaterial.add((Component)this.labelDescMaterial, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.buttonOkMaterial.setPreferredSize(new Dimension(50, 20));
        this.buttonOkMaterial.setMinimumSize(new Dimension(50, 20));
        this.panelMaterial.add((Component)this.buttonOkMaterial, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 4;
        gbc.fill = 1;
        this.panelMaterial.add((Component)new JScrollPane(this.tabelaMaterial), gbc);
        this.add((Component)this.panelMaterial, "Center");
        this.montaListener();
        ScreenUtil.requisitarFoco(this.textCodMaterial);
    }

    private void montaListener() {
        this.buttonBuscaMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvisarMaterial.this.buscaMaterial();
            }
        });
        this.tabelaMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int resp;
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja excluir o registro selecionado?", 4)) == 0) {
                    Integer codigoMaterial = (Integer)AvisarMaterial.this.modeloMaterial.getValueAt(row, COLUNA_CODIGO);
                    AvisarMaterial.this.modeloMaterial.removeLine(row);
                    MaterialUsuarioVO matUsuario = null;
                    for (MaterialUsuarioVO materialUsuarioVO : AvisarMaterial.this.listaMaterialUsuarios) {
                        if (!materialUsuarioVO.getCodigoMaterial().equals(codigoMaterial) || !materialUsuarioVO.getTipoMaterialUsuario().equals(tipo)) continue;
                        matUsuario = materialUsuarioVO;
                        break;
                    }
                    AvisarMaterial.this.listaMaterialUsuarios.remove(matUsuario);
                }
            }
        });
        this.buttonBuscaMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AvisarMaterial.this.pressioneiF2();
                }
            }
        });
        this.textCodMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AvisarMaterial.this.pressioneiF2();
                }
            }
        });
        this.textCodMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (AvisarMaterial.this.textCodMaterial.getText().trim().length() > 0) {
                    try {
                        MaterialService materialService = new MaterialService();
                        List<MaterialVO> listaMaterial = materialService.buscaMaterial(Variaveis.filialPadrao, AvisarMaterial.this.textCodMaterial.getText());
                        for (MaterialVO materialVO : listaMaterial) {
                            AvisarMaterial.this.labelDescMaterial.setText(materialVO.getDescricao());
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(AvisarMaterial.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                    }
                }
            }
        });
        this.buttonOkMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvisarMaterial.this.adicionarMaterial();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < AvisarMaterial.this.tabelaMaterial.getRowCount(); ++i) {
                    Integer material = (Integer)AvisarMaterial.this.tabelaMaterial.getValueAt(i, COLUNA_CODIGO);
                    boolean adicionar = true;
                    for (MaterialUsuarioVO materialUsuarioVO : AvisarMaterial.this.listaMaterialUsuarios) {
                        if (!material.equals(materialUsuarioVO.getCodigoMaterial()) || !tipo.equals(materialUsuarioVO.getTipoMaterialUsuario())) continue;
                        adicionar = material.equals(materialUsuarioVO.getCodigoMaterial()) || !tipo.equals(materialUsuarioVO.getTipoMaterialUsuario());
                        break;
                    }
                    if (!adicionar) continue;
                    MaterialUsuarioVO materialUsuario = new MaterialUsuarioVO();
                    materialUsuario.setCodigoMaterial(material);
                    materialUsuario.setTipoMaterialUsuario(tipo);
                    AvisarMaterial.this.listaMaterialUsuarios.add(materialUsuario);
                }
            }
        });
    }

    private void adicionarMaterial() {
        if (this.materialEncontrado()) {
            if (this.modeloMaterial.getRowCount() == 0) {
                this.modeloMaterial.addLine(new Object[]{Integer.valueOf(this.textCodMaterial.getText()), this.labelDescMaterial.getText()});
            } else {
                boolean encontrado = false;
                for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                    if (!this.modeloMaterial.getValueAt(i, COLUNA_CODIGO).equals(Integer.valueOf(this.textCodMaterial.getText()))) continue;
                    encontrado = true;
                    break;
                }
                if (!encontrado) {
                    this.modeloMaterial.addLine(new Object[]{Integer.valueOf(this.textCodMaterial.getText()), this.labelDescMaterial.getText()});
                }
            }
        }
        this.textCodMaterial.clear();
        this.labelDescMaterial.setText("");
        ScreenUtil.requisitarFoco(this.textCodMaterial);
    }

    private boolean materialEncontrado() {
        return !Funcoes.textoVazio(this.labelDescMaterial.getText()) && !this.labelDescMaterial.getText().equals("N\u00e3o cadastrado");
    }

    private void buscaMaterial() {
        Hashtable resultado = Pesquisas.materialAtivo(this, true);
        if (resultado != null) {
            this.textCodMaterial.setText(resultado.get("mat_codigo").toString());
        }
        this.textCodMaterial.requestFocus();
    }

    public List<MaterialUsuarioVO> getListaMaterialUsuarios() {
        return this.listaMaterialUsuarios;
    }

    public void setListaMaterialUsuarios(List<MaterialUsuarioVO> listaMaterialUsuarios, String tipo) {
        MaterialService materialService = new MaterialService();
        for (MaterialUsuarioVO materialUsuarioVO : listaMaterialUsuarios) {
            this.listaMaterialUsuarios.add(materialUsuarioVO);
            if (!materialUsuarioVO.getTipoMaterialUsuario().equals(tipo)) continue;
            try {
                List<MaterialVO> listaMaterial = materialService.buscaMaterial(Variaveis.filialPadrao, materialUsuarioVO.getCodigoMaterial().toString());
                for (MaterialVO materialVO : listaMaterial) {
                    this.modeloMaterial.addLine(new Object[]{materialVO.getCodigo(), materialVO.getDescricao()});
                }
            }
            catch (SQLException e) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
            }
        }
    }

    public void pressioneiF2() {
        if (this.textCodMaterial.hasFocus()) {
            this.buscaMaterial();
        }
    }
}

