/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao.log;

import jalis.comum.Conexao;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configuracao.log.ProtocoloTabelas;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RequisicaoExcluida
extends FrmPadrao
implements ActionListener {
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_DATA = 1;
    private final int COLUNA_USUARIO = 2;
    private final int COLUNA_TABELA = 3;
    private final int COLUNA_PESQUISA = 4;
    private final int COLUNA_PACIENTE = 5;
    private final int COLUNA_MOTIVO = 6;
    private final int COLUNA_RECUPERAVEL = 7;
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonRecuperar = ComponenteFactory.novoJButton("Recuperar requisi\u00e7\u00e3o", 'R', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JButton buttonConsulta = ComponenteFactory.novoJButton("Consultar", 'n', this);
    private CheckItemFiltro itemUsuario;
    private CheckItemFiltro itemFilial;
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private TTextField textPesquisa = new TTextField(12);
    private JComboBox comboTabela = new JComboBox<ProtocoloTabelas>(ProtocoloTabelas.getProtocolos());
    private JPanel panelFiltro = new JPanel(new GridBagLayout());
    private JPanel panelDataInicial;
    private JPanel panelDataFinal;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Filial", "Data", "Usu\u00e1rio", "Tabela", "Pesquisa", "Paciente"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scrollLog = new JScrollPane(this.table);
    private JTextPane textMotivo = new JTextPane();
    private JScrollPane scrollMotivo = new JScrollPane(this.textMotivo);

    public RequisicaoExcluida() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Requisi\u00e7\u00f5es exclu\u00eddas", "Logs de exclus\u00e3o de registros do sistema", "configuracoes/requisicoes_excluidas.jpg");
        this.montaTela();
        this.novo();
    }

    private void montaTela() {
        this.modelo.setColumnSize(new int[]{45, 80, 100, 100, 80, 0}, this.table);
        JPanel panelCentro = new JPanel(new BorderLayout());
        this.add((Component)panelCentro, "Center");
        this.panelFiltro.setBorder(new TitledBorder("Filtro"));
        this.panelFiltro.setPreferredSize(new Dimension(200, 100));
        panelCentro.add((Component)this.panelFiltro, "West");
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonNovo);
        panelBotoes.add(this.buttonRecuperar);
        panelBotoes.add(this.buttonFechar);
        this.add((Component)panelBotoes, "South");
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 3;
        cons.insets = new Insets(2, 0, 0, 0);
        this.itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.panelFiltro.add((Component)this.itemFilial, cons);
        ++cons.gridy;
        this.itemUsuario = new CheckItemFiltro("Usu\u00e1rio", "Filtrar", "Filtrando usu\u00e1rios", "");
        this.itemUsuario.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"Usu\u00e1rio", "Nome"}, new int[]{70, 0});
        this.itemUsuario.setColunaHint(1);
        this.panelFiltro.add((Component)this.itemUsuario, cons);
        ++cons.gridy;
        cons.weightx = 0.0;
        cons.gridwidth = 1;
        cons.gridx = 0;
        JLabel l = new JLabel("Data Inicial:");
        this.panelFiltro.add((Component)l, cons);
        ++cons.gridx;
        cons.weightx = 1.0;
        this.textDataInicial.setPreferredSize(new Dimension(50, 20));
        this.textDataInicial.setMinimumSize(new Dimension(50, 20));
        this.textDataFinal.setPreferredSize(new Dimension(50, 20));
        this.textDataFinal.setMinimumSize(new Dimension(50, 20));
        this.panelFiltro.add((Component)this.textDataInicial, cons);
        ++cons.gridx;
        cons.weightx = 0.0;
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicial.setMinimumSize(new Dimension(20, 20));
        this.panelFiltro.add((Component)this.buttonDataInicial, cons);
        ++cons.gridy;
        cons.gridx = 0;
        l = new JLabel("Data Final:");
        this.panelFiltro.add((Component)l, cons);
        ++cons.gridx;
        cons.weightx = 1.0;
        this.panelFiltro.add((Component)this.textDataFinal, cons);
        ++cons.gridx;
        cons.weightx = 0.0;
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinal.setMinimumSize(new Dimension(20, 20));
        this.panelFiltro.add((Component)this.buttonDataFinal, cons);
        ++cons.gridy;
        cons.gridx = 0;
        l = new JLabel("Tela:");
        this.panelFiltro.add((Component)l, cons);
        ++cons.gridx;
        cons.gridwidth = 2;
        this.panelFiltro.add((Component)this.comboTabela, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        l = new JLabel("C\u00f3digo:");
        this.panelFiltro.add((Component)l, cons);
        ++cons.gridx;
        cons.weightx = 1.0;
        cons.gridwidth = 2;
        this.textPesquisa.setPreferredSize(new Dimension(50, 20));
        this.textPesquisa.setMinimumSize(new Dimension(50, 20));
        this.panelFiltro.add((Component)this.textPesquisa, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 3;
        cons.fill = 0;
        cons.anchor = 13;
        this.panelFiltro.add((Component)this.buttonConsulta, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.fill = 1;
        cons.weighty = 1.0;
        cons.weightx = 1.0;
        cons.gridwidth = 3;
        this.panelFiltro.add((Component)new JPanel(), cons);
        JPanel panelDados = new JPanel(new BorderLayout());
        panelCentro.add((Component)panelDados, "Center");
        this.textMotivo.setPreferredSize(new Dimension(200, 100));
        this.textMotivo.setEditable(false);
        this.table.getTableHeader().addMouseListener(this.modelo);
        GridBagConstraints bag = new GridBagConstraints();
        bag.gridx = 0;
        bag.gridy = 0;
        bag.fill = 1;
        bag.weightx = 1.0;
        bag.weighty = 1.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Registros encontrados"));
        jPanel.add((Component)this.scrollLog, bag);
        panelDados.add((Component)jPanel, "Center");
        this.scrollMotivo.setBorder(new TitledBorder("Motivo da exclus\u00e3o"));
        panelDados.add((Component)this.scrollMotivo, "South");
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RequisicaoExcluida.this.table.getSelectedRow() > -1 && RequisicaoExcluida.this.modelo.getValueAt(RequisicaoExcluida.this.table.getSelectedRow(), 6) != null) {
                    RequisicaoExcluida.this.textMotivo.setText(RequisicaoExcluida.this.modelo.getValueAt(RequisicaoExcluida.this.table.getSelectedRow(), 6).toString());
                } else {
                    RequisicaoExcluida.this.textMotivo.setText("");
                }
                RequisicaoExcluida.this.controlaBotao();
            }
        });
        this.controlaBotao();
    }

    private JPanel montaCampoData(JLabel label, Component comp, JButton botao) {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        p.setPreferredSize(new Dimension(10, 25));
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        p.add((Component)label, c);
        c.gridx = 1;
        c.weightx = 1.0;
        p.add(comp, c);
        c.weightx = 0.0;
        c.gridx = 2;
        if (botao != null) {
            p.add((Component)botao, c);
        }
        return p;
    }

    private void controlaBotao() {
        int row = this.table.getSelectedRow();
        if (row >= 0) {
            this.buttonRecuperar.setEnabled((Boolean)this.modelo.getValueAt(row, 7));
        } else {
            this.buttonRecuperar.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        } else if (o == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, this.panelDataInicial, true);
        } else if (o == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, this.panelDataFinal, true);
        } else if (o == this.buttonConsulta) {
            this.consultar();
        } else if (o == this.buttonNovo) {
            this.novo();
        } else if (o == this.buttonRecuperar) {
            this.recuperar();
        }
    }

    private void recuperar() {
        int resp;
        int row = this.table.getSelectedRow();
        if (row > -1 && (resp = Funcoes.mensagem(this, "Deseja restaurar a requisi\u00e7\u00e3o?", 4, true)) == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(" update requisicao ");
            buf.append("    set req_excluida = false ");
            buf.append("       ,req_dataexcluida = NULL ");
            buf.append("       ,usr_codexcluida = NULL ");
            buf.append("       ,req_motivoexclusao = NULL");
            buf.append("  where fil_codigo = ").append(this.modelo.getValueAt(row, 0));
            buf.append("    and req_codigo = ").append(this.modelo.getValueAt(row, 4));
            StringBuilder buf2 = new StringBuilder();
            buf2.append(" update examerequisicao ");
            buf2.append("    set exr_excluido = false ");
            buf2.append("       ,usr_codexcluido = NULL ");
            buf2.append("       ,exr_dataexcluido = NULL ");
            buf2.append("  where fil_codigo = ").append(this.modelo.getValueAt(row, 0));
            buf2.append("    and req_codigo = ").append(this.modelo.getValueAt(row, 4));
            try {
                Conexao.executeUpdate(this.modelo.getValueAt(row, 0).toString(), Conexao.getStatement(), buf.toString());
                Conexao.executeUpdate(this.modelo.getValueAt(row, 0).toString(), Conexao.getStatement(), buf2.toString());
                Conexao.arquivaSQL();
                this.modelo.removeLine(row);
                this.controlaBotao();
            }
            catch (SQLException sqle) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel recuperar requisi\u00e7\u00e3o.\n" + sqle.getMessage(), sqle.getStackTrace());
            }
        }
    }

    private void novo() {
        this.modelo.clear();
        this.textMotivo.setText("");
        this.itemFilial.clear();
        this.itemUsuario.clear();
        this.textDataInicial.clear();
        this.textDataFinal.clear();
        this.textPesquisa.clear();
        ScreenUtil.requisitarFoco(this.textDataInicial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultar() {
        Statement st = Conexao.getStatement();
        try {
            int i;
            StringBuilder buf = new StringBuilder();
            String[] filiais = this.itemFilial.getSelecionados(0);
            String[] usuarios = this.itemUsuario.getSelecionados(0);
            String tabela = ((ProtocoloTabelas)((Object)this.comboTabela.getSelectedItem())).getTabela();
            buf.append(" select fil_codigo ");
            buf.append("       ,log_datahora ");
            buf.append("       ,log_motivo ");
            buf.append("       ,log_tabela ");
            buf.append("       ,usr_codigo ");
            buf.append("       ,usr_codigo ");
            buf.append("       ,log_codigopesquisa ");
            buf.append("       ,log_operacao ");
            buf.append("   from log ");
            buf.append("  where log_tabela = '").append(StringUtil.textoDB(tabela)).append("' ");
            if (filiais != null && filiais.length > 0) {
                buf.append(" and fil_codigo in (");
                for (i = 0; i < filiais.length; ++i) {
                    buf.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if (usuarios != null && usuarios.length > 0) {
                buf.append(" and usr_codigo in (");
                for (i = 0; i < usuarios.length; ++i) {
                    buf.append("'").append(usuarios[i]).append("'");
                    if (i >= usuarios.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if (Funcoes.verificaData(this.textDataInicial.getText())) {
                buf.append(" and cast(log_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText())).append("' ");
            }
            if (Funcoes.verificaData(this.textDataFinal.getText())) {
                buf.append(" and cast(log_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText())).append("' ");
            }
            if (!Funcoes.textoVazio(this.textPesquisa.getText())) {
                buf.append(" and upper(log_codigopesquisa) = upper('").append(this.textPesquisa.getTextDB()).append("') ");
            }
            buf.append("order by log_datahora ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            this.modelo.clear();
            String xml = null;
            int widthTabela = 0;
            while (rs.next()) {
                xml = rs.getString("log_operacao");
                xml = StringUtil.getValor(xml, "registros");
                String[] registros = StringUtil.getValores(xml, "registro");
                boolean encontrou = false;
                block7: for (int i2 = 0; i2 < registros.length && !encontrou; ++i2) {
                    String reg = registros[i2];
                    String aux = StringUtil.getValor(reg, "tabela");
                    if (!aux.equalsIgnoreCase("paciente")) continue;
                    xml = StringUtil.getValor(reg, "campos");
                    registros = StringUtil.getValores(xml, "campo");
                    for (int j = 0; j < registros.length; ++j) {
                        aux = registros[j];
                        xml = StringUtil.getValor(aux, "nome");
                        if (!xml.equalsIgnoreCase("pac_nome")) continue;
                        xml = StringUtil.getValor(aux, "valor");
                        encontrou = true;
                        continue block7;
                    }
                }
                if (tabela.equalsIgnoreCase(ProtocoloTabelas.Requisicao.getTabela())) {
                    FontMetrics met = this.table.getFontMetrics(this.table.getFont());
                    if (widthTabela < met.stringWidth(xml) + 20) {
                        widthTabela = met.stringWidth(xml) + 20;
                    }
                } else {
                    widthTabela = 1;
                }
                ProtocoloTabelas p = ProtocoloTabelas.getProtocolo(rs.getString("log_tabela"));
                this.modelo.addLine(new Object[]{rs.getString("fil_codigo"), Funcoes.formataData("dd/MM/yyyy", rs.getDate("log_datahora")), rs.getString("usr_codigo"), p != null ? p.getNomeTela() : "", rs.getString("log_codigopesquisa"), encontrou ? xml : "", rs.getString("log_motivo"), false});
            }
            if (tabela.equalsIgnoreCase(ProtocoloTabelas.Requisicao.getTabela())) {
                buf.setLength(0);
                buf.append(" select req.fil_codigo ");
                buf.append("       ,req.req_dataexcluida ");
                buf.append("       ,req.usr_codexcluida ");
                buf.append("       ,req.req_codigo ");
                buf.append("       ,pac.pac_nome ");
                buf.append("       ,req.req_motivoexclusao ");
                buf.append("   from requisicao req ");
                buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
                buf.append("  where req_excluida ");
                buf.append(" and not req.req_origemagendamento");
                if (filiais != null && filiais.length > 0) {
                    buf.append(" and req.fil_codigo in (");
                    for (int i3 = 0; i3 < filiais.length; ++i3) {
                        buf.append(filiais[i3]);
                        if (i3 >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
                if (usuarios != null && usuarios.length > 0) {
                    buf.append(" and req.usr_codexcluida in (");
                    for (int i4 = 0; i4 < usuarios.length; ++i4) {
                        buf.append("'").append(usuarios[i4]).append("'");
                        if (i4 >= usuarios.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
                if (Funcoes.verificaData(this.textDataInicial.getText())) {
                    buf.append(" and cast(req.req_dataexcluida as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText())).append("' ");
                }
                if (Funcoes.verificaData(this.textDataFinal.getText())) {
                    buf.append(" and cast(req.req_dataexcluida as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText())).append("' ");
                }
                if (!Funcoes.textoVazio(this.textPesquisa.getText()) && Funcoes.isNumeric(this.textPesquisa.getText())) {
                    buf.append(" and req.req_codigo = ").append(this.textPesquisa.getText());
                }
                rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                while (rs.next()) {
                    FontMetrics met = this.table.getFontMetrics(this.table.getFont());
                    if (widthTabela < met.stringWidth(rs.getString("pac_nome")) + 20) {
                        widthTabela = met.stringWidth(rs.getString("pac_nome")) + 20;
                    }
                    this.modelo.addLine(new Object[]{rs.getString("fil_codigo"), Funcoes.formataData("dd/MM/yyyy", rs.getDate("req_dataexcluida")), rs.getString("usr_codexcluida"), "Requisi\u00e7\u00e3o", rs.getString("req_codigo"), rs.getString("pac_nome"), rs.getString("req_motivoexclusao"), true});
                }
            }
            this.modelo.fireTableStructureChanged();
            this.modelo.setColumnSize(new int[]{45, 80, 100, 100, 80, 0}, this.table);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return Long.valueOf("0500900000");
    }
}

