/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao.log;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.configuracao.log.LogRegistroMudanca;
import jalis.laboratorio.relatorios.log.RelatorioAuditoriaLog;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.log.AuditoriaTabelaDescricaoLogBean;
import jalis.model.bean.log.AuditoriaTabelaDescricaoLogTabelaBean;
import jalis.model.bean.log.LogRastreabilidadeBean;
import jalis.relatorio.Gerador;
import jalis.service.cadastro.FilialService;
import jalis.service.log.AuditoriaTabelaDescricaoLogTabelaService;
import jalis.service.log.AuditoriaTabelaDescricaoService;
import jalis.service.log.LogRastreabilidadeService;
import jalis.util.ArraysUtil;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class AuditoriaLog
extends FrmCadPadraoBean
implements ActionListener,
ThreadFinalizadaListener {
    private static final String FILTRO_CHAVES = "filtroChaves";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_TABELA = "filtroTabela";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final int COLUNA_MUDANCA_COLUNA = 0;
    private static final int COLUNA_MUDANCA_VALOR_ANTERIOR = 1;
    private static final int COLUNA_MUDANCA_VALOR_NOVO = 2;
    private static final int COLUNA_MUDANCA_LOG = 3;
    private final int POSICAO_LOG_TABELA = 5;
    private CheckItemFiltro itemFiltroFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", "");
    private CheckItemFiltro itemFiltroUsuario = new CheckItemFiltro("Usu\u00e1rio", "Filtrar", "Filtrando usu\u00e1rios", "");
    private JPanel painelOpcoes = new JPanel(new FlowLayout(0));
    private JPanel panelFiltros = new JPanel(new GridBagLayout());
    private JPanel panelChave = new JPanel(new GridBagLayout());
    private JButton buttonImprimir = new JButton("Imprimir");
    private JButton buttonFiltrarFilial = new JButton("Filtrar");
    private JButton buttonFiltarUsuario = new JButton("Filtrar");
    private JButton buttonConsultar = new JButton("Consultar");
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JComboBox comboBoxTabela = null;
    private TTextField textFieldDataInicial = ComponenteFactory.novoTTextField(10, 4);
    private TTextField textFieldDataFinal = ComponenteFactory.novoTTextField(10, 4);
    private TTextField textFieldChaveConsulta = ComponenteFactory.novoTTextField(100, 3);
    private JLabel labelFilial = new JLabel("Filial:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelTabela = new JLabel("Tabela:");
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JLabel labelChavePesquisa = new JLabel("Chave Pesquisa:");
    private ModeloGridTable modeloLog = new ModeloGridTable(new String[]{"C\u00f3digo", "Tipo Opera\u00e7\u00e3o", "Data Hora", "Tabela", "Usu\u00e1rio"});
    private JTable tableLog = new JTable(this.modeloLog);
    private JScrollPane scrollPaneLog = new JScrollPane(this.tableLog);
    private ModeloGridTable modeloMudanca = new ModeloGridTable(new String[]{"Coluna", "Valor Anterior", "Valor Novo"});
    private JTable tableMudanca = new JTable(this.modeloMudanca);
    private JScrollPane scrollPaneMudanca = new JScrollPane(this.tableMudanca);
    private AuditoriaTabelaDescricaoService auditoriaTabelaDescricaoService = new AuditoriaTabelaDescricaoService();
    private AuditoriaTabelaDescricaoLogTabelaService auditoriaTabelaDescricaoLogTabelaService = new AuditoriaTabelaDescricaoLogTabelaService();
    private LogRastreabilidadeService rastreabilidadeService = new LogRastreabilidadeService();
    private SplashMensagem mensagem = null;
    private JTextArea textAreaChave = new JTextArea();
    private boolean isExecutandoPesquisa = false;
    Set<AuditoriaTabelaDescricaoLogTabelaBean> auditoriaTabelaDescricaoLogTabelaBeans = null;
    HashMap<String, String> camposAtributosClasse = new HashMap();

    public AuditoriaLog() {
        Funcoes.criaBarraDescricao(this, "Auditoria de log", "Logs de altera\u00e7\u00f5es de registros do sistema", "configuracoes/log_audit.jpg");
        this.montarTela();
    }

    private void montarTela() {
        this.setModuloAcesso(AuditoriaLog.getModuloAcesso());
        this.buttonConsultar.setMnemonic('s');
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setVisible(false);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new BorderLayout());
        this.painelOpcoes.add(this.buttonImprimir);
        this.painelBotoes.add((Component)this.painelOpcoes, "West");
        this.painelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.botaoNovo, this.botaoCancelar, this.botaoFechar), "East");
        this.buttonImprimir.setMnemonic('i');
        this.buttonImprimir.addActionListener(this);
        this.buttonConsultar.addActionListener(this);
        this.buttonFiltrarFilial.addActionListener(this);
        this.buttonFiltarUsuario.addActionListener(this);
        this.modeloLog.setColumnSize(new int[]{65, 100, 150, 0, 0}, this.tableLog);
        this.modeloMudanca.setColumnSize(new int[]{0, 0, 0}, this.tableMudanca);
        this.tableLog.getTableHeader().addMouseListener(this.modeloLog);
        this.tableMudanca.setDefaultRenderer(Object.class, new RendererLogs());
        this.tableMudanca.getTableHeader().addMouseListener(this.modeloMudanca);
        this.textAreaChave.setWrapStyleWord(true);
        this.textAreaChave.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textAreaChave);
        ScreenUtil.posicionaTextoTopo(this.textAreaChave);
        this.montarPainelFiltro();
        this.controlaCampos();
    }

    private void montarPainelFiltro() {
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 17;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(1, 0, 0, 1);
        this.panelFiltros.setBorder(new TitledBorder("Filtros"));
        Insets padrao = new Insets(0, 2, 2, 0);
        Insets espaco = new Insets(0, 20, 2, 0);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridwidth = 2;
        this.itemFiltroFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFiltroFilial.setTamanhoMinimoCheck(new Dimension(130, 20));
        this.itemFiltroFilial.setTamanhoPreferidoCheck(new Dimension(130, 20));
        this.panelFiltros.add((Component)this.itemFiltroFilial, c);
        this.comboBoxTabela = new JComboBox<Object>(this.montarListaTabela());
        this.comboBoxTabela.setPreferredSize(new Dimension(20, 20));
        this.comboBoxTabela.setMinimumSize(new Dimension(20, 20));
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = espaco;
        this.panelFiltros.add((Component)this.labelTabela, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 7;
        c.insets = padrao;
        this.panelFiltros.add((Component)this.comboBoxTabela, c);
        this.itemFiltroUsuario.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemFiltroUsuario.setTamanhoMinimoCheck(new Dimension(130, 20));
        this.itemFiltroUsuario.setTamanhoPreferidoCheck(new Dimension(130, 20));
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelFiltros.add((Component)this.itemFiltroUsuario, c);
        c.gridwidth = 1;
        c.gridx += 2;
        c.insets = espaco;
        this.panelFiltros.add((Component)this.labelDataInicial, c);
        ++c.gridx;
        c.insets = padrao;
        this.textFieldDataInicial.setPreferredSize(new Dimension(87, 20));
        this.textFieldDataInicial.setMinimumSize(new Dimension(87, 20));
        this.panelFiltros.add((Component)this.textFieldDataInicial, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 2, 0);
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicial.setMinimumSize(new Dimension(20, 20));
        this.panelFiltros.add((Component)this.buttonDataInicial, c);
        ++c.gridx;
        c.insets = espaco;
        this.panelFiltros.add((Component)this.labelDataFinal, c);
        ++c.gridx;
        c.insets = padrao;
        this.textFieldDataFinal.setPreferredSize(new Dimension(87, 20));
        this.textFieldDataFinal.setMinimumSize(new Dimension(87, 20));
        this.panelFiltros.add((Component)this.textFieldDataFinal, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 2, 0);
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinal.setMinimumSize(new Dimension(20, 20));
        this.panelFiltros.add((Component)this.buttonDataFinal, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.insets = padrao;
        c.fill = 2;
        this.panelFiltros.add((Component)new JPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelFiltros.add((Component)this.labelChavePesquisa, c);
        ++c.gridx;
        this.textFieldChaveConsulta.setPreferredSize(new Dimension(100, 20));
        this.textFieldChaveConsulta.setMinimumSize(new Dimension(100, 20));
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 8;
        this.panelFiltros.add((Component)this.textFieldChaveConsulta, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 9;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.buttonConsultar.setPreferredSize(new Dimension(95, 20));
        this.buttonConsultar.setMinimumSize(new Dimension(95, 20));
        this.panelFiltros.add((Component)this.buttonConsultar, c);
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        this.painelCentral.add((Component)this.panelFiltros, constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.painelCentral.add((Component)this.scrollPaneLog, constraints);
        GridBagConstraints bagChave = new GridBagConstraints();
        bagChave.fill = 1;
        bagChave.gridx = 0;
        bagChave.gridy = 0;
        bagChave.weightx = 1.0;
        bagChave.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.textAreaChave);
        this.textAreaChave.setEditable(false);
        jScrollPane.setPreferredSize(new Dimension(40, 50));
        jScrollPane.setMinimumSize(new Dimension(40, 50));
        this.panelChave.add((Component)jScrollPane, bagChave);
        this.panelChave.setBorder(new TitledBorder("Chave"));
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        ++constraints.gridy;
        this.painelCentral.add((Component)this.panelChave, constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        ++constraints.gridy;
        this.painelCentral.add((Component)this.scrollPaneMudanca, constraints);
        this.textFieldDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AuditoriaLog.this.buttonDataInicial.doClick();
                }
            }
        });
        this.textFieldDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AuditoriaLog.this.buttonDataFinal.doClick();
                }
            }
        });
        this.tableLog.addMouseListener(this.modeloLog);
        this.tableLog.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LogRastreabilidadeBean logSelecionado;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (AuditoriaLog.this.tableLog.getSelectedRow() != -1 && (logSelecionado = (LogRastreabilidadeBean)AuditoriaLog.this.modeloLog.getValueAt(AuditoriaLog.this.tableLog.getSelectedRow(), 5)) != null && logSelecionado.getOperacao() != null) {
                    try {
                        AuditoriaLog.this.adicionarDadosAlterados(logSelecionado);
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(AuditoriaLog.this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel apresetnar o log de altera\u00e7\u00f5es.\n" + ex.getMessage(), ex.getStackTrace());
                    }
                }
            }
        });
    }

    private void adicionarDadosAlterados(LogRastreabilidadeBean logSelecionado) throws Exception {
        this.modeloMudanca.clear();
        String xmlCampos = logSelecionado.getOperacao();
        String[] campos = StringUtil.getValores(xmlCampos, "campo");
        if (Funcoes.textoVazio(xmlCampos)) {
            return;
        }
        ArrayList<Object> mudancaBeanAuxs = new ArrayList();
        mudancaBeanAuxs = campos != null && campos.length > 0 ? AuditoriaLog.carregaCamposAntigo(logSelecionado, campos, true) : AuditoriaLog.carregaCamposNovo(logSelecionado, xmlCampos, true);
        this.textAreaChave.setText(logSelecionado.getChave());
        for (LogRegistroMudanca logRegistroMudanca : mudancaBeanAuxs) {
            this.modeloMudanca.addLine(new Object[]{logRegistroMudanca.getColunaAlteradaField() != null && !logRegistroMudanca.getColunaAlteradaField().isEmpty() ? logRegistroMudanca.getColunaAlteradaField() : logRegistroMudanca.getColunaAlterada(), logRegistroMudanca.getValorAnterior(), logRegistroMudanca.getValorNovo(), logSelecionado});
        }
    }

    public static ArrayList<LogRegistroMudanca> carregaCamposNovo(LogRastreabilidadeBean logSelecionado, String xmlCampos, boolean isPreencherTabela) throws Exception {
        ArrayList<LogRegistroMudanca> mudancaBeanAuxs = new ArrayList<LogRegistroMudanca>();
        boolean isInsert = logSelecionado.getTipoOperacao().equalsIgnoreCase("I");
        boolean isDelete = logSelecionado.getTipoOperacao().equalsIgnoreCase("D");
        String camposNew = StringUtil.getValor(xmlCampos, "new");
        String camposOld = StringUtil.getValor(xmlCampos, "old");
        String camposNome = logSelecionado.getCampos();
        if (Funcoes.textoVazio(camposNome)) {
            camposNome = AuditoriaLog.getCampos(logSelecionado.getTabela());
        }
        camposNome = camposNome.replace("{", "");
        camposNome = camposNome.replace("}", "");
        camposNew = camposNew.replace("(", "");
        camposNew = camposNew.replace(")", "");
        camposOld = camposOld.replace("(", "");
        camposOld = camposOld.replace(")", "");
        StringTokenizer tokenizerNew = new StringTokenizer(camposNew, ",", true);
        StringTokenizer tokenizerOld = new StringTokenizer(camposOld, ",", true);
        StringTokenizer tokenizerCampos = new StringTokenizer(camposNome, ",");
        while (tokenizerCampos.hasMoreTokens()) {
            String campo = tokenizerCampos.nextToken();
            String valorNovo = null;
            if (!isDelete && tokenizerNew.hasMoreTokens()) {
                valorNovo = tokenizerNew.nextToken();
                if (valorNovo.equals(",")) {
                    valorNovo = null;
                } else if (tokenizerNew.hasMoreTokens()) {
                    tokenizerNew.nextToken();
                }
            }
            String valorAlterado = null;
            if (!isInsert && tokenizerOld.hasMoreTokens()) {
                valorAlterado = tokenizerOld.nextToken();
                if (valorAlterado.equals(",")) {
                    valorAlterado = null;
                } else if (tokenizerOld.hasMoreTokens()) {
                    tokenizerOld.nextToken();
                }
            }
            LogRegistroMudanca mudancaBeanAux = new LogRegistroMudanca();
            mudancaBeanAux.setTabelaAlterada(logSelecionado.getTabela());
            mudancaBeanAux.setColunaAlterada(campo);
            mudancaBeanAux.setValorAnterior(valorAlterado);
            mudancaBeanAux.setValorNovo(valorNovo);
            mudancaBeanAux.setTipoOperacao(logSelecionado.getTipoOperacao());
            mudancaBeanAux.setCodigoLogTabela(logSelecionado.getCodigo().toString());
            mudancaBeanAux.setUsuarioAlteracao(logSelecionado.getUsuario());
            mudancaBeanAux.setChave(logSelecionado.getChave());
            mudancaBeanAux.setDataHoraAlteracao(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", logSelecionado.getDataHora()));
            mudancaBeanAuxs.add(mudancaBeanAux);
        }
        return mudancaBeanAuxs;
    }

    private static String getCampos(String tabela) throws Exception {
        Statement st;
        block5: {
            StringBuilder buf = new StringBuilder();
            buf.append(" SELECT array_agg(col) as campos ");
            buf.append("   FROM (SELECT attname as col ");
            buf.append("           FROM pg_attribute ");
            buf.append("          WHERE attrelid = '").append(tabela).append("'::regclass ");
            buf.append("            AND attnum > 0 ");
            buf.append("            AND NOT attisdropped ");
            buf.append("          ORDER BY attnum) as tabela ");
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (!rs.next()) break block5;
            String string = rs.getString("campos");
            Conexao.fecharStatement(st);
            return string;
        }
        try {
            try {
                throw new Exception("N\u00e3o foi poss\u00edvel obter os campos da tabela \"" + tabela + "\".");
            }
            catch (SQLException e) {
                throw new Exception("N\u00e3o foi poss\u00edvel obter os campos da tabela \"" + tabela + "\".\n" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
    }

    public static ArrayList<LogRegistroMudanca> carregaCamposAntigo(LogRastreabilidadeBean logSelecionado, String[] campos, boolean isPreencherTabela) throws Exception {
        ArrayList<LogRegistroMudanca> mudancaBeanAuxs = new ArrayList<LogRegistroMudanca>();
        for (String campoXml : campos) {
            LogRegistroMudanca mudancaBeanAux = new LogRegistroMudanca();
            String atributoCampoBanco = StringUtil.getValor(campoXml, "nome");
            String valorNovo = StringUtil.getValor(campoXml, "new");
            String valorAlterado = StringUtil.getValor(campoXml, "old");
            mudancaBeanAux.setTabelaAlterada(logSelecionado.getTabela());
            mudancaBeanAux.setColunaAlterada(atributoCampoBanco);
            mudancaBeanAux.setValorAnterior(valorAlterado);
            mudancaBeanAux.setValorNovo(valorNovo);
            mudancaBeanAux.setTipoOperacao(logSelecionado.getTipoOperacao());
            mudancaBeanAux.setCodigoLogTabela(logSelecionado.getCodigo().toString());
            mudancaBeanAux.setUsuarioAlteracao(logSelecionado.getUsuario());
            mudancaBeanAux.setChave(logSelecionado.getChave());
            mudancaBeanAux.setDataHoraAlteracao(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", logSelecionado.getDataHora()));
            mudancaBeanAuxs.add(mudancaBeanAux);
        }
        return mudancaBeanAuxs;
    }

    private Object[] montarListaTabela() {
        try {
            return this.auditoriaTabelaDescricaoService.getListaTabelaDescricaoUser();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar combo de tabelas.", e.getStackTrace());
            return Collections.EMPTY_LIST.toArray();
        }
    }

    private AuditoriaTabelaDescricaoLogBean getTabelaSelecionada() {
        return (AuditoriaTabelaDescricaoLogBean)this.comboBoxTabela.getSelectedItem();
    }

    public CheckItemFiltro filtroItens(String titulo, String filtro, String tabela, String[] campos, String[] colunas, int[] tamanhoColunas, int colunaHint, int[] colunasSelecionaveis, int colunaOrdenacao, boolean considerarComoSelect, boolean pesquisaAvancada, boolean executarAoAbrir) {
        CheckItemFiltro itemFiltro = new CheckItemFiltro(titulo, "Filtrar", "Filtrando " + titulo, filtro, colunasSelecionaveis, colunaOrdenacao, pesquisaAvancada);
        itemFiltro.setDados(tabela, campos, colunas, tamanhoColunas, colunaOrdenacao, considerarComoSelect, pesquisaAvancada, executarAoAbrir);
        itemFiltro.setColunaHint(colunaHint);
        return itemFiltro;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0501200000");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonImprimir)) {
            this.imprimirRelatorio();
        } else if (e.getSource().equals(this.buttonConsultar)) {
            this.consultar();
        } else if (e.getSource().equals(this.buttonDataInicial)) {
            Funcoes.mostraData(this.textFieldDataInicial, this.buttonDataInicial, this.panelFiltros, true);
        } else if (e.getSource().equals(this.buttonDataFinal)) {
            Funcoes.mostraData(this.textFieldDataFinal, this.buttonDataFinal, this.panelFiltros, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirRelatorio() {
        try {
            Object logSelecionado;
            this.mensagem = SplashMensagem.getInstancia(this);
            ModeloGridTable modeloImpressao = new ModeloGridTable(this.camposBanco());
            FilialBean filialBeanLogada = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
            ArrayList<LogRegistroMudanca> mudancaBeanAuxs = new ArrayList<LogRegistroMudanca>();
            if (this.modeloLog.getRowCount() > 0) {
                this.mensagem.mostrar("Aguarde...");
            }
            for (int linha = 0; linha < this.modeloLog.getRowCount(); ++linha) {
                logSelecionado = (LogRastreabilidadeBean)this.modeloLog.getValueAt(linha, 5);
                String xmlCampos = ((LogRastreabilidadeBean)logSelecionado).getOperacao();
                String[] campos = StringUtil.getValores(xmlCampos, "campo");
                if (campos == null || campos.length == 0) {
                    mudancaBeanAuxs.addAll(AuditoriaLog.carregaCamposNovo((LogRastreabilidadeBean)logSelecionado, xmlCampos, false));
                } else {
                    mudancaBeanAuxs.addAll(AuditoriaLog.carregaCamposAntigo((LogRastreabilidadeBean)logSelecionado, campos, false));
                }
                for (LogRegistroMudanca mudancaBeanAux : mudancaBeanAuxs) {
                    mudancaBeanAux.setCepFilial(filialBeanLogada.getCep());
                    mudancaBeanAux.setCNESFilial(filialBeanLogada.getCnes());
                    mudancaBeanAux.setCnpjFilial(filialBeanLogada.getCnpj());
                    mudancaBeanAux.setCodigoBairroFilial(filialBeanLogada.getBairro() != null ? filialBeanLogada.getBairro().getCodigo() : null);
                    mudancaBeanAux.setCodigoCidadeFilial(filialBeanLogada.getCidade() != null ? filialBeanLogada.getCidade().getCodigo().toString() : null);
                    mudancaBeanAux.setCodigoFilial(filialBeanLogada.getCodigo().toString());
                    mudancaBeanAux.setComplementoFilial(filialBeanLogada.getComplemento());
                    mudancaBeanAux.setDescricaoBairroFilial(filialBeanLogada.getBairro() != null ? filialBeanLogada.getBairro().getDescricao() : null);
                    mudancaBeanAux.setDescricaoCidadeFilial(filialBeanLogada.getCidade() != null ? filialBeanLogada.getCidade().getNome() : null);
                    mudancaBeanAux.setDescricaoFilial(filialBeanLogada.getDescricao());
                    mudancaBeanAux.setEnderecoFilial(filialBeanLogada.getEndereco());
                    mudancaBeanAux.setEstadoCidadeFilial(filialBeanLogada.getCidade() != null ? filialBeanLogada.getCidade().getUf() : null);
                    mudancaBeanAux.setFaxFilial(filialBeanLogada.getFax());
                    mudancaBeanAux.setFoneFilial(filialBeanLogada.getFone());
                    mudancaBeanAux.setRazaoSocialFilial(filialBeanLogada.getRazaoSocial());
                }
            }
            Class<?> classGenerica = Class.forName(new LogRegistroMudanca().getClass().getCanonicalName());
            logSelecionado = mudancaBeanAuxs.iterator();
            while (logSelecionado.hasNext()) {
                LogRegistroMudanca mudancaBeanAux;
                LogRegistroMudanca object = mudancaBeanAux = (LogRegistroMudanca)logSelecionado.next();
                Object[] o = new Object[this.camposBanco().length];
                int i = 0;
                for (Field fildObject : mudancaBeanAux.getClass().getDeclaredFields()) {
                    fildObject.setAccessible(true);
                    try {
                        Method method = classGenerica.getMethod(this.metodo(fildObject), new Class[0]);
                        o[i] = method.getName().equalsIgnoreCase("getTipoOperacao") ? Tipos.getTipoOperacaoLog(method.invoke((Object)object, new Object[0]).toString()) : method.invoke((Object)object, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ErrorLogger.mostraMensagem(this, "M\u00e9todo n\u00e3o encontrado : " + this.metodo(fildObject), e.getStackTrace());
                    }
                    ++i;
                }
                modeloImpressao.addLine(o);
            }
            StringBuilder sql = new StringBuilder();
            sql.setLength(0);
            sql.append("select rel_xml from relatoriosistema where rel_codigo = ");
            sql.append(RelatorioAuditoriaLog.getModuloAcesso());
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
            if (modeloImpressao.getRowCount() > 0) {
                modeloImpressao.ordenarColunaAvancado(modeloImpressao.findColumn("codigoLogTabela"), modeloImpressao.findColumn("codigoLogTabela"), 1, false);
                if (rs.next()) {
                    HashMap<String, Object> variaveis = new HashMap<String, Object>();
                    variaveis.put(FILTRO_FILIAL, this.itemFiltroFilial.getSelecionados(0));
                    variaveis.put(FILTRO_USUARIO, this.itemFiltroUsuario.getSelecionados(0));
                    variaveis.put(FILTRO_TABELA, this.comboBoxTabela.getSelectedItem().toString());
                    if (!Funcoes.textoVazio(this.textFieldDataInicial.getText())) {
                        variaveis.put(FILTRO_DATA_INICIAL, Funcoes.formataData("dd/MM/yyyy", this.textFieldDataInicial.getText()));
                    } else {
                        variaveis.put(FILTRO_DATA_INICIAL, "");
                    }
                    if (!Funcoes.textoVazio(this.textFieldDataFinal.getText())) {
                        variaveis.put(FILTRO_DATA_FINAL, Funcoes.formataData("dd/MM/yyyy", this.textFieldDataFinal.getText()));
                    } else {
                        variaveis.put(FILTRO_DATA_FINAL, "");
                    }
                    variaveis.put(FILTRO_CHAVES, this.textFieldChaveConsulta.getText());
                    Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    gerador.setPreVisualizar(true);
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modeloImpressao, variaveis);
                } else {
                    Funcoes.mensagem(this, "Relat\u00f3rio n\u00e3o possui layout.", 2);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            }
            this.mensagem.apagar();
        }
        catch (Exception e) {
            this.mensagem.apagar();
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel imprimir relat\u00f3rio de log.", e.getStackTrace());
        }
        finally {
            this.mensagem.apagar();
        }
    }

    private String metodo(Field fildObject) {
        return "get" + fildObject.getName().substring(0, 1).toUpperCase() + fildObject.getName().substring(1, fildObject.getName().length());
    }

    private void consultar() {
        this.textAreaChave.setText("");
        if (this.comboBoxTabela.getItemCount() == 0) {
            Funcoes.mensagem(this, "Nenhuma tabela configurada.", 2);
            ScreenUtil.requisitarFoco(this.comboBoxTabela);
            return;
        }
        if (Funcoes.textoVazio(this.textFieldDataInicial.getText())) {
            Funcoes.mensagem(this, "Informa a data inicial.", 2);
            ScreenUtil.requisitarFoco(this.textFieldDataInicial);
            return;
        }
        this.mensagem = SplashMensagem.getInstancia(this);
        this.mensagem.mostrar("Pesquisando. Aguarde...");
        this.modeloLog.clear();
        this.modeloMudanca.clear();
        StringBuilder sqlConsultaLog = new StringBuilder();
        StringBuilder tabelasRelacionadas = new StringBuilder();
        StringBuilder filial = new StringBuilder();
        StringBuilder usuarios = new StringBuilder();
        String[] filialSelecionada = this.itemFiltroFilial.getSelecionados(0);
        String[] usuariosSelecionados = this.itemFiltroUsuario.getSelecionados(0);
        AuditoriaTabelaDescricaoLogBean tabela = this.getTabelaSelecionada();
        String dataInicial = Funcoes.formataData("yyyy-MM-dd", this.textFieldDataInicial.getText());
        String dataFinal = null;
        if (!Funcoes.textoVazio(this.textFieldDataFinal)) {
            dataFinal = Funcoes.formataData("yyyy-MM-dd", this.textFieldDataFinal.getText());
        }
        try {
            this.auditoriaTabelaDescricaoLogTabelaBeans = this.auditoriaTabelaDescricaoLogTabelaService.getListaTabelaRelacionada(tabela.getCodigo());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar lista de tabelas relacionadas ao log.", e.getStackTrace());
            return;
        }
        this.montaSqlTabelaRelacionada(tabelasRelacionadas, this.auditoriaTabelaDescricaoLogTabelaBeans);
        sqlConsultaLog.append(" where ras_tabela in (").append((CharSequence)tabelasRelacionadas).append(")");
        sqlConsultaLog.append(" and cast(ras_datahora as date) >= '").append(dataInicial).append("'");
        if (dataFinal != null) {
            sqlConsultaLog.append(" and cast(ras_datahora as date) <= '").append(dataFinal).append("'");
        }
        this.montaSqlFilialUserSelecionados(filial, filialSelecionada);
        if (filialSelecionada != null && filialSelecionada.length > 0) {
            sqlConsultaLog.append(" and ras_filialorigem in(").append(filial.toString()).append(")");
        }
        this.montaSqlFilialUserSelecionados(usuarios, usuariosSelecionados);
        if (usuarios != null && !usuarios.toString().isEmpty()) {
            sqlConsultaLog.append(" and ras_loginusuario in(").append((CharSequence)usuarios).append(")");
        }
        if (!Funcoes.textoVazio(this.textFieldChaveConsulta.getText())) {
            sqlConsultaLog.append(" and ras_chave like '%").append(this.textFieldChaveConsulta.getText()).append("%'");
        }
        try {
            sqlConsultaLog.append(" order by ras_filialorigem, ras_datahora");
            Set logRastreabilidadeBeans = this.rastreabilidadeService.load(sqlConsultaLog.toString());
            for (LogRastreabilidadeBean log : logRastreabilidadeBeans) {
                this.modeloLog.addLine(new Object[]{log.getCodigo(), Tipos.getTipoOperacaoLog(log.getTipoOperacao()), Funcoes.formataData("dd/MM/yyyy HH:mm:ss", log.getDataHora()), log.getTabela(), log.getUsuario(), log});
            }
            this.modeloLog.ordenarColunaSemTrocarSentido(this.modeloLog.findColumn("Data Hora"));
        }
        catch (Exception e) {
            this.mensagem.apagar();
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar lista de registro de logs", e.getStackTrace());
            return;
        }
        this.mensagem.apagar();
    }

    private void montaSqlFilialUserSelecionados(StringBuilder sql, String[] listaSelecionados) {
        if (listaSelecionados != null) {
            for (String selecionado : listaSelecionados) {
                sql.append("'");
                sql.append(selecionado);
                sql.append("'");
            }
        }
        if (!sql.toString().isEmpty()) {
            String temp = sql.toString();
            sql.setLength(0);
            sql.append(temp.replaceAll("''", "','"));
        }
    }

    private void montaSqlTabelaRelacionada(StringBuilder tabelasRelacionadas, Set<AuditoriaTabelaDescricaoLogTabelaBean> auditoriaTabelaDescricaoLogTabelaBeans) {
        for (AuditoriaTabelaDescricaoLogTabelaBean auditoriaTabelaDescricaoLogTabelaBean : auditoriaTabelaDescricaoLogTabelaBeans) {
            tabelasRelacionadas.append("'");
            tabelasRelacionadas.append(auditoriaTabelaDescricaoLogTabelaBean.getTabela().trim());
            tabelasRelacionadas.append("'");
        }
        if (!tabelasRelacionadas.toString().isEmpty()) {
            String temp = tabelasRelacionadas.toString();
            tabelasRelacionadas.setLength(0);
            tabelasRelacionadas.append(temp.replaceAll("''", "','"));
        }
    }

    @Override
    protected void controlaCampos() {
        this.buttonConsultar.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonDataFinal.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonDataInicial.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonFiltarUsuario.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonFiltrarFilial.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonImprimir.setEnabled(this.habilitaDesabilitaCampo());
        this.textFieldChaveConsulta.setEnabled(this.habilitaDesabilitaCampo());
        this.textFieldDataFinal.setEnabled(this.habilitaDesabilitaCampo());
        this.textFieldDataInicial.setEnabled(this.habilitaDesabilitaCampo());
        this.comboBoxTabela.setEnabled(this.habilitaDesabilitaCampo());
        this.itemFiltroFilial.setEnabled(this.habilitaDesabilitaCampo());
        this.itemFiltroUsuario.setEnabled(this.habilitaDesabilitaCampo());
        if (!Acesso.getAcesso(RelatorioAuditoriaLog.getModuloAcesso())) {
            this.buttonImprimir.setEnabled(false);
        }
        if (this.isExecutandoPesquisa) {
            this.botaoCancelar.setEnabled(false);
        } else {
            this.botaoCancelar.setEnabled(true);
        }
    }

    private boolean habilitaDesabilitaCampo() {
        if (this.isExecutandoPesquisa) {
            return false;
        }
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    protected void limparCampos() {
        this.modeloLog.clear();
        this.modeloMudanca.clear();
        if (this.comboBoxTabela.getSelectedObjects() != null && this.comboBoxTabela.getSelectedObjects().length > 0) {
            this.comboBoxTabela.setSelectedIndex(0);
        }
        this.textFieldChaveConsulta.setText("");
        this.textFieldDataFinal.setText("");
        this.textFieldDataInicial.setText("");
        this.itemFiltroFilial.setEnabled(false);
        this.itemFiltroUsuario.setEnabled(false);
        this.textAreaChave.setText("");
    }

    private String[] camposBanco() {
        return ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoLogTabela", "dataHoraAlteracao", "codigoUsuarioAlteracao", "tabelaAlterada", "tipoOperacao", "colunaAlterada", "valorAnterior", "valorNovo", "colunaAlteradaField", "chave"});
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        return false;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isExecutandoPesquisa = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isExecutandoPesquisa = false;
        this.controlaCampos();
    }

    class RendererLogs
    extends DefaultTableCellRenderer {
        RendererLogs() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ModeloGridTable modelo = (ModeloGridTable)table.getModel();
            String valorAnterior = (String)modelo.getValueAt(row, 1);
            String valorNovo = (String)modelo.getValueAt(row, 2);
            LogRastreabilidadeBean log = (LogRastreabilidadeBean)modelo.getValueAt(row, 3);
            JLabel retorno = new JLabel();
            if (log.getTipoOperacao().equalsIgnoreCase("I") || log.getTipoOperacao().equalsIgnoreCase("D") || !valorAnterior.equals(valorNovo)) {
                retorno.setBackground(Color.RED);
            } else {
                retorno.setBackground(Color.WHITE);
            }
            retorno.setFont(table.getFont());
            retorno.setText(value.toString());
            retorno.setOpaque(true);
            return retorno;
        }
    }
}

