/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.camera.VisualizarFoto;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configuracao.CertificadoDigital;
import jalis.laboratorio.configuracao.DefAcesso;
import jalis.laboratorio.configuracao.FiliaisPermitidas;
import jalis.laboratorio.configuracao.Filial;
import jalis.laboratorio.configuracao.material.AvisarMaterial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.material.MaterialUsuarioVO;
import jalis.model.vo.configuracao.UsuarioFilialVO;
import jalis.model.vo.configuracao.UsuarioSenhasVO;
import jalis.service.configuracao.UsuarioFilialService;
import jalis.service.configuracao.UsuarioSenhasService;
import jalis.service.configuracao.UsuarioService;
import jalis.service.estoque.MaterialService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.LabelFotoCaptura;
import jalis.util.LabelFotoCapturaListener;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TPasswordField;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.codec.binary.Base64;

public class Usuario
extends FrmCadPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private JPopupMenu menuFoto = new JPopupMenu();
    private JMenuItem menuAlteraFoto = new JMenuItem("Adicionar/Alterar imagem");
    private JMenuItem menuRemoveFoto = new JMenuItem("Remover imagem");
    private JPopupMenu menuAssinatura = new JPopupMenu();
    private JMenuItem menuAlteraAssinatura = new JMenuItem("Adicionar/Alterar assinatura");
    private JMenuItem menuRemoveAssinatura = new JMenuItem("Remover assinatura");
    private JPopupMenu menuAssinaWeb = new JPopupMenu();
    private JMenuItem menuAlteraAssinaWeb = new JMenuItem("Adicionar/Alterar assinatura");
    private JMenuItem menuRemoveAssinaWeb = new JMenuItem("Remover assinatura");
    private JPopupMenu menuImpressaoDigital = new JPopupMenu();
    private JMenuItem menuCapturarImpressaoDigital = ComponenteFactory.novoJMenuItem(this.menuImpressaoDigital, "Adicionar/Alterar", (ActionListener)this);
    private JMenuItem menuRemoverImpressaoDigital = ComponenteFactory.novoJMenuItem(this.menuImpressaoDigital, "Remover", (ActionListener)this);
    private JMenuItem menuVerificarImpressaoDigital = ComponenteFactory.novoJMenuItem(this.menuImpressaoDigital, "Verificar", (ActionListener)this);
    private JLabel jLabel1;
    private TTextField txtCodigo = new TTextField(20);
    private TTextField txtNome = new TTextField(80);
    private TPasswordField txtSenha = new TPasswordField(20);
    private TPasswordField txtSenha2 = new TPasswordField(20);
    private String senhaAnterior;
    private ArrayList<String> senhasAnteriores = new ArrayList();
    private java.util.Date dataUltimaSenha = new java.util.Date();
    private boolean alterado = false;
    private TTextField txtCodTipo = new TTextField(5, 1);
    private JButton jButton1;
    private TTextField txtDescTipo = new TTextField();
    private JLabel jLabel7;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel labelAssinatura = new JLabel("Laudo:");
    private JLabel labelVAssinatura = new JLabel();
    private JLabel labelColetor = new JLabel("Coletor:");
    private TPasswordField txtColetor = new TPasswordField(10);
    private JLabel labelFilial = new JLabel("Filial:");
    private JComboBox comboFilial = new JComboBox();
    private JButton buttonAcesso;
    private JPopupMenu menu;
    private JMenuItem menuNovo;
    private JMenuItem menuCopia;
    private ImageIcon imagemAssinatura;
    private ImageIcon imagemAssinaWeb;
    private ImageIcon fotoUsuario;
    private LabelFotoCaptura labelFoto;
    private JCheckBox checkSenha = new JCheckBox("Alterar senha no login");
    private JCheckBox checkInativo = new JCheckBox("Inativo");
    private JCheckBox checkWeb = new JCheckBox("Receber mensagens de erro da Web");
    private JButton buttonFiliais = ComponenteFactory.novoJButton("Filiais permitidas", this);
    private JLabel labelAssinaWeb = new JLabel("Web:");
    private JLabel labelVAssinaWeb = new JLabel();
    private JPanel panelAssinaturas = ComponenteFactory.novoJPanel(null, new TitledBorder("Assinaturas"));
    private JLabel labelPersonalizacaoAssinaturaDigital = new JLabel("Personaliza\u00e7\u00e3o do texto para Assinatura Digital (Certificado):");
    private JTextArea textPersonalizacaoAssinaturaDigital = new JTextArea(new TTextAreaDocument(200));
    private JScrollPane scrollPersonalizacaoAssinaturaDigital = new JScrollPane(this.textPersonalizacaoAssinaturaDigital);
    private JButton buttonCertificado = ComponenteFactory.novoJButton("Certificado Digital", 'g', this);
    private final long mudarAcessos = Long.parseLong("0500500204");
    private final boolean mudarFiliais = Acesso.getAcesso(Long.parseLong("0500500205"));
    private final boolean visualizarSenhaColetador = Acesso.getAcesso(Long.parseLong("0500500206"));
    private boolean usuarioInativo = false;
    private String codigoUsuario = "";
    private String retornoParaPesquisa = "";
    private String impressaoDigital = null;
    private boolean mostrarImpressaoDigital = ParametrosLocais.existeParametro("biometriaCaptura") && !ParametrosLocais.getParametro("biometriaCaptura").equals("Sem biometria");
    private ArrayList<Integer> filiaisPermitidas = new ArrayList();
    private HashSet<Long> listaModulos = new HashSet();
    private HashSet<Long> listaModulosOriginais = new HashSet();
    private String codigoTipoOriginal = null;
    private boolean isExecutando = false;
    private boolean isDesmarcarTodos = false;
    private boolean isEditandoRegistro = false;
    private boolean isPorTipoUsuario = ParametrosGerais.getTipoControleAcesso().equals("T");
    PreparedStatement prstInsereAcessoUsuario = null;
    PreparedStatement prstRemoveAcessoUsuario = null;
    PreparedStatement prstRemoveTodosAcessosUsuario = null;
    private CertificadoDigital certificado;
    private JPanel panelEstoque = ComponenteFactory.novoJPanel(null, new TitledBorder("Estoque"));
    private JButton buttonAvisarReposicao = new JButton("Avisar Reposi\u00e7\u00e3o");
    private JButton buttonAvisarValidade = new JButton("Avisar Validade");
    private List<MaterialUsuarioVO> listaMaterialUsuarios = new ArrayList<MaterialUsuarioVO>();

    private void montaBotoes() {
        this.painelBotoes.removeAll();
        JPanel panelBotoesDireita = new JPanel(new FlowLayout(2));
        JPanel panelBotoesEsquerda = new JPanel(new FlowLayout(0));
        this.painelBotoes.setLayout(new BorderLayout());
        this.painelBotoes.add((Component)panelBotoesDireita, "East");
        this.painelBotoes.add((Component)panelBotoesEsquerda, "West");
        panelBotoesEsquerda.add(this.buttonCertificado);
        this.buttonCertificado.setName("buttonCertificado");
        panelBotoesDireita.add(this.botaoNovo);
        this.botaoNovo.setName("botaoNovo");
        panelBotoesDireita.add(this.botaoEditar);
        this.botaoEditar.setName("botaoEditar");
        panelBotoesDireita.add(this.botaoSalvar);
        this.botaoSalvar.setName("botaoSalvar");
        panelBotoesDireita.add(this.botaoCancelar);
        this.botaoCancelar.setName("botaoCancelar");
        panelBotoesDireita.add(this.botaoExcluir);
        this.botaoExcluir.setName("botaoExcluir");
        panelBotoesDireita.add(this.botaoFechar);
        this.botaoFechar.setName("botaoFechar");
    }

    public Usuario() {
        try {
            this.jbInit();
            StringBuilder buf = new StringBuilder();
            buf.append(" insert into usuarioacesso ");
            buf.append(" (usr_codigo, ass_codigo) ");
            buf.append(" values (?, ?) ");
            this.prstInsereAcessoUsuario = Conexao.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" delete from usuarioacesso ");
            buf.append(" where usr_codigo = ? ");
            buf.append("   and ass_codigo = ? ");
            this.prstRemoveAcessoUsuario = Conexao.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" delete from usuarioacesso ");
            buf.append(" where usr_codigo = ? ");
            this.prstRemoveTodosAcessosUsuario = Conexao.getPreparedStatement(buf.toString());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Usuario");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Usuario");
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel7 = new JLabel();
        this.labelFoto = new LabelFotoCaptura(this);
        this.labelFoto.setName("labelFoto");
        this.labelFoto.addFotoCapturaListener(new LabelFotoCapturaListener(){

            @Override
            public void fotoCapturada() {
                Usuario.this.fotoUsuario = Usuario.this.labelFoto.getFotoPaciente();
            }
        });
        this.buttonAcesso = new JButton("Acessos \u25bc");
        this.buttonAcesso.setName("buttonAcesso");
        this.menu = new JPopupMenu();
        this.menu.setName("menu");
        this.menuNovo = new JMenuItem("Novo/Alterar");
        this.menuNovo.setName("menuNovo");
        this.menuCopia = new JMenuItem("Copiar acessos");
        this.menuCopia.setName("menuCopia");
        this.menu.add(this.menuNovo);
        this.menu.add(this.menuCopia);
        if (this.visualizarSenhaColetador) {
            this.txtColetor.setEchoChar('\u0000');
        }
        this.setLabelDescricao("Cadastro de usu\u00e1rios e acessos ao sistema");
        this.setLabelFormulario("Cadastro de usu\u00e1rios");
        this.setIcone(ImagemUtils.carregaImagemJalis("configuracoes/cad_usuario.jpg"));
        this.montaPanelEstoque();
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("Usu\u00e1rio:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setName("txtCodigo");
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(90, 7, 400, 20));
        this.txtNome.setName("txtNome");
        this.txtNome.setBounds(new Rectangle(90, 28, 400, 20));
        this.txtNome.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Nome:");
        this.jLabel2.setLabelFor(this.txtNome);
        this.jLabel2.setDisplayedMnemonic('R');
        this.txtSenha.setName("txtSenha");
        this.txtSenha.setBounds(new Rectangle(90, 49, 400, 20));
        this.txtSenha.setText("");
        this.txtSenha.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (Usuario.this.txtSenha.getPassword().equals(Usuario.this.senhaAnterior)) {
                    Usuario.this.alterado = false;
                } else {
                    Usuario.this.alterado = true;
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (Usuario.this.isEditandoRegistro && Usuario.this.getStatus() != 2) {
                    if (Usuario.this.txtSenha.getPassword().equals(Usuario.this.senhaAnterior)) {
                        Usuario.this.alterado = false;
                    } else {
                        Usuario.this.alterado = true;
                    }
                } else {
                    Usuario.this.isEditandoRegistro = true;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.txtSenha2.setName("txtSenha2");
        this.txtSenha2.setBounds(new Rectangle(90, 70, 400, 20));
        this.txtSenha2.setText("");
        this.jLabel3.setBounds(new Rectangle(7, 51, 63, 14));
        this.jLabel3.setText("Senha:");
        this.jLabel4.setBounds(new Rectangle(7, 72, 75, 14));
        this.jLabel4.setText("Confirmar:");
        this.jLabel7.setBounds(new Rectangle(7, 93, 75, 14));
        this.jLabel7.setText("Tipo:");
        this.txtDescTipo.setName("txtDescTipo");
        this.txtDescTipo.setEditable(false);
        this.txtDescTipo.setFocusable(false);
        this.jButton1.setName("jButton1");
        this.jButton1.setFocusable(false);
        Funcoes.imagemPesquisa(this.jButton1);
        this.txtCodTipo.setName("txtCodTipo");
        this.txtCodTipo.setBounds(new Rectangle(90, 91, 69, 20));
        this.txtDescTipo.setName("txtDescTipo");
        this.txtDescTipo.setBounds(new Rectangle(181, 91, 309, 20));
        this.jButton1.setBounds(new Rectangle(160, 91, 20, 20));
        this.labelVAssinatura.setHorizontalAlignment(0);
        this.labelVAssinatura.setBounds(new Rectangle(7, 27, 250, 200));
        this.labelVAssinatura.setToolTipText("<html>Clique sobre o texto/imagem para alterar a imagem <br>ou clique com o bot\u00e3o direito do mouse<br> sobre o texto/imagem para ver um menu de op\u00e7\u00f5es</html>");
        this.labelVAssinatura.setText("Clique para adicionar imagem");
        this.labelVAssinatura.setBorder(new TitledBorder(""));
        this.labelVAssinaWeb.setHorizontalAlignment(0);
        this.labelVAssinaWeb.setBounds(new Rectangle(277, 27, 250, 200));
        this.labelVAssinaWeb.setToolTipText("<html>Clique sobre o texto/imagem para alterar a imagem <br>ou clique com o bot\u00e3o direito do mouse<br> sobre o texto/imagem para ver um menu de op\u00e7\u00f5es</html>");
        this.labelVAssinaWeb.setText("Clique para adicionar imagem");
        this.labelVAssinaWeb.setBorder(new TitledBorder(""));
        this.labelAssinatura.setBounds(7, 13, 200, 14);
        this.labelAssinaWeb.setBounds(277, 13, 200, 14);
        this.labelPersonalizacaoAssinaturaDigital.setBounds(7, 230, 550, 16);
        this.textPersonalizacaoAssinaturaDigital.setWrapStyleWord(true);
        this.textPersonalizacaoAssinaturaDigital.setLineWrap(true);
        this.scrollPersonalizacaoAssinaturaDigital.setBounds(7, 246, 520, 40);
        this.labelColetor.setBounds(7, 112, 83, 14);
        this.txtColetor.setBounds(90, 112, 400, 20);
        this.txtColetor.setName("txtColetor");
        this.labelFilial.setBounds(7, 133, 83, 14);
        this.comboFilial.setBounds(90, 133, 400, 20);
        this.comboFilial.setName("comboFilial");
        this.checkSenha.setBounds(90, 154, 180, 20);
        this.checkSenha.setName("checkSenha");
        this.checkWeb.setBounds(90, 175, 245, 20);
        this.checkWeb.setName("checkWeb");
        this.checkInativo.setBounds(340, 154, 150, 20);
        this.checkInativo.setName("checkInativo");
        this.buttonFiliais.setBounds(495, 154, 130, 20);
        this.buttonFiliais.setName("buttonFiliais");
        this.buttonAcesso.setBounds(495, 175, 130, 20);
        this.buttonAcesso.setName("buttonAcesso");
        this.buttonAcesso.setMnemonic('e');
        this.panelEstoque.setBounds(90, 195, 537, 60);
        this.panelAssinaturas.setBounds(90, 260, 537, 295);
        this.checkInativo.setVisible(false);
        this.panelAssinaturas.setLayout(null);
        this.panelAssinaturas.add(this.labelVAssinatura);
        this.panelAssinaturas.add(this.labelVAssinaWeb);
        this.panelAssinaturas.add(this.labelAssinatura);
        this.panelAssinaturas.add(this.labelAssinaWeb);
        this.panelAssinaturas.add(this.labelPersonalizacaoAssinaturaDigital);
        this.panelAssinaturas.add(this.scrollPersonalizacaoAssinaturaDigital);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, "select fil_codigo, fil_descricao from filiais_postocoleta order by fil_codigo");
            this.comboFilial.removeAllItems();
            while (rs.next()) {
                this.comboFilial.addItem(new Filial(rs.getInt("fil_codigo"), rs.getString("fil_descricao")));
            }
            this.comboFilial.setSelectedIndex(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Conexao.fecharStatement(st);
        this.menuAssinatura.add(this.menuAlteraAssinatura);
        this.menuAlteraAssinatura.setName("menuAlteraAssinatura");
        this.menuAssinatura.add(this.menuRemoveAssinatura);
        this.menuRemoveAssinatura.setName("menuRemoveAssinatura");
        this.menuAssinaWeb.add(this.menuAlteraAssinaWeb);
        this.menuAlteraAssinaWeb.setName("menuAlteraAssinaWeb");
        this.menuAssinaWeb.add(this.menuRemoveAssinaWeb);
        this.menuRemoveAssinaWeb.setName("menuRemoveAssinaWeb");
        this.menuAlteraAssinatura.setName("menuAlteraAssinatura");
        this.menuAlteraAssinatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser file = ComponenteFactory.novoJFileChooser();
                file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
                if (file.showOpenDialog(Usuario.this) == 0) {
                    if (Usuario.this.imagemAssinatura == null) {
                        Usuario.this.imagemAssinatura = new ImageIcon();
                    }
                    Usuario.this.imagemAssinatura.setImage(Toolkit.getDefaultToolkit().getImage(file.getSelectedFile().getAbsolutePath()));
                    Usuario.this.labelVAssinatura.setIcon(Usuario.this.imagemAssinatura);
                    Usuario.this.labelVAssinatura.setText("");
                    Usuario.this.labelVAssinatura.setBorder(null);
                }
            }
        });
        this.menuAlteraAssinaWeb.setName("menuAlteraAssinaWeb");
        this.menuAlteraAssinaWeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser file = ComponenteFactory.novoJFileChooser();
                file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
                if (file.showOpenDialog(Usuario.this) == 0) {
                    if (Usuario.this.imagemAssinaWeb == null) {
                        Usuario.this.imagemAssinaWeb = new ImageIcon();
                    }
                    Usuario.this.imagemAssinaWeb.setImage(Toolkit.getDefaultToolkit().getImage(file.getSelectedFile().getAbsolutePath()));
                    Usuario.this.labelVAssinaWeb.setIcon(Usuario.this.imagemAssinaWeb);
                    Usuario.this.labelVAssinaWeb.setText("");
                    Usuario.this.labelVAssinaWeb.setBorder(null);
                }
            }
        });
        this.menuRemoveAssinatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Usuario.this.imagemAssinatura = null;
                Usuario.this.labelVAssinatura.setText("Clique para adicionar imagem");
                Usuario.this.labelVAssinatura.setBorder(new TitledBorder(""));
                Usuario.this.labelVAssinatura.setIcon(null);
            }
        });
        this.menuRemoveAssinaWeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Usuario.this.imagemAssinaWeb = null;
                Usuario.this.labelVAssinaWeb.setText("Clique para adicionar imagem");
                Usuario.this.labelVAssinaWeb.setBorder(new TitledBorder(""));
                Usuario.this.labelVAssinaWeb.setIcon(null);
            }
        });
        this.labelVAssinatura.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((Usuario.this.getStatus() == 2 || Usuario.this.getStatus() == 3) && e.getButton() == 3) {
                    Usuario.this.menuAssinatura.show(Usuario.this.labelVAssinatura, e.getX(), e.getY());
                } else if (Usuario.this.getStatus() == 2 || Usuario.this.getStatus() == 3) {
                    JFileChooser file = ComponenteFactory.novoJFileChooser();
                    file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
                    if (file.showOpenDialog(Usuario.this) == 0) {
                        if (Usuario.this.imagemAssinatura == null) {
                            Usuario.this.imagemAssinatura = new ImageIcon();
                        }
                        Usuario.this.imagemAssinatura.setImage(Toolkit.getDefaultToolkit().getImage(file.getSelectedFile().getAbsolutePath()));
                        Usuario.this.labelVAssinatura.setIcon(Usuario.this.imagemAssinatura);
                        Usuario.this.labelVAssinatura.setText("");
                        Usuario.this.labelVAssinatura.setBorder(null);
                    }
                }
            }
        });
        this.labelVAssinaWeb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((Usuario.this.getStatus() == 2 || Usuario.this.getStatus() == 3) && e.getButton() == 3) {
                    Usuario.this.menuAssinaWeb.show(Usuario.this.labelVAssinaWeb, e.getX(), e.getY());
                } else if (Usuario.this.getStatus() == 2 || Usuario.this.getStatus() == 3) {
                    JFileChooser file = ComponenteFactory.novoJFileChooser();
                    file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
                    if (file.showOpenDialog(Usuario.this) == 0) {
                        if (Usuario.this.imagemAssinaWeb == null) {
                            Usuario.this.imagemAssinaWeb = new ImageIcon();
                        }
                        Usuario.this.imagemAssinaWeb.setImage(Toolkit.getDefaultToolkit().getImage(file.getSelectedFile().getAbsolutePath()));
                        Usuario.this.labelVAssinaWeb.setIcon(Usuario.this.imagemAssinaWeb);
                        Usuario.this.labelVAssinaWeb.setText("");
                        Usuario.this.labelVAssinaWeb.setBorder(null);
                    }
                }
            }
        });
        this.menuFoto.setName("menuFoto");
        this.menuFoto.add(this.menuAlteraFoto);
        this.menuAlteraFoto.setName("menuAlteraFoto");
        this.menuFoto.add(this.menuRemoveFoto);
        this.menuRemoveFoto.setName("menuRemoveFoto");
        this.menuAlteraFoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser file = ComponenteFactory.novoJFileChooser();
                file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
                if (file.showOpenDialog(Usuario.this) == 0) {
                    if (Usuario.this.fotoUsuario == null) {
                        Usuario.this.fotoUsuario = new ImageIcon();
                    }
                    Usuario.this.fotoUsuario.setImage(Toolkit.getDefaultToolkit().getImage(file.getSelectedFile().getAbsolutePath()));
                    if (Usuario.this.fotoUsuario.getIconWidth() > Usuario.this.labelFoto.getWidth() || Usuario.this.fotoUsuario.getIconHeight() > Usuario.this.labelFoto.getHeight()) {
                        VisualizarFoto v = VisualizarFoto.novaInstancia(Usuario.this.getTopLevelAncestor());
                        v.setFoto(Usuario.this.fotoUsuario.getImage());
                        v.setVisible(true);
                        if (v.isOK()) {
                            Usuario.this.fotoUsuario = v.getImageIcon();
                        } else {
                            Funcoes.mensagem(Usuario.this, "Redimensione a imagem antes de adicionar ao usu\u00e1rio", 1);
                            Usuario.this.fotoUsuario = null;
                        }
                    }
                    if (Usuario.this.fotoUsuario != null) {
                        Usuario.this.labelFoto.setIcon(Usuario.this.fotoUsuario);
                        Usuario.this.labelFoto.setBorder(null);
                        Usuario.this.labelFoto.setText("");
                    }
                }
            }
        });
        this.menuRemoveFoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Usuario.this.labelFoto.setText("<html><div align=center>Clique para <br>adicionar <br>imagem</div></html>");
                Usuario.this.labelFoto.setIcon(null);
                Usuario.this.labelFoto.setBorder(new TitledBorder(""));
                Usuario.this.fotoUsuario = null;
            }
        });
        this.labelFoto.setName("labelFoto");
        this.labelFoto.setBounds(new Rectangle(495, 7, 130, 150));
        this.labelFoto.setToolTipText("<html>Clique sobre o texto/imagem para alterar a imagem <br>ou clique com o bot\u00e3o direito do mouse<br> sobre o texto/imagem para ver um menu de op\u00e7\u00f5es</html>");
        this.labelFoto.setHorizontalAlignment(0);
        this.labelFoto.setText("<html><div align=center>Clique para <br>adicionar <br>imagem</div></html>");
        this.labelFoto.setBorder(new TitledBorder(""));
        this.labelFoto.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((Usuario.this.getStatus() == 2 || Usuario.this.getStatus() == 3) && e.getButton() == 3) {
                    Usuario.this.menuFoto.show(Usuario.this.labelFoto, e.getX(), e.getY());
                } else if (Usuario.this.getStatus() == 2 || Usuario.this.getStatus() == 3) {
                    JFileChooser file = ComponenteFactory.novoJFileChooser();
                    file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
                    if (file.showOpenDialog(Usuario.this) == 0) {
                        if (Usuario.this.fotoUsuario == null) {
                            Usuario.this.fotoUsuario = new ImageIcon();
                        }
                        Usuario.this.fotoUsuario.setImage(Toolkit.getDefaultToolkit().getImage(file.getSelectedFile().getAbsolutePath()));
                        if (Usuario.this.fotoUsuario.getIconWidth() > Usuario.this.labelFoto.getWidth() || Usuario.this.fotoUsuario.getIconHeight() > Usuario.this.labelFoto.getHeight()) {
                            VisualizarFoto v = VisualizarFoto.novaInstancia(Usuario.this.getTopLevelAncestor());
                            v.setFoto(Usuario.this.fotoUsuario.getImage());
                            v.setVisible(true);
                            if (v.isOK()) {
                                Usuario.this.fotoUsuario = v.getImageIcon();
                            } else {
                                Funcoes.mensagem(Usuario.this, "Redimensione a imagem antes de adicionar ao usu\u00e1rio", 1);
                                Usuario.this.fotoUsuario = null;
                            }
                        }
                        if (Usuario.this.fotoUsuario != null) {
                            Usuario.this.labelFoto.setIcon(Usuario.this.fotoUsuario);
                            Usuario.this.labelFoto.setBorder(null);
                            Usuario.this.labelFoto.setText("");
                        }
                    }
                }
            }
        });
        this.buttonAcesso.setName("buttonAcesso");
        this.buttonAcesso.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Usuario.this.menu.show(Usuario.this.painelCentral, Usuario.this.buttonAcesso.getX(), Usuario.this.buttonAcesso.getY() + Usuario.this.buttonAcesso.getHeight());
            }
        });
        this.menuNovo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean apenasAlimentos = false;
                Statement st = Conexao.getStatement();
                try {
                    apenasAlimentos = DBUtil.temApenasBaseAlimentos(st);
                }
                catch (Exception e2) {
                    try {
                        ErrorLogger.mostraMensagem(Usuario.this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel buscar a configura\u00e7\u00e3o de base de dados", e2.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                Conexao.fecharStatement(st);
                DefAcesso da = new DefAcesso((Frame)Usuario.this.getTopLevelAncestor(), "Definindo acessos para " + Usuario.this.txtNome.getText(), apenasAlimentos);
                da.setListaAcesso(Usuario.this.listaModulos);
                da.setVisible(true);
                if (da.isOK()) {
                    Usuario.this.listaModulos.clear();
                    da.getListaAcessosSelecionados(Usuario.this.listaModulos);
                    Usuario.this.isDesmarcarTodos = da.getDesmarcarTodos();
                }
            }
        });
        this.menuCopia.setName("menuCopia");
        this.menuCopia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable resultado = Pesquisas.usuario((Frame)Usuario.this.getTopLevelAncestor(), false);
                String codigo = "";
                if (resultado != null) {
                    codigo = StringUtil.textoDB(resultado.get("usr_codigo").toString());
                }
                if (!Funcoes.textoVazio(codigo)) {
                    Usuario.this.listaModulos.clear();
                    Usuario.this.carregaAcessosUsuario(codigo, new HashSet[]{Usuario.this.listaModulos});
                }
            }
        });
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.jLabel4, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtNome, null);
        this.painelCentral.add((Component)this.txtSenha, null);
        this.painelCentral.add((Component)this.txtSenha2, null);
        this.painelCentral.add((Component)this.jLabel7, null);
        this.painelCentral.add((Component)this.txtCodTipo, null);
        this.painelCentral.add((Component)this.txtDescTipo, null);
        this.painelCentral.add((Component)this.jButton1, null);
        this.painelCentral.add((Component)this.buttonAcesso, null);
        this.painelCentral.add((Component)this.labelFoto, null);
        this.painelCentral.add(this.labelColetor);
        this.painelCentral.add(this.txtColetor);
        this.painelCentral.add(this.labelFilial);
        this.painelCentral.add(this.comboFilial);
        this.painelCentral.add(this.checkSenha);
        this.painelCentral.add(this.checkWeb);
        this.painelCentral.add(this.checkInativo);
        this.painelCentral.add(this.buttonFiliais);
        this.painelCentral.add(this.panelAssinaturas);
        this.painelCentral.add(this.panelEstoque);
        this.buttonFiliais.setVisible(this.mudarFiliais);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Usuario.this.buscaTipo();
            }
        });
        this.txtCodTipo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (!Funcoes.textoVazio(Usuario.this.txtCodTipo.getText()) && !e.isTemporary() && (st = Conexao.getStatement()) != null) {
                    try {
                        StringBuilder buf = new StringBuilder();
                        buf.append(" select tpu_descricao ");
                        buf.append("   from tipousuario ");
                        buf.append("  where tpu_codigo = ").append(Usuario.this.txtCodTipo.getText());
                        buf.append(" and tpu_inativo = false ");
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        if (rs.next()) {
                            Usuario.this.txtDescTipo.setText(rs.getString("tpu_descricao"));
                        } else {
                            Usuario.this.txtDescTipo.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Usuario.this, "N\u00e3o foi poss\u00edvel carregar os acessos do usu\u00e1rio.\n" + sqlex.getMessage(), sqlex.getStackTrace());
                        Usuario.this.setStatus(1);
                        Usuario.this.controlaCampos();
                    }
                }
            }
        });
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Usuario.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuilder buf = new StringBuilder("select a.usr_codigo, a.usr_nome, a.usr_senha, a.usr_assinatura, ");
                            buf.append("a.tpu_codigo, b.tpu_descricao, a.usr_foto, a.usr_codcoletor, a.usr_alterasenha, a.fil_codigo, ");
                            buf.append("a.usr_inativo, a.usr_assinaturaweb, a.usr_datainativo, a.usr_digital, a.usr_mensagemweb ");
                            buf.append(", a.usr_certificado, a.usr_senhacertificado, a.usr_validadecertificado, a.usr_dataultimasenha, a.usr_textoassinaturadigital ");
                            buf.append(" from usuario a ");
                            buf.append("left join tipousuario b on a.tpu_codigo = b.tpu_codigo ");
                            buf.append("where upper(a.usr_codigo)=upper('");
                            buf.append(Usuario.this.txtCodigo.getTextDB().trim());
                            buf.append("')");
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs != null && rs.next()) {
                                Usuario.this.codigoUsuario = rs.getString("usr_codigo");
                                Usuario.this.txtNome.setText(rs.getString("usr_nome"));
                                Usuario.this.txtSenha.setText(rs.getString("usr_senha"));
                                Usuario.this.txtSenha2.setText(rs.getString("usr_senha"));
                                Usuario.this.senhaAnterior = rs.getString("usr_senha");
                                Usuario.this.txtCodTipo.setText(rs.getString("tpu_codigo"));
                                Usuario.this.textPersonalizacaoAssinaturaDigital.setText(rs.getString("usr_textoassinaturadigital"));
                                StringBuilder buffer = new StringBuilder();
                                Statement sTipo = Conexao.getStatement();
                                buffer.append(" select tpu_descricao ");
                                buffer.append("   from tipousuario ");
                                buffer.append("  where tpu_codigo = ").append(rs.getString("tpu_codigo"));
                                buffer.append(" and tpu_inativo = false ");
                                ResultSet rsTipo = Conexao.executeQuery(sTipo, buffer.toString());
                                if (rsTipo.next()) {
                                    Usuario.this.txtDescTipo.setText(rs.getString("tpu_descricao"));
                                } else {
                                    Usuario.this.txtDescTipo.setText("N\u00e3o cadastrado");
                                }
                                Conexao.fecharStatement(sTipo);
                                Usuario.this.txtColetor.setText(rs.getString("usr_codcoletor"));
                                Usuario.this.checkSenha.setSelected(rs.getBoolean("usr_alterasenha"));
                                Usuario.this.checkWeb.setSelected(rs.getBoolean("usr_mensagemweb"));
                                Usuario.this.checkInativo.setSelected(rs.getBoolean("usr_inativo"));
                                Usuario.this.usuarioInativo = Usuario.this.checkInativo.isSelected();
                                Date dataInativo = rs.getDate("usr_datainativo");
                                Timestamp aux = rs.getTimestamp("usr_dataultimasenha");
                                if (aux != null) {
                                    Usuario.this.dataUltimaSenha = new java.util.Date(aux.getTime());
                                }
                                int filial = -1;
                                if (!DBUtil.campoNull(rs.getString("fil_codigo"))) {
                                    filial = rs.getInt("fil_codigo");
                                }
                                for (int i = 0; i < Usuario.this.comboFilial.getItemCount(); ++i) {
                                    if (((Filial)Usuario.this.comboFilial.getItemAt(i)).getCodigo() != filial) continue;
                                    Usuario.this.comboFilial.setSelectedIndex(i);
                                    break;
                                }
                                if (rs.getString("usr_assinatura") != null && !Funcoes.textoVazio(rs.getString("usr_assinatura"))) {
                                    if (Usuario.this.imagemAssinatura != null) {
                                        Usuario.this.imagemAssinatura = null;
                                    }
                                    String imagem64 = rs.getString("usr_assinatura");
                                    try {
                                        Usuario.this.imagemAssinatura = new ImageIcon(new Base64().decode(imagem64));
                                        Usuario.this.labelVAssinatura.setIcon(Usuario.this.imagemAssinatura);
                                        Usuario.this.labelVAssinatura.setBorder(null);
                                        Usuario.this.labelVAssinatura.setText("");
                                    }
                                    catch (Exception ex) {
                                        ErrorLogger.mostraMensagem(Usuario.this, ex.getMessage(), ex.getStackTrace(), "Usuario: 588");
                                    }
                                }
                                if (rs.getString("usr_assinaturaweb") != null && !Funcoes.textoVazio(rs.getString("usr_assinaturaweb"))) {
                                    if (Usuario.this.imagemAssinaWeb != null) {
                                        Usuario.this.imagemAssinaWeb = null;
                                    }
                                    String imagem64 = rs.getString("usr_assinaturaweb");
                                    try {
                                        Usuario.this.imagemAssinaWeb = new ImageIcon(new Base64().decode(imagem64));
                                        Usuario.this.labelVAssinaWeb.setIcon(Usuario.this.imagemAssinaWeb);
                                        Usuario.this.labelVAssinaWeb.setBorder(null);
                                        Usuario.this.labelVAssinaWeb.setText("");
                                    }
                                    catch (Exception ex) {
                                        ErrorLogger.mostraMensagem(Usuario.this, ex.getMessage(), ex.getStackTrace(), "Usuario: 601");
                                    }
                                }
                                if (rs.getString("usr_foto") != null && !Funcoes.textoVazio(rs.getString("usr_foto"))) {
                                    if (Usuario.this.fotoUsuario != null) {
                                        Usuario.this.fotoUsuario = null;
                                    }
                                    String foto64 = rs.getString("usr_foto");
                                    try {
                                        Usuario.this.fotoUsuario = new ImageIcon(new Base64().decode(foto64));
                                        Usuario.this.labelFoto.setIcon(Usuario.this.fotoUsuario);
                                        Usuario.this.labelFoto.setBorder(null);
                                        Usuario.this.labelFoto.setText("");
                                    }
                                    catch (Exception ex) {
                                        ErrorLogger.mostraMensagem(Usuario.this, ex.getMessage(), ex.getStackTrace(), "Usuario");
                                    }
                                }
                                if (rs.getString("usr_certificado") != null && !Funcoes.textoVazio(rs.getString("usr_certificado"))) {
                                    try {
                                        Base64 base64e = new Base64();
                                        Usuario.this.certificado = CertificadoDigital.novaInstancia(Usuario.this.getTopLevelAncestor(), Base64.decodeBase64((String)rs.getString("usr_certificado")), rs.getString("usr_senhacertificado"), rs.getDate("usr_validadecertificado"), true);
                                    }
                                    catch (Exception e1) {
                                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os certificado digital do usu\u00e1rio.\n" + e1.getMessage(), e1.getStackTrace());
                                    }
                                } else {
                                    Usuario.this.certificado = CertificadoDigital.novaInstancia(Usuario.this.getTopLevelAncestor());
                                }
                                if (rs.getString("usr_digital") != null && !Funcoes.textoVazio(rs.getString("usr_digital"))) {
                                    Usuario.this.labelFoto.setImpressaoDigital(rs.getString("usr_digital"));
                                }
                                if (Usuario.this.getStatus() == 2) {
                                    Usuario.this.setStatus(3);
                                }
                                Usuario.this.txtCodigo.setEnabled(false);
                                Usuario.this.listaModulos.clear();
                                Usuario.this.listaModulosOriginais.clear();
                                Usuario.this.carregaAcessosUsuario(Usuario.this.txtCodigo.getText().trim(), new HashSet[]{Usuario.this.listaModulos, Usuario.this.listaModulosOriginais});
                                Usuario.this.carregarUsuarioMaterial();
                                ResultSet rf = Conexao.executeQuery(st, "select fil_codigo from usuariofilial where upper(usr_codigo)=upper('" + Usuario.this.txtCodigo.getTextDB().trim() + "') order by fil_codigo ");
                                Usuario.this.filiaisPermitidas.clear();
                                while (rf.next()) {
                                    Usuario.this.filiaisPermitidas.add(rf.getInt("fil_codigo"));
                                }
                                if (Usuario.this.checkInativo.isSelected() && dataInativo != null) {
                                    Funcoes.mensagem(Usuario.this, "Usu\u00e1rio inativo desde " + Funcoes.formataData(dataInativo), 5);
                                }
                                Conexao.arquivaSQL();
                                Usuario.this.codigoTipoOriginal = Usuario.this.txtCodTipo.getText();
                                ScreenUtil.requisitarFoco(Usuario.this.txtNome);
                            } else if (Usuario.this.getStatus() == 3) {
                                Funcoes.mensagem(Usuario.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Usuario.this.setStatus(1);
                                Usuario.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(Usuario.this, sqlex.getMessage(), sqlex.getStackTrace(), "Usuario");
                    }
                }
            }
        });
        this.montaBotoes();
    }

    private void carregarUsuarioMaterial() {
        MaterialService materialService = new MaterialService();
        try {
            this.listaMaterialUsuarios = materialService.buscaMaterialUsuario(Variaveis.filialPadrao, this.txtCodigo.getText());
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os materiais do usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void montaPanelEstoque() {
        Dimension d = new Dimension(135, 20);
        this.buttonAvisarReposicao.setPreferredSize(d);
        this.buttonAvisarReposicao.setMinimumSize(d);
        this.buttonAvisarValidade.setPreferredSize(d);
        this.buttonAvisarValidade.setMinimumSize(d);
        this.panelEstoque.setBorder(new TitledBorder("Estoque"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.panelEstoque.add((Component)this.buttonAvisarReposicao, gbc);
        ++gbc.gridx;
        this.panelEstoque.add((Component)this.buttonAvisarValidade, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(235, 20));
        panel.setMinimumSize(new Dimension(235, 20));
        this.panelEstoque.add((Component)panel, gbc);
        this.montaListener();
    }

    private void montaListener() {
        this.buttonAvisarReposicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvisarMaterial avisar = AvisarMaterial.novaInstancia(Usuario.this.getTopLevelAncestor(), "Materiais para avisar reposi\u00e7\u00e3o", "R");
                avisar.setListaMaterialUsuarios(Usuario.this.listaMaterialUsuarios, "R");
                avisar.setVisible(true);
                List<MaterialUsuarioVO> usuarios = avisar.getListaMaterialUsuarios();
                Usuario.this.listaMaterialUsuarios.clear();
                for (MaterialUsuarioVO materialUsuario : usuarios) {
                    boolean adicionar = true;
                    materialUsuario.setCodigoUsuario(Usuario.this.txtCodigo.getText());
                    materialUsuario.setCodigoFilial(Integer.valueOf(Variaveis.filialPadrao));
                    materialUsuario.setTipoMaterialUsuario(materialUsuario.getTipoMaterialUsuario());
                    Usuario.this.listaMaterialUsuarios.add(materialUsuario);
                }
            }
        });
        this.buttonAvisarValidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvisarMaterial avisar = AvisarMaterial.novaInstancia(Usuario.this.getTopLevelAncestor(), "Materiais para avisar vencimento", "L");
                avisar.setListaMaterialUsuarios(Usuario.this.listaMaterialUsuarios, "L");
                avisar.setVisible(true);
                List<MaterialUsuarioVO> usuarios = avisar.getListaMaterialUsuarios();
                Usuario.this.listaMaterialUsuarios.clear();
                for (MaterialUsuarioVO materialUsuario : usuarios) {
                    boolean adicionar = true;
                    materialUsuario.setCodigoFilial(Integer.valueOf(Variaveis.filialPadrao));
                    materialUsuario.setTipoMaterialUsuario(materialUsuario.getTipoMaterialUsuario());
                    Usuario.this.listaMaterialUsuarios.add(materialUsuario);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregaAcessosUsuario(String codigoUsuario, HashSet<Long> ... listaAcesso) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select ass_codigo as acesso ");
        buf.append("   from usuarioacesso ");
        buf.append("  where upper(usr_codigo) = '").append(codigoUsuario.toUpperCase()).append("' ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                for (HashSet<Long> lista : listaAcesso) {
                    lista.add(rs.getLong("acesso"));
                }
            }
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os acessos do tipo de usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void carregaAcessosTipoUsuario(String codigoTipoUsuario, HashSet<Long> ... listaAcesso) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select ass_codigo as acesso ");
        buf.append("   from tipousuarioacesso ");
        buf.append("  where tpu_codigo = ").append(codigoTipoUsuario);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                for (HashSet<Long> lista : listaAcesso) {
                    lista.add(rs.getLong("acesso"));
                }
            }
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os acessos do tipo de usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Usuario.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0500500201"));
        this.setModuloEdita(Long.parseLong("0500500202"));
        this.setModuloApaga(Long.parseLong("0500500203"));
        this.buttonAcesso.setVisible(Acesso.getAcesso(this.mudarAcessos) && ParametrosGerais.getTipoControleAcesso().equals("U"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.usuarioTipo(Laboratorio.getInstancia(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("usr_codigo").toString());
            this.codigoUsuario = resultado.get("usr_codigo").toString();
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.txtCodigo.setDocument(new TTextField().criaDocument(20, 3));
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null && DBUtil.checkPK(this, statement, "usr_codigo", this.txtCodigo.getTextDB(), 0, new String[]{"paciente", "setores"})) {
                    String[] filiaisIntegracao;
                    String s = "delete from usuarioacesso where upper(usr_codigo)=upper('" + this.txtCodigo.getTextDB() + "')";
                    Conexao.execute(Variaveis.filialPadrao, statement, s, true);
                    for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(statement)) {
                        IntegracaoUtil.insereComandoLog(statement, Variaveis.filialPadrao, filial, s);
                    }
                    s = "delete from usuario where upper(usr_codigo)=upper('" + this.txtCodigo.getTextDB() + "')";
                    Conexao.execute(Variaveis.filialPadrao, statement, s, true);
                    for (String filial : filiaisIntegracao) {
                        IntegracaoUtil.insereComandoLog(statement, Variaveis.filialPadrao, filial, s);
                    }
                    Conexao.arquivaSQL();
                }
            }
            catch (SQLException sqlex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "Usuario (545)");
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Usuario (547)");
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.txtCodigo.setDocument(new TTextField().criaDocument(20, 18));
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCodigo.grabFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void salvar() {
        if (!this.validaCampos()) return;
        if (this.getStatus() == 3 && !Funcoes.textoVazio(this.codigoTipoOriginal) && !this.codigoTipoOriginal.equals(this.txtCodTipo.getText())) {
            if (Funcoes.mensagem(this, "O tipo de acesso foi modificado. Os acessos do usu\u00e1rio ser\u00e3o atualizados.\nDeseja continuar?", 4) != 0) return;
            this.listaModulos.clear();
            this.carregaAcessosTipoUsuario(this.txtCodTipo.getText(), this.listaModulos);
        } else if (this.getStatus() == 2) {
            this.carregaAcessosTipoUsuario(this.txtCodTipo.getText(), this.listaModulos);
        }
        Statement statement = Conexao.getStatement();
        if (statement == null) return;
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        try {
            FilialVO filialVO;
            boolean codigoExiste;
            String codigo = this.txtCodigo.getTextDB().trim();
            Base64 base64e = new Base64();
            String imagem64 = "";
            if (this.imagemAssinatura != null) {
                imagem64 = base64e.encodeAsString(ImagemUtils.imageToByte(this.imagemAssinatura.getImage()));
            }
            String foto64 = "";
            if (this.fotoUsuario != null) {
                foto64 = base64e.encodeAsString(ImagemUtils.imageToByte(this.fotoUsuario.getImage()));
            } else if (this.labelFoto.getFotoPaciente() != null) {
                foto64 = base64e.encodeAsString(ImagemUtils.imageToByte(this.labelFoto.getFotoPaciente().getImage()));
            }
            String imagemAssina64 = "";
            if (this.imagemAssinaWeb != null) {
                imagemAssina64 = base64e.encodeAsString(ImagemUtils.imageToByte(this.imagemAssinaWeb.getImage()));
            }
            if (ParametrosGerais.getUpperCase() && this.getStatus() == 3) {
                codigo = new UsuarioService().buscaCodigo(codigo).getCodigo();
            }
            if (!Funcoes.textoVazio(this.txtColetor) && (codigoExiste = new UsuarioService().verificaCodigoColetadorUsuario(codigo, StringUtil.converteArrayCharString(this.txtColetor.getPassword())))) {
                Funcoes.mensagem(this, "O c\u00f3digo de coletor informado j\u00e1 existe.\nInforme outro c\u00f3digo de coletador.", 2);
                ScreenUtil.requisitarFoco(this.txtColetor);
                return;
            }
            splash.mostrar("Aguarde.");
            String[] filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(statement);
            String textCertificado = "null";
            String certificadoValidade = "null";
            String certificadoSenha = "null";
            if (null != this.certificado) {
                textCertificado = this.certificado.getCertificado() != null ? StringUtil.textoDBEscape(base64e.encodeAsString(this.certificado.getCertificado())) : "null";
                certificadoValidade = this.certificado.getDateValidade() != null ? StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", this.certificado.getDateValidade())) : "null";
                certificadoSenha = this.certificado.getTextSenhaCertificado() != null ? StringUtil.textoDBEscape(this.certificado.getTextSenhaCertificado().getText()) : "null";
            }
            UsuarioVO usuarioVO = new UsuarioVO();
            UsuarioService usuarioService = new UsuarioService();
            boolean adicionarInformacoesCertificado = false;
            boolean adicionarDataInativo = false;
            boolean alterarDataMudancaSenha = false;
            if (this.getStatus() == 2) {
                adicionarInformacoesCertificado = null != this.certificado && this.certificado.getOK();
                usuarioVO.setCodigo(this.txtCodigo.getTextDB());
                usuarioVO.setNome(this.txtNome.getTextDB());
                usuarioVO.setSenha(String.valueOf(this.txtSenha.getPassword()));
                usuarioVO.setTpuCodigo(this.txtCodTipo.getText());
                usuarioVO.setTextoAssinaturaDigital(this.textPersonalizacaoAssinaturaDigital.getText());
                usuarioVO.setAssinatura(imagem64);
                usuarioVO.setFoto(foto64);
                usuarioVO.setCodColetor(String.valueOf(this.txtColetor.getPassword()));
                filialVO = new FilialVO();
                filialVO.setCodigo(((Filial)this.comboFilial.getSelectedItem()).getCodigo());
                usuarioVO.setFilial(filialVO);
                usuarioVO.setAlteraSenha(this.checkSenha.isSelected());
                usuarioVO.setMensagemWeb(this.checkWeb.isSelected());
                usuarioVO.setInativo(false);
                usuarioVO.setAssinaturaWeb(imagemAssina64);
                usuarioVO.setDigital(this.impressaoDigital);
                if (adicionarInformacoesCertificado) {
                    usuarioVO.setCertificado(textCertificado);
                    usuarioVO.setSenhaCertificado(certificadoSenha);
                    usuarioVO.setValidadeCertificado(this.certificado.getDateValidade());
                }
                usuarioService.inserirUsuario(usuarioVO, "usuario", Variaveis.filialPadrao);
            } else if (this.getStatus() == 3) {
                adicionarDataInativo = this.checkInativo.isSelected() && !this.usuarioInativo;
                adicionarInformacoesCertificado = this.certificado.getOK();
                alterarDataMudancaSenha = this.alterado;
                usuarioVO.setCodigo(this.codigoUsuario);
                usuarioVO.setNome(this.txtNome.getTextDB());
                usuarioVO.setSenha(String.valueOf(this.txtSenha.getPassword()));
                usuarioVO.setTpuCodigo(this.txtCodTipo.getText());
                usuarioVO.setAssinatura(imagem64);
                usuarioVO.setFoto(foto64);
                usuarioVO.setTextoAssinaturaDigital(this.textPersonalizacaoAssinaturaDigital.getText());
                usuarioVO.setAssinaturaWeb(imagemAssina64);
                usuarioVO.setCodColetor(String.copyValueOf(this.txtColetor.getPassword()));
                filialVO = new FilialVO();
                filialVO.setCodigo(((Filial)this.comboFilial.getSelectedItem()).getCodigo());
                usuarioVO.setFilial(filialVO);
                usuarioVO.setAlteraSenha(this.checkSenha.isSelected());
                usuarioVO.setMensagemWeb(this.checkWeb.isSelected());
                usuarioVO.setInativo(this.checkInativo.isSelected());
                usuarioVO.setDigital(this.labelFoto.getImpressaoDigital());
                if (adicionarDataInativo) {
                    usuarioVO.setDataInativo(new java.util.Date());
                }
                if (adicionarInformacoesCertificado) {
                    usuarioVO.setCertificado(textCertificado);
                    usuarioVO.setSenhaCertificado(certificadoSenha);
                    usuarioVO.setValidadeCertificado(this.certificado.getDateValidade());
                }
                if (alterarDataMudancaSenha) {
                    usuarioVO.setDataUltimaSenha(new Timestamp(0L));
                }
                usuarioService.atualizarUsuario(usuarioVO, Variaveis.filialPadrao);
            }
            UsuarioSenhasVO usuarioSenhasVO = new UsuarioSenhasVO();
            usuarioSenhasVO.setUsrCodigo(usuarioVO.getCodigo());
            usuarioSenhasVO.setUsnSenha(usuarioVO.getSenha());
            UsuarioSenhasService usuarioSenhasService = new UsuarioSenhasService();
            usuarioSenhasService.inserir(usuarioSenhasVO, usuarioVO, Variaveis.filialPadrao);
            if (this.isDesmarcarTodos) {
                this.removeTodosAcessosUsuario(statement, filiaisIntegracao, codigo);
                for (Long acesso : this.listaModulos) {
                    this.adicionaAcessoUsuario(statement, filiaisIntegracao, codigo, acesso);
                }
            } else {
                for (Long acesso : this.listaModulosOriginais) {
                    if (this.listaModulos.contains(acesso)) continue;
                    this.removeAcessoUsuario(statement, filiaisIntegracao, codigo, acesso);
                }
                for (Long acesso : this.listaModulos) {
                    if (this.listaModulosOriginais.contains(acesso)) continue;
                    this.adicionaAcessoUsuario(statement, filiaisIntegracao, codigo, acesso);
                }
            }
            this.adicionarMateriaUsuario();
            UsuarioFilialVO usuarioFilialVO = new UsuarioFilialVO();
            usuarioFilialVO.setUsrCodigo(codigo);
            UsuarioFilialService usuarioFilialService = new UsuarioFilialService();
            usuarioFilialService.deletarAcessos(usuarioFilialVO, Variaveis.filialPadrao);
            if (this.filiaisPermitidas.size() > 0) {
                for (int i = 0; i < this.filiaisPermitidas.size(); ++i) {
                    usuarioFilialVO.setUsrCodigo(codigo);
                    usuarioFilialVO.setFilCodigo(this.filiaisPermitidas.get(i));
                    usuarioFilialService.inserirAcessos(usuarioFilialVO, Variaveis.filialPadrao);
                }
            }
            this.retornoParaPesquisa = codigo;
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Usuario (687)");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            splash.apagar();
        }
        this.limparCampos();
        this.setStatus(1);
        this.controlaCampos();
    }

    private void adicionarMateriaUsuario() throws SQLException {
        MaterialService service = new MaterialService();
        this.removerUsuarios(service);
        for (MaterialUsuarioVO materialUsuarioVO : this.listaMaterialUsuarios) {
            materialUsuarioVO.setCodigoUsuario(this.txtCodigo.getText());
            service.inserirMaterialUsuario(materialUsuarioVO);
        }
    }

    private void removerUsuarios(MaterialService service) throws NumberFormatException, SQLException {
        service.removeUsuarios(this.listaMaterialUsuarios, new MaterialUsuarioVO(Integer.valueOf(Variaveis.filialPadrao), this.txtCodigo.getText()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> buscaSenhasAnterioresUsuario(String usuario, int quantidadeSenhas) {
        StringBuilder bui = new StringBuilder();
        bui.append("select usn_senha from usuariosenhas ");
        bui.append(" where usr_codigo = '").append(usuario).append("'");
        bui.append(" order by usn_codigo desc ");
        bui.append(" limit ").append(quantidadeSenhas);
        Statement st = Conexao.getStatement();
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            while (rs.next()) {
                this.senhasAnteriores.add(rs.getString("usn_senha"));
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as senhas do usu\u00e1rio", e.getStackTrace());
        }
        return this.senhasAnteriores;
    }

    private void adicionaAcessoUsuario(Statement st, String[] filiaisIntegracao, String codigoUsuario, Long acesso) throws SQLException {
        this.prstInsereAcessoUsuario.setString(1, codigoUsuario);
        this.prstInsereAcessoUsuario.setLong(2, acesso);
        this.prstInsereAcessoUsuario.executeUpdate();
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into usuarioacesso ");
        buf.append(" (usr_codigo, ass_codigo) ");
        buf.append(" values ('").append(codigoUsuario).append("',").append(acesso).append(") ");
        for (String filial : filiaisIntegracao) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    private void removeAcessoUsuario(Statement st, String[] filiaisIntegracao, String codigoUsuario, Long acesso) throws SQLException {
        this.prstRemoveAcessoUsuario.setString(1, codigoUsuario);
        this.prstRemoveAcessoUsuario.setLong(2, acesso);
        this.prstRemoveAcessoUsuario.executeUpdate();
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from usuarioacesso ");
        buf.append(" where usr_codigo = '").append(codigoUsuario).append("' ");
        buf.append("   and ass_codigo = ").append(acesso);
        for (String filial : filiaisIntegracao) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    private void removeTodosAcessosUsuario(Statement st, String[] filiaisIntegracao, String codigoUsuario) throws SQLException {
        this.prstRemoveTodosAcessosUsuario.setString(1, codigoUsuario);
        this.prstRemoveTodosAcessosUsuario.executeUpdate();
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from usuarioacesso ");
        buf.append(" where usr_codigo = '").append(codigoUsuario).append("' ");
        for (String filial : filiaisIntegracao) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    private void controlaCampos() {
        boolean enabled = !this.isExecutando && (this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodigo.setEnabled(enabled);
        this.txtNome.setEnabled(enabled);
        this.txtSenha.setEnabled(enabled);
        this.txtSenha2.setEnabled(enabled);
        this.txtCodTipo.setEnabled(enabled);
        this.jButton1.setEnabled(enabled);
        this.buttonAvisarReposicao.setEnabled(enabled);
        this.buttonAvisarValidade.setEnabled(enabled);
        this.labelVAssinatura.setEnabled(enabled);
        this.labelVAssinaWeb.setEnabled(enabled);
        this.buttonAcesso.setEnabled(enabled);
        this.labelFoto.setEnabled(enabled);
        this.txtColetor.setEnabled(enabled);
        this.comboFilial.setEnabled(enabled);
        this.checkSenha.setEnabled(enabled);
        this.checkWeb.setEnabled(enabled);
        this.checkInativo.setVisible(!this.isExecutando && this.getStatus() == 3);
        this.checkInativo.setEnabled(!this.isExecutando && this.getStatus() == 3);
        this.buttonFiliais.setEnabled(enabled);
        this.labelFoto.controlaCampos(enabled);
        this.buttonCertificado.setEnabled(enabled);
        this.textPersonalizacaoAssinaturaDigital.setEnabled(enabled);
        if (this.isExecutando) {
            this.botaoNovo.setEnabled(false);
            this.botaoEditar.setEnabled(false);
            this.botaoSalvar.setEnabled(false);
            this.botaoExcluir.setEnabled(false);
            this.botaoCancelar.setEnabled(false);
            this.botaoFechar.setEnabled(false);
        } else {
            this.habilitaBotoes();
        }
    }

    private void limparCampos() {
        this.codigoUsuario = "";
        this.txtCodigo.setText("");
        this.txtNome.setText("");
        this.txtSenha.setText("");
        this.txtSenha2.setText("");
        this.txtCodTipo.setText("");
        this.txtColetor.setText("");
        this.txtDescTipo.setText("");
        this.checkSenha.setSelected(false);
        this.checkWeb.setSelected(false);
        if (this.comboFilial.getItemCount() > 0) {
            this.comboFilial.setSelectedIndex(0);
        }
        this.listaModulos.clear();
        this.labelVAssinatura.setIcon(null);
        this.labelVAssinatura.setText("Clique para adicionar imagem");
        this.labelVAssinatura.setBorder(new TitledBorder(""));
        this.labelVAssinaWeb.setIcon(null);
        this.labelVAssinaWeb.setText("Clique para adicionar imagem");
        this.labelVAssinaWeb.setBorder(new TitledBorder(""));
        this.labelFoto.setIcon(null);
        this.labelFoto.setText("<html><div align=center>Clique para <br>adicionar <br>imagem</div></html>");
        this.labelFoto.setBorder(new TitledBorder(""));
        this.fotoUsuario = null;
        this.labelFoto.setFotoPaciente(null);
        this.imagemAssinatura = null;
        this.imagemAssinaWeb = null;
        this.checkInativo.setSelected(false);
        this.usuarioInativo = false;
        this.filiaisPermitidas.clear();
        this.impressaoDigital = null;
        this.isDesmarcarTodos = false;
        this.isEditandoRegistro = false;
        this.alterado = false;
        this.certificado = null;
        this.listaModulosOriginais.clear();
        this.listaModulos.clear();
        this.textPersonalizacaoAssinaturaDigital.setText("");
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validaCampos() {
        block22: {
            String usuario;
            if (this.getStatus() == 2) {
                Statement st = Conexao.getStatement();
                try (ResultSet rs = null;){
                    rs = Conexao.executeQuery(st, "select usr_codigo from usuario where upper(usr_codigo)=upper('" + this.txtCodigo.getTextDB().trim() + "')");
                    if (rs != null && !DBUtil.resultIsEmpty(rs)) {
                        Funcoes.mensagem(this, "Usu\u00e1rio j\u00e1 cadastrado", 1);
                        this.txtCodigo.grabFocus();
                        boolean bl = false;
                        return bl;
                    }
                    break block22;
                }
                catch (SQLException sqlex) {
                    Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + sqlex.getMessage(), 1);
                    this.txtCodigo.grabFocus();
                    return false;
                }
            }
            if (this.getStatus() == 2 && !(usuario = this.txtCodigo.getText()).matches("[a-zA-z0-9_ .]*")) {
                Funcoes.mensagem(this, "Caracteres inv\u00e1lidos no c\u00f3digo do usu\u00e1rio", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (Funcoes.textoVazio(this.txtCodigo.getText())) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtNome.getText())) {
            Funcoes.mensagem(this, "Campo nome n\u00e3o informado", 1);
            this.txtNome.selectAll();
            this.txtNome.grabFocus();
            return false;
        }
        if (this.txtSenha.getPassword().length == 0 || Funcoes.textoVazio(String.valueOf(this.txtSenha.getPassword()))) {
            Funcoes.mensagem(this, "Campo senha n\u00e3o informado", 1);
            this.txtSenha.selectAll();
            this.txtSenha.grabFocus();
            return false;
        }
        if (this.txtSenha.getPassword().length > 0 && !String.valueOf(this.txtSenha.getPassword()).equals(String.valueOf(this.txtSenha2.getPassword()))) {
            Funcoes.mensagem(this, "Senha incorreta", 1);
            this.txtSenha.selectAll();
            this.txtSenha.grabFocus();
            return false;
        }
        if (this.alterado && ParametrosGerais.getValidarSenhasRepitidas() > 0) {
            this.senhasAnteriores = this.buscaSenhasAnterioresUsuario(this.txtCodigo.getTextDB().trim(), ParametrosGerais.getValidarSenhasRepitidas());
            if (null != this.senhasAnteriores && this.senhasAnteriores.size() > 0) {
                for (String senhaRepitida : this.senhasAnteriores) {
                    if (!String.valueOf(this.txtSenha.getPassword()).equals(senhaRepitida)) continue;
                    Funcoes.mensagem(this, "Senha j\u00e1 utilizada. Digite novamente.", 2);
                    this.txtSenha.selectAll();
                    this.txtSenha.grabFocus();
                    return false;
                }
            }
        }
        if (this.alterado && ParametrosGerais.getValidarSenhasRepitidas() <= 0 && String.valueOf(this.txtSenha.getPassword()).equals(String.valueOf(this.senhasAnteriores))) {
            Funcoes.mensagem(this, "Senha j\u00e1 utilizada. Digite novamente.", 2);
            this.txtSenha.selectAll();
            this.txtSenha.grabFocus();
            return false;
        }
        if (!this.alterado && ParametrosGerais.getPrazoValidadeSenha() > 0 && !Funcoes.validaPrazoSenha(this.dataUltimaSenha)) {
            Funcoes.mensagem(this, "Sua senha expirou, favor cadastrar uma nova senha.", 2);
            this.txtSenha.selectAll();
            this.txtSenha.grabFocus();
            return false;
        }
        if (!Funcoes.validaComplexidadeSenha(String.valueOf(this.txtSenha.getPassword()))) {
            this.txtSenha.selectAll();
            this.txtSenha.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodTipo.getText())) {
            Funcoes.mensagem(this, "Campo tipo n\u00e3o informado", 1);
            this.txtCodTipo.grabFocus();
            return false;
        }
        if (this.txtCodTipo.getText().trim().length() > 0 && this.txtDescTipo.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Tipo n\u00e3o localizado", 1);
            this.txtCodTipo.selectAll();
            this.txtCodTipo.grabFocus();
            return false;
        }
        if (this.txtCodigo.getText().indexOf(",") > 0) {
            Funcoes.mensagem(this, "Caracteres n\u00e3o permitidos no c\u00f3digo", 1);
            this.txtCodigo.selectAll();
            this.txtCodigo.grabFocus();
            return false;
        }
        if (!Variaveis.login.equalsIgnoreCase(this.txtCodigo.getText())) return true;
        if (this.filiaisPermitidas.size() <= 0) return true;
        if (this.filiaisPermitidas.contains(((Filial)this.comboFilial.getSelectedItem()).getCodigo())) return true;
        Funcoes.mensagem(this, "A filial padr\u00e3o n\u00e3o \u00e9 permitida para o usu\u00e1rio", 1);
        this.comboFilial.grabFocus();
        return false;
    }

    private void buscaTipo() {
        Hashtable resultado = Pesquisas.tipoUsuario(Laboratorio.getInstancia(), true);
        if (resultado != null) {
            this.txtCodTipo.setText(resultado.get("tpu_codigo").toString());
        }
        this.txtCodTipo.requestFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodTipo.hasFocus()) {
            this.buscaTipo();
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0500500200");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFiliais) {
            this.configurarFiliais();
        } else if (e.getSource() == this.buttonCertificado) {
            this.configurarCertificadoDigital();
        }
    }

    private void configurarCertificadoDigital() {
        if (this.getStatus() == 2) {
            this.certificado = CertificadoDigital.novaInstancia(this.getTopLevelAncestor());
        }
        if (null != this.certificado) {
            this.certificado.setVisible(true);
        }
    }

    private void configurarFiliais() {
        FiliaisPermitidas f = FiliaisPermitidas.novaInstancia(this.getTopLevelAncestor());
        if (f != null) {
            f.setFiliais(this.filiaisPermitidas);
            f.setVisible(true);
            if (f.isOK()) {
                this.filiaisPermitidas = f.getFiliais();
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "usr_codigo";
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isExecutando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isExecutando = false;
        this.controlaCampos();
    }
}

