/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.configuracao.DefAcesso;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TipoUsuario
extends FrmCadPadrao
implements ThreadFinalizadaListener {
    private JLabel jLabel1 = new JLabel("C\u00f3digo:");
    private TTextField txtCodigo = new TTextField(5, 1);
    private TTextField txtDescricao = new TTextField(100);
    private JLabel jLabel2 = new JLabel("Descri\u00e7\u00e3o:");
    private JButton buttonAcesso = new JButton("Acessos \u25bc");
    private JPopupMenu menu = new JPopupMenu();
    private JMenuItem menuNovo = new JMenuItem("Novo/Alterar");
    private JMenuItem menuCopia = new JMenuItem("Copiar acessos");
    private HashSet<Long> listaModulos = new HashSet();
    private HashSet<Long> listaModulosOriginais = new HashSet();
    private JCheckBox checkInativo = new JCheckBox("Inativo");
    private boolean tipoUsuarioInativo = false;
    private final long mudarAcessos = Long.parseLong("0500500104");
    private String retornoParaPesquisa = "";
    private boolean isExecutando = false;
    private boolean isDesmarcarTodos = false;
    PreparedStatement prstInsereAcessoTipoUsuario = null;
    PreparedStatement prstRemoveAcessoTipoUsuario = null;
    PreparedStatement prstRemoveTodosAcessosTipoUsuario = null;
    PreparedStatement prstInsereAcessoUsuario = null;
    PreparedStatement prstRemoveAcessoUsuario = null;
    PreparedStatement prstRemoveTodosAcessosUsuario = null;

    public TipoUsuario() {
        try {
            this.jbInit();
            StringBuilder buf = new StringBuilder();
            buf.append(" insert into tipousuarioacesso ");
            buf.append(" (tpu_codigo, ass_codigo) ");
            buf.append(" values (?, ?) ");
            this.prstInsereAcessoTipoUsuario = Conexao.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" delete from tipousuarioacesso ");
            buf.append(" where tpu_codigo = ? ");
            buf.append("   and ass_codigo = ? ");
            this.prstRemoveAcessoTipoUsuario = Conexao.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" delete from tipousuarioacesso ");
            buf.append(" where tpu_codigo = ? ");
            this.prstRemoveTodosAcessosTipoUsuario = Conexao.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" insert into usuarioacesso ");
            buf.append(" (usr_codigo, ass_codigo) ");
            buf.append(" values (?, ?) ");
            this.prstInsereAcessoUsuario = Conexao.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" delete from usuarioacesso ");
            buf.append(" where usr_codigo = ? ");
            buf.append("   and ass_codigo = ? ");
            this.prstRemoveAcessoUsuario = Conexao.getPreparedStatement(buf.toString());
            buf.setLength(0);
            buf.append(" delete from usuarioacesso ");
            buf.append(" where usr_codigo = ? ");
            this.prstRemoveTodosAcessosUsuario = Conexao.getPreparedStatement(buf.toString());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "TipoUsuario (41)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("TipoUsuario");
        this.menuNovo.setName("menuNovo");
        this.menu.add(this.menuNovo);
        this.menuCopia.setName("menuCopia");
        this.menu.add(this.menuCopia);
        this.setLabelDescricao("Cadastro de tipos de usu\u00e1rio e permiss\u00f5es de acesso");
        this.setLabelFormulario("Cadastro de tipos de usu\u00e1rio");
        this.setIcone(ImagemUtils.carregaImagemJalis("configuracoes/tipo_usuario.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setName("txtCodigo");
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtDescricao.setName("txtDescricao");
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.buttonAcesso.setBounds(new Rectangle(362, 49, 110, 25));
        this.buttonAcesso.setName("buttonAcesso");
        this.buttonAcesso.setMnemonic('e');
        this.checkInativo.setBounds(69, 50, 69, 20);
        this.checkInativo.setName("checkInativo");
        this.checkInativo.setVisible(false);
        this.controlaCampos();
        this.painelCentral.add(this.checkInativo);
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.buttonAcesso, null);
        this.painelCentral.setName("painelCentral");
        this.buttonAcesso.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TipoUsuario.this.menu.show(TipoUsuario.this.painelCentral, TipoUsuario.this.buttonAcesso.getX(), TipoUsuario.this.buttonAcesso.getY() + TipoUsuario.this.buttonAcesso.getHeight());
            }
        });
        this.menuNovo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                DefAcesso da = null;
                boolean apenasAlimentos = false;
                Statement st = Conexao.getStatement();
                try {
                    apenasAlimentos = DBUtil.temApenasBaseAlimentos(st);
                }
                catch (Exception e2) {
                    try {
                        ErrorLogger.mostraMensagem(TipoUsuario.this.getTopLevelAncestor(), "Erro ao buscar a configura\u00e7\u00e3o de base de dados", e2.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                Conexao.fecharStatement(st);
                String titulo = "Definindo acessos para " + TipoUsuario.this.txtDescricao.getText();
                da = TipoUsuario.this.getTopLevelAncestor() instanceof Frame ? new DefAcesso((Frame)TipoUsuario.this.getTopLevelAncestor(), titulo, apenasAlimentos) : new DefAcesso((Dialog)TipoUsuario.this.getTopLevelAncestor(), titulo, apenasAlimentos);
                da.setListaAcesso(TipoUsuario.this.listaModulos);
                da.setVisible(true);
                if (da.isOK()) {
                    TipoUsuario.this.isDesmarcarTodos = da.getDesmarcarTodos();
                    TipoUsuario.this.listaModulos.clear();
                    da.getListaAcessosSelecionados(TipoUsuario.this.listaModulos);
                }
            }
        });
        this.menuCopia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable resultado = Pesquisas.tipoUsuario(TipoUsuario.this.getTopLevelAncestor(), false);
                String codigo = "";
                if (resultado != null) {
                    codigo = resultado.get("tpu_codigo").toString();
                }
                if (!Funcoes.textoVazio(codigo)) {
                    TipoUsuario.this.listaModulos.clear();
                    TipoUsuario.this.carregaAcessosTipoUsuario(codigo, TipoUsuario.this.listaModulos);
                }
            }
        });
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(TipoUsuario.this.txtCodigo)) {
                    Statement st;
                    block7: {
                        st = Conexao.getStatement();
                        try {
                            StringBuilder buf = new StringBuilder();
                            buf.append(" select tpu_codigo ");
                            buf.append("       ,tpu_descricao, tpu_inativo ");
                            buf.append("   from tipousuario ");
                            buf.append("  where tpu_codigo = ").append(TipoUsuario.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                TipoUsuario.this.txtDescricao.setText(rs.getString("tpu_descricao"));
                                TipoUsuario.this.txtCodigo.setEnabled(false);
                                TipoUsuario.this.checkInativo.setSelected(rs.getBoolean("tpu_inativo"));
                                TipoUsuario.this.tipoUsuarioInativo = TipoUsuario.this.checkInativo.isSelected();
                                TipoUsuario.this.checkInativo.setVisible(true);
                                TipoUsuario.this.listaModulos.clear();
                                TipoUsuario.this.listaModulosOriginais.clear();
                                TipoUsuario.this.carregaAcessosTipoUsuario(TipoUsuario.this.txtCodigo.getText().trim(), TipoUsuario.this.listaModulos, TipoUsuario.this.listaModulosOriginais);
                            } else {
                                Funcoes.mensagem(TipoUsuario.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                TipoUsuario.this.setStatus(1);
                                TipoUsuario.this.controlaCampos();
                            }
                            if (!TipoUsuario.this.checkInativo.isSelected()) break block7;
                            Funcoes.mensagem(TipoUsuario.this, "Tipo de usu\u00e1rio inativo", 5);
                        }
                        catch (SQLException sqlex) {
                            try {
                                ErrorLogger.mostraMensagem(TipoUsuario.this, sqlex.getMessage(), sqlex.getStackTrace(), "TipoUsuario");
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                        }
                    }
                    Conexao.fecharStatement(st);
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(TipoUsuario.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0500500101"));
        this.setModuloEdita(Long.parseLong("0500500102"));
        this.setModuloApaga(Long.parseLong("0500500103"));
        this.buttonAcesso.setVisible(Acesso.getAcesso(this.mudarAcessos) && ParametrosGerais.getTipoControleAcesso().equals("T"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.tipoUsuario(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (resultado == null) {
            return false;
        }
        this.txtCodigo.setText(resultado.get("tpu_codigo").toString());
        this.txtDescricao.setText(resultado.get("tpu_descricao").toString());
        ScreenUtil.requisitarFoco(this.txtCodigo);
        this.listaModulos.clear();
        this.listaModulosOriginais.clear();
        this.carregaAcessosTipoUsuario(this.txtCodigo.getText().trim(), this.listaModulos, this.listaModulosOriginais);
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null && DBUtil.checkPK(this, statement, "tpu_codigo", this.txtCodigo.getText(), 1, new String[]{"usuario"})) {
                    String[] filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(statement);
                    String s = "delete from tipousuarioacesso where tpu_codigo=" + this.txtCodigo.getText();
                    Conexao.execute(Variaveis.filialPadrao, statement, s, true);
                    for (String filial : filiaisIntegracao) {
                        IntegracaoUtil.insereComandoLog(statement, Variaveis.filialPadrao, filial, s);
                    }
                    s = "delete from tipousuario where tpu_codigo=" + this.txtCodigo.getText();
                    Conexao.execute(Variaveis.filialPadrao, statement, s, true);
                    for (String filial : filiaisIntegracao) {
                        IntegracaoUtil.insereComandoLog(statement, Variaveis.filialPadrao, filial, s);
                    }
                    Conexao.arquivaSQL();
                }
            }
            catch (SQLException sqlex) {
                try {
                    Conexao.anulaSQL();
                    Funcoes.mensagem(this, "Ocorreu uma situa\u00e7\u00e3o inesperada ao efetuar a opera\u00e7\u00e3o no banco de dados", 1);
                }
                catch (Exception ex) {
                    Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
                }
            }
            catch (Exception ex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.checkInativo.setVisible(true);
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
        this.listaModulos.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void salvar() {
        block34: {
            block32: {
                if (!this.validaCampos() || (statement = Conexao.getStatement()) == null) break block34;
                splash = null;
                buf = new StringBuilder();
                codigo = this.getStatus() == 2 ? Integer.valueOf(Integer.parseInt(DBUtil.getSequencia(statement, "tipousuario", false))) : Integer.valueOf(Integer.parseInt(this.txtCodigo.getText().trim()));
                filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(statement);
                if (this.confirmaModificacaoInativo(codigo)) break block32;
                Conexao.fecharStatement(new Statement[]{statement});
                if (splash != null) {
                    splash.apagar();
                }
                return;
            }
            try {
                if (this.getStatus() == 2) {
                    if (Funcoes.textoVazio(this.txtCodigo.getText())) {
                        buf.setLength(0);
                        buf.append(" insert into tipousuario ");
                        buf.append(" (tpu_codigo, tpu_descricao, tpu_inativo) ");
                        buf.append(" values (").append(codigo).append(", '").append(this.txtDescricao.getTextDB()).append("', " + this.checkInativo.isSelected()).append(") ");
                    }
                } else if (this.getStatus() == 3) {
                    buf.setLength(0);
                    buf.append(" update tipousuario ");
                    buf.append(" set tpu_descricao = '").append(this.txtDescricao.getTextDB()).append("' ");
                    buf.append("\t, tpu_inativo = " + this.checkInativo.isSelected());
                    buf.append(" where tpu_codigo = ").append(codigo);
                }
                Conexao.execute(Variaveis.filialPadrao, statement, buf.toString(), true);
                for (String filial : filiaisIntegracao) {
                    IntegracaoUtil.insereComandoLog(statement, Variaveis.filialPadrao, filial, buf.toString());
                }
                haAcessosModificados = false;
                if (this.isDesmarcarTodos) {
                    this.removeTodosAcessosTipoUsuario(statement, filiaisIntegracao, codigo);
                    for (Long acesso : this.listaModulos) {
                        this.adicionaAcessoTipoUsuario(statement, filiaisIntegracao, codigo, acesso);
                    }
                } else {
                    for (Long acesso : this.listaModulos) {
                        if (this.listaModulosOriginais.contains(acesso)) continue;
                        this.adicionaAcessoTipoUsuario(statement, filiaisIntegracao, codigo, acesso);
                        haAcessosModificados = true;
                    }
                    if (!this.isDesmarcarTodos) {
                        for (Long acesso : this.listaModulosOriginais) {
                            if (this.listaModulos.contains(acesso)) continue;
                            this.removeAcessoTipoUsuario(statement, filiaisIntegracao, codigo, acesso);
                            haAcessosModificados = true;
                        }
                    }
                }
                Conexao.arquivaSQL();
                if (haAcessosModificados || this.isDesmarcarTodos) {
                    splash = SplashMensagem.getInstancia(this);
                    splash.mostrar("Aguarde.");
                    buf.setLength(0);
                    buf.append(" select usr_codigo from usuario where tpu_codigo = ").append(codigo);
                    st = Conexao.getStatement();
                    rs = Conexao.executeQuery(st, buf.toString());
                    qtde = 0;
                    while (rs.next()) {
                        ++qtde;
                    }
                    contador = 0;
                    rs.beforeFirst();
                    while (rs.next()) {
                        splash.setText("Aguarde. Atualizando usu\u00e1rio " + ++contador + " de " + qtde + ".");
                        codigoUsuario = rs.getString("usr_codigo");
                        this.listaModulosOriginais = this.carregaAcessosUsuario(statement, codigoUsuario);
                        if (this.isDesmarcarTodos) {
                            this.removeTodosAcessosUsuario(statement, filiaisIntegracao, codigoUsuario);
                            for (Long acesso : this.listaModulos) {
                                this.adicionaAcessoUsuario(statement, filiaisIntegracao, codigoUsuario, acesso);
                            }
                        } else {
                            for (Long acesso : this.listaModulos) {
                                if (this.listaModulosOriginais.contains(acesso)) continue;
                                this.adicionaAcessoUsuario(statement, filiaisIntegracao, codigoUsuario, acesso);
                                haAcessosModificados = true;
                            }
                            if (!this.isDesmarcarTodos) {
                                for (Long acesso : this.listaModulosOriginais) {
                                    if (this.listaModulos.contains(acesso)) continue;
                                    this.removeAcessoUsuario(statement, filiaisIntegracao, codigoUsuario, acesso);
                                    haAcessosModificados = true;
                                }
                            }
                        }
                        Conexao.arquivaSQL();
                    }
                    rs.close();
                    Conexao.fecharStatement(new Statement[]{st});
                }
                if (splash != null) {
                    splash.setText("Aguarde, finalizando processo.");
                }
                this.retornoParaPesquisa = codigo.toString();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception var4_6) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel inserir/atualizar acessos.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable var14_23) {
                    Conexao.fecharStatement(new Statement[]{statement});
                    if (splash != null) {
                        splash.apagar();
                    }
                    throw var14_23;
                }
                Conexao.fecharStatement(new Statement[]{statement});
                if (splash != null) {
                    splash.apagar();
                } else {
                    ** GOTO lbl121
                }
            }
            Conexao.fecharStatement(new Statement[]{statement});
            if (splash != null) {
                splash.apagar();
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void inativarUsuarios(Integer codigo) throws SQLException {
        Statement statementUser = Conexao.getStatement();
        StringBuilder userBuilder = new StringBuilder();
        Date date = new Date();
        SimpleDateFormat DateFor = new SimpleDateFormat("MM-dd-yyyy");
        String stringDate = DateFor.format(date);
        userBuilder.append(" update usuario set ");
        userBuilder.append(" usr_inativo = true, ");
        userBuilder.append(" usr_datainativo = '" + stringDate + "'");
        userBuilder.append(" where tpu_codigo = " + codigo);
        Conexao.execute(Variaveis.filialPadrao, statementUser, userBuilder.toString(), true);
        Conexao.fecharStatement(statementUser);
    }

    private boolean confirmaModificacaoInativo(Integer codigo) {
        if (!this.tipoUsuarioInativo && this.checkInativo.isSelected()) {
            boolean isInativo;
            boolean bl = isInativo = Funcoes.mensagem(this, "Todos os usu\u00e1rios que possuem essas permiss\u00f5es de acesso ser\u00e3o inativados. \nTem certeza que deseja inativar o Tipo de Usu\u00e1rio? ", 4) == 0;
            if (!isInativo) {
                return false;
            }
            try {
                this.inativarUsuarios(codigo);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void adicionaAcessoTipoUsuario(Statement st, String[] filiaisIntegracao, Integer codigo, Long acesso) throws SQLException {
        this.prstInsereAcessoTipoUsuario.setInt(1, codigo);
        this.prstInsereAcessoTipoUsuario.setLong(2, acesso);
        this.prstInsereAcessoTipoUsuario.executeUpdate();
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into tipousuarioacesso ");
        buf.append(" (tpu_codigo, ass_codigo) ");
        buf.append(" values (").append(codigo).append(",").append(acesso).append(") ");
        for (String filial : filiaisIntegracao) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    private void removeAcessoTipoUsuario(Statement st, String[] filiaisIntegracao, Integer codigo, Long acesso) throws SQLException {
        this.prstRemoveAcessoTipoUsuario.setInt(1, codigo);
        this.prstRemoveAcessoTipoUsuario.setLong(2, acesso);
        this.prstRemoveAcessoTipoUsuario.executeUpdate();
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from tipousuarioacesso ");
        buf.append(" where tpu_codigo = ").append(codigo);
        buf.append("   and ass_codigo = ").append(acesso);
        for (String filial : filiaisIntegracao) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    private void removeTodosAcessosTipoUsuario(Statement st, String[] filiaisIntegracao, Integer codigo) throws SQLException {
        this.prstRemoveTodosAcessosTipoUsuario.setInt(1, codigo);
        this.prstRemoveTodosAcessosTipoUsuario.executeUpdate();
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from tipousuarioacesso ");
        buf.append(" where tpu_codigo = ").append(codigo);
        for (String filial : filiaisIntegracao) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    private void adicionaAcessoUsuario(Statement st, String[] filiaisIntegracao, String codigoUsuario, Long acesso) throws SQLException {
        this.prstInsereAcessoUsuario.setString(1, codigoUsuario);
        this.prstInsereAcessoUsuario.setLong(2, acesso);
        this.prstInsereAcessoUsuario.executeUpdate();
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into usuarioacesso ");
        buf.append(" (usr_codigo, ass_codigo) ");
        buf.append(" values ('").append(codigoUsuario).append("',").append(acesso).append(") ");
        for (String filial : filiaisIntegracao) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    private void removeAcessoUsuario(Statement st, String[] filiaisIntegracao, String codigoUsuario, Long acesso) throws SQLException {
        this.prstRemoveAcessoUsuario.setString(1, codigoUsuario);
        this.prstRemoveAcessoUsuario.setLong(2, acesso);
        this.prstRemoveAcessoUsuario.executeUpdate();
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from usuarioacesso ");
        buf.append(" where usr_codigo = '").append(codigoUsuario).append("'");
        buf.append("   and ass_codigo = ").append(acesso);
        for (String filial : filiaisIntegracao) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    private void removeTodosAcessosUsuario(Statement st, String[] filiaisIntegracao, String codigoUsuario) throws SQLException {
        this.prstRemoveTodosAcessosUsuario.setString(1, codigoUsuario);
        this.prstRemoveTodosAcessosUsuario.executeUpdate();
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from usuarioacesso ");
        buf.append(" where usr_codigo = '").append(codigoUsuario).append("'");
        for (String filial : filiaisIntegracao) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    private HashSet<Long> carregaAcessosUsuario(Statement st, String codigoUsuario) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select ass_codigo as acesso ");
        buf.append("   from usuarioacesso ");
        buf.append("  where usr_codigo = '").append(codigoUsuario).append("' ");
        HashSet<Long> acessos = new HashSet<Long>();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        while (rs.next()) {
            acessos.add(rs.getLong("acesso"));
        }
        return acessos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void carregaAcessosTipoUsuario(String codigoTipoUsuario, HashSet<Long> ... listaAcesso) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select ass_codigo as acesso ");
        buf.append("   from tipousuarioacesso ");
        buf.append("  where tpu_codigo = ").append(codigoTipoUsuario);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                for (HashSet<Long> lista : listaAcesso) {
                    lista.add(rs.getLong("acesso"));
                }
            }
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os acessos do tipo de usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(!this.isExecutando && this.getStatus() == 3);
        this.txtDescricao.setEnabled(!this.isExecutando && (this.getStatus() == 3 || this.getStatus() == 2));
        this.buttonAcesso.setEnabled(!this.isExecutando && (this.getStatus() == 3 || this.getStatus() == 2));
        if (this.isExecutando) {
            this.botaoNovo.setEnabled(false);
            this.botaoEditar.setEnabled(false);
            this.botaoSalvar.setEnabled(false);
            this.botaoCancelar.setEnabled(false);
            this.botaoExcluir.setEnabled(false);
            this.botaoFechar.setEnabled(false);
        } else {
            this.habilitaBotoes();
        }
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.checkInativo.setSelected(false);
        this.checkInativo.setVisible(false);
        this.isDesmarcarTodos = false;
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0500500100");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "tpu_codigo";
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isExecutando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isExecutando = false;
        this.controlaCampos();
    }
}

