/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.servidor.Cliente;
import jalis.servidor.Estacoes;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class LicencaEstacoes
extends JDialog
implements ActionListener {
    private Component pai;
    private GridBagConstraints cons = new GridBagConstraints();
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00f5es:");
    private JLabel labelVCodigo = new JLabel();
    private JLabel labelVEstacao = new JLabel();
    private JLabel labelLiberacao = new JLabel("C\u00f3digo de libera\u00e7\u00e3o:");
    private TTextField txtLiberacao = new TTextField(30);
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonAtualizar = ComponenteFactory.novoJButton("Atualizar", 'A', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);

    public LicencaEstacoes(Frame frame) {
        super(frame);
        this.pai = frame;
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Licen\u00e7as de esta\u00e7\u00f5es");
        this.setSize(400, 180);
        this.setLocationRelativeTo(this.pai);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonAtualizar);
        this.panelBotoes.add(this.buttonFechar);
        ScreenUtil.setBorda(new Component[]{this.labelVCodigo, this.labelVEstacao}, new TitledBorder(""));
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.txtLiberacao.setUpperCase(true);
        this.montaTela();
        this.labelVCodigo.setText(String.valueOf(ParametrosGerais.getCodigoCliente()));
        this.labelVEstacao.setText(String.valueOf(Estacoes.decodificar(ParametrosGerais.getEstacoes()).getQuantidadeEstacoes()));
    }

    private void montaTela() {
        this.cons.gridx = 0;
        this.cons.gridy = 0;
        this.cons.anchor = 17;
        this.cons.fill = 2;
        this.cons.weightx = 1.0;
        this.panelCentro.add((Component)this.labelCodigo, this.cons);
        this.cons.gridy = 1;
        this.panelCentro.add((Component)this.labelVCodigo, this.cons);
        this.cons.gridy = 2;
        this.panelCentro.add((Component)this.labelEstacao, this.cons);
        this.cons.gridy = 3;
        this.panelCentro.add((Component)this.labelVEstacao, this.cons);
        this.cons.gridy = 4;
        this.panelCentro.add((Component)this.labelLiberacao, this.cons);
        this.cons.gridy = 5;
        this.panelCentro.add((Component)this.txtLiberacao, this.cons);
        this.cons.gridy = 6;
        this.cons.fill = 1;
        this.cons.weighty = 1.0;
        this.panelCentro.add((Component)new JPanel(), this.cons);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonAtualizar) {
            this.validaAtualizacao();
        }
    }

    private void validaAtualizacao() {
        boolean fechar = true;
        if (!Funcoes.textoVazio(this.txtLiberacao.getText()) && this.txtLiberacao.getText().length() == 30) {
            Estacoes estacoes = Estacoes.decodificar(this.txtLiberacao.getText());
            if (estacoes.getCodigoCliente() != ParametrosGerais.getCodigoCliente()) {
                Funcoes.mensagem(this, "C\u00f3digo do cliente incorreto.\nA libera\u00e7\u00e3o ser\u00e1 cancelada.", 1);
            } else {
                try {
                    Statement st = Conexao.getStatement();
                    st.execute("update parametros set par_estacoes = '" + this.txtLiberacao.getText() + "'");
                    Conexao.arquivaSQL();
                    Conexao.fecharStatement(st);
                    if (Cliente.getInstancia() != null) {
                        Cliente.getInstancia().atualizarServidor();
                    }
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "LicencaEstacoes");
                }
            }
        } else {
            boolean bl = fechar = Funcoes.mensagem(this, "C\u00f3digo de libera\u00e7\u00e3o incorreto.\nDeseja cancelar a libera\u00e7\u00e3o?", 4) == 0;
        }
        if (!fechar) {
            this.txtLiberacao.selectAll();
            this.txtLiberacao.grabFocus();
        } else {
            this.setVisible(false);
        }
    }
}

