/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class JanelaIPIntegracao
extends AbstractDialogoOKCancelar {
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel panel = new JPanel(this.grid);
    private TTextField txtIP = new TTextField(100, 3);
    private JButton botaoOK = new JButton("OK");
    private JLabel labelAlternativo = new JLabel("Host");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Host"});
    private JButton botaoFechar = new JButton("Fechar");
    private JTable tabela = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.tabela);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));

    public static JanelaIPIntegracao novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new JanelaIPIntegracao((Frame)owner, "Host Integra\u00e7\u00e3o");
        }
        if (owner instanceof Dialog) {
            return new JanelaIPIntegracao((Dialog)owner, "Host Integra\u00e7\u00e3o");
        }
        return null;
    }

    public JanelaIPIntegracao(JDialog owner, String title) {
        super((Dialog)owner, title);
        this.montaTela(owner);
    }

    public JanelaIPIntegracao(Frame owner, String title) {
        super(owner, title);
        this.montaTela(owner);
    }

    public JanelaIPIntegracao(Dialog owner, String title) {
        super(owner, title);
        this.montaTela(owner);
    }

    private void montaTela(Window owner) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        this.modelo.setColumnSize(new int[]{0}, this.tabela);
        this.botaoOK.setMargin(new Insets(0, 2, 0, 2));
        this.scroll.setBounds(new Rectangle(5, 41, 413, 217));
        this.scroll.setPreferredSize(new Dimension(new Dimension(250, 120)));
        this.botaoFechar.setMnemonic('F');
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.panelBotoes.add(this.botaoFechar);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.insets = new Insets(1, 5, 1, 5);
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.panel.add((Component)this.labelAlternativo, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.botaoOK.setPreferredSize(new Dimension(35, 20));
        this.botaoOK.setMinimumSize(new Dimension(35, 20));
        this.panel.add((Component)this.botaoOK, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.insets = new Insets(1, 5, 1, 5);
        this.txtIP.setPreferredSize(new Dimension(180, 20));
        this.txtIP.setMinimumSize(new Dimension(180, 20));
        this.panel.add((Component)this.txtIP, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.constraints.weighty = 1.0;
        this.constraints.gridwidth = 2;
        this.constraints.insets = new Insets(1, 5, 1, 5);
        this.panel.add((Component)this.scroll, this.constraints);
        this.getContentPane().add((Component)this.panel, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.pack();
        this.setLocation(ScreenUtil.getCentralizado(owner.getBounds(), this.getSize()));
        this.setModal(true);
        Funcoes.montaEnter((JComponent)this.panel);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.botaoOK.addActionListener(event -> {
            if (!Funcoes.textoVazio(this.txtIP.getText())) {
                String hostRegex = "^(https?://)?([a-zA-Z0-9\\.\\-]+)(:\\d+)$";
                if (!this.txtIP.getText().matches("^(https?://)?([a-zA-Z0-9\\.\\-]+)(:\\d+)$")) {
                    Funcoes.mensagem(this, "Host inv\u00e1lido!\nInformar Protocolo e porta.\nEx.: 'http://host.com.br:8080'", 2);
                    return;
                }
                int localizado = this.modelo.localizar(0, this.txtIP.getText());
                if (localizado > -1) {
                    Funcoes.mensagem(this, "IP j\u00e1 foi adicionado.", 2);
                } else if (this.modelo.getRowCount() < 5) {
                    this.modelo.addLine(new Object[]{this.txtIP.getText()});
                } else {
                    Funcoes.mensagem(this, "Limite de IPs excedido. (m\u00e1ximo 5 IPs)", 2);
                }
                this.txtIP.clear();
                this.txtIP.grabFocus();
            }
        });
        this.botaoFechar.addActionListener(event -> this.setVisible(false));
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linha;
                if (e.getKeyCode() == 127 && JanelaIPIntegracao.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(JanelaIPIntegracao.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    JanelaIPIntegracao.this.modelo.removeLine(JanelaIPIntegracao.this.tabela.getSelectedRow());
                } else if (e.getKeyCode() == 32 && (linha = JanelaIPIntegracao.this.tabela.getSelectedRow()) > -1) {
                    String ip = (String)JanelaIPIntegracao.this.modelo.getValueAt(linha, 0);
                    JanelaIPIntegracao.this.txtIP.setText(ip);
                    JanelaIPIntegracao.this.modelo.removeLine(linha);
                }
            }
        });
        ScreenUtil.requisitarFoco(this.txtIP);
    }

    public List<String> getIPs() {
        ArrayList<String> ips = new ArrayList<String>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            ips.add((String)this.modelo.getValueAt(i, 0));
        }
        return ips;
    }

    public void setIps(List<String> ips) {
        this.modelo.clear();
        for (String s : ips) {
            this.modelo.addLine(new Object[]{s});
        }
    }
}

