/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.CBOS;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.cadastro.MedicoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.BairroVO;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.service.cadastro.MedicoService;
import jalis.service.cadastro.auxiliares.BairroService;
import jalis.service.cadastro.auxiliares.CidadeService;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TAvisoLabel;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class JanelaConfiguracaoIDSSaude
extends JDialog
implements ActionListener,
FocusListener {
    public static final String TAG_UNIDADE_SAUDE = "unidadeSaude";
    public static final String TAG_MUNICIPIO = "municipio";
    public static final String TAG_BAIRRO = "bairro";
    public static final String TAG_CONVENIO = "convenio";
    public static final String TAG_FILIAL = "filial";
    public static final String TAG_CODIGO = "codigo";
    public static final String TAG_MEDICO = "medico";
    public static final String TAG_DESCRICAO = "descricao";
    public static final String TAG_MEDICO_UF = "uf";
    public static final String TAG_MEDICO_CRM = "crm";
    public static final String TAG_MEDICO_CONSELHO = "conselho";
    public static final String TAG_CHAVE_ACESSO = "chaveAcesso";
    public static final String TAG_CHAVES_ACESSO = "chavesAcesso";
    public static final String TAG_CODIGO_FILIAL = "codigoFilial";
    public static final String TAG_GERAL_CONFIGURACAO_IDS = "configuracaoIDS";
    public static final String TAG_NOME_PROFISSIONAL = "nomeProf";
    public static final String TAG_CODIGO_CBO_PROFISSIONAL = "codCboProf";
    public static final String TAG_DADO_FILIAL = "dadoFilial";
    public static final String TAG_ESTACAO = "estacao";
    public static final String TAG_LINK_COMUNICACAO = "link";
    public static final int COLUNA_CHAVE_ACESSO = 1;
    public static final int COLUNA_FILIAL = 0;
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private JPanel panel = new JPanel(this.grid);
    private JButton botaoCancelar = new JButton("Cancelar");
    private JButton botaoOK = new JButton("OK");
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JLabel labelChaveAcesso = new JLabel("Chave:");
    private final TTextField textChaveAcesso = new TTextField(100, 3);
    private JButton buttonOKChaveAcesso = ComponenteFactory.novoJButton("OK", this);
    private ModeloGridTable modeloChaves = new ModeloGridTable(new String[]{"Filial", "Chave Acesso"});
    private JTable tableChaves = ComponenteFactory.novoJTable((TableModel)this.modeloChaves, null, 70, 370);
    JScrollPane scrollChaves = new JScrollPane(this.tableChaves);
    private final TTextField textFilial = new TTextField(5, 1);
    private final JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'l', null, null, this.textFilial);
    private final JButton buttonFilial = ComponenteFactory.novoJButton(this, true);
    private final JLabel labelVFilial = new JLabel("");
    private final TTextField textFilialChaveAcesso = new TTextField(5, 1);
    private final JLabel labelFilialChaveAcesso = ComponenteFactory.novoJLabel("Filial:", 'l', null, null, this.textFilialChaveAcesso);
    private final JButton buttonFilialChaveAcesso = ComponenteFactory.novoJButton(this, true);
    private final JLabel labelVFilialChaveAcesso = new JLabel("");
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private final TTextField textCodigoConvenio = new TTextField(5, 1);
    private final JButton buttonBuscaConvenio = ComponenteFactory.novoJButton(this, true);
    private final TAvisoLabel labelDescConvenio = new TAvisoLabel();
    private JLabel labelMedico = new JLabel("M\u00e9dico:");
    private JButton buttonMedico = ComponenteFactory.novoJButton(this, true);
    private JLabel labelDescMedico = new JLabel();
    private JLabel labelBairro = new JLabel("Bairro:");
    private final TTextField textBairro = new TTextField(10, 3);
    private final JButton buttonBairro = ComponenteFactory.novoJButton(this, true);
    private JLabel labelDescBairro = new JLabel();
    private JLabel labelMunicipio = new JLabel("Munic\u00edpio:");
    private final TTextField textMunicipio = new TTextField(10, 1);
    private final JButton buttonMunicipio = ComponenteFactory.novoJButton(this, true);
    private JLabel labelDescMunicipio = new JLabel();
    private final JLabel labelSaude = new JLabel("Un. Sa\u00fade:");
    private final TTextField textCodSaude = new TTextField(7);
    private final JButton buttonBuscaSaude = ComponenteFactory.novoJButton(this, true);
    private final JLabel labelDescSaude = new JLabel();
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o:");
    private TTextField textEstacao = new TTextField(30, 1);
    private JButton buttonEstacao = ComponenteFactory.novoJButton(this, true);
    private JLabel labelVlrEstacao = new JLabel();
    private JPanel panelProfissionalExecutante = new JPanel(new GridBagLayout());
    private JPanel panelChaveDeAcesso = new JPanel(new GridBagLayout());
    private JLabel labelNomeProfissional = new JLabel("Nome:");
    private TTextField textNomeProfissional = new TTextField(70);
    private JLabel labelEspecialidadeProfissional = new JLabel("Especialidade:");
    private TTextField textEspecialidadeProfissional = new TTextField(6, 1);
    private JLabel labelLink = new JLabel("Link:");
    private TTextField textLink = new TTextField(150, 3);
    private int editandoChave = -1;
    private boolean ok = false;
    private boolean isTabelaLog = DBUtil.campoExiste(Conexao.getStatement(), "logids", "ids_codigo");
    private String xmlChaves = "";

    public static JanelaConfiguracaoIDSSaude novaInstancia(Window owner) {
        if (owner instanceof JFrame) {
            return new JanelaConfiguracaoIDSSaude((JFrame)owner, "Configura\u00e7\u00e3o integra\u00e7\u00e3o com IDS Sa\u00fade");
        }
        if (owner instanceof JDialog) {
            return new JanelaConfiguracaoIDSSaude((JDialog)owner, "Configura\u00e7\u00e3o integra\u00e7\u00e3o com IDS Sa\u00fade");
        }
        return null;
    }

    private JanelaConfiguracaoIDSSaude(JDialog owner, String title) {
        super((Dialog)owner, title);
        this.montaTela();
    }

    private JanelaConfiguracaoIDSSaude(JFrame owner, String title) {
        super((Frame)owner, title);
        this.montaTela();
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(this, false);
        boolean retorno = false;
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
            this.labelVFilial.setText(resultado.get("fil_descricao").toString());
            this.ativaComponentesFilial(true);
        } else {
            this.ativaComponentesFilial(false);
        }
        this.disparaMudaFilial();
    }

    private void buscaFilialChaveAcesso() {
        Hashtable resultado = Pesquisas.filial(this, false);
        boolean retorno = false;
        if (resultado != null) {
            this.textFilialChaveAcesso.setText(resultado.get("fil_codigo").toString());
            this.labelVFilialChaveAcesso.setText(resultado.get("fil_descricao").toString());
        }
    }

    private void disparaMudaFilial() {
        this.buscaDadosBairro();
        this.buscaDadosCidade();
        this.buscaDadosConvenio();
        this.buscaDadosSaude();
        this.atualizaMedico();
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void buscaDadosFilial(boolean isFocalizarConvenio) {
        if (!Funcoes.textoVazio(this.textFilial.getText())) {
            String descricao = "N\u00e3o cadastrado";
            try {
                descricao = DBUtil.getDescricao("fil_codigo", "fil_descricao", this.textFilial.getText(), "filiais_postocoleta", true);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "Requisicao (3011)");
            }
            this.labelVFilial.setText(descricao);
            this.ativaComponentesFilial(true);
            this.buscaDadosBairro();
            this.buscaDadosCidade();
            this.buscaDadosConvenio();
            this.buscaDadosSaude();
            this.atualizaMedico();
            this.buscaEstacao(true);
            if (isFocalizarConvenio) {
                ScreenUtil.requisitarFoco(this.textCodigoConvenio);
            }
        } else {
            this.labelVFilial.setText("");
            this.ativaComponentesFilial(false);
        }
    }

    private void buscaDadosFilialChaveAcesso() {
        if (!Funcoes.textoVazio(this.textFilialChaveAcesso.getText())) {
            String descricao = "N\u00e3o cadastrado";
            try {
                descricao = DBUtil.getDescricao("fil_codigo", "fil_descricao", this.textFilialChaveAcesso.getText(), "filiais_postocoleta", true);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "Requisicao (3011)");
            }
            this.labelVFilialChaveAcesso.setText(descricao);
        } else {
            this.labelVFilialChaveAcesso.setText("");
        }
    }

    private void atualizaMedico() {
        if (Funcoes.textoVazio(this.labelDescMedico.getText())) {
            return;
        }
        String dadosMedico = this.labelDescMedico.getText();
        String[] dados = dadosMedico.split("-");
        if (dados.length < 3) {
            this.labelDescMedico.setText("");
            return;
        }
        String conselho = dados[0];
        String crm = dados[1];
        String uf = dados[2];
        this.buscaDadosMedico(conselho, uf, crm);
    }

    private void montaTela() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(490, 510);
        this.setModal(true);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.buttonEstacao.setPreferredSize(new Dimension(20, 20));
        this.buttonEstacao.setSize(this.buttonEstacao.getPreferredSize());
        this.buttonEstacao.setMinimumSize(this.buttonEstacao.getPreferredSize());
        this.buttonEstacao.setMaximumSize(this.buttonEstacao.getPreferredSize());
        this.buttonEstacao.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.labelVlrEstacao.setPreferredSize(new Dimension(1, 20));
        this.labelVlrEstacao.setMinimumSize(this.labelVlrEstacao.getPreferredSize());
        ScreenUtil.setBorda(new Component[]{this.labelVlrEstacao}, new TitledBorder(""));
        this.botaoOK.setMargin(new Insets(2, 2, 2, 2));
        this.botaoOK.setPreferredSize(new Dimension(40, 25));
        this.botaoCancelar.setMargin(new Insets(2, 2, 2, 2));
        this.botaoOK.setMnemonic('O');
        this.botaoCancelar.setMnemonic('C');
        this.botaoOK.addActionListener(this);
        this.botaoCancelar.addActionListener(this);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        JPanel panelButton = new JPanel(new FlowLayout(2));
        panelButton.add(this.botaoOK);
        panelButton.add(this.botaoCancelar);
        this.panelBotoes.add((Component)panelButton, "East");
        this.panel.setBorder(new TitledBorder("Padr\u00e3o"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.panel.add((Component)this.labelFilial, c);
        ++c.gridy;
        this.panel.add((Component)this.labelConvenio, c);
        ++c.gridy;
        this.panel.add((Component)this.labelMedico, c);
        ++c.gridy;
        this.panel.add((Component)this.labelBairro, c);
        ++c.gridy;
        this.panel.add((Component)this.labelMunicipio, c);
        ++c.gridy;
        this.panel.add((Component)this.labelSaude, c);
        ++c.gridy;
        this.panel.add((Component)this.labelLink, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.textFilial.setPreferredSize(new Dimension(50, 20));
        this.textFilial.setMinimumSize(new Dimension(50, 20));
        this.panel.add((Component)this.textFilial, c);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        this.buttonFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonFilial.setMinimumSize(new Dimension(20, 20));
        this.panel.add((Component)this.buttonFilial, c);
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 2;
        c.insets = new Insets(1, 0, 0, 1);
        c.fill = 2;
        this.labelVFilial.setBorder(new TitledBorder(""));
        this.labelVFilial.setPreferredSize(new Dimension(150, 20));
        this.labelVFilial.setMinimumSize(new Dimension(150, 20));
        this.panel.add((Component)this.labelVFilial, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.textCodigoConvenio.setPreferredSize(new Dimension(50, 20));
        this.textCodigoConvenio.setMinimumSize(new Dimension(50, 20));
        this.panel.add((Component)this.textCodigoConvenio, c);
        c.gridx = 2;
        this.buttonBuscaConvenio.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaConvenio.setMinimumSize(new Dimension(20, 20));
        this.panel.add((Component)this.buttonBuscaConvenio, c);
        c.gridx = 3;
        c.gridwidth = 2;
        c.fill = 2;
        this.labelDescConvenio.setBorder(new TitledBorder(""));
        this.labelDescConvenio.setPreferredSize(new Dimension(150, 20));
        this.labelDescConvenio.setMinimumSize(new Dimension(150, 20));
        this.panel.add((Component)this.labelDescConvenio, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 3;
        this.labelDescMedico.setBorder(new TitledBorder(""));
        this.labelDescMedico.setPreferredSize(new Dimension(367, 20));
        this.labelDescMedico.setMinimumSize(new Dimension(367, 20));
        this.panel.add((Component)this.labelDescMedico, c);
        c.gridx = 4;
        c.gridwidth = 1;
        c.fill = 0;
        this.buttonMedico.setPreferredSize(new Dimension(20, 20));
        this.buttonMedico.setMinimumSize(new Dimension(20, 20));
        this.panel.add((Component)this.buttonMedico, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 1;
        this.textBairro.setPreferredSize(new Dimension(50, 20));
        this.textBairro.setMinimumSize(new Dimension(50, 20));
        this.panel.add((Component)this.textBairro, c);
        ++c.gridx;
        this.buttonBairro.setPreferredSize(new Dimension(20, 20));
        this.buttonBairro.setMinimumSize(new Dimension(20, 20));
        this.panel.add((Component)this.buttonBairro, c);
        ++c.gridx;
        c.fill = 2;
        c.gridwidth = 2;
        this.labelDescBairro.setBorder(new TitledBorder(""));
        this.labelDescBairro.setPreferredSize(new Dimension(150, 20));
        this.labelDescBairro.setMinimumSize(new Dimension(150, 20));
        this.panel.add((Component)this.labelDescBairro, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 1;
        this.textMunicipio.setPreferredSize(new Dimension(50, 20));
        this.textMunicipio.setMinimumSize(new Dimension(50, 20));
        this.panel.add((Component)this.textMunicipio, c);
        ++c.gridx;
        this.buttonMunicipio.setPreferredSize(new Dimension(20, 20));
        this.buttonMunicipio.setMinimumSize(new Dimension(20, 20));
        this.panel.add((Component)this.buttonMunicipio, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.labelDescMunicipio.setBorder(new TitledBorder(""));
        this.labelDescMunicipio.setPreferredSize(new Dimension(150, 20));
        this.labelDescMunicipio.setMinimumSize(new Dimension(150, 20));
        this.panel.add((Component)this.labelDescMunicipio, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 1;
        this.textCodSaude.setPreferredSize(new Dimension(50, 20));
        this.textCodSaude.setMinimumSize(new Dimension(50, 20));
        this.panel.add((Component)this.textCodSaude, c);
        ++c.gridx;
        this.buttonBuscaSaude.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaSaude.setMinimumSize(new Dimension(20, 20));
        this.panel.add((Component)this.buttonBuscaSaude, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.labelDescSaude.setBorder(new TitledBorder(""));
        this.labelDescSaude.setPreferredSize(new Dimension(150, 20));
        this.labelDescSaude.setMinimumSize(new Dimension(150, 20));
        this.panel.add((Component)this.labelDescSaude, c);
        ++c.gridy;
        c.gridwidth = 4;
        c.gridx = 1;
        c.fill = 2;
        this.panel.add((Component)this.textLink, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.panel.add((Component)this.labelEstacao, c);
        ++c.gridx;
        this.panel.add((Component)this.textEstacao, c);
        ++c.gridx;
        this.panel.add((Component)this.buttonEstacao, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.panel.add((Component)this.labelVlrEstacao, c);
        this.montaPanelProfissionalExecutante();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 1, 1, 1);
        this.panel.add((Component)this.panelProfissionalExecutante, c);
        this.montaPanelChaveAcesso();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 1, 1, 1);
        this.panel.add((Component)this.panelChaveDeAcesso, c);
        this.getContentPane().add((Component)this.panel, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.ativaComponentesFilial(false);
        this.montaListeners();
        Funcoes.montaEnter((JComponent)this.panel);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.defineUpperCase(this.getContentPane(), ParametrosGerais.getUpperCase());
        this.textBairro.setUpperCase(true);
    }

    private void adicionaChaveAcesso() {
        if (!(Funcoes.textoVazio(this.textChaveAcesso.getText()) || Funcoes.textoVazio(this.textFilialChaveAcesso.getText()) || Funcoes.textoVazio(this.textFilialChaveAcesso.getText()) || this.labelVFilialChaveAcesso.getText().equals("N\u00e3o cadastrado"))) {
            this.adicionaChaveAcessoTabela(this.textFilialChaveAcesso.getText(), this.textChaveAcesso.getText());
        }
    }

    private void adicionaChaveAcessoTabela(String filial, String chaveAcesso) {
        if (!this.filiaChaveAcessoExistente(filial, this.editandoChave).booleanValue()) {
            if (this.editandoChave > -1) {
                this.modeloChaves.setValueAt(filial, this.editandoChave, 0);
                this.modeloChaves.setValueAt(chaveAcesso, this.editandoChave, 1);
                this.editandoChave = -1;
            } else {
                this.modeloChaves.addLine(new Object[]{filial, chaveAcesso});
                this.tableChaves.getSelectionModel().setSelectionInterval(0, 0);
            }
            this.textChaveAcesso.setText("");
            this.textFilialChaveAcesso.setText("");
            this.labelVFilialChaveAcesso.setText("");
        } else {
            ScreenUtil.requisitarFoco(this.textFilialChaveAcesso);
        }
    }

    private Boolean filiaChaveAcessoExistente(String filial, int editandoChave) {
        Boolean existe = false;
        int qtdChavesEditando = 0;
        if (this.modeloChaves.localizarContendo(0, filial) > -1) {
            if (editandoChave > -1) {
                for (int i = 0; i < this.modeloChaves.getRowCount(); ++i) {
                    if (!this.modeloChaves.getValueAt(i, 0).equals(filial) || i == editandoChave) continue;
                    ++qtdChavesEditando;
                }
                if (qtdChavesEditando == 1) {
                    existe = true;
                }
            } else {
                existe = true;
            }
        }
        if (existe.booleanValue()) {
            Funcoes.mensagem(this, "A filial pode ter apenas uma chave.", 2);
        }
        return existe;
    }

    private void montaPanelProfissionalExecutante() {
        this.panelProfissionalExecutante.setBorder(new TitledBorder("Profissional executante"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelProfissionalExecutante.add((Component)this.labelNomeProfissional, c);
        ++c.gridy;
        this.panelProfissionalExecutante.add((Component)this.labelEspecialidadeProfissional, c);
        ++c.gridx;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelProfissionalExecutante.add((Component)this.textNomeProfissional, c);
        ++c.gridy;
        c.fill = 0;
        this.textEspecialidadeProfissional.setPreferredSize(new Dimension(70, 20));
        this.textEspecialidadeProfissional.setMinimumSize(new Dimension(70, 20));
        this.panelProfissionalExecutante.add((Component)this.textEspecialidadeProfissional, c);
    }

    private void montaPanelChaveAcesso() {
        this.panelChaveDeAcesso.setBorder(new TitledBorder("Chave de Acesso"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelChaveDeAcesso.add((Component)this.labelChaveAcesso, c);
        ++c.gridy;
        this.panelChaveDeAcesso.add((Component)this.labelFilialChaveAcesso, c);
        ++c.gridy;
        this.panelChaveDeAcesso.add(new JLabel(""));
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        this.textChaveAcesso.setMinimumSize(new Dimension(130, 20));
        this.textChaveAcesso.setPreferredSize(new Dimension(130, 20));
        this.panelChaveDeAcesso.add((Component)this.textChaveAcesso, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(1, 1, 1, 1);
        this.textFilialChaveAcesso.setPreferredSize(new Dimension(50, 20));
        this.textFilialChaveAcesso.setMinimumSize(new Dimension(50, 20));
        this.panelChaveDeAcesso.add((Component)this.textFilialChaveAcesso, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.buttonFilialChaveAcesso.setPreferredSize(new Dimension(20, 20));
        this.buttonFilialChaveAcesso.setMinimumSize(new Dimension(20, 20));
        this.panelChaveDeAcesso.add((Component)this.buttonFilialChaveAcesso, c);
        c.gridx = 3;
        c.fill = 0;
        this.labelVFilialChaveAcesso.setBorder(new TitledBorder(""));
        this.labelVFilialChaveAcesso.setPreferredSize(new Dimension(263, 20));
        this.labelVFilialChaveAcesso.setMinimumSize(new Dimension(263, 20));
        this.panelChaveDeAcesso.add((Component)this.labelVFilialChaveAcesso, c);
        c.gridx = 4;
        c.fill = 0;
        this.buttonOKChaveAcesso.setPreferredSize(new Dimension(40, 20));
        this.buttonOKChaveAcesso.setMinimumSize(new Dimension(40, 20));
        this.panelChaveDeAcesso.add((Component)this.buttonOKChaveAcesso, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.fill = 1;
        this.scrollChaves.setPreferredSize(new Dimension(100, 100));
        this.scrollChaves.setMinimumSize(new Dimension(270, 80));
        this.panelChaveDeAcesso.add((Component)this.scrollChaves, c);
    }

    private void montaListeners() {
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoIDSSaude.this.buttonFilial.doClick();
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    JanelaConfiguracaoIDSSaude.this.buscaDadosFilial(false);
                }
            }
        });
        this.textFilialChaveAcesso.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoIDSSaude.this.buttonFilialChaveAcesso.doClick();
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    JanelaConfiguracaoIDSSaude.this.buscaDadosFilialChaveAcesso();
                }
            }
        });
        this.textCodigoConvenio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoIDSSaude.this.buttonBuscaConvenio.doClick();
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    JanelaConfiguracaoIDSSaude.this.buscaDadosConvenio();
                }
            }
        });
        this.textBairro.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoIDSSaude.this.buttonBairro.doClick();
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    JanelaConfiguracaoIDSSaude.this.buscaDadosBairro();
                }
            }
        });
        this.textMunicipio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoIDSSaude.this.buttonMunicipio.doClick();
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    JanelaConfiguracaoIDSSaude.this.buscaDadosCidade();
                }
            }
        });
        this.textCodSaude.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoIDSSaude.this.buttonBuscaSaude.doClick();
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    JanelaConfiguracaoIDSSaude.this.buscaDadosSaude();
                }
            }
        });
        this.textEstacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    JanelaConfiguracaoIDSSaude.this.buscaEstacao(true);
                }
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoIDSSaude.this.buscaEstacao(false);
                }
            }
        });
        this.tableChaves.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = JanelaConfiguracaoIDSSaude.this.tableChaves.getSelectedRow();
                if (row >= 0 && e.getKeyCode() == 127 && Funcoes.mensagem(null, "Confirma exclus\u00e3o da chave", 4) == 0) {
                    JanelaConfiguracaoIDSSaude.this.modeloChaves.removeLine(row);
                    JanelaConfiguracaoIDSSaude.this.textChaveAcesso.setText("");
                    JanelaConfiguracaoIDSSaude.this.editandoChave = -1;
                } else if (row >= 0 && e.getKeyCode() == 32) {
                    JanelaConfiguracaoIDSSaude.this.textChaveAcesso.setText(JanelaConfiguracaoIDSSaude.this.modeloChaves.getValueAt(row, 1).toString());
                    JanelaConfiguracaoIDSSaude.this.textFilialChaveAcesso.setText(JanelaConfiguracaoIDSSaude.this.modeloChaves.getValueAt(row, 0).toString());
                    JanelaConfiguracaoIDSSaude.this.buscaDadosFilialChaveAcesso();
                    JanelaConfiguracaoIDSSaude.this.editandoChave = row;
                    ScreenUtil.requisitarFoco(JanelaConfiguracaoIDSSaude.this.textChaveAcesso);
                }
            }
        });
        this.tableChaves.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JanelaConfiguracaoIDSSaude.this.editandoChave = JanelaConfiguracaoIDSSaude.this.tableChaves.getSelectedRow();
                    JanelaConfiguracaoIDSSaude.this.textChaveAcesso.setText(JanelaConfiguracaoIDSSaude.this.modeloChaves.getValueAt(JanelaConfiguracaoIDSSaude.this.editandoChave, 1).toString());
                    JanelaConfiguracaoIDSSaude.this.textFilialChaveAcesso.setText(JanelaConfiguracaoIDSSaude.this.modeloChaves.getValueAt(JanelaConfiguracaoIDSSaude.this.editandoChave, 0).toString());
                    JanelaConfiguracaoIDSSaude.this.buscaDadosFilialChaveAcesso();
                    ScreenUtil.requisitarFoco(JanelaConfiguracaoIDSSaude.this.textChaveAcesso);
                }
            }
        });
        this.textFilial.addFocusListener(this);
        this.textCodigoConvenio.addFocusListener(this);
        this.textBairro.addFocusListener(this);
        this.textMunicipio.addFocusListener(this);
        this.textCodSaude.addFocusListener(this);
        this.textFilialChaveAcesso.addFocusListener(this);
        this.textEstacao.addFocusListener(this);
    }

    private void buscaConvenio() {
        Hashtable resultado = Pesquisas.convenio(Laboratorio.getInstancia(), this.getCodigoFilial(), true, true);
        if (resultado != null) {
            this.textCodigoConvenio.setText(resultado.get("con_codigo").toString());
            ScreenUtil.requisitarFoco(this.textCodigoConvenio);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDadosConvenio() {
        if (Funcoes.textoVazio(this.textCodigoConvenio)) {
            this.labelDescConvenio.setText("");
            return;
        }
        if (Funcoes.textoVazio(this.getCodigoFilial())) {
            Funcoes.mensagem(this, "A filial deve ser informada.", 2);
            this.textCodigoConvenio.clear();
            ScreenUtil.requisitarFoco(this.textFilial);
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select con_fantasia from convenios ");
        buf.append(" where fil_codigo = ").append(this.getCodigoFilial());
        buf.append("   and con_codigo = ").append(this.textCodigoConvenio.getText());
        Statement st = ConexaoTemporaria.getStatement();
        try {
            if (!Funcoes.textoVazio(this.textCodigoConvenio) && Funcoes.isNumeric(this.textCodigoConvenio.getText())) {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    this.labelDescConvenio.setText(rs.getString("con_fantasia"));
                } else {
                    this.labelDescConvenio.setText("N\u00e3o cadastrado");
                }
                st.close();
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Conv\u00eanio n\u00e3o informado.", 1);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar a lista de matr\u00edculas para o conv\u00eanio.", e.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private void buscaMedico() {
        Hashtable resultado = Pesquisas.medico(Laboratorio.getInstancia(), this.getCodigoFilial(), true);
        String dadosMedico = null;
        if (resultado != null) {
            dadosMedico = resultado.get("med_conselho").toString();
            dadosMedico = dadosMedico + "-" + resultado.get("med_crm").toString();
            dadosMedico = dadosMedico + "-" + resultado.get("med_uf").toString();
            dadosMedico = dadosMedico + "-" + resultado.get("med_nome").toString();
            this.labelDescMedico.setText(dadosMedico);
            ScreenUtil.requisitarFoco(this.textBairro);
        } else {
            Funcoes.mensagem(this, "M\u00e9dico n\u00e3o encontrado.", 2);
            ScreenUtil.requisitarFoco(this.buttonMedico);
        }
    }

    private void buscaDadosMedico(String conselho, String uf, String crm) {
        if (Funcoes.textoVazio(this.getCodigoFilial())) {
            this.labelDescMedico.setText("");
            return;
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("med_conselho", conselho);
        chaves.put("med_uf", uf);
        chaves.put("med_crm", crm);
        chaves.put("fil_codigo", this.getCodigoFilial());
        MedicoBean medico = null;
        try {
            medico = (MedicoBean)new MedicoService().getBean(chaves);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do m\u00e9dico." + e.getMessage(), e.getStackTrace());
        }
        if (medico != null) {
            this.labelDescMedico.setText(medico.getConselho() + "-" + medico.getCrm() + "-" + medico.getUf() + "-" + medico.getNome());
        } else {
            this.labelDescMedico.setText("N\u00e3o cadastrado");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDadosSaude() {
        if (Funcoes.textoVazio(this.textCodSaude)) {
            this.labelDescSaude.setText("");
            return;
        }
        if (Funcoes.textoVazio(this.getCodigoFilial())) {
            Funcoes.mensagem(this, "A filial deve ser informada.", 2);
            this.textCodSaude.clear();
            ScreenUtil.requisitarFoco(this.textFilial);
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select uns_descricao from unidadesaude ");
        buf.append(" where fil_codigo = ").append(this.getCodigoFilial());
        buf.append("   and uns_codigo = '").append(this.textCodSaude.getText()).append("' ");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                this.labelDescSaude.setText(rs.getString("uns_descricao"));
            } else {
                this.labelDescSaude.setText("N\u00e3o cadastrado");
            }
            st.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar a lista de matr\u00edculas para o conv\u00eanio.", e.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private void buscaBairro() {
        Hashtable resultado = Pesquisas.bairro(Laboratorio.getInstancia(), true, this.getCodigoFilial());
        if (resultado != null) {
            this.textBairro.setText(resultado.get("bai_codigo").toString());
            this.labelDescBairro.setText(resultado.get("bai_descricao").toString());
            ScreenUtil.requisitarFoco(this.textBairro);
        }
    }

    private void buscaDadosBairro() {
        if (Funcoes.textoVazio(this.textBairro)) {
            this.labelDescBairro.setText("");
            return;
        }
        if (Funcoes.textoVazio(this.getCodigoFilial())) {
            Funcoes.mensagem(this, "A filial deve ser informada.", 2);
            this.textBairro.clear();
            ScreenUtil.requisitarFoco(this.textFilial);
            return;
        }
        BairroVO bairro = null;
        try {
            bairro = (BairroVO)new BairroService().getVO(this.textFilial.getText(), this.textBairro.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e2o foi poss\u00edvel carregar os dados do bairro." + e.getMessage(), e.getStackTrace());
        }
        if (bairro != null) {
            this.labelDescBairro.setText(bairro.getDescricao());
        } else {
            this.labelDescBairro.setText("N\u00e3o cadastrado");
        }
    }

    private void buscaDadosCidade() {
        if (Funcoes.textoVazio(this.textMunicipio)) {
            this.labelDescMunicipio.setText("");
            return;
        }
        if (Funcoes.textoVazio(this.getCodigoFilial())) {
            Funcoes.mensagem(this, "A filial deve ser informada.", 2);
            this.textMunicipio.clear();
            ScreenUtil.requisitarFoco(this.textFilial);
            return;
        }
        CidadeVO cidade = null;
        try {
            cidade = (CidadeVO)new CidadeService().getVO(this.getCodigoFilial(), this.textMunicipio.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e2o foi poss\u00edvel carregar os dados do cidade." + e.getMessage(), e.getStackTrace());
        }
        if (cidade != null) {
            this.labelDescMunicipio.setText(cidade.getNome());
        } else {
            this.labelDescMunicipio.setText("N\u00e3o cadastrado");
        }
    }

    private void buscaCidade() {
        Hashtable resultado = Pesquisas.cidade(Laboratorio.getInstancia(), true, this.getCodigoFilial());
        if (resultado != null) {
            this.textMunicipio.setText(resultado.get("cid_codigo").toString());
            this.labelDescMunicipio.setText(resultado.get("cid_nome").toString() + " - " + resultado.get("cid_uf").toString());
            ScreenUtil.requisitarFoco(this.textMunicipio);
        }
    }

    private void buscaSaude() {
        Hashtable resultado = Pesquisas.unidadeSaude(Laboratorio.getInstancia(), this.getCodigoFilial(), true);
        if (resultado != null) {
            this.textCodSaude.setText(resultado.get("uns_codigo").toString());
            this.labelDescSaude.setText(resultado.get("uns_descricao").toString());
            ScreenUtil.requisitarFoco(this.textCodSaude);
        }
    }

    private void buscaEstacao(boolean isDigitado) {
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = null;
        if (isDigitado) {
            try {
                if (!Funcoes.textoVazio(this.textEstacao)) {
                    estacaoVO = (EstacaoVO)estacaoService.getVO(this.textEstacao.getText().trim());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da esta\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
        } else {
            estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        }
        if (!Funcoes.objectIsNull(estacaoVO)) {
            this.textEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        } else {
            if (isDigitado && !Funcoes.textoVazio(this.textEstacao)) {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
                return;
            }
            if (Funcoes.textoVazio(this.textEstacao)) {
                this.labelVlrEstacao.setText("");
            }
        }
    }

    private String getCodigoFilial() {
        if (Funcoes.textoVazio(this.textFilial.getText()) || this.labelVFilial.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            return null;
        }
        return this.textFilial.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFilial) {
            this.buscaFilial();
        } else if (e.getSource() == this.buttonFilialChaveAcesso) {
            this.buscaFilialChaveAcesso();
        } else if (e.getSource() == this.buttonBuscaConvenio) {
            this.buscaConvenio();
        } else if (e.getSource() == this.buttonMedico) {
            this.buscaMedico();
        } else if (e.getSource() == this.buttonBairro) {
            this.buscaBairro();
        } else if (e.getSource() == this.buttonMunicipio) {
            this.buscaCidade();
        } else if (e.getSource() == this.buttonBuscaSaude) {
            this.buscaSaude();
        } else if (e.getSource() == this.buttonEstacao) {
            this.buscaEstacao(false);
        } else if (e.getSource() == this.buttonOKChaveAcesso) {
            this.adicionaChaveAcesso();
        } else if (e.getSource() == this.botaoOK) {
            if (this.validaCampoVazio() || this.validaCampos()) {
                this.ok = true;
                this.setVisible(false);
            }
        } else if (e.getSource() == this.botaoCancelar) {
            this.setVisible(false);
        }
    }

    public boolean validaCampoVazio() {
        return Funcoes.textoVazio(this.textChaveAcesso) && Funcoes.textoVazio(this.textFilial) && Funcoes.textoVazio(this.textCodigoConvenio) && Funcoes.textoVazio(this.textBairro) && Funcoes.textoVazio(this.textMunicipio) && Funcoes.textoVazio(this.textCodSaude) && Funcoes.textoVazio(this.textEstacao);
    }

    public boolean validaCampos() {
        if (this.modeloChaves.getRowCount() == 0) {
            Funcoes.mensagem(this, "C\u00f3digo de acesso deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textChaveAcesso);
            return false;
        }
        if (Funcoes.textoVazio(this.textFilial.getText()) || this.labelVFilial.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "A filial deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textFilial);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoConvenio.getText()) || this.labelDescConvenio.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "O conv\u00eanio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoConvenio);
            return false;
        }
        if (Funcoes.textoVazio(this.labelDescMedico.getText()) || this.labelDescMedico.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "O m\u00e9dico deve ser informado.", 2);
            this.buttonMedico.doClick();
            return false;
        }
        if (Funcoes.textoVazio(this.textBairro.getText()) || this.labelDescBairro.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "O bairro deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textBairro);
            return false;
        }
        if (Funcoes.textoVazio(this.textMunicipio.getText()) || this.labelDescMunicipio.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "O municipio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textMunicipio);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodSaude.getText()) || this.labelDescSaude.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Unidade de sa\u00fade deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodSaude);
            return false;
        }
        return true;
    }

    public String getXML() {
        if (this.validaCampoVazio()) {
            return null;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        XMLStringBuilder xmlAux = new XMLStringBuilder();
        try {
            xml.abrir(TAG_GERAL_CONFIGURACAO_IDS);
            if (this.modeloChaves.getRowCount() > 0) {
                xml.abrir(TAG_CHAVES_ACESSO);
                for (int i = 0; i < this.modeloChaves.getRowCount(); ++i) {
                    xml.abrir(TAG_DADO_FILIAL);
                    xml.escrever(TAG_CODIGO_FILIAL, (String)this.modeloChaves.getValueAt(i, 0));
                    xml.escrever(TAG_CHAVE_ACESSO, StringUtil.textoDB((String)this.modeloChaves.getValueAt(i, 1)));
                    xml.fechar(TAG_DADO_FILIAL);
                }
                xml.fechar(TAG_CHAVES_ACESSO);
            }
            String dadosMedico = this.labelDescMedico.getText();
            String[] dados = dadosMedico.split("-");
            xmlAux.escrever(TAG_MEDICO_CONSELHO, dados[0]);
            xmlAux.escrever(TAG_MEDICO_CRM, dados[1]);
            xmlAux.escrever(TAG_MEDICO_UF, dados[2]);
            xmlAux.escrever(TAG_DESCRICAO, this.labelDescMedico.getText());
            xml.escrever(TAG_MEDICO, xmlAux);
            xmlAux = new XMLStringBuilder();
            xmlAux.escrever(TAG_CODIGO, this.textFilial.getText());
            xmlAux.escrever(TAG_DESCRICAO, this.labelVFilial.getText());
            xml.escrever(TAG_FILIAL, xmlAux);
            xmlAux = new XMLStringBuilder();
            xmlAux.escrever(TAG_CODIGO, this.textCodigoConvenio.getText());
            xmlAux.escrever(TAG_DESCRICAO, this.labelDescConvenio.getText());
            xml.escrever(TAG_CONVENIO, xmlAux);
            xmlAux = new XMLStringBuilder();
            xmlAux.escrever(TAG_CODIGO, this.textBairro.getText());
            xmlAux.escrever(TAG_DESCRICAO, this.labelDescBairro.getText());
            xml.escrever(TAG_BAIRRO, xmlAux);
            xmlAux = new XMLStringBuilder();
            xmlAux.escrever(TAG_CODIGO, this.textMunicipio.getText());
            xmlAux.escrever(TAG_DESCRICAO, this.labelDescMunicipio.getText());
            xml.escrever(TAG_MUNICIPIO, xmlAux);
            xmlAux = new XMLStringBuilder();
            xmlAux.escrever(TAG_CODIGO, this.textCodSaude.getText());
            xmlAux.escrever(TAG_DESCRICAO, this.labelDescSaude.getText());
            xml.escrever(TAG_UNIDADE_SAUDE, xmlAux);
            xml.escrever(TAG_NOME_PROFISSIONAL, this.textNomeProfissional.getText());
            xml.escrever(TAG_CODIGO_CBO_PROFISSIONAL, this.textEspecialidadeProfissional.getText());
            xml.escrever(TAG_LINK_COMUNICACAO, this.textLink.getText());
            xmlAux = new XMLStringBuilder();
            xmlAux.escrever(TAG_CODIGO, this.textEstacao.getText().trim());
            xmlAux.escrever(TAG_DESCRICAO, this.labelVlrEstacao.getText());
            xml.escrever(TAG_ESTACAO, xmlAux);
            xml.fechar(TAG_GERAL_CONFIGURACAO_IDS);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar xml.\n" + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public void setXML(String xml) {
        List<String> dadosFilial;
        String configuracao = StringUtil.getValor(xml, TAG_GERAL_CONFIGURACAO_IDS);
        String filial = StringUtil.getValor(configuracao, TAG_FILIAL);
        String codigo = StringUtil.getValor(filial, TAG_CODIGO);
        String descricao = StringUtil.getValor(filial, TAG_DESCRICAO);
        this.textFilial.setText(codigo);
        this.labelVFilial.setText(descricao);
        if (xml.indexOf(TAG_CHAVES_ACESSO) > -1 && (dadosFilial = StringUtil.getListValores(xml, TAG_DADO_FILIAL)).size() > 0) {
            String codigoFilial = "";
            String chaveAcesso = "";
            for (String item : dadosFilial) {
                codigoFilial = StringUtil.getValor(item, TAG_CODIGO_FILIAL);
                chaveAcesso = StringUtil.getValor(item, TAG_CHAVE_ACESSO);
                this.adicionaChaveAcessoTabela(codigoFilial, chaveAcesso);
            }
            this.modeloChaves.ordenarColuna(0, 1);
        }
        String filialSelecionada = StringUtil.getValor(filial, TAG_CODIGO);
        String convenio = StringUtil.getValor(configuracao, TAG_CONVENIO);
        codigo = StringUtil.getValor(convenio, TAG_CODIGO);
        descricao = StringUtil.getValor(convenio, TAG_DESCRICAO);
        this.textCodigoConvenio.setText(codigo);
        this.labelDescConvenio.setText(descricao);
        String municipio = StringUtil.getValor(configuracao, TAG_MUNICIPIO);
        codigo = StringUtil.getValor(municipio, TAG_CODIGO);
        descricao = StringUtil.getValor(municipio, TAG_DESCRICAO);
        this.textMunicipio.setText(codigo);
        this.labelDescMunicipio.setText(descricao);
        String unidadeSaude = StringUtil.getValor(configuracao, TAG_UNIDADE_SAUDE);
        codigo = StringUtil.getValor(unidadeSaude, TAG_CODIGO);
        descricao = StringUtil.getValor(unidadeSaude, TAG_DESCRICAO);
        this.textCodSaude.setText(codigo);
        this.labelDescSaude.setText(descricao);
        String bairro = StringUtil.getValor(configuracao, TAG_BAIRRO);
        codigo = StringUtil.getValor(bairro, TAG_CODIGO);
        descricao = StringUtil.getValor(bairro, TAG_DESCRICAO);
        this.textBairro.setText(codigo);
        this.labelDescBairro.setText(descricao);
        String medico = StringUtil.getValor(xml, TAG_MEDICO);
        descricao = StringUtil.getValor(medico, TAG_DESCRICAO);
        this.labelDescMedico.setText(descricao);
        String nomeProfissional = StringUtil.getValor(xml, TAG_NOME_PROFISSIONAL);
        if (!Funcoes.textoVazio(nomeProfissional)) {
            this.textNomeProfissional.setText(nomeProfissional);
        }
        String cboProfissional = StringUtil.getValor(xml, TAG_CODIGO_CBO_PROFISSIONAL);
        this.textEspecialidadeProfissional.setText(cboProfissional);
        String estacao = StringUtil.getValor(xml, TAG_ESTACAO);
        this.textEstacao.setText(StringUtil.getValor(estacao, TAG_CODIGO));
        this.labelVlrEstacao.setText(StringUtil.getValor(estacao, TAG_DESCRICAO));
        String linkComunicacao = StringUtil.getValor(xml, TAG_LINK_COMUNICACAO);
        this.textLink.setText(linkComunicacao);
        this.ativaComponentesFilial(!Funcoes.textoVazio(this.textFilial));
    }

    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.textBairro) {
            this.buscaDadosBairro();
        } else if (e.getSource() == this.textFilial) {
            this.buscaDadosFilial(e.getOppositeComponent() != this.textChaveAcesso);
        } else if (e.getSource() == this.textFilialChaveAcesso) {
            this.buscaDadosFilialChaveAcesso();
        } else if (e.getSource() == this.textMunicipio) {
            this.buscaDadosCidade();
        } else if (e.getSource() == this.textCodigoConvenio) {
            this.buscaDadosConvenio();
        } else if (e.getSource() == this.textCodSaude) {
            this.buscaDadosSaude();
        } else if (e.getSource() == this.textEstacao) {
            this.buscaEstacao(true);
        }
    }

    private void ativaComponentesFilial(boolean isAtivo) {
        this.textCodigoConvenio.setEnabled(isAtivo);
        this.buttonBuscaConvenio.setEnabled(isAtivo);
        this.textBairro.setEnabled(isAtivo);
        this.buttonBairro.setEnabled(isAtivo);
        this.textMunicipio.setEnabled(isAtivo);
        this.buttonMunicipio.setEnabled(isAtivo);
        this.textCodSaude.setEnabled(isAtivo);
        this.buttonBuscaSaude.setEnabled(isAtivo);
        this.buttonMedico.setEnabled(isAtivo);
        this.textEstacao.setEnabled(isAtivo);
        this.buttonEstacao.setEnabled(isAtivo);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    class ObjetoCBO {
        CBOS.CBO cbo = null;

        public ObjetoCBO(CBOS.CBO cbo) {
            this.cbo = cbo;
        }

        public String toString() {
            if (this.cbo != null) {
                return this.cbo.descricao;
            }
            return "";
        }
    }
}

